/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SculkShriekerBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SculkShriekerBlock> CODEC = SculkShriekerBlock.simpleCodec(SculkShriekerBlock::new);
    public static final BooleanProperty SHRIEKING = BlockStateProperties.SHRIEKING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty CAN_SUMMON = BlockStateProperties.CAN_SUMMON;
    protected static final VoxelShape COLLIDER = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final double TOP_Y = COLLIDER.max(Direction.Axis.Y);

    public MapCodec<SculkShriekerBlock> codec() {
        return CODEC;
    }

    public SculkShriekerBlock(BlockBehaviour.Properties p_222159_) {
        super(p_222159_);
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)SHRIEKING, Boolean.valueOf(false)))).setValue((Property)WATERLOGGED, Boolean.valueOf(false)))).setValue((Property)CAN_SUMMON, Boolean.valueOf(false))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_222211_) {
        p_222211_.add(new Property[]{SHRIEKING});
        p_222211_.add(new Property[]{WATERLOGGED});
        p_222211_.add(new Property[]{CAN_SUMMON});
    }

    public void stepOn(Level p_222177_, BlockPos p_222178_, BlockState p_222179_, Entity p_222180_) {
        if (p_222177_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_222177_;
            ServerPlayer serverplayer = SculkShriekerBlockEntity.tryGetPlayer((Entity)p_222180_);
            if (serverplayer != null) {
                serverlevel.getBlockEntity(p_222178_, BlockEntityType.SCULK_SHRIEKER).ifPresent(p_222163_ -> p_222163_.tryShriek(serverlevel, serverplayer));
            }
        }
        super.stepOn(p_222177_, p_222178_, p_222179_, p_222180_);
    }

    protected void onRemove(BlockState p_222198_, Level p_222199_, BlockPos p_222200_, BlockState p_222201_, boolean p_222202_) {
        if (p_222199_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_222199_;
            if (((Boolean)p_222198_.getValue((Property)SHRIEKING)).booleanValue() && !p_222198_.is(p_222201_.getBlock())) {
                serverlevel.getBlockEntity(p_222200_, BlockEntityType.SCULK_SHRIEKER).ifPresent(p_222217_ -> p_222217_.tryRespond(serverlevel));
            }
        }
        super.onRemove(p_222198_, p_222199_, p_222200_, p_222201_, p_222202_);
    }

    protected void tick(BlockState p_222187_, ServerLevel p_222188_, BlockPos p_222189_, RandomSource p_222190_) {
        if (((Boolean)p_222187_.getValue((Property)SHRIEKING)).booleanValue()) {
            p_222188_.setBlock(p_222189_, (BlockState)((Object)p_222187_.setValue((Property)SHRIEKING, Boolean.valueOf(false))), 3);
            p_222188_.getBlockEntity(p_222189_, BlockEntityType.SCULK_SHRIEKER).ifPresent(p_222169_ -> p_222169_.tryRespond(p_222188_));
        }
    }

    protected RenderShape getRenderShape(BlockState p_222219_) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getCollisionShape(BlockState p_222225_, BlockGetter p_222226_, BlockPos p_222227_, CollisionContext p_222228_) {
        return COLLIDER;
    }

    protected VoxelShape getOcclusionShape(BlockState p_222221_, BlockGetter p_222222_, BlockPos p_222223_) {
        return COLLIDER;
    }

    protected boolean useShapeForLightOcclusion(BlockState p_222232_) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_222213_, BlockState p_222214_) {
        return new SculkShriekerBlockEntity(p_222213_, p_222214_);
    }

    protected BlockState updateShape(BlockState p_222204_, Direction p_222205_, BlockState p_222206_, LevelAccessor p_222207_, BlockPos p_222208_, BlockPos p_222209_) {
        if (((Boolean)p_222204_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_222207_.scheduleTick(p_222208_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_222207_));
        }
        return super.updateShape(p_222204_, p_222205_, p_222206_, p_222207_, p_222208_, p_222209_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_222171_) {
        return (BlockState)((Object)this.defaultBlockState().setValue((Property)WATERLOGGED, Boolean.valueOf(p_222171_.getLevel().getFluidState(p_222171_.getClickedPos()).getType() == Fluids.WATER)));
    }

    protected FluidState getFluidState(BlockState p_222230_) {
        return (Boolean)p_222230_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_222230_);
    }

    protected void spawnAfterBreak(BlockState p_222192_, ServerLevel p_222193_, BlockPos p_222194_, ItemStack p_222195_, boolean p_222196_) {
        super.spawnAfterBreak(p_222192_, p_222193_, p_222194_, p_222195_, p_222196_);
    }

    public int getExpDrop(BlockState state, LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        return silkTouchLevel == 0 ? 5 : 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_222173_, BlockState p_222174_, BlockEntityType<T> p_222175_) {
        return !p_222173_.isClientSide ? BaseEntityBlock.createTickerHelper(p_222175_, BlockEntityType.SCULK_SHRIEKER, (p_281134_, p_281135_, p_281136_, p_281137_) -> VibrationSystem.Ticker.tick(p_281134_, p_281137_.getVibrationData(), p_281137_.getVibrationUser())) : null;
    }
}

