/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrapDoorBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TrapDoorBlock> CODEC = RecordCodecBuilder.mapCodec(p_308843_ -> p_308843_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(p_304735_ -> p_304735_.type), (App)TrapDoorBlock.propertiesCodec()).apply((Applicative)p_308843_, TrapDoorBlock::new));
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final int AABB_THICKNESS = 3;
    protected static final VoxelShape EAST_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.box(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape TOP_AABB = Block.box(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private final BlockSetType type;

    public MapCodec<? extends TrapDoorBlock> codec() {
        return CODEC;
    }

    public TrapDoorBlock(BlockSetType p_272964_, BlockBehaviour.Properties p_273079_) {
        super(p_273079_.sound(p_272964_.soundType()));
        this.type = p_272964_;
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH))).setValue((Property)OPEN, Boolean.valueOf(false)))).setValue((Property)HALF, (Comparable)Half.BOTTOM))).setValue((Property)POWERED, Boolean.valueOf(false)))).setValue((Property)WATERLOGGED, Boolean.valueOf(false))));
    }

    protected VoxelShape getShape(BlockState p_57563_, BlockGetter p_57564_, BlockPos p_57565_, CollisionContext p_57566_) {
        if (!((Boolean)p_57563_.getValue((Property)OPEN)).booleanValue()) {
            return p_57563_.getValue((Property)HALF) == Half.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        switch ((Direction)p_57563_.getValue((Property)FACING)) {
            default: {
                return NORTH_OPEN_AABB;
            }
            case SOUTH: {
                return SOUTH_OPEN_AABB;
            }
            case WEST: {
                return WEST_OPEN_AABB;
            }
            case EAST: 
        }
        return EAST_OPEN_AABB;
    }

    protected boolean isPathfindable(BlockState p_57535_, PathComputationType p_57538_) {
        switch (p_57538_) {
            case LAND: {
                return (Boolean)p_57535_.getValue((Property)OPEN);
            }
            case WATER: {
                return (Boolean)p_57535_.getValue((Property)WATERLOGGED);
            }
            case AIR: {
                return (Boolean)p_57535_.getValue((Property)OPEN);
            }
        }
        return false;
    }

    protected InteractionResult useWithoutItem(BlockState p_57540_, Level p_57541_, BlockPos p_57542_, Player p_57543_, BlockHitResult p_57545_) {
        if (!this.type.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        this.toggle(p_57540_, p_57541_, p_57542_, p_57543_);
        return InteractionResult.sidedSuccess((boolean)p_57541_.isClientSide);
    }

    protected void onExplosionHit(BlockState p_312371_, Level p_312286_, BlockPos p_312879_, Explosion p_312330_, BiConsumer<ItemStack, BlockPos> p_312161_) {
        if (p_312330_.getBlockInteraction() == Explosion.BlockInteraction.TRIGGER_BLOCK && !p_312286_.isClientSide() && this.type.canOpenByWindCharge() && !((Boolean)p_312371_.getValue((Property)POWERED)).booleanValue()) {
            this.toggle(p_312371_, p_312286_, p_312879_, null);
        }
        super.onExplosionHit(p_312371_, p_312286_, p_312879_, p_312330_, p_312161_);
    }

    private void toggle(BlockState p_312094_, Level p_312235_, BlockPos p_312619_, @Nullable Player p_312853_) {
        BlockState blockstate = (BlockState)((Object)p_312094_.cycle((Property)OPEN));
        p_312235_.setBlock(p_312619_, blockstate, 2);
        if (((Boolean)blockstate.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_312235_.scheduleTick(p_312619_, Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)((Object)p_312235_)));
        }
        this.playSound(p_312853_, p_312235_, p_312619_, (Boolean)blockstate.getValue((Property)OPEN));
    }

    protected void playSound(@Nullable Player p_57528_, Level p_57529_, BlockPos p_57530_, boolean p_57531_) {
        p_57529_.playSound(p_57528_, p_57530_, p_57531_ ? this.type.trapdoorOpen() : this.type.trapdoorClose(), SoundSource.BLOCKS, 1.0f, p_57529_.getRandom().nextFloat() * 0.1f + 0.9f);
        p_57529_.gameEvent(p_57528_, p_57531_ ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, p_57530_);
    }

    protected void neighborChanged(BlockState p_57547_, Level p_57548_, BlockPos p_57549_, Block p_57550_, BlockPos p_57551_, boolean p_57552_) {
        boolean flag;
        if (!p_57548_.isClientSide && (flag = p_57548_.hasNeighborSignal(p_57549_)) != (Boolean)p_57547_.getValue((Property)POWERED)) {
            if ((Boolean)p_57547_.getValue((Property)OPEN) != flag) {
                p_57547_ = (BlockState)((Object)p_57547_.setValue((Property)OPEN, Boolean.valueOf(flag)));
                this.playSound(null, p_57548_, p_57549_, flag);
            }
            p_57548_.setBlock(p_57549_, (BlockState)((Object)p_57547_.setValue((Property)POWERED, Boolean.valueOf(flag))), 2);
            if (((Boolean)p_57547_.getValue((Property)WATERLOGGED)).booleanValue()) {
                p_57548_.scheduleTick(p_57549_, Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)((Object)p_57548_)));
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_57533_) {
        BlockState blockstate = this.defaultBlockState();
        FluidState fluidstate = p_57533_.getLevel().getFluidState(p_57533_.getClickedPos());
        Direction direction = p_57533_.getClickedFace();
        blockstate = !p_57533_.replacingClickedOnBlock() && direction.getAxis().isHorizontal() ? (BlockState)((Object)((BlockState)((Object)blockstate.setValue((Property)FACING, (Comparable)direction))).setValue((Property)HALF, (Comparable)(p_57533_.getClickLocation().y - (double)p_57533_.getClickedPos().getY() > 0.5 ? Half.TOP : Half.BOTTOM))) : (BlockState)((Object)((BlockState)((Object)blockstate.setValue((Property)FACING, (Comparable)p_57533_.getHorizontalDirection().getOpposite()))).setValue((Property)HALF, (Comparable)(direction == Direction.UP ? Half.BOTTOM : Half.TOP)));
        if (p_57533_.getLevel().hasNeighborSignal(p_57533_.getClickedPos())) {
            blockstate = (BlockState)((Object)((BlockState)((Object)blockstate.setValue((Property)OPEN, Boolean.valueOf(true)))).setValue((Property)POWERED, Boolean.valueOf(true)));
        }
        return (BlockState)((Object)blockstate.setValue((Property)WATERLOGGED, Boolean.valueOf(fluidstate.getType() == Fluids.WATER)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57561_) {
        p_57561_.add(new Property[]{FACING, OPEN, HALF, POWERED, WATERLOGGED});
    }

    protected FluidState getFluidState(BlockState p_57568_) {
        return (Boolean)p_57568_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_57568_);
    }

    protected BlockState updateShape(BlockState p_57554_, Direction p_57555_, BlockState p_57556_, LevelAccessor p_57557_, BlockPos p_57558_, BlockPos p_57559_) {
        if (((Boolean)p_57554_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_57557_.scheduleTick(p_57558_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_57557_));
        }
        return super.updateShape(p_57554_, p_57555_, p_57556_, p_57557_, p_57558_, p_57559_);
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            BlockPos downPos = pos.below();
            BlockState down = world.getBlockState(downPos);
            return down.getBlock().makesOpenTrapdoorAboveClimbable(down, world, downPos, state);
        }
        return false;
    }

    protected BlockSetType getType() {
        return this.type;
    }
}

