/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ToolActions;

public class TripWireBlock
extends Block {
    public static final MapCodec<TripWireBlock> CODEC = RecordCodecBuilder.mapCodec(p_308844_ -> p_308844_.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("hook").forGetter(p_304664_ -> p_304664_.hook), TripWireBlock.propertiesCodec()).apply((Applicative)p_308844_, TripWireBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    public static final BooleanProperty DISARMED = BlockStateProperties.DISARMED;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = CrossCollisionBlock.PROPERTY_BY_DIRECTION;
    protected static final VoxelShape AABB = Block.box(0.0, 1.0, 0.0, 16.0, 2.5, 16.0);
    protected static final VoxelShape NOT_ATTACHED_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private static final int RECHECK_PERIOD = 10;
    private final Block hook;

    public MapCodec<TripWireBlock> codec() {
        return CODEC;
    }

    public TripWireBlock(Block p_304873_, BlockBehaviour.Properties p_57604_) {
        super(p_57604_);
        this.registerDefaultState((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, Boolean.valueOf(false)))).setValue((Property)ATTACHED, Boolean.valueOf(false)))).setValue((Property)DISARMED, Boolean.valueOf(false)))).setValue((Property)NORTH, Boolean.valueOf(false)))).setValue((Property)EAST, Boolean.valueOf(false)))).setValue((Property)SOUTH, Boolean.valueOf(false)))).setValue((Property)WEST, Boolean.valueOf(false))));
        this.hook = p_304873_;
    }

    @Override
    protected VoxelShape getShape(BlockState p_57654_, BlockGetter p_57655_, BlockPos p_57656_, CollisionContext p_57657_) {
        return (Boolean)p_57654_.getValue((Property)ATTACHED) != false ? AABB : NOT_ATTACHED_AABB;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_57606_) {
        Level blockgetter = p_57606_.getLevel();
        BlockPos blockpos = p_57606_.getClickedPos();
        return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.defaultBlockState().setValue((Property)NORTH, Boolean.valueOf(this.shouldConnectTo(blockgetter.getBlockState(blockpos.north()), Direction.NORTH))))).setValue((Property)EAST, Boolean.valueOf(this.shouldConnectTo(blockgetter.getBlockState(blockpos.east()), Direction.EAST))))).setValue((Property)SOUTH, Boolean.valueOf(this.shouldConnectTo(blockgetter.getBlockState(blockpos.south()), Direction.SOUTH))))).setValue((Property)WEST, Boolean.valueOf(this.shouldConnectTo(blockgetter.getBlockState(blockpos.west()), Direction.WEST))));
    }

    @Override
    protected BlockState updateShape(BlockState p_57645_, Direction p_57646_, BlockState p_57647_, LevelAccessor p_57648_, BlockPos p_57649_, BlockPos p_57650_) {
        return p_57646_.getAxis().isHorizontal() ? (BlockState)((Object)p_57645_.setValue((Property)PROPERTY_BY_DIRECTION.get(p_57646_), Boolean.valueOf(this.shouldConnectTo(p_57647_, p_57646_)))) : super.updateShape(p_57645_, p_57646_, p_57647_, p_57648_, p_57649_, p_57650_);
    }

    @Override
    protected void onPlace(BlockState p_57659_, Level p_57660_, BlockPos p_57661_, BlockState p_57662_, boolean p_57663_) {
        if (!p_57662_.is(p_57659_.getBlock())) {
            this.updateSource(p_57660_, p_57661_, p_57659_);
        }
    }

    @Override
    protected void onRemove(BlockState p_57630_, Level p_57631_, BlockPos p_57632_, BlockState p_57633_, boolean p_57634_) {
        if (!p_57634_ && !p_57630_.is(p_57633_.getBlock())) {
            this.updateSource(p_57631_, p_57632_, (BlockState)((Object)p_57630_.setValue((Property)POWERED, Boolean.valueOf(true))));
        }
    }

    @Override
    public BlockState playerWillDestroy(Level p_57615_, BlockPos p_57616_, BlockState p_57617_, Player p_57618_) {
        if (!p_57615_.isClientSide && !p_57618_.getMainHandItem().isEmpty() && p_57618_.getMainHandItem().canPerformAction(ToolActions.SHEARS_DISARM)) {
            p_57615_.setBlock(p_57616_, (BlockState)((Object)p_57617_.setValue((Property)DISARMED, Boolean.valueOf(true))), 4);
            p_57615_.gameEvent(p_57618_, GameEvent.SHEAR, p_57616_);
        }
        return super.playerWillDestroy(p_57615_, p_57616_, p_57617_, p_57618_);
    }

    private void updateSource(Level p_57611_, BlockPos p_57612_, BlockState p_57613_) {
        block0: for (Direction direction : new Direction[]{Direction.SOUTH, Direction.WEST}) {
            for (int i = 1; i < 42; ++i) {
                BlockPos blockpos = p_57612_.relative(direction, i);
                BlockState blockstate = p_57611_.getBlockState(blockpos);
                if (blockstate.is(this.hook)) {
                    if (blockstate.getValue((Property)TripWireHookBlock.FACING) != direction.getOpposite()) continue block0;
                    TripWireHookBlock.calculateState(p_57611_, blockpos, blockstate, false, true, i, p_57613_);
                    continue block0;
                }
                if (!blockstate.is(this)) continue block0;
            }
        }
    }

    @Override
    protected void entityInside(BlockState p_57625_, Level p_57626_, BlockPos p_57627_, Entity p_57628_) {
        if (!p_57626_.isClientSide && !((Boolean)p_57625_.getValue((Property)POWERED)).booleanValue()) {
            this.checkPressed(p_57626_, p_57627_);
        }
    }

    @Override
    protected void tick(BlockState p_222598_, ServerLevel p_222599_, BlockPos p_222600_, RandomSource p_222601_) {
        if (((Boolean)p_222599_.getBlockState(p_222600_).getValue((Property)POWERED)).booleanValue()) {
            this.checkPressed(p_222599_, p_222600_);
        }
    }

    private void checkPressed(Level p_57608_, BlockPos p_57609_) {
        BlockState blockstate = p_57608_.getBlockState(p_57609_);
        boolean flag = (Boolean)blockstate.getValue((Property)POWERED);
        boolean flag1 = false;
        List list = p_57608_.getEntities(null, blockstate.getShape((BlockGetter)((Object)p_57608_), p_57609_).bounds().move(p_57609_));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.isIgnoringBlockTriggers()) continue;
                flag1 = true;
                break;
            }
        }
        if (flag1 != flag) {
            blockstate = (BlockState)((Object)blockstate.setValue((Property)POWERED, Boolean.valueOf(flag1)));
            p_57608_.setBlock(p_57609_, blockstate, 3);
            this.updateSource(p_57608_, p_57609_, blockstate);
        }
        if (flag1) {
            p_57608_.scheduleTick(new BlockPos((Vec3i)p_57609_), this, 10);
        }
    }

    public boolean shouldConnectTo(BlockState p_57642_, Direction p_57643_) {
        return p_57642_.is(this.hook) ? p_57642_.getValue((Property)TripWireHookBlock.FACING) == p_57643_.getOpposite() : p_57642_.is(this);
    }

    @Override
    protected BlockState rotate(BlockState p_57639_, Rotation p_57640_) {
        switch (p_57640_) {
            case CLOCKWISE_180: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_57639_.setValue((Property)NORTH, (Boolean)p_57639_.getValue((Property)SOUTH)))).setValue((Property)EAST, (Boolean)p_57639_.getValue((Property)WEST)))).setValue((Property)SOUTH, (Boolean)p_57639_.getValue((Property)NORTH)))).setValue((Property)WEST, (Boolean)p_57639_.getValue((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_57639_.setValue((Property)NORTH, (Boolean)p_57639_.getValue((Property)EAST)))).setValue((Property)EAST, (Boolean)p_57639_.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Boolean)p_57639_.getValue((Property)WEST)))).setValue((Property)WEST, (Boolean)p_57639_.getValue((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_57639_.setValue((Property)NORTH, (Boolean)p_57639_.getValue((Property)WEST)))).setValue((Property)EAST, (Boolean)p_57639_.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Boolean)p_57639_.getValue((Property)EAST)))).setValue((Property)WEST, (Boolean)p_57639_.getValue((Property)SOUTH)));
            }
        }
        return p_57639_;
    }

    @Override
    protected BlockState mirror(BlockState p_57636_, Mirror p_57637_) {
        switch (p_57637_) {
            case LEFT_RIGHT: {
                return (BlockState)((Object)((BlockState)((Object)p_57636_.setValue((Property)NORTH, (Boolean)p_57636_.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Boolean)p_57636_.getValue((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((Object)((BlockState)((Object)p_57636_.setValue((Property)EAST, (Boolean)p_57636_.getValue((Property)WEST)))).setValue((Property)WEST, (Boolean)p_57636_.getValue((Property)EAST)));
            }
        }
        return super.mirror(p_57636_, p_57637_);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57652_) {
        p_57652_.add(new Property[]{POWERED, ATTACHED, DISARMED, NORTH, EAST, WEST, SOUTH});
    }
}

