/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;

public class SectionStorage<R>
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String SECTIONS_TAG = "Sections";
    private final SimpleRegionStorage simpleRegionStorage;
    private final Long2ObjectMap<Optional<R>> storage = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet dirty = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> codec;
    private final Function<Runnable, R> factory;
    private final RegistryAccess registryAccess;
    protected final LevelHeightAccessor levelHeightAccessor;

    public SectionStorage(SimpleRegionStorage p_321814_, Function<Runnable, Codec<R>> p_223510_, Function<Runnable, R> p_223511_, RegistryAccess p_223515_, LevelHeightAccessor p_223516_) {
        this.simpleRegionStorage = p_321814_;
        this.codec = p_223510_;
        this.factory = p_223511_;
        this.registryAccess = p_223515_;
        this.levelHeightAccessor = p_223516_;
    }

    protected void tick(BooleanSupplier p_63812_) {
        while (this.hasWork() && p_63812_.getAsBoolean()) {
            ChunkPos chunkpos = SectionPos.of((long)this.dirty.firstLong()).chunk();
            this.writeColumn(chunkpos);
        }
    }

    public boolean hasWork() {
        return !this.dirty.isEmpty();
    }

    @Nullable
    protected Optional<R> get(long p_63819_) {
        return (Optional)this.storage.get(p_63819_);
    }

    protected Optional<R> getOrLoad(long p_63824_) {
        if (this.outsideStoredRange(p_63824_)) {
            return Optional.empty();
        }
        Optional<R> optional = this.get(p_63824_);
        if (optional != null) {
            return optional;
        }
        this.readColumn(SectionPos.of((long)p_63824_).chunk());
        optional = this.get(p_63824_);
        if (optional == null) {
            throw Util.pauseInIde(new IllegalStateException());
        }
        return optional;
    }

    protected boolean outsideStoredRange(long p_156631_) {
        int i = SectionPos.sectionToBlockCoord((int)SectionPos.y((long)p_156631_));
        return this.levelHeightAccessor.isOutsideBuildHeight(i);
    }

    protected R getOrCreate(long p_63828_) {
        if (this.outsideStoredRange(p_63828_)) {
            throw Util.pauseInIde(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> optional = this.getOrLoad(p_63828_);
        if (optional.isPresent()) {
            return optional.get();
        }
        R r = this.factory.apply(() -> this.setDirty(p_63828_));
        this.storage.put(p_63828_, Optional.of(r));
        return r;
    }

    private void readColumn(ChunkPos p_63815_) {
        Optional<CompoundTag> optional = this.tryRead(p_63815_).join();
        RegistryOps registryops = this.registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.readColumn(p_63815_, registryops, optional.orElse(null));
    }

    private CompletableFuture<Optional<CompoundTag>> tryRead(ChunkPos p_223533_) {
        return this.simpleRegionStorage.read(p_223533_).exceptionally(p_223526_ -> {
            if (p_223526_ instanceof IOException) {
                IOException ioexception = (IOException)p_223526_;
                LOGGER.error("Error reading chunk {} data from disk", (Object)p_223533_, (Object)ioexception);
                return Optional.empty();
            }
            throw new CompletionException((Throwable)p_223526_);
        });
    }

    private void readColumn(ChunkPos p_63802_, RegistryOps<Tag> p_321830_, @Nullable CompoundTag p_321530_) {
        if (p_321530_ == null) {
            for (int i = this.levelHeightAccessor.getMinSection(); i < this.levelHeightAccessor.getMaxSection(); ++i) {
                this.storage.put(SectionStorage.getKey(p_63802_, i), Optional.empty());
            }
        } else {
            int k;
            Dynamic dynamic1 = new Dynamic(p_321830_, (Object)p_321530_);
            int j = SectionStorage.getVersion(dynamic1);
            boolean flag = j != (k = SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            Dynamic dynamic = this.simpleRegionStorage.upgradeChunkTag(dynamic1, j);
            OptionalDynamic optionaldynamic = dynamic.get(SECTIONS_TAG);
            for (int l = this.levelHeightAccessor.getMinSection(); l < this.levelHeightAccessor.getMaxSection(); ++l) {
                long i1 = SectionStorage.getKey(p_63802_, l);
                Optional optional = optionaldynamic.get(Integer.toString(l)).result().flatMap(p_338087_ -> this.codec.apply(() -> this.setDirty(i1)).parse(p_338087_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
                this.storage.put(i1, optional);
                optional.ifPresent(p_223523_ -> {
                    this.onSectionLoad(i1);
                    if (flag) {
                        this.setDirty(i1);
                    }
                });
            }
        }
    }

    private void writeColumn(ChunkPos p_63826_) {
        RegistryOps registryops = this.registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        Dynamic dynamic = this.writeColumn(p_63826_, (DynamicOps)registryops);
        Tag tag = (Tag)dynamic.getValue();
        if (tag instanceof CompoundTag) {
            this.simpleRegionStorage.write(p_63826_, (CompoundTag)tag);
        } else {
            LOGGER.error("Expected compound tag, got {}", (Object)tag);
        }
    }

    private <T> Dynamic<T> writeColumn(ChunkPos p_63799_, DynamicOps<T> p_63800_) {
        HashMap map = Maps.newHashMap();
        for (int i = this.levelHeightAccessor.getMinSection(); i < this.levelHeightAccessor.getMaxSection(); ++i) {
            long j = SectionStorage.getKey(p_63799_, i);
            this.dirty.remove(j);
            Optional optional = (Optional)this.storage.get(j);
            if (optional == null || optional.isEmpty()) continue;
            DataResult dataresult = this.codec.apply(() -> this.setDirty(j)).encodeStart(p_63800_, optional.get());
            String s = Integer.toString(i);
            dataresult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_223531_ -> map.put(p_63800_.createString(s), p_223531_));
        }
        return new Dynamic(p_63800_, p_63800_.createMap((Map)ImmutableMap.of((Object)p_63800_.createString(SECTIONS_TAG), (Object)p_63800_.createMap((Map)map), (Object)p_63800_.createString("DataVersion"), (Object)p_63800_.createInt(SharedConstants.getCurrentVersion().getDataVersion().getVersion()))));
    }

    private static long getKey(ChunkPos p_156628_, int p_156629_) {
        return SectionPos.asLong((int)p_156628_.x, (int)p_156629_, (int)p_156628_.z);
    }

    protected void onSectionLoad(long p_63813_) {
    }

    protected void setDirty(long p_63788_) {
        Optional optional = (Optional)this.storage.get(p_63788_);
        if (optional != null && !optional.isEmpty()) {
            this.dirty.add(p_63788_);
        } else {
            LOGGER.warn("No data for position: {}", (Object)SectionPos.of((long)p_63788_));
        }
    }

    private static int getVersion(Dynamic<?> p_63806_) {
        return p_63806_.get("DataVersion").asInt(1945);
    }

    public void flush(ChunkPos p_63797_) {
        if (this.hasWork()) {
            for (int i = this.levelHeightAccessor.getMinSection(); i < this.levelHeightAccessor.getMaxSection(); ++i) {
                long j = SectionStorage.getKey(p_63797_, i);
                if (!this.dirty.contains(j)) continue;
                this.writeColumn(p_63797_);
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.simpleRegionStorage.close();
    }

    public void remove(long sectionPosAsLong) {
        this.storage.remove(sectionPosAsLong);
    }
}

