/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public record LootDataType<T>(ResourceKey<Registry<T>> registryKey, Codec<T> codec, String directory, Validator<T> validator, @Nullable T defaultValue, Codec<Optional<T>> conditionalCodec, BiConsumer<T, ResourceLocation> idSetter) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootDataType<LootItemCondition> PREDICATE = new LootDataType(Registries.PREDICATE, LootItemConditions.DIRECT_CODEC, "predicates", LootDataType.createSimpleValidator());
    public static final LootDataType<LootItemFunction> MODIFIER = new LootDataType(Registries.ITEM_MODIFIER, LootItemFunctions.ROOT_CODEC, "item_modifiers", LootDataType.createSimpleValidator());
    public static final LootDataType<LootTable> TABLE = new LootDataType<LootTable>(Registries.LOOT_TABLE, LootTable.DIRECT_CODEC, "loot_tables", LootDataType.createLootTableValidator(), LootTable.EMPTY, LootTable::setLootTableId);

    @Deprecated
    private LootDataType(ResourceKey<Registry<T>> registryKey, Codec<T> codec, String directory, Validator<T> validator) {
        this(registryKey, codec, directory, validator, null, (it, id) -> {});
    }

    private LootDataType(ResourceKey<Registry<T>> registryKey, Codec<T> codec, String directory, Validator<T> validator, @Nullable T defaultValue, BiConsumer<T, ResourceLocation> idSetter) {
        this(registryKey, codec, directory, validator, defaultValue, ConditionalOps.createConditionalCodec(codec), idSetter);
    }

    public void runValidation(ValidationContext p_279366_, ResourceKey<T> p_336149_, T p_279124_) {
        this.validator.run(p_279366_, p_336149_, p_279124_);
    }

    public <V> Optional<T> deserialize(ResourceLocation p_279253_, DynamicOps<V> p_324006_, V p_324329_) {
        DataResult dataresult = this.conditionalCodec.parse(p_324006_, p_324329_);
        dataresult.error().ifPresent(p_338121_ -> LOGGER.error("Couldn't parse element {}:{} - {}", new Object[]{this.directory, p_279253_, p_338121_.message()}));
        return dataresult.result().map(it -> {
            it.ifPresent(val -> this.idSetter.accept(val, p_279253_));
            Object value = it.orElse(this.defaultValue);
            if (value instanceof LootTable) {
                LootTable lootTable = (LootTable)value;
                value = EventHooks.loadLootTable((ResourceLocation)p_279253_, (LootTable)lootTable);
            }
            return value;
        });
    }

    public static Stream<LootDataType<?>> values() {
        return Stream.of(PREDICATE, MODIFIER, TABLE);
    }

    private static <T extends LootContextUser> Validator<T> createSimpleValidator() {
        return (p_339560_, p_339561_, p_339562_) -> p_339562_.validate(p_339560_.enterElement("{" + String.valueOf(p_339561_.registry()) + "/" + String.valueOf(p_339561_.location()) + "}", p_339561_));
    }

    private static Validator<LootTable> createLootTableValidator() {
        return (p_339557_, p_339558_, p_339559_) -> p_339559_.validate(p_339557_.setParams(p_339559_.getParamSet()).enterElement("{" + String.valueOf(p_339558_.registry()) + "/" + String.valueOf(p_339558_.location()) + "}", p_339558_));
    }

    @FunctionalInterface
    public static interface Validator<T> {
        public void run(ValidationContext var1, ResourceKey<T> var2, T var3);
    }
}

