/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootTable EMPTY = new LootTable(LootContextParamSets.EMPTY, Optional.empty(), List.of(), List.of());
    public static final LootContextParamSet DEFAULT_PARAM_SET = LootContextParamSets.ALL_PARAMS;
    public static final long RANDOMIZE_SEED = 0L;
    public static final Codec<LootTable> DIRECT_CODEC = RecordCodecBuilder.create(p_338123_ -> p_338123_.group((App)LootContextParamSets.CODEC.lenientOptionalFieldOf("type", (Object)DEFAULT_PARAM_SET).forGetter(p_298001_ -> p_298001_.paramSet), (App)ResourceLocation.CODEC.optionalFieldOf("random_sequence").forGetter(p_297998_ -> p_297998_.randomSequence), (App)CommonHooks.lootPoolsCodec(LootPool::setName).optionalFieldOf("pools", List.of()).forGetter(p_298002_ -> p_298002_.pools), (App)ConditionalOps.decodeListWithElementConditions((Codec)LootItemFunctions.ROOT_CODEC).optionalFieldOf("functions", List.of()).forGetter(p_298000_ -> p_298000_.functions)).apply((Applicative)p_338123_, LootTable::new));
    public static final Codec<Holder<LootTable>> CODEC = RegistryFileCodec.create((ResourceKey)Registries.LOOT_TABLE, DIRECT_CODEC);
    private final LootContextParamSet paramSet;
    private final Optional<ResourceLocation> randomSequence;
    private final List<LootPool> pools;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    private boolean isFrozen = false;
    private ResourceLocation lootTableId;

    LootTable(LootContextParamSet p_287716_, Optional<ResourceLocation> p_299055_, List<LootPool> p_298390_, List<LootItemFunction> p_298775_) {
        this.paramSet = p_287716_;
        this.randomSequence = p_299055_;
        this.pools = Lists.newArrayList(p_298390_);
        this.functions = p_298775_;
        this.compositeFunction = LootItemFunctions.compose(p_298775_);
    }

    public static Consumer<ItemStack> createStackSplitter(ServerLevel p_287765_, Consumer<ItemStack> p_251308_) {
        return p_287570_ -> {
            if (p_287570_.isItemEnabled(p_287765_.enabledFeatures())) {
                if (p_287570_.getCount() < p_287570_.getMaxStackSize()) {
                    p_251308_.accept((ItemStack)p_287570_);
                } else {
                    ItemStack itemstack;
                    for (int i = p_287570_.getCount(); i > 0; i -= itemstack.getCount()) {
                        itemstack = p_287570_.copyWithCount(Math.min(p_287570_.getMaxStackSize(), i));
                        p_251308_.accept(itemstack);
                    }
                }
            }
        };
    }

    @Deprecated
    public void getRandomItemsRaw(LootParams p_287669_, Consumer<ItemStack> p_287781_) {
        this.getRandomItemsRaw(new LootContext.Builder(p_287669_).create(this.randomSequence), p_287781_);
    }

    @Deprecated
    public void getRandomItemsRaw(LootContext p_79132_, Consumer<ItemStack> p_79133_) {
        LootContext.VisitedEntry<LootTable> visitedentry = LootContext.createVisitedEntry(this);
        if (p_79132_.pushVisitedElement(visitedentry)) {
            Consumer consumer = LootItemFunction.decorate(this.compositeFunction, p_79133_, (LootContext)p_79132_);
            for (LootPool lootpool : this.pools) {
                lootpool.addRandomItems(consumer, p_79132_);
            }
            p_79132_.popVisitedElement(visitedentry);
        } else {
            LOGGER.warn("Detected infinite loop in loot tables");
        }
    }

    public void getRandomItems(LootParams p_287748_, long p_287729_, Consumer<ItemStack> p_287583_) {
        this.getRandomItems(new LootContext.Builder(p_287748_).withOptionalRandomSeed(p_287729_).create(this.randomSequence)).forEach(p_287583_);
    }

    public void getRandomItems(LootParams p_287704_, Consumer<ItemStack> p_287617_) {
        this.getRandomItems(p_287704_).forEach(p_287617_);
    }

    public void getRandomItems(LootContext p_79149_, Consumer<ItemStack> p_79150_) {
        this.getRandomItems(p_79149_).forEach(p_79150_);
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams p_287574_, long p_287773_) {
        return this.getRandomItems(new LootContext.Builder(p_287574_).withOptionalRandomSeed(p_287773_).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams p_287616_) {
        return this.getRandomItems(new LootContext.Builder(p_287616_).create(this.randomSequence));
    }

    private ObjectArrayList<ItemStack> getRandomItems(LootContext p_230923_) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        this.getRandomItemsRaw(p_230923_, LootTable.createStackSplitter(p_230923_.getLevel(), arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0)));
        objectarraylist = CommonHooks.modifyLoot((ResourceLocation)this.getLootTableId(), (ObjectArrayList)objectarraylist, (LootContext)p_230923_);
        return objectarraylist;
    }

    public LootContextParamSet getParamSet() {
        return this.paramSet;
    }

    public void validate(ValidationContext p_79137_) {
        for (int i = 0; i < this.pools.size(); ++i) {
            this.pools.get(i).validate(p_79137_.forChild(".pools[" + i + "]"));
        }
        for (int j = 0; j < this.functions.size(); ++j) {
            this.functions.get(j).validate(p_79137_.forChild(".functions[" + j + "]"));
        }
    }

    public void fill(Container p_287662_, LootParams p_287743_, long p_287585_) {
        LootContext lootcontext = new LootContext.Builder(p_287743_).withOptionalRandomSeed(p_287585_).create(this.randomSequence);
        ObjectArrayList<ItemStack> objectarraylist = this.getRandomItems(lootcontext);
        RandomSource randomsource = lootcontext.getRandom();
        List<Integer> list = this.getAvailableSlots(p_287662_, randomsource);
        this.shuffleAndSplitItems(objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.isEmpty()) {
                p_287662_.setItem(list.remove(list.size() - 1).intValue(), ItemStack.EMPTY);
                continue;
            }
            p_287662_.setItem(list.remove(list.size() - 1).intValue(), itemstack);
        }
    }

    private void shuffleAndSplitItems(ObjectArrayList<ItemStack> p_230925_, int p_230926_, RandomSource p_230927_) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = p_230925_.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            if (itemstack.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (itemstack.getCount() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (p_230926_ - p_230925_.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.nextInt((RandomSource)p_230927_, (int)0, (int)(list.size() - 1)));
            int i = Mth.nextInt((RandomSource)p_230927_, (int)1, (int)(itemstack2.getCount() / 2));
            ItemStack itemstack1 = itemstack2.split(i);
            if (itemstack2.getCount() > 1 && p_230927_.nextBoolean()) {
                list.add(itemstack2);
            } else {
                p_230925_.add((Object)itemstack2);
            }
            if (itemstack1.getCount() > 1 && p_230927_.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            p_230925_.add((Object)itemstack1);
        }
        p_230925_.addAll((Collection)list);
        Util.shuffle(p_230925_, p_230927_);
    }

    private List<Integer> getAvailableSlots(Container p_230920_, RandomSource p_230921_) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        for (int i = 0; i < p_230920_.getContainerSize(); ++i) {
            if (!p_230920_.getItem(i).isEmpty()) continue;
            objectarraylist.add((Object)i);
        }
        Util.shuffle(objectarraylist, p_230921_);
        return objectarraylist;
    }

    public static Builder lootTable() {
        return new Builder();
    }

    public void freeze() {
        this.isFrozen = true;
        this.pools.forEach(LootPool::freeze);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootTable after being finalized!");
        }
    }

    public void setLootTableId(ResourceLocation id) {
        if (this.lootTableId != null) {
            throw new IllegalStateException("Attempted to rename loot table from '" + String.valueOf(this.lootTableId) + "' to '" + String.valueOf(id) + "': this is not supported");
        }
        this.lootTableId = Objects.requireNonNull(id);
    }

    public ResourceLocation getLootTableId() {
        return this.lootTableId;
    }

    @Nullable
    public LootPool getPool(String name) {
        return this.pools.stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
    }

    @Nullable
    public LootPool removePool(String name) {
        this.checkFrozen();
        for (LootPool pool : this.pools) {
            if (!name.equals(pool.getName())) continue;
            this.pools.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(LootPool pool) {
        this.checkFrozen();
        if (this.pools.stream().anyMatch(e -> e == pool || e.getName() != null && e.getName().equals(pool.getName()))) {
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + pool.getName());
        }
        this.pools.add(pool);
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPool> pools = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private LootContextParamSet paramSet = DEFAULT_PARAM_SET;
        private Optional<ResourceLocation> randomSequence = Optional.empty();

        public Builder withPool(LootPool.Builder p_79162_) {
            this.pools.add((Object)p_79162_.build());
            return this;
        }

        public Builder setParamSet(LootContextParamSet p_79166_) {
            this.paramSet = p_79166_;
            return this;
        }

        public Builder setRandomSequence(ResourceLocation p_287667_) {
            this.randomSequence = Optional.of(p_287667_);
            return this;
        }

        public Builder apply(LootItemFunction.Builder p_79164_) {
            this.functions.add((Object)p_79164_.build());
            return this;
        }

        public Builder unwrap() {
            return this;
        }

        public LootTable build() {
            return new LootTable(this.paramSet, this.randomSequence, (List<LootPool>)this.pools.build(), (List<LootItemFunction>)this.functions.build());
        }
    }
}

