/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.phys.Vec3;

public record DamageSourcePredicate(List<TagPredicate<DamageType>> tags, Optional<EntityPredicate> directEntity, Optional<EntityPredicate> sourceEntity) {
    public static final Codec<DamageSourcePredicate> CODEC = RecordCodecBuilder.create(p_337351_ -> p_337351_.group((App)TagPredicate.codec(Registries.DAMAGE_TYPE).listOf().optionalFieldOf("tags", List.of()).forGetter(DamageSourcePredicate::tags), (App)EntityPredicate.CODEC.optionalFieldOf("direct_entity").forGetter(DamageSourcePredicate::directEntity), (App)EntityPredicate.CODEC.optionalFieldOf("source_entity").forGetter(DamageSourcePredicate::sourceEntity)).apply((Applicative)p_337351_, DamageSourcePredicate::new));

    public boolean matches(ServerPlayer p_25449_, DamageSource p_25450_) {
        return this.matches(p_25449_.serverLevel(), p_25449_.position(), p_25450_);
    }

    public boolean matches(ServerLevel p_25445_, Vec3 p_25446_, DamageSource p_25447_) {
        for (TagPredicate<DamageType> $$3 : this.tags) {
            if ($$3.matches(p_25447_.typeHolder())) continue;
            return false;
        }
        if (this.directEntity.isPresent() && !this.directEntity.get().matches(p_25445_, p_25446_, p_25447_.getDirectEntity())) {
            return false;
        }
        return !this.sourceEntity.isPresent() || this.sourceEntity.get().matches(p_25445_, p_25446_, p_25447_.getEntity());
    }

    public static class Builder {
        private final ImmutableList.Builder<TagPredicate<DamageType>> tags = ImmutableList.builder();
        private Optional<EntityPredicate> directEntity = Optional.empty();
        private Optional<EntityPredicate> sourceEntity = Optional.empty();

        public static Builder damageType() {
            return new Builder();
        }

        public Builder tag(TagPredicate<DamageType> p_270455_) {
            this.tags.add(p_270455_);
            return this;
        }

        public Builder direct(EntityPredicate.Builder p_25473_) {
            this.directEntity = Optional.of(p_25473_.build());
            return this;
        }

        public Builder source(EntityPredicate.Builder p_148232_) {
            this.sourceEntity = Optional.of(p_148232_.build());
            return this;
        }

        public DamageSourcePredicate build() {
            return new DamageSourcePredicate((List<TagPredicate<DamageType>>)this.tags.build(), this.directEntity, this.sourceEntity);
        }
    }
}

