/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public record EnchantmentPredicate(Optional<Holder<Enchantment>> enchantment, MinMaxBounds.Ints level) {
    public static final Codec<EnchantmentPredicate> CODEC = RecordCodecBuilder.create(p_337357_ -> p_337357_.group((App)BuiltInRegistries.ENCHANTMENT.holderByNameCodec().optionalFieldOf("enchantment").forGetter(EnchantmentPredicate::enchantment), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("levels", (Object)MinMaxBounds.Ints.ANY).forGetter(EnchantmentPredicate::level)).apply((Applicative)p_337357_, EnchantmentPredicate::new));

    public EnchantmentPredicate(Enchantment p_30471_, MinMaxBounds.Ints p_30472_) {
        this(Optional.of(p_30471_.builtInRegistryHolder()), p_30472_);
    }

    public boolean containedIn(ItemEnchantments p_330878_) {
        if (this.enchantment.isPresent()) {
            Enchantment $$1 = this.enchantment.get().value();
            int $$2 = p_330878_.getLevel($$1);
            if ($$2 == 0) {
                return false;
            }
            if (this.level != MinMaxBounds.Ints.ANY && !this.level.matches($$2)) {
                return false;
            }
        } else if (this.level != MinMaxBounds.Ints.ANY) {
            for (Object2IntMap.Entry<Holder<Enchantment>> $$3 : p_330878_.entrySet()) {
                if (!this.level.matches($$3.getIntValue())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

