/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record PlayerPredicate(MinMaxBounds.Ints level, Optional<GameType> gameType, List<StatMatcher<?>> stats, Object2BooleanMap<ResourceLocation> recipes, Map<ResourceLocation, AdvancementPredicate> advancements, Optional<EntityPredicate> lookingAt) implements EntitySubPredicate
{
    public static final int LOOKING_AT_RANGE = 100;
    public static final MapCodec<PlayerPredicate> CODEC = RecordCodecBuilder.mapCodec(p_297911_ -> p_297911_.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("level", (Object)MinMaxBounds.Ints.ANY).forGetter(PlayerPredicate::level), (App)GameType.CODEC.optionalFieldOf("gamemode").forGetter(PlayerPredicate::gameType), (App)StatMatcher.CODEC.listOf().optionalFieldOf("stats", List.of()).forGetter(PlayerPredicate::stats), (App)ExtraCodecs.object2BooleanMap(ResourceLocation.CODEC).optionalFieldOf("recipes", (Object)Object2BooleanMaps.emptyMap()).forGetter(PlayerPredicate::recipes), (App)Codec.unboundedMap(ResourceLocation.CODEC, AdvancementPredicate.CODEC).optionalFieldOf("advancements", Map.of()).forGetter(PlayerPredicate::advancements), (App)EntityPredicate.CODEC.optionalFieldOf("looking_at").forGetter(PlayerPredicate::lookingAt)).apply((Applicative)p_297911_, PlayerPredicate::new));

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean matches(Entity p_222484_, ServerLevel p_222485_, @Nullable Vec3 p_222486_) {
        void $$4;
        if (!(p_222484_ instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer $$3 = (ServerPlayer)p_222484_;
        if (!this.level.matches($$4.experienceLevel)) {
            return false;
        }
        if (this.gameType.isPresent() && this.gameType.get() != $$4.gameMode.getGameModeForPlayer()) {
            return false;
        }
        ServerStatsCounter $$5 = $$4.getStats();
        for (StatMatcher<?> statMatcher : this.stats) {
            if (statMatcher.matches($$5)) continue;
            return false;
        }
        ServerRecipeBook $$7 = $$4.getRecipeBook();
        for (Object2BooleanMap.Entry $$8 : this.recipes.object2BooleanEntrySet()) {
            if ($$7.contains((ResourceLocation)$$8.getKey()) == $$8.getBooleanValue()) continue;
            return false;
        }
        if (!this.advancements.isEmpty()) {
            PlayerAdvancements playerAdvancements = $$4.getAdvancements();
            ServerAdvancementManager $$10 = $$4.getServer().getAdvancements();
            for (Map.Entry<ResourceLocation, AdvancementPredicate> $$11 : this.advancements.entrySet()) {
                AdvancementHolder $$12 = $$10.get($$11.getKey());
                if ($$12 != null && $$11.getValue().test(playerAdvancements.getOrStartProgress($$12))) continue;
                return false;
            }
        }
        if (this.lookingAt.isPresent()) {
            Vec3 vec3 = $$4.getEyePosition();
            Vec3 $$14 = $$4.getViewVector(1.0f);
            Vec3 $$15 = vec3.add($$14.x * 100.0, $$14.y * 100.0, $$14.z * 100.0);
            EntityHitResult $$16 = ProjectileUtil.getEntityHitResult($$4.level(), (Entity)$$4, vec3, $$15, new AABB(vec3, $$15).inflate(1.0), p_156765_ -> !p_156765_.isSpectator(), 0.0f);
            if ($$16 == null || $$16.getType() != HitResult.Type.ENTITY) {
                return false;
            }
            Entity $$17 = $$16.getEntity();
            if (!this.lookingAt.get().matches((ServerPlayer)$$4, $$17) || !$$4.hasLineOfSight($$17)) {
                return false;
            }
        }
        return true;
    }

    public MapCodec<PlayerPredicate> codec() {
        return EntitySubPredicates.PLAYER;
    }

    record StatMatcher<T>(StatType<T> type, Holder<T> value, MinMaxBounds.Ints range, Supplier<Stat<T>> stat) {
        public static final Codec<StatMatcher<?>> CODEC = BuiltInRegistries.STAT_TYPE.byNameCodec().dispatch(StatMatcher::type, StatMatcher::createTypedCodec);

        public StatMatcher(StatType<T> p_299207_, Holder<T> p_298208_, MinMaxBounds.Ints p_299102_) {
            this(p_299207_, p_298208_, p_299102_, (Supplier<Stat<T>>)Suppliers.memoize(() -> p_299207_.get(p_298208_.value())));
        }

        private static <T> MapCodec<StatMatcher<T>> createTypedCodec(StatType<T> p_299086_) {
            return RecordCodecBuilder.mapCodec(p_337389_ -> p_337389_.group((App)p_299086_.getRegistry().holderByNameCodec().fieldOf("stat").forGetter(StatMatcher::value), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("value", (Object)MinMaxBounds.Ints.ANY).forGetter(StatMatcher::range)).apply((Applicative)p_337389_, (p_298946_, p_299298_) -> new StatMatcher(p_299086_, p_298946_, (MinMaxBounds.Ints)p_299298_)));
        }

        public boolean matches(StatsCounter p_298568_) {
            return this.range.matches(p_298568_.getValue(this.stat.get()));
        }
    }

    static interface AdvancementPredicate
    extends Predicate<AdvancementProgress> {
        public static final Codec<AdvancementPredicate> CODEC = Codec.either(AdvancementDonePredicate.CODEC, AdvancementCriterionsPredicate.CODEC).xmap(Either::unwrap, p_298611_ -> {
            if (p_298611_ instanceof AdvancementDonePredicate) {
                AdvancementDonePredicate $$1 = (AdvancementDonePredicate)p_298611_;
                return Either.left((Object)$$1);
            }
            if (p_298611_ instanceof AdvancementCriterionsPredicate) {
                AdvancementCriterionsPredicate $$2 = (AdvancementCriterionsPredicate)p_298611_;
                return Either.right((Object)$$2);
            }
            throw new UnsupportedOperationException();
        });
    }

    public static class Builder {
        private MinMaxBounds.Ints level = MinMaxBounds.Ints.ANY;
        private Optional<GameType> gameType = Optional.empty();
        private final ImmutableList.Builder<StatMatcher<?>> stats = ImmutableList.builder();
        private final Object2BooleanMap<ResourceLocation> recipes = new Object2BooleanOpenHashMap();
        private final Map<ResourceLocation, AdvancementPredicate> advancements = Maps.newHashMap();
        private Optional<EntityPredicate> lookingAt = Optional.empty();

        public static Builder player() {
            return new Builder();
        }

        public Builder setLevel(MinMaxBounds.Ints p_156776_) {
            this.level = p_156776_;
            return this;
        }

        public <T> Builder addStat(StatType<T> p_299266_, Holder.Reference<T> p_299053_, MinMaxBounds.Ints p_156770_) {
            this.stats.add(new StatMatcher<T>(p_299266_, p_299053_, p_156770_));
            return this;
        }

        public Builder addRecipe(ResourceLocation p_156781_, boolean p_156782_) {
            this.recipes.put((Object)p_156781_, p_156782_);
            return this;
        }

        public Builder setGameType(GameType p_156774_) {
            this.gameType = Optional.of(p_156774_);
            return this;
        }

        public Builder setLookingAt(EntityPredicate.Builder p_301131_) {
            this.lookingAt = Optional.of(p_301131_.build());
            return this;
        }

        public Builder checkAdvancementDone(ResourceLocation p_156784_, boolean p_156785_) {
            this.advancements.put(p_156784_, new AdvancementDonePredicate(p_156785_));
            return this;
        }

        public Builder checkAdvancementCriterions(ResourceLocation p_156778_, Map<String, Boolean> p_156779_) {
            this.advancements.put(p_156778_, new AdvancementCriterionsPredicate((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(p_156779_)));
            return this;
        }

        public PlayerPredicate build() {
            return new PlayerPredicate(this.level, this.gameType, (List<StatMatcher<?>>)this.stats.build(), this.recipes, this.advancements, this.lookingAt);
        }
    }

    record AdvancementCriterionsPredicate(Object2BooleanMap<String> criterions) implements AdvancementPredicate
    {
        public static final Codec<AdvancementCriterionsPredicate> CODEC = ExtraCodecs.object2BooleanMap(Codec.STRING).xmap(AdvancementCriterionsPredicate::new, AdvancementCriterionsPredicate::criterions);

        @Override
        public boolean test(AdvancementProgress p_62296_) {
            for (Object2BooleanMap.Entry $$1 : this.criterions.object2BooleanEntrySet()) {
                CriterionProgress $$2 = p_62296_.getCriterion((String)$$1.getKey());
                if ($$2 != null && $$2.isDone() == $$1.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    record AdvancementDonePredicate(boolean state) implements AdvancementPredicate
    {
        public static final Codec<AdvancementDonePredicate> CODEC = Codec.BOOL.xmap(AdvancementDonePredicate::new, AdvancementDonePredicate::state);

        @Override
        public boolean test(AdvancementProgress p_62304_) {
            return p_62304_.isDone() == this.state;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }
}

