/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class EntityArgument
implements ArgumentType<EntitySelector> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_ENTITY = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.toomany"));
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable("argument.player.toomany"));
    public static final SimpleCommandExceptionType ERROR_ONLY_PLAYERS_ALLOWED = new SimpleCommandExceptionType((Message)Component.translatable("argument.player.entities"));
    public static final SimpleCommandExceptionType NO_ENTITIES_FOUND = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType ERROR_SELECTORS_NOT_ALLOWED = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.selector.not_allowed"));
    final boolean single;
    final boolean playersOnly;

    protected EntityArgument(boolean p_91447_, boolean p_91448_) {
        this.single = p_91447_;
        this.playersOnly = p_91448_;
    }

    public static EntityArgument entity() {
        return new EntityArgument(true, false);
    }

    public static Entity getEntity(CommandContext<CommandSourceStack> p_91453_, String p_91454_) throws CommandSyntaxException {
        return ((EntitySelector)p_91453_.getArgument(p_91454_, EntitySelector.class)).findSingleEntity((CommandSourceStack)p_91453_.getSource());
    }

    public static EntityArgument entities() {
        return new EntityArgument(false, false);
    }

    public static Collection<? extends Entity> getEntities(CommandContext<CommandSourceStack> p_91462_, String p_91463_) throws CommandSyntaxException {
        Collection<? extends Entity> $$2 = EntityArgument.getOptionalEntities(p_91462_, p_91463_);
        if ($$2.isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return $$2;
    }

    public static Collection<? extends Entity> getOptionalEntities(CommandContext<CommandSourceStack> p_91468_, String p_91469_) throws CommandSyntaxException {
        return ((EntitySelector)p_91468_.getArgument(p_91469_, EntitySelector.class)).findEntities((CommandSourceStack)p_91468_.getSource());
    }

    public static Collection<ServerPlayer> getOptionalPlayers(CommandContext<CommandSourceStack> p_91472_, String p_91473_) throws CommandSyntaxException {
        return ((EntitySelector)p_91472_.getArgument(p_91473_, EntitySelector.class)).findPlayers((CommandSourceStack)p_91472_.getSource());
    }

    public static EntityArgument player() {
        return new EntityArgument(true, true);
    }

    public static ServerPlayer getPlayer(CommandContext<CommandSourceStack> p_91475_, String p_91476_) throws CommandSyntaxException {
        return ((EntitySelector)p_91475_.getArgument(p_91476_, EntitySelector.class)).findSinglePlayer((CommandSourceStack)p_91475_.getSource());
    }

    public static EntityArgument players() {
        return new EntityArgument(false, true);
    }

    public static Collection<ServerPlayer> getPlayers(CommandContext<CommandSourceStack> p_91478_, String p_91479_) throws CommandSyntaxException {
        List<ServerPlayer> $$2 = ((EntitySelector)p_91478_.getArgument(p_91479_, EntitySelector.class)).findPlayers((CommandSourceStack)p_91478_.getSource());
        if ($$2.isEmpty()) {
            throw NO_PLAYERS_FOUND.create();
        }
        return $$2;
    }

    public EntitySelector parse(StringReader p_91451_) throws CommandSyntaxException {
        boolean $$1 = false;
        EntitySelectorParser $$2 = new EntitySelectorParser(p_91451_);
        EntitySelector $$3 = $$2.parse();
        if ($$3.getMaxResults() > 1 && this.single) {
            if (this.playersOnly) {
                p_91451_.setCursor(0);
                throw ERROR_NOT_SINGLE_PLAYER.createWithContext((ImmutableStringReader)p_91451_);
            }
            p_91451_.setCursor(0);
            throw ERROR_NOT_SINGLE_ENTITY.createWithContext((ImmutableStringReader)p_91451_);
        }
        if ($$3.includesEntities() && this.playersOnly && !$$3.isSelfSelector()) {
            p_91451_.setCursor(0);
            throw ERROR_ONLY_PLAYERS_ALLOWED.createWithContext((ImmutableStringReader)p_91451_);
        }
        return $$3;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_91482_, SuggestionsBuilder p_91483_) {
        Object object = p_91482_.getSource();
        if (object instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider $$2 = (SharedSuggestionProvider)object;
            StringReader $$3 = new StringReader(p_91483_.getInput());
            $$3.setCursor(p_91483_.getStart());
            EntitySelectorParser $$4 = new EntitySelectorParser($$3, $$2.hasPermission(2));
            try {
                $$4.parse();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return $$4.fillSuggestions(p_91483_, p_91457_ -> {
                Collection<String> $$2 = $$2.getOnlinePlayerNames();
                Collection<String> $$3 = this.playersOnly ? $$2 : Iterables.concat($$2, $$2.getSelectedEntities());
                SharedSuggestionProvider.suggest($$3, p_91457_);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class Info
    implements ArgumentTypeInfo<EntityArgument, Template> {
        private static final byte FLAG_SINGLE = 1;
        private static final byte FLAG_PLAYERS_ONLY = 2;

        @Override
        public void serializeToNetwork(Template p_231271_, FriendlyByteBuf p_231272_) {
            int $$2 = 0;
            if (p_231271_.single) {
                $$2 |= 1;
            }
            if (p_231271_.playersOnly) {
                $$2 |= 2;
            }
            p_231272_.writeByte($$2);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf p_231282_) {
            byte $$1 = p_231282_.readByte();
            return new Template(($$1 & 1) != 0, ($$1 & 2) != 0);
        }

        @Override
        public void serializeToJson(Template p_231268_, JsonObject p_231269_) {
            p_231269_.addProperty("amount", p_231268_.single ? "single" : "multiple");
            p_231269_.addProperty("type", p_231268_.playersOnly ? "players" : "entities");
        }

        @Override
        public Template unpack(EntityArgument p_231274_) {
            return new Template(p_231274_.single, p_231274_.playersOnly);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return this.deserializeFromNetwork(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<EntityArgument> {
            final boolean single;
            final boolean playersOnly;

            Template(boolean p_231290_, boolean p_231291_) {
                this.single = p_231290_;
                this.playersOnly = p_231291_;
            }

            @Override
            public EntityArgument instantiate(CommandBuildContext p_231294_) {
                return new EntityArgument(this.single, this.playersOnly);
            }

            @Override
            public ArgumentTypeInfo<EntityArgument, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

