/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemInput {
    private static final Dynamic2CommandExceptionType ERROR_STACK_TOO_BIG = new Dynamic2CommandExceptionType((p_304131_, p_304132_) -> Component.translatableEscape("arguments.item.overstacked", p_304131_, p_304132_));
    private final Holder<Item> item;
    private final DataComponentMap components;

    public ItemInput(Holder<Item> p_235282_, DataComponentMap p_330777_) {
        this.item = p_235282_;
        this.components = p_330777_;
    }

    public Item getItem() {
        return this.item.value();
    }

    public ItemStack createItemStack(int p_120981_, boolean p_120982_) throws CommandSyntaxException {
        ItemStack $$2 = new ItemStack(this.item, p_120981_);
        $$2.applyComponents(this.components);
        if (p_120982_ && p_120981_ > $$2.getMaxStackSize()) {
            throw ERROR_STACK_TOO_BIG.create((Object)this.getItemName(), (Object)$$2.getMaxStackSize());
        }
        return $$2;
    }

    public String serialize(HolderLookup.Provider p_330692_) {
        StringBuilder $$1 = new StringBuilder(this.getItemName());
        String $$2 = this.serializeComponents(p_330692_);
        if (!$$2.isEmpty()) {
            $$1.append('[');
            $$1.append($$2);
            $$1.append(']');
        }
        return $$1.toString();
    }

    private String serializeComponents(HolderLookup.Provider p_331015_) {
        RegistryOps<Tag> $$1 = p_331015_.createSerializationContext(NbtOps.INSTANCE);
        return this.components.stream().flatMap(p_339321_ -> {
            DataComponentType $$2 = p_339321_.type();
            ResourceLocation $$3 = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey($$2);
            Optional $$4 = p_339321_.encodeValue($$1).result();
            if ($$3 == null || $$4.isEmpty()) {
                return Stream.empty();
            }
            return Stream.of($$3.toString() + "=" + String.valueOf($$4.get()));
        }).collect(Collectors.joining(String.valueOf(',')));
    }

    private String getItemName() {
        return this.item.unwrapKey().map(ResourceKey::location).orElseGet(() -> "unknown[" + String.valueOf(this.item) + "]").toString();
    }
}

