/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public interface DataComponentMap
extends Iterable<TypedDataComponent<?>> {
    public static final DataComponentMap EMPTY = new DataComponentMap(){

        @Override
        @Nullable
        public <T> T get(DataComponentType<? extends T> p_331168_) {
            return null;
        }

        @Override
        public Set<DataComponentType<?>> keySet() {
            return Set.of();
        }

        @Override
        public Iterator<TypedDataComponent<?>> iterator() {
            return Collections.emptyIterator();
        }
    };
    public static final Codec<DataComponentMap> CODEC = DataComponentType.VALUE_MAP_CODEC.flatComapMap(Builder::buildFromMapTrusted, p_337448_ -> {
        int $$1 = p_337448_.size();
        if ($$1 == 0) {
            return DataResult.success((Object)Reference2ObjectMaps.emptyMap());
        }
        Reference2ObjectArrayMap $$2 = new Reference2ObjectArrayMap($$1);
        for (TypedDataComponent<?> $$3 : p_337448_) {
            if ($$3.type().isTransient()) continue;
            $$2.put($$3.type(), $$3.value());
        }
        return DataResult.success((Object)$$2);
    });

    public static DataComponentMap composite(final DataComponentMap p_340974_, final DataComponentMap p_341350_) {
        return new DataComponentMap(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> p_330291_) {
                T $$1 = p_341350_.get(p_330291_);
                if ($$1 != null) {
                    return $$1;
                }
                return p_340974_.get(p_330291_);
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return Sets.union(p_340974_.keySet(), p_341350_.keySet());
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> var1);

    public Set<DataComponentType<?>> keySet();

    default public boolean has(DataComponentType<?> p_330409_) {
        return this.get(p_330409_) != null;
    }

    default public <T> T getOrDefault(DataComponentType<? extends T> p_331896_, T p_331597_) {
        T $$2 = this.get(p_331896_);
        return $$2 != null ? $$2 : p_331597_;
    }

    @Nullable
    default public <T> TypedDataComponent<T> getTyped(DataComponentType<T> p_330594_) {
        T $$1 = this.get(p_330594_);
        return $$1 != null ? new TypedDataComponent<T>(p_330594_, $$1) : null;
    }

    @Override
    default public Iterator<TypedDataComponent<?>> iterator() {
        return Iterators.transform(this.keySet().iterator(), p_330954_ -> Objects.requireNonNull(this.getTyped((DataComponentType)p_330954_)));
    }

    default public Stream<TypedDataComponent<?>> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.size(), 1345), false);
    }

    default public int size() {
        return this.keySet().size();
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public DataComponentMap filter(final Predicate<DataComponentType<?>> p_331448_) {
        return new DataComponentMap(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> p_341052_) {
                return p_331448_.test(p_341052_) ? (T)DataComponentMap.this.get(p_341052_) : null;
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return Sets.filter(DataComponentMap.this.keySet(), p_331448_::test);
            }
        };
    }

    public static class Builder {
        private final Reference2ObjectMap<DataComponentType<?>, Object> map = new Reference2ObjectArrayMap();

        Builder() {
        }

        public <T> Builder set(DataComponentType<T> p_330228_, @Nullable T p_332186_) {
            this.setUnchecked(p_330228_, p_332186_);
            return this;
        }

        <T> void setUnchecked(DataComponentType<T> p_338736_, @Nullable Object p_338594_) {
            if (p_338594_ != null) {
                this.map.put(p_338736_, p_338594_);
            } else {
                this.map.remove(p_338736_);
            }
        }

        public Builder addAll(DataComponentMap p_331194_) {
            for (TypedDataComponent<?> $$1 : p_331194_) {
                this.map.put($$1.type(), $$1.value());
            }
            return this;
        }

        public DataComponentMap build() {
            return Builder.buildFromMapTrusted(this.map);
        }

        private static DataComponentMap buildFromMapTrusted(Map<DataComponentType<?>, Object> p_338248_) {
            if (p_338248_.isEmpty()) {
                return EMPTY;
            }
            if (p_338248_.size() < 8) {
                return new SimpleMap((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectArrayMap(p_338248_));
            }
            return new SimpleMap((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectOpenHashMap(p_338248_));
        }

        record SimpleMap(Reference2ObjectMap<DataComponentType<?>, Object> map) implements DataComponentMap
        {
            @Override
            @Nullable
            public <T> T get(DataComponentType<? extends T> p_331063_) {
                return (T)this.map.get(p_331063_);
            }

            @Override
            public boolean has(DataComponentType<?> p_331343_) {
                return this.map.containsKey(p_331343_);
            }

            @Override
            public Set<DataComponentType<?>> keySet() {
                return this.map.keySet();
            }

            @Override
            public Iterator<TypedDataComponent<?>> iterator() {
                return Iterators.transform((Iterator)Reference2ObjectMaps.fastIterator(this.map), TypedDataComponent::fromEntryUnchecked);
            }

            @Override
            public int size() {
                return this.map.size();
            }

            @Override
            public String toString() {
                return this.map.toString();
            }
        }
    }
}

