/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;

public final class DataComponentPatch {
    public static final DataComponentPatch EMPTY = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> CODEC = Codec.dispatchedMap(PatchKey.CODEC, PatchKey::valueCodec).xmap(p_330885_ -> {
        if (p_330885_.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap $$1 = new Reference2ObjectArrayMap(p_330885_.size());
        for (Map.Entry $$2 : p_330885_.entrySet()) {
            PatchKey $$3 = (PatchKey)$$2.getKey();
            if ($$3.removed()) {
                $$1.put($$3.type(), Optional.empty());
                continue;
            }
            $$1.put($$3.type(), Optional.of($$2.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)$$1);
    }, p_332132_ -> {
        Reference2ObjectArrayMap $$1 = new Reference2ObjectArrayMap(p_332132_.map.size());
        for (Map.Entry $$2 : Reference2ObjectMaps.fastIterable(p_332132_.map)) {
            DataComponentType $$3 = (DataComponentType)$$2.getKey();
            if ($$3.isTransient()) continue;
            Optional $$4 = (Optional)$$2.getValue();
            if ($$4.isPresent()) {
                $$1.put((Object)new PatchKey($$3, false), $$4.get());
                continue;
            }
            $$1.put((Object)new PatchKey($$3, true), (Object)Unit.INSTANCE);
        }
        return $$1;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

        @Override
        public DataComponentPatch decode(RegistryFriendlyByteBuf p_331850_) {
            int $$1 = p_331850_.readVarInt();
            int $$2 = p_331850_.readVarInt();
            if ($$1 == 0 && $$2 == 0) {
                return EMPTY;
            }
            Reference2ObjectArrayMap $$3 = new Reference2ObjectArrayMap($$1 + $$2);
            for (int $$4 = 0; $$4 < $$1; ++$$4) {
                DataComponentType $$5 = (DataComponentType)DataComponentType.STREAM_CODEC.decode(p_331850_);
                Object $$6 = $$5.streamCodec().decode(p_331850_);
                $$3.put((Object)$$5, Optional.of($$6));
            }
            for (int $$7 = 0; $$7 < $$2; ++$$7) {
                DataComponentType $$8 = (DataComponentType)DataComponentType.STREAM_CODEC.decode(p_331850_);
                $$3.put((Object)$$8, Optional.empty());
            }
            return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)$$3);
        }

        @Override
        public void encode(RegistryFriendlyByteBuf p_330636_, DataComponentPatch p_330346_) {
            if (p_330346_.isEmpty()) {
                p_330636_.writeVarInt(0);
                p_330636_.writeVarInt(0);
                return;
            }
            int $$2 = 0;
            int $$3 = 0;
            for (Reference2ObjectMap.Entry $$4 : Reference2ObjectMaps.fastIterable(p_330346_.map)) {
                if (((Optional)$$4.getValue()).isPresent()) {
                    ++$$2;
                    continue;
                }
                ++$$3;
            }
            p_330636_.writeVarInt($$2);
            p_330636_.writeVarInt($$3);
            for (Reference2ObjectMap.Entry $$5 : Reference2ObjectMaps.fastIterable(p_330346_.map)) {
                Optional $$6 = (Optional)$$5.getValue();
                if (!$$6.isPresent()) continue;
                DataComponentType $$7 = (DataComponentType)$$5.getKey();
                DataComponentType.STREAM_CODEC.encode(p_330636_, $$7);
                1.encodeComponent(p_330636_, $$7, $$6.get());
            }
            for (Reference2ObjectMap.Entry $$8 : Reference2ObjectMaps.fastIterable(p_330346_.map)) {
                if (!((Optional)$$8.getValue()).isEmpty()) continue;
                DataComponentType $$9 = (DataComponentType)$$8.getKey();
                DataComponentType.STREAM_CODEC.encode(p_330636_, $$9);
            }
        }

        private static <T> void encodeComponent(RegistryFriendlyByteBuf p_331735_, DataComponentType<T> p_330633_, Object p_331089_) {
            p_330633_.streamCodec().encode(p_331735_, p_331089_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((RegistryFriendlyByteBuf)((Object)object), (DataComponentPatch)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((RegistryFriendlyByteBuf)((Object)object));
        }
    };
    private static final String REMOVED_PREFIX = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map;

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> p_331816_) {
        this.map = p_331816_;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public <T> Optional<? extends T> get(DataComponentType<? extends T> p_331532_) {
        return (Optional)this.map.get(p_331532_);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public DataComponentPatch forget(Predicate<DataComponentType<?>> p_338629_) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap $$1 = new Reference2ObjectArrayMap(this.map);
        $$1.keySet().removeIf(p_338629_);
        if ($$1.isEmpty()) {
            return EMPTY;
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)$$1);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public SplitResult split() {
        if (this.isEmpty()) {
            return SplitResult.EMPTY;
        }
        DataComponentMap.Builder $$0 = DataComponentMap.builder();
        Set $$1 = Sets.newIdentityHashSet();
        this.map.forEach((p_337451_, p_337452_) -> {
            if (p_337452_.isPresent()) {
                $$0.setUnchecked(p_337451_, p_337452_.get());
            } else {
                $$1.add(p_337451_);
            }
        });
        return new SplitResult($$0.build(), $$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_331686_) {
        if (this == p_331686_) {
            return true;
        }
        if (!(p_331686_ instanceof DataComponentPatch)) return false;
        DataComponentPatch $$1 = (DataComponentPatch)p_331686_;
        if (!this.map.equals($$1.map)) return false;
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return DataComponentPatch.toString(this.map);
    }

    static String toString(Reference2ObjectMap<DataComponentType<?>, Optional<?>> p_330935_) {
        StringBuilder $$1 = new StringBuilder();
        $$1.append('{');
        boolean $$2 = true;
        for (Map.Entry $$3 : Reference2ObjectMaps.fastIterable(p_330935_)) {
            if ($$2) {
                $$2 = false;
            } else {
                $$1.append(", ");
            }
            Optional $$4 = (Optional)$$3.getValue();
            if ($$4.isPresent()) {
                $$1.append($$3.getKey());
                $$1.append("=>");
                $$1.append($$4.get());
                continue;
            }
            $$1.append(REMOVED_PREFIX);
            $$1.append($$3.getKey());
        }
        $$1.append('}');
        return $$1.toString();
    }

    public static class Builder {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map = new Reference2ObjectArrayMap();

        Builder() {
        }

        public <T> Builder set(DataComponentType<T> p_332004_, T p_331566_) {
            this.map.put(p_332004_, Optional.of(p_331566_));
            return this;
        }

        public <T> Builder remove(DataComponentType<T> p_330845_) {
            this.map.put(p_330845_, Optional.empty());
            return this;
        }

        public <T> Builder set(TypedDataComponent<T> p_331321_) {
            return this.set(p_331321_.type(), p_331321_.value());
        }

        public DataComponentPatch build() {
            if (this.map.isEmpty()) {
                return EMPTY;
            }
            return new DataComponentPatch(this.map);
        }
    }

    public record SplitResult(DataComponentMap added, Set<DataComponentType<?>> removed) {
        public static final SplitResult EMPTY = new SplitResult(DataComponentMap.EMPTY, Set.of());
    }

    record PatchKey(DataComponentType<?> type, boolean removed) {
        public static final Codec<PatchKey> CODEC = Codec.STRING.flatXmap(p_330929_ -> {
            ResourceLocation $$2;
            DataComponentType<?> $$3;
            boolean $$1 = p_330929_.startsWith(DataComponentPatch.REMOVED_PREFIX);
            if ($$1) {
                p_330929_ = p_330929_.substring(DataComponentPatch.REMOVED_PREFIX.length());
            }
            if (($$3 = BuiltInRegistries.DATA_COMPONENT_TYPE.get($$2 = ResourceLocation.tryParse(p_330929_))) == null) {
                return DataResult.error(() -> "No component with type: '" + String.valueOf($$2) + "'");
            }
            if ($$3.isTransient()) {
                return DataResult.error(() -> "'" + String.valueOf($$2) + "' is not a persistent component");
            }
            return DataResult.success((Object)new PatchKey($$3, $$1));
        }, p_339345_ -> {
            DataComponentType<?> $$1 = p_339345_.type();
            ResourceLocation $$2 = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey($$1);
            if ($$2 == null) {
                return DataResult.error(() -> "Unregistered component: " + String.valueOf($$1));
            }
            return DataResult.success((Object)(p_339345_.removed() ? DataComponentPatch.REMOVED_PREFIX + String.valueOf($$2) : $$2.toString()));
        });

        public Codec<?> valueCodec() {
            return this.removed ? Codec.EMPTY.codec() : this.type.codecOrThrow();
        }
    }
}

