/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.WorldVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.UpdateOneTwentyOneAdvancementProvider;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.ItemListReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.TradeRebalanceLootTableProvider;
import net.minecraft.data.loot.packs.UpdateOneTwentyOneLootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.packs.BundleRecipeProvider;
import net.minecraft.data.recipes.packs.UpdateOneTwentyOneRecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.UpdateOneTwentyOneRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.CatVariantTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.TradeRebalanceStructureTagsProvider;
import net.minecraft.data.tags.UpdateOneTwentyOneBannerPatternTagsProvider;
import net.minecraft.data.tags.UpdateOneTwentyOneBiomeTagsProvider;
import net.minecraft.data.tags.UpdateOneTwentyOneBlockTagsProvider;
import net.minecraft.data.tags.UpdateOneTwentyOneDamageTypeTagsProvider;
import net.minecraft.data.tags.UpdateOneTwentyOneEnchantmentTagsProvider;
import net.minecraft.data.tags.UpdateOneTwentyOneEntityTypeTagsProvider;
import net.minecraft.data.tags.UpdateOneTwentyOneItemTagsProvider;
import net.minecraft.data.tags.UpdateOneTwentyOneStructureTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaEnchantmentTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Main {
    @DontObfuscate
    public static void main(String[] p_129669_) throws IOException {
        SharedConstants.tryDetectVersion();
        OptionParser $$1 = new OptionParser();
        AbstractOptionSpec $$2 = $$1.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder $$3 = $$1.accepts("server", "Include server generators");
        OptionSpecBuilder $$4 = $$1.accepts("client", "Include client generators");
        OptionSpecBuilder $$5 = $$1.accepts("dev", "Include development tools");
        OptionSpecBuilder $$6 = $$1.accepts("reports", "Include data reports");
        OptionSpecBuilder $$7 = $$1.accepts("validate", "Validate inputs");
        OptionSpecBuilder $$8 = $$1.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec $$9 = $$1.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("input", "Input folder").withRequiredArg();
        OptionSet $$11 = $$1.parse(p_129669_);
        if ($$11.has((OptionSpec)$$2) || !$$11.hasOptions()) {
            $$1.printHelpOn((OutputStream)System.out);
            return;
        }
        Path $$12 = Paths.get((String)$$9.value($$11), new String[0]);
        boolean $$13 = $$11.has((OptionSpec)$$8);
        boolean $$14 = $$13 || $$11.has((OptionSpec)$$4);
        boolean $$15 = $$13 || $$11.has((OptionSpec)$$3);
        boolean $$16 = $$13 || $$11.has((OptionSpec)$$5);
        boolean $$17 = $$13 || $$11.has((OptionSpec)$$6);
        boolean $$18 = $$13 || $$11.has((OptionSpec)$$7);
        DataGenerator $$19 = Main.createStandardGenerator($$12, $$11.valuesOf((OptionSpec)$$10).stream().map(p_129659_ -> Paths.get(p_129659_, new String[0])).collect(Collectors.toList()), $$14, $$15, $$16, $$17, $$18, SharedConstants.getCurrentVersion(), true);
        $$19.run();
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> p_256618_, CompletableFuture<HolderLookup.Provider> p_256515_) {
        return p_255476_ -> (DataProvider)p_256618_.apply(p_255476_, p_256515_);
    }

    public static DataGenerator createStandardGenerator(Path p_236680_, Collection<Path> p_236681_, boolean p_236682_, boolean p_236683_, boolean p_236684_, boolean p_236685_, boolean p_236686_, WorldVersion p_236687_, boolean p_236688_) {
        DataGenerator $$9 = new DataGenerator(p_236680_, p_236687_, p_236688_);
        DataGenerator.PackGenerator $$10 = $$9.getVanillaPack(p_236682_ || p_236683_);
        $$10.addProvider(p_253388_ -> new SnbtToNbt(p_253388_, p_236681_).addFilter(new StructureUpdater()));
        CompletableFuture<HolderLookup.Provider> $$11 = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        DataGenerator.PackGenerator $$12 = $$9.getVanillaPack(p_236682_);
        $$12.addProvider(ModelProvider::new);
        DataGenerator.PackGenerator $$13 = $$9.getVanillaPack(p_236683_);
        $$13.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaAdvancementProvider::create, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaLootTableProvider::create, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaRecipeProvider::new, $$11));
        TagsProvider $$14 = $$13.addProvider(Main.bindRegistries(VanillaBlockTagsProvider::new, $$11));
        TagsProvider $$15 = $$13.addProvider(p_274753_ -> new VanillaItemTagsProvider(p_274753_, $$11, $$14.contentsGetter()));
        TagsProvider $$16 = $$13.addProvider(Main.bindRegistries(BiomeTagsProvider::new, $$11));
        TagsProvider $$17 = $$13.addProvider(Main.bindRegistries(BannerPatternTagsProvider::new, $$11));
        TagsProvider $$18 = $$13.addProvider(Main.bindRegistries(StructureTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(CatVariantTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(DamageTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(EntityTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(FlatLevelGeneratorPresetTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(FluidTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(GameEventTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(InstrumentTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(PaintingVariantTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(PoiTypeTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(WorldPresetTagsProvider::new, $$11));
        $$13.addProvider(Main.bindRegistries(VanillaEnchantmentTagsProvider::new, $$11));
        DataGenerator.PackGenerator $$19 = $$9.getVanillaPack(p_236684_);
        $$19.addProvider(p_253386_ -> new NbtToSnbt(p_253386_, p_236681_));
        DataGenerator.PackGenerator $$20 = $$9.getVanillaPack(p_236685_);
        $$20.addProvider(Main.bindRegistries(BiomeParametersDumpReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(ItemListReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(BlockListReport::new, $$11));
        $$20.addProvider(Main.bindRegistries(CommandsReport::new, $$11));
        $$20.addProvider(RegistryDumpReport::new);
        DataGenerator.PackGenerator $$21 = $$9.getBuiltinDatapack(p_236683_, "bundle");
        $$21.addProvider(Main.bindRegistries(BundleRecipeProvider::new, $$11));
        $$21.addProvider(p_253392_ -> PackMetadataGenerator.forFeaturePack(p_253392_, Component.translatable("dataPack.bundle.description"), FeatureFlagSet.of(FeatureFlags.BUNDLE)));
        DataGenerator.PackGenerator $$22 = $$9.getBuiltinDatapack(p_236683_, "trade_rebalance");
        $$22.addProvider(p_293698_ -> PackMetadataGenerator.forFeaturePack(p_293698_, Component.translatable("dataPack.trade_rebalance.description"), FeatureFlagSet.of(FeatureFlags.TRADE_REBALANCE)));
        $$22.addProvider(Main.bindRegistries(TradeRebalanceLootTableProvider::create, $$11));
        $$22.addProvider(Main.bindRegistries(TradeRebalanceStructureTagsProvider::new, $$11));
        CompletableFuture<RegistrySetBuilder.PatchedRegistries> $$23 = UpdateOneTwentyOneRegistries.createLookup($$11);
        CompletionStage $$24 = $$23.thenApply(RegistrySetBuilder.PatchedRegistries::full);
        DataGenerator.PackGenerator $$25 = $$9.getBuiltinDatapack(p_236683_, "update_1_21");
        $$25.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.Provider>)$$23.thenApply(RegistrySetBuilder.PatchedRegistries::patches)));
        $$25.addProvider(Main.bindRegistries(UpdateOneTwentyOneRecipeProvider::new, (CompletableFuture<HolderLookup.Provider>)$$24));
        TagsProvider $$26 = $$25.addProvider(arg_0 -> Main.lambda$createStandardGenerator$7((CompletableFuture)$$24, $$14, arg_0));
        $$25.addProvider(arg_0 -> Main.lambda$createStandardGenerator$8((CompletableFuture)$$24, $$15, $$26, arg_0));
        $$25.addProvider(arg_0 -> Main.lambda$createStandardGenerator$9((CompletableFuture)$$24, $$16, arg_0));
        $$25.addProvider(Main.bindRegistries(UpdateOneTwentyOneLootTableProvider::create, (CompletableFuture<HolderLookup.Provider>)$$24));
        $$25.addProvider(p_307134_ -> PackMetadataGenerator.forFeaturePack(p_307134_, Component.translatable("dataPack.update_1_21.description"), FeatureFlagSet.of(FeatureFlags.UPDATE_1_21)));
        $$25.addProvider(Main.bindRegistries(UpdateOneTwentyOneEntityTypeTagsProvider::new, (CompletableFuture<HolderLookup.Provider>)$$24));
        $$25.addProvider(Main.bindRegistries(UpdateOneTwentyOneDamageTypeTagsProvider::new, (CompletableFuture<HolderLookup.Provider>)$$24));
        $$25.addProvider(Main.bindRegistries(UpdateOneTwentyOneAdvancementProvider::create, (CompletableFuture<HolderLookup.Provider>)$$24));
        $$25.addProvider(arg_0 -> Main.lambda$createStandardGenerator$11((CompletableFuture)$$24, $$17, arg_0));
        $$25.addProvider(arg_0 -> Main.lambda$createStandardGenerator$12((CompletableFuture)$$24, $$18, arg_0));
        $$25.addProvider(Main.bindRegistries(UpdateOneTwentyOneEnchantmentTagsProvider::new, (CompletableFuture<HolderLookup.Provider>)$$24));
        return $$9;
    }

    private static /* synthetic */ UpdateOneTwentyOneStructureTagsProvider lambda$createStandardGenerator$12(CompletableFuture p_335182_, TagsProvider p_335183_, PackOutput p_335184_) {
        return new UpdateOneTwentyOneStructureTagsProvider(p_335184_, p_335182_, p_335183_.contentsGetter());
    }

    private static /* synthetic */ UpdateOneTwentyOneBannerPatternTagsProvider lambda$createStandardGenerator$11(CompletableFuture p_333482_, TagsProvider p_333483_, PackOutput p_333484_) {
        return new UpdateOneTwentyOneBannerPatternTagsProvider(p_333484_, p_333482_, p_333483_.contentsGetter());
    }

    private static /* synthetic */ UpdateOneTwentyOneBiomeTagsProvider lambda$createStandardGenerator$9(CompletableFuture p_311510_, TagsProvider p_311511_, PackOutput p_311512_) {
        return new UpdateOneTwentyOneBiomeTagsProvider(p_311512_, p_311510_, p_311511_.contentsGetter());
    }

    private static /* synthetic */ UpdateOneTwentyOneItemTagsProvider lambda$createStandardGenerator$8(CompletableFuture p_307135_, TagsProvider p_307136_, TagsProvider p_307137_, PackOutput p_307138_) {
        return new UpdateOneTwentyOneItemTagsProvider(p_307138_, p_307135_, p_307136_.contentsGetter(), p_307137_.contentsGetter());
    }

    private static /* synthetic */ UpdateOneTwentyOneBlockTagsProvider lambda$createStandardGenerator$7(CompletableFuture p_307131_, TagsProvider p_307132_, PackOutput p_307133_) {
        return new UpdateOneTwentyOneBlockTagsProvider(p_307133_, p_307131_, p_307132_.contentsGetter());
    }
}

