/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemListReport
implements DataProvider {
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public ItemListReport(PackOutput p_331079_, CompletableFuture<HolderLookup.Provider> p_330936_) {
        this.output = p_331079_;
        this.registries = p_330936_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_330682_) {
        Path $$1 = this.output.getOutputFolder(PackOutput.Target.REPORTS).resolve("items.json");
        return this.registries.thenCompose(p_330267_ -> {
            JsonObject $$3 = new JsonObject();
            RegistryOps $$4 = p_330267_.createSerializationContext(JsonOps.INSTANCE);
            p_330267_.lookupOrThrow(Registries.ITEM).listElements().forEach(p_331576_ -> {
                JsonObject $$3 = new JsonObject();
                JsonArray $$4 = new JsonArray();
                ((Item)p_331576_.value()).components().forEach(p_330888_ -> $$4.add(ItemListReport.dumpComponent(p_330888_, $$4)));
                $$3.add("components", (JsonElement)$$4);
                $$3.add(p_331576_.getRegisteredName(), (JsonElement)$$3);
            });
            return DataProvider.saveStable(p_330682_, (JsonElement)$$3, $$1);
        });
    }

    private static <T> JsonElement dumpComponent(TypedDataComponent<T> p_330424_, DynamicOps<JsonElement> p_332057_) {
        ResourceLocation $$2 = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(p_330424_.type());
        JsonElement $$3 = (JsonElement)p_330424_.encodeValue(p_332057_).getOrThrow(p_339362_ -> new IllegalStateException("Failed to serialize component " + String.valueOf($$2) + ": " + p_339362_));
        JsonObject $$4 = new JsonObject();
        $$4.addProperty("type", $$2.toString());
        $$4.add("value", $$3);
        return $$4;
    }

    @Override
    public final String getName() {
        return "Item List";
    }
}

