/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.registries;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

public class RegistriesDatapackGenerator
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public RegistriesDatapackGenerator(PackOutput p_256643_, CompletableFuture<HolderLookup.Provider> p_255780_) {
        this.registries = p_255780_;
        this.output = p_256643_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_255785_) {
        return this.registries.thenCompose(p_326736_ -> {
            RegistryOps $$2 = p_326736_.createSerializationContext(JsonOps.INSTANCE);
            return CompletableFuture.allOf((CompletableFuture[])RegistryDataLoader.WORLDGEN_REGISTRIES.stream().flatMap(p_256552_ -> this.dumpRegistryCap(p_255785_, (HolderLookup.Provider)p_326736_, $$2, (RegistryDataLoader.RegistryData)p_256552_).stream()).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistryCap(CachedOutput p_256502_, HolderLookup.Provider p_256492_, DynamicOps<JsonElement> p_256000_, RegistryDataLoader.RegistryData<T> p_256449_) {
        ResourceKey $$4 = p_256449_.key();
        return p_256492_.lookup($$4).map(p_255847_ -> {
            PackOutput.PathProvider $$5 = this.output.createPathProvider(PackOutput.Target.DATA_PACK, $$4.location().getPath());
            return CompletableFuture.allOf((CompletableFuture[])p_255847_.listElements().map(p_256105_ -> RegistriesDatapackGenerator.dumpValue($$5.json(p_256105_.key().location()), p_256502_, p_256000_, p_256449_.elementCodec(), p_256105_.value())).toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> dumpValue(Path p_255678_, CachedOutput p_256438_, DynamicOps<JsonElement> p_256127_, Encoder<E> p_255938_, E p_256590_) {
        Optional $$5 = p_255938_.encodeStart(p_256127_, p_256590_).resultOrPartial(p_255999_ -> LOGGER.error("Couldn't serialize element {}: {}", (Object)p_255678_, p_255999_));
        if ($$5.isPresent()) {
            return DataProvider.saveStable(p_256438_, (JsonElement)$$5.get(), p_255678_);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public final String getName() {
        return "Registries";
    }
}

