/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerLevel;

public class GameTestBatchFactory {
    private static final int MAX_TESTS_PER_BATCH = 50;

    public static Collection<GameTestBatch> fromTestFunction(Collection<TestFunction> p_320519_, ServerLevel p_319999_) {
        Map<String, List<TestFunction>> $$2 = p_320519_.stream().collect(Collectors.groupingBy(TestFunction::batchName));
        return $$2.entrySet().stream().flatMap(p_325551_ -> {
            String $$2 = (String)p_325551_.getKey();
            List $$3 = (List)p_325551_.getValue();
            return Streams.mapWithIndex(Lists.partition((List)$$3, (int)50).stream(), (p_325548_, p_325549_) -> GameTestBatchFactory.toGameTestBatch(p_325548_.stream().map(p_320787_ -> GameTestBatchFactory.toGameTestInfo(p_320787_, 0, p_319999_)).toList(), $$2, p_325549_));
        }).toList();
    }

    public static GameTestInfo toGameTestInfo(TestFunction p_320432_, int p_320796_, ServerLevel p_320136_) {
        return new GameTestInfo(p_320432_, StructureUtils.getRotationForRotationSteps(p_320796_), p_320136_, RetryOptions.noRetries());
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo() {
        return p_325541_ -> {
            Map<String, List<GameTestInfo>> $$1 = p_325541_.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(p_320634_ -> p_320634_.getTestFunction().batchName()));
            return $$1.entrySet().stream().flatMap(p_325545_ -> {
                String $$1 = (String)p_325545_.getKey();
                List $$2 = (List)p_325545_.getValue();
                return Streams.mapWithIndex(Lists.partition((List)$$2, (int)50).stream(), (p_325543_, p_325544_) -> GameTestBatchFactory.toGameTestBatch(List.copyOf(p_325543_), $$1, p_325544_));
            }).toList();
        };
    }

    private static GameTestBatch toGameTestBatch(List<GameTestInfo> p_320150_, String p_320417_, long p_326505_) {
        Consumer<ServerLevel> $$3 = GameTestRegistry.getBeforeBatchFunction(p_320417_);
        Consumer<ServerLevel> $$4 = GameTestRegistry.getAfterBatchFunction(p_320417_);
        return new GameTestBatch(p_320417_ + ":" + p_326505_, p_320150_, $$3, $$4);
    }
}

