/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INLINE_LIST_THRESHOLD = 8;
    private static final int MAX_DEPTH = 64;
    private static final ByteCollection INLINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_KEY = ChatFormatting.AQUA;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_STRING = ChatFormatting.GREEN;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER = ChatFormatting.GOLD;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER_TYPE = ChatFormatting.RED;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String NAME_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private static final Component TOO_DEEP = Component.literal("<...>").withStyle(ChatFormatting.GRAY);
    private final String indentation;
    private final int indentDepth;
    private final int depth;
    private Component result = CommonComponents.EMPTY;

    public TextComponentTagVisitor(String p_178251_) {
        this(p_178251_, 0, 0);
    }

    private TextComponentTagVisitor(String p_341604_, int p_341638_, int p_341618_) {
        this.indentation = p_341604_;
        this.indentDepth = p_341638_;
        this.depth = p_341618_;
    }

    public Component visit(Tag p_178282_) {
        p_178282_.accept(this);
        return this.result;
    }

    @Override
    public void visitString(StringTag p_178280_) {
        String $$1 = StringTag.quoteAndEscape(p_178280_.getAsString());
        String $$2 = $$1.substring(0, 1);
        MutableComponent $$3 = Component.literal($$1.substring(1, $$1.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_STRING);
        this.result = Component.literal($$2).append($$3).append($$2);
    }

    @Override
    public void visitByte(ByteTag p_178258_) {
        MutableComponent $$1 = Component.literal("b").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178258_.getAsNumber())).append($$1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitShort(ShortTag p_178278_) {
        MutableComponent $$1 = Component.literal("s").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178278_.getAsNumber())).append($$1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitInt(IntTag p_178270_) {
        this.result = Component.literal(String.valueOf(p_178270_.getAsNumber())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitLong(LongTag p_178276_) {
        MutableComponent $$1 = Component.literal("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178276_.getAsNumber())).append($$1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitFloat(FloatTag p_178266_) {
        MutableComponent $$1 = Component.literal("f").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178266_.getAsFloat())).append($$1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitDouble(DoubleTag p_178262_) {
        MutableComponent $$1 = Component.literal("d").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(p_178262_.getAsDouble())).append($$1).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitByteArray(ByteArrayTag p_178256_) {
        MutableComponent $$1 = Component.literal("B").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent $$2 = Component.literal(LIST_OPEN).append($$1).append(LIST_TYPE_SEPARATOR);
        byte[] $$3 = p_178256_.getAsByteArray();
        for (int $$4 = 0; $$4 < $$3.length; ++$$4) {
            MutableComponent $$5 = Component.literal(String.valueOf($$3[$$4])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            $$2.append(ELEMENT_SPACING).append($$5).append($$1);
            if ($$4 == $$3.length - 1) continue;
            $$2.append(ELEMENT_SEPARATOR);
        }
        $$2.append(LIST_CLOSE);
        this.result = $$2;
    }

    @Override
    public void visitIntArray(IntArrayTag p_178268_) {
        MutableComponent $$1 = Component.literal("I").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent $$2 = Component.literal(LIST_OPEN).append($$1).append(LIST_TYPE_SEPARATOR);
        int[] $$3 = p_178268_.getAsIntArray();
        for (int $$4 = 0; $$4 < $$3.length; ++$$4) {
            $$2.append(ELEMENT_SPACING).append(Component.literal(String.valueOf($$3[$$4])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
            if ($$4 == $$3.length - 1) continue;
            $$2.append(ELEMENT_SEPARATOR);
        }
        $$2.append(LIST_CLOSE);
        this.result = $$2;
    }

    @Override
    public void visitLongArray(LongArrayTag p_178274_) {
        MutableComponent $$1 = Component.literal("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent $$2 = Component.literal(LIST_OPEN).append($$1).append(LIST_TYPE_SEPARATOR);
        long[] $$3 = p_178274_.getAsLongArray();
        for (int $$4 = 0; $$4 < $$3.length; ++$$4) {
            MutableComponent $$5 = Component.literal(String.valueOf($$3[$$4])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            $$2.append(ELEMENT_SPACING).append($$5).append($$1);
            if ($$4 == $$3.length - 1) continue;
            $$2.append(ELEMENT_SEPARATOR);
        }
        $$2.append(LIST_CLOSE);
        this.result = $$2;
    }

    @Override
    public void visitList(ListTag p_178272_) {
        if (p_178272_.isEmpty()) {
            this.result = Component.literal("[]");
            return;
        }
        if (this.depth >= 64) {
            this.result = Component.literal(LIST_OPEN).append(TOO_DEEP).append(LIST_CLOSE);
            return;
        }
        if (INLINE_ELEMENT_TYPES.contains(p_178272_.getElementType()) && p_178272_.size() <= 8) {
            String $$1 = ELEMENT_SEPARATOR + ELEMENT_SPACING;
            MutableComponent $$2 = Component.literal(LIST_OPEN);
            for (int $$3 = 0; $$3 < p_178272_.size(); ++$$3) {
                if ($$3 != 0) {
                    $$2.append($$1);
                }
                $$2.append(this.buildSubTag(p_178272_.get($$3), false));
            }
            $$2.append(LIST_CLOSE);
            this.result = $$2;
            return;
        }
        MutableComponent $$4 = Component.literal(LIST_OPEN);
        if (!this.indentation.isEmpty()) {
            $$4.append(NEWLINE);
        }
        String $$5 = Strings.repeat((String)this.indentation, (int)(this.indentDepth + 1));
        for (int $$6 = 0; $$6 < p_178272_.size(); ++$$6) {
            MutableComponent $$7 = Component.literal($$5);
            $$7.append(this.buildSubTag(p_178272_.get($$6), true));
            if ($$6 != p_178272_.size() - 1) {
                $$7.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            $$4.append($$7);
        }
        if (!this.indentation.isEmpty()) {
            $$4.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.indentDepth));
        }
        $$4.append(LIST_CLOSE);
        this.result = $$4;
    }

    @Override
    public void visitCompound(CompoundTag p_178260_) {
        if (p_178260_.isEmpty()) {
            this.result = Component.literal("{}");
            return;
        }
        if (this.depth >= 64) {
            this.result = Component.literal(STRUCT_OPEN).append(TOO_DEEP).append(STRUCT_CLOSE);
            return;
        }
        MutableComponent $$1 = Component.literal(STRUCT_OPEN);
        Collection<String> $$2 = p_178260_.getAllKeys();
        if (LOGGER.isDebugEnabled()) {
            ArrayList $$3 = Lists.newArrayList(p_178260_.getAllKeys());
            Collections.sort($$3);
            $$2 = $$3;
        }
        if (!this.indentation.isEmpty()) {
            $$1.append(NEWLINE);
        }
        String $$4 = Strings.repeat((String)this.indentation, (int)(this.indentDepth + 1));
        Iterator<String> $$5 = $$2.iterator();
        while ($$5.hasNext()) {
            String $$6 = $$5.next();
            MutableComponent $$7 = Component.literal($$4).append(TextComponentTagVisitor.handleEscapePretty($$6)).append(NAME_VALUE_SEPARATOR).append(ELEMENT_SPACING).append(this.buildSubTag(p_178260_.get($$6), true));
            if ($$5.hasNext()) {
                $$7.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            $$1.append($$7);
        }
        if (!this.indentation.isEmpty()) {
            $$1.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.indentDepth));
        }
        $$1.append(STRUCT_CLOSE);
        this.result = $$1;
    }

    private Component buildSubTag(Tag p_341640_, boolean p_341665_) {
        return new TextComponentTagVisitor(this.indentation, p_341665_ ? this.indentDepth + 1 : this.indentDepth, this.depth + 1).visit(p_341640_);
    }

    protected static Component handleEscapePretty(String p_178254_) {
        if (SIMPLE_VALUE.matcher(p_178254_).matches()) {
            return Component.literal(p_178254_).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        }
        String $$1 = StringTag.quoteAndEscape(p_178254_);
        String $$2 = $$1.substring(0, 1);
        MutableComponent $$3 = Component.literal($$1.substring(1, $$1.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        return Component.literal($$2).append($$3).append($$2);
    }

    @Override
    public void visitEnd(EndTag p_178264_) {
        this.result = CommonComponents.EMPTY;
    }
}

