/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.PacketUtils;

public interface PacketListener {
    public PacketFlow flow();

    public ConnectionProtocol protocol();

    public void onDisconnect(Component var1);

    default public void onPacketError(Packet p_341593_, Exception p_341607_) throws ReportedException {
        throw PacketUtils.makeReportedException(p_341607_, p_341593_, this);
    }

    public boolean isAcceptingMessages();

    default public boolean shouldHandleMessage(Packet<?> p_295210_) {
        return this.isAcceptingMessages();
    }

    default public void fillCrashReport(CrashReport p_314927_) {
        CrashReportCategory $$1 = p_314927_.addCategory("Connection");
        $$1.setDetail("Protocol", () -> this.protocol().id());
        $$1.setDetail("Flow", () -> this.flow().toString());
        this.fillListenerSpecificCrashDetails($$1);
    }

    default public void fillListenerSpecificCrashDetails(CrashReportCategory p_314965_) {
    }
}

