/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HoverEvent {
    public static final Codec<HoverEvent> CODEC = Codec.withAlternative((Codec)TypedHoverEvent.CODEC.codec(), (Codec)TypedHoverEvent.LEGACY_CODEC.codec()).xmap(HoverEvent::new, p_337497_ -> p_337497_.event);
    private final TypedHoverEvent<?> event;

    public <T> HoverEvent(Action<T> p_130818_, T p_130819_) {
        this(new TypedHoverEvent<T>(p_130818_, p_130819_));
    }

    private HoverEvent(TypedHoverEvent<?> p_304734_) {
        this.event = p_304734_;
    }

    public Action<?> getAction() {
        return this.event.action;
    }

    @Nullable
    public <T> T getValue(Action<T> p_130824_) {
        if (this.event.action == p_130824_) {
            return p_130824_.cast(this.event.value);
        }
        return null;
    }

    public boolean equals(Object p_130828_) {
        if (this == p_130828_) {
            return true;
        }
        if (p_130828_ == null || this.getClass() != p_130828_.getClass()) {
            return false;
        }
        return ((HoverEvent)p_130828_).event.equals(this.event);
    }

    public String toString() {
        return this.event.toString();
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    record TypedHoverEvent<T>(Action<T> action, T value) {
        public static final MapCodec<TypedHoverEvent<?>> CODEC = Action.CODEC.dispatchMap("action", TypedHoverEvent::action, p_337503_ -> p_337503_.codec);
        public static final MapCodec<TypedHoverEvent<?>> LEGACY_CODEC = Action.CODEC.dispatchMap("action", TypedHoverEvent::action, p_337502_ -> p_337502_.legacyCodec);
    }

    public static class Action<T>
    implements StringRepresentable {
        public static final Action<Component> SHOW_TEXT = new Action<Component>("show_text", true, ComponentSerialization.CODEC, (p_329861_, p_329862_) -> DataResult.success((Object)p_329861_));
        public static final Action<ItemStackInfo> SHOW_ITEM = new Action<ItemStackInfo>("show_item", true, ItemStackInfo.CODEC, ItemStackInfo::legacyCreate);
        public static final Action<EntityTooltipInfo> SHOW_ENTITY = new Action<EntityTooltipInfo>("show_entity", true, EntityTooltipInfo.CODEC, EntityTooltipInfo::legacyCreate);
        public static final Codec<Action<?>> UNSAFE_CODEC = StringRepresentable.fromValues(() -> new Action[]{SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY});
        public static final Codec<Action<?>> CODEC = UNSAFE_CODEC.validate(Action::filterForSerialization);
        private final String name;
        private final boolean allowFromServer;
        final MapCodec<TypedHoverEvent<T>> codec;
        final MapCodec<TypedHoverEvent<T>> legacyCodec;

        public Action(String p_130842_, boolean p_130843_, Codec<T> p_304723_, final LegacyConverter<T> p_331991_) {
            this.name = p_130842_;
            this.allowFromServer = p_130843_;
            this.codec = p_304723_.xmap(p_304162_ -> new TypedHoverEvent<Object>(this, p_304162_), p_304164_ -> p_304164_.value).fieldOf("contents");
            this.legacyCodec = new Codec<TypedHoverEvent<T>>(){

                public <D> DataResult<Pair<TypedHoverEvent<T>, D>> decode(DynamicOps<D> p_331755_, D p_331509_) {
                    return ComponentSerialization.CODEC.decode(p_331755_, p_331509_).flatMap(p_337500_ -> {
                        DataResult $$5;
                        if (p_331755_ instanceof RegistryOps) {
                            RegistryOps $$3 = (RegistryOps)p_331755_;
                            DataResult $$4 = p_331991_.parse((Component)p_337500_.getFirst(), $$3);
                        } else {
                            $$5 = p_331991_.parse((Component)p_337500_.getFirst(), null);
                        }
                        return $$5.map(p_331221_ -> Pair.of(new TypedHoverEvent<Object>(this, p_331221_), (Object)p_337500_.getSecond()));
                    });
                }

                public <D> DataResult<D> encode(TypedHoverEvent<T> p_330570_, DynamicOps<D> p_331345_, D p_331702_) {
                    return DataResult.error(() -> "Can't encode in legacy format");
                }

                public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                    return this.encode((TypedHoverEvent)object, dynamicOps, object2);
                }
            }.fieldOf("value");
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        T cast(Object p_130865_) {
            return (T)p_130865_;
        }

        public String toString() {
            return "<action " + this.name + ">";
        }

        private static DataResult<Action<?>> filterForSerialization(@Nullable Action<?> p_304784_) {
            if (p_304784_ == null) {
                return DataResult.error(() -> "Unknown action");
            }
            if (!p_304784_.isAllowedFromServer()) {
                return DataResult.error(() -> "Action not allowed: " + String.valueOf(p_304784_));
            }
            return DataResult.success(p_304784_, (Lifecycle)Lifecycle.stable());
        }
    }

    public static interface LegacyConverter<T> {
        public DataResult<T> parse(Component var1, @Nullable RegistryOps<?> var2);
    }

    public static class ItemStackInfo {
        public static final Codec<ItemStackInfo> FULL_CODEC = ItemStack.CODEC.xmap(ItemStackInfo::new, ItemStackInfo::getItemStack);
        private static final Codec<ItemStackInfo> SIMPLE_CODEC = ItemStack.SIMPLE_ITEM_CODEC.xmap(ItemStackInfo::new, ItemStackInfo::getItemStack);
        public static final Codec<ItemStackInfo> CODEC = Codec.withAlternative(FULL_CODEC, SIMPLE_CODEC);
        private final Holder<Item> item;
        private final int count;
        private final DataComponentPatch components;
        @Nullable
        private ItemStack itemStack;

        ItemStackInfo(Holder<Item> p_330519_, int p_130894_, DataComponentPatch p_331646_) {
            this.item = p_330519_;
            this.count = p_130894_;
            this.components = p_331646_;
        }

        public ItemStackInfo(ItemStack p_130897_) {
            this(p_130897_.getItemHolder(), p_130897_.getCount(), p_130897_.getComponentsPatch());
        }

        public boolean equals(Object p_130911_) {
            if (this == p_130911_) {
                return true;
            }
            if (p_130911_ == null || this.getClass() != p_130911_.getClass()) {
                return false;
            }
            ItemStackInfo $$1 = (ItemStackInfo)p_130911_;
            return this.count == $$1.count && this.item.equals($$1.item) && this.components.equals($$1.components);
        }

        public int hashCode() {
            int $$0 = this.item.hashCode();
            $$0 = 31 * $$0 + this.count;
            $$0 = 31 * $$0 + this.components.hashCode();
            return $$0;
        }

        public ItemStack getItemStack() {
            if (this.itemStack == null) {
                this.itemStack = new ItemStack(this.item, this.count, this.components);
            }
            return this.itemStack;
        }

        private static DataResult<ItemStackInfo> legacyCreate(Component p_304732_, @Nullable RegistryOps<?> p_331763_) {
            try {
                CompoundTag $$2 = TagParser.parseTag(p_304732_.getString());
                NbtOps $$3 = p_331763_ != null ? p_331763_.withParent(NbtOps.INSTANCE) : NbtOps.INSTANCE;
                return ItemStack.CODEC.parse((DynamicOps)$$3, (Object)$$2).map(ItemStackInfo::new);
            }
            catch (CommandSyntaxException $$4) {
                return DataResult.error(() -> "Failed to parse item tag: " + $$4.getMessage());
            }
        }
    }

    public static class EntityTooltipInfo {
        public static final Codec<EntityTooltipInfo> CODEC = RecordCodecBuilder.create(p_337501_ -> p_337501_.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(p_304417_ -> p_304417_.type), (App)UUIDUtil.LENIENT_CODEC.fieldOf("id").forGetter(p_304877_ -> p_304877_.id), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("name").forGetter(p_304585_ -> p_304585_.name)).apply((Applicative)p_337501_, EntityTooltipInfo::new));
        public final EntityType<?> type;
        public final UUID id;
        public final Optional<Component> name;
        @Nullable
        private List<Component> linesCache;

        public EntityTooltipInfo(EntityType<?> p_130876_, UUID p_130877_, @Nullable Component p_130878_) {
            this(p_130876_, p_130877_, Optional.ofNullable(p_130878_));
        }

        public EntityTooltipInfo(EntityType<?> p_304581_, UUID p_304712_, Optional<Component> p_304973_) {
            this.type = p_304581_;
            this.id = p_304712_;
            this.name = p_304973_;
        }

        public static DataResult<EntityTooltipInfo> legacyCreate(Component p_304689_, @Nullable RegistryOps<?> p_330431_) {
            try {
                CompoundTag $$2 = TagParser.parseTag(p_304689_.getString());
                JsonOps $$3 = p_330431_ != null ? p_330431_.withParent(JsonOps.INSTANCE) : JsonOps.INSTANCE;
                DataResult $$4 = ComponentSerialization.CODEC.parse((DynamicOps)$$3, (Object)JsonParser.parseString((String)$$2.getString("name")));
                EntityType<?> $$5 = BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation($$2.getString("type")));
                UUID $$6 = UUID.fromString($$2.getString("id"));
                return $$4.map(p_329865_ -> new EntityTooltipInfo($$5, $$6, (Component)p_329865_));
            }
            catch (Exception $$7) {
                return DataResult.error(() -> "Failed to parse tooltip: " + $$7.getMessage());
            }
        }

        public List<Component> getTooltipLines() {
            if (this.linesCache == null) {
                this.linesCache = new ArrayList<Component>();
                this.name.ifPresent(this.linesCache::add);
                this.linesCache.add(Component.translatable("gui.entity_tooltip.type", this.type.getDescription()));
                this.linesCache.add(Component.literal(this.id.toString()));
            }
            return this.linesCache;
        }

        public boolean equals(Object p_130886_) {
            if (this == p_130886_) {
                return true;
            }
            if (p_130886_ == null || this.getClass() != p_130886_.getClass()) {
                return false;
            }
            EntityTooltipInfo $$1 = (EntityTooltipInfo)p_130886_;
            return this.type.equals($$1.type) && this.id.equals($$1.id) && this.name.equals($$1.name);
        }

        public int hashCode() {
            int $$0 = this.type.hashCode();
            $$0 = 31 * $$0 + this.id.hashCode();
            $$0 = 31 * $$0 + this.name.hashCode();
            return $$0;
        }
    }
}

