/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;

public class ScoreContents
implements ComponentContents {
    public static final MapCodec<ScoreContents> INNER_CODEC = RecordCodecBuilder.mapCodec(p_304795_ -> p_304795_.group((App)Codec.STRING.fieldOf("name").forGetter(ScoreContents::getName), (App)Codec.STRING.fieldOf("objective").forGetter(ScoreContents::getObjective)).apply((Applicative)p_304795_, ScoreContents::new));
    public static final MapCodec<ScoreContents> CODEC = INNER_CODEC.fieldOf("score");
    public static final ComponentContents.Type<ScoreContents> TYPE = new ComponentContents.Type<ScoreContents>(CODEC, "score");
    private final String name;
    @Nullable
    private final EntitySelector selector;
    private final String objective;

    @Nullable
    private static EntitySelector parseSelector(String p_237448_) {
        try {
            return new EntitySelectorParser(new StringReader(p_237448_)).parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public ScoreContents(String p_237438_, String p_237439_) {
        this.name = p_237438_;
        this.selector = ScoreContents.parseSelector(p_237438_);
        this.objective = p_237439_;
    }

    @Override
    public ComponentContents.Type<?> type() {
        return TYPE;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public EntitySelector getSelector() {
        return this.selector;
    }

    public String getObjective() {
        return this.objective;
    }

    private ScoreHolder findTargetName(CommandSourceStack p_237442_) throws CommandSyntaxException {
        List<? extends Entity> $$1;
        if (this.selector != null && !($$1 = this.selector.findEntities(p_237442_)).isEmpty()) {
            if ($$1.size() != 1) {
                throw EntityArgument.ERROR_NOT_SINGLE_ENTITY.create();
            }
            return $$1.get(0);
        }
        return ScoreHolder.forNameOnly(this.name);
    }

    private MutableComponent getScore(ScoreHolder p_313863_, CommandSourceStack p_237451_) {
        ReadOnlyScoreInfo $$5;
        ServerScoreboard $$3;
        Objective $$4;
        MinecraftServer $$2 = p_237451_.getServer();
        if ($$2 != null && ($$4 = ($$3 = $$2.getScoreboard()).getObjective(this.objective)) != null && ($$5 = $$3.getPlayerScoreInfo(p_313863_, $$4)) != null) {
            return $$5.formatValue($$4.numberFormatOrDefault(StyledFormat.NO_STYLE));
        }
        return Component.empty();
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack p_237444_, @Nullable Entity p_237445_, int p_237446_) throws CommandSyntaxException {
        if (p_237444_ == null) {
            return Component.empty();
        }
        ScoreHolder $$3 = this.findTargetName(p_237444_);
        ScoreHolder $$4 = p_237445_ != null && $$3.equals(ScoreHolder.WILDCARD) ? p_237445_ : $$3;
        return this.getScore($$4, p_237444_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_237455_) {
        if (this == p_237455_) {
            return true;
        }
        if (!(p_237455_ instanceof ScoreContents)) return false;
        ScoreContents $$1 = (ScoreContents)p_237455_;
        if (!this.name.equals($$1.name)) return false;
        if (!this.objective.equals($$1.objective)) return false;
        return true;
    }

    public int hashCode() {
        int $$0 = this.name.hashCode();
        $$0 = 31 * $$0 + this.objective.hashCode();
        return $$0;
    }

    public String toString() {
        return "score{name='" + this.name + "', objective='" + this.objective + "'}";
    }
}

