/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RegistrationInfo NETWORK_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> REGISTRATION_INFO_CACHE = Util.memoize(p_325559_ -> {
        Lifecycle $$1 = p_325559_.map(KnownPack::isVanilla).map(p_325560_ -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)p_325559_, $$1);
    });
    public static final List<RegistryData<?>> WORLDGEN_REGISTRIES = List.of(new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<Biome>(Registries.BIOME, Biome.DIRECT_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_CARVER, ConfiguredWorldCarver.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_FEATURE, ConfiguredFeature.DIRECT_CODEC), new RegistryData<PlacedFeature>(Registries.PLACED_FEATURE, PlacedFeature.DIRECT_CODEC), new RegistryData<Structure>(Registries.STRUCTURE, Structure.DIRECT_CODEC), new RegistryData<StructureSet>(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC), new RegistryData<StructureProcessorList>(Registries.PROCESSOR_LIST, StructureProcessorType.DIRECT_CODEC), new RegistryData<StructureTemplatePool>(Registries.TEMPLATE_POOL, StructureTemplatePool.DIRECT_CODEC), new RegistryData<NoiseGeneratorSettings>(Registries.NOISE_SETTINGS, NoiseGeneratorSettings.DIRECT_CODEC), new RegistryData<NormalNoise.NoiseParameters>(Registries.NOISE, NormalNoise.NoiseParameters.DIRECT_CODEC), new RegistryData<DensityFunction>(Registries.DENSITY_FUNCTION, DensityFunction.DIRECT_CODEC), new RegistryData<WorldPreset>(Registries.WORLD_PRESET, WorldPreset.DIRECT_CODEC), new RegistryData<FlatLevelGeneratorPreset>(Registries.FLAT_LEVEL_GENERATOR_PRESET, FlatLevelGeneratorPreset.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<MultiNoiseBiomeSourceParameterList>(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, MultiNoiseBiomeSourceParameterList.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC));
    public static final List<RegistryData<?>> DIMENSION_REGISTRIES = List.of(new RegistryData<LevelStem>(Registries.LEVEL_STEM, LevelStem.CODEC));
    public static final List<RegistryData<?>> SYNCHRONIZED_REGISTRIES = List.of(new RegistryData<Biome>(Registries.BIOME, Biome.NETWORK_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC), new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC));

    public static RegistryAccess.Frozen load(ResourceManager p_252046_, RegistryAccess p_249916_, List<RegistryData<?>> p_250344_) {
        return RegistryDataLoader.load((Loader<?> p_321412_, RegistryOps.RegistryInfoLookup p_321413_) -> p_321412_.loadFromResources(p_252046_, p_321413_), p_249916_, p_250344_);
    }

    public static RegistryAccess.Frozen load(Map<ResourceKey<? extends Registry<?>>, List<RegistrySynchronization.PackedRegistryEntry>> p_321642_, ResourceProvider p_326068_, RegistryAccess p_321850_, List<RegistryData<?>> p_321716_) {
        return RegistryDataLoader.load((Loader<?> p_325557_, RegistryOps.RegistryInfoLookup p_325558_) -> p_325557_.loadFromNetwork(p_321642_, p_326068_, p_325558_), p_321850_, p_321716_);
    }

    public static RegistryAccess.Frozen load(LoadingFunction p_321713_, RegistryAccess p_321583_, List<RegistryData<?>> p_321856_) {
        HashMap $$3 = new HashMap();
        List<Loader<?>> $$4 = p_321856_.stream().map(p_321410_ -> p_321410_.create(Lifecycle.stable(), $$3)).collect(Collectors.toUnmodifiableList());
        RegistryOps.RegistryInfoLookup $$5 = RegistryDataLoader.createContext(p_321583_, $$4);
        $$4.forEach(p_321416_ -> p_321713_.apply((Loader<?>)p_321416_, $$5));
        $$4.forEach(p_321406_ -> {
            WritableRegistry $$2 = p_321406_.registry();
            try {
                $$2.freeze();
            }
            catch (Exception $$3) {
                $$3.put($$2.key(), $$3);
            }
        });
        if (!$$3.isEmpty()) {
            RegistryDataLoader.logErrors($$3);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new RegistryAccess.ImmutableRegistryAccess($$4.stream().map(Loader::registry).toList()).freeze();
    }

    private static RegistryOps.RegistryInfoLookup createContext(RegistryAccess p_256568_, List<Loader<?>> p_255821_) {
        final HashMap $$2 = new HashMap();
        p_256568_.registries().forEach(p_255505_ -> $$2.put(p_255505_.key(), RegistryDataLoader.createInfoForContextRegistry(p_255505_.value())));
        p_255821_.forEach(p_321408_ -> $$2.put(p_321408_.registry.key(), RegistryDataLoader.createInfoForNewRegistry(p_321408_.registry)));
        return new RegistryOps.RegistryInfoLookup(){

            @Override
            public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_256014_) {
                return Optional.ofNullable((RegistryOps.RegistryInfo)$$2.get(p_256014_));
            }
        };
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForNewRegistry(WritableRegistry<T> p_256020_) {
        return new RegistryOps.RegistryInfo(p_256020_.asLookup(), p_256020_.createRegistrationLookup(), p_256020_.registryLifecycle());
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForContextRegistry(Registry<T> p_256230_) {
        return new RegistryOps.RegistryInfo<T>(p_256230_.asLookup(), p_256230_.asTagAddingLookup(), p_256230_.registryLifecycle());
    }

    private static void logErrors(Map<ResourceKey<?>, Exception> p_252325_) {
        StringWriter $$1 = new StringWriter();
        PrintWriter $$2 = new PrintWriter($$1);
        Map<ResourceLocation, Map<ResourceLocation, Exception>> $$3 = p_252325_.entrySet().stream().collect(Collectors.groupingBy(p_249353_ -> ((ResourceKey)p_249353_.getKey()).registry(), Collectors.toMap(p_251444_ -> ((ResourceKey)p_251444_.getKey()).location(), Map.Entry::getValue)));
        $$3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_249838_ -> {
            $$2.printf("> Errors in registry %s:%n", p_249838_.getKey());
            ((Map)p_249838_.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_250688_ -> {
                $$2.printf(">> Errors in element %s:%n", p_250688_.getKey());
                ((Exception)p_250688_.getValue()).printStackTrace($$2);
            });
        });
        $$2.flush();
        LOGGER.error("Registry loading errors:\n{}", (Object)$$1);
    }

    private static String registryDirPath(ResourceLocation p_252033_) {
        return p_252033_.getPath();
    }

    private static <E> void loadElementFromResource(WritableRegistry<E> p_326195_, Decoder<E> p_326476_, RegistryOps<JsonElement> p_325932_, ResourceKey<E> p_326054_, Resource p_326141_, RegistrationInfo p_326033_) throws IOException {
        try (BufferedReader $$6 = p_326141_.openAsReader();){
            JsonElement $$7 = JsonParser.parseReader((Reader)$$6);
            DataResult $$8 = p_326476_.parse(p_325932_, (Object)$$7);
            Object $$9 = $$8.getOrThrow();
            p_326195_.register(p_326054_, $$9, p_326033_);
        }
    }

    static <E> void loadContentsFromManager(ResourceManager p_321535_, RegistryOps.RegistryInfoLookup p_321612_, WritableRegistry<E> p_321557_, Decoder<E> p_321820_, Map<ResourceKey<?>, Exception> p_321649_) {
        String $$5 = RegistryDataLoader.registryDirPath(p_321557_.key().location());
        FileToIdConverter $$6 = FileToIdConverter.json($$5);
        RegistryOps<JsonElement> $$7 = RegistryOps.create(JsonOps.INSTANCE, p_321612_);
        for (Map.Entry<ResourceLocation, Resource> $$8 : $$6.listMatchingResources(p_321535_).entrySet()) {
            ResourceLocation $$9 = $$8.getKey();
            ResourceKey $$10 = ResourceKey.create(p_321557_.key(), $$6.fileToId($$9));
            Resource $$11 = $$8.getValue();
            RegistrationInfo $$12 = REGISTRATION_INFO_CACHE.apply($$11.knownPackInfo());
            try {
                RegistryDataLoader.loadElementFromResource(p_321557_, p_321820_, $$7, $$10, $$11, $$12);
            }
            catch (Exception $$13) {
                p_321649_.put($$10, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", $$9, $$11.sourcePackId()), $$13));
            }
        }
    }

    static <E> void loadContentsFromNetwork(Map<ResourceKey<? extends Registry<?>>, List<RegistrySynchronization.PackedRegistryEntry>> p_321633_, ResourceProvider p_326020_, RegistryOps.RegistryInfoLookup p_321801_, WritableRegistry<E> p_321671_, Decoder<E> p_321718_, Map<ResourceKey<?>, Exception> p_321625_) {
        List<RegistrySynchronization.PackedRegistryEntry> $$6 = p_321633_.get(p_321671_.key());
        if ($$6 == null) {
            return;
        }
        RegistryOps<Tag> $$7 = RegistryOps.create(NbtOps.INSTANCE, p_321801_);
        RegistryOps<JsonElement> $$8 = RegistryOps.create(JsonOps.INSTANCE, p_321801_);
        String $$9 = RegistryDataLoader.registryDirPath(p_321671_.key().location());
        FileToIdConverter $$10 = FileToIdConverter.json($$9);
        for (RegistrySynchronization.PackedRegistryEntry $$11 : $$6) {
            ResourceKey $$12 = ResourceKey.create(p_321671_.key(), $$11.id());
            Optional<Tag> $$13 = $$11.data();
            if ($$13.isPresent()) {
                try {
                    DataResult $$14 = p_321718_.parse($$7, (Object)$$13.get());
                    Object $$15 = $$14.getOrThrow();
                    p_321671_.register($$12, $$15, NETWORK_REGISTRATION_INFO);
                }
                catch (Exception $$16) {
                    p_321625_.put($$12, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", $$13.get()), $$16));
                }
                continue;
            }
            ResourceLocation $$17 = $$10.idToFile($$11.id());
            try {
                Resource $$18 = p_326020_.getResourceOrThrow($$17);
                RegistryDataLoader.loadElementFromResource(p_321671_, p_321718_, $$8, $$12, $$18, NETWORK_REGISTRATION_INFO);
            }
            catch (Exception $$19) {
                p_321625_.put($$12, new IllegalStateException("Failed to parse local data", $$19));
            }
        }
    }

    @FunctionalInterface
    static interface LoadingFunction {
        public void apply(Loader<?> var1, RegistryOps.RegistryInfoLookup var2);
    }

    record Loader<T>(RegistryData<T> data, WritableRegistry<T> registry, Map<ResourceKey<?>, Exception> loadingErrors) {
        public void loadFromResources(ResourceManager p_321702_, RegistryOps.RegistryInfoLookup p_321840_) {
            RegistryDataLoader.loadContentsFromManager(p_321702_, p_321840_, this.registry, this.data.elementCodec, this.loadingErrors);
        }

        public void loadFromNetwork(Map<ResourceKey<? extends Registry<?>>, List<RegistrySynchronization.PackedRegistryEntry>> p_321562_, ResourceProvider p_326419_, RegistryOps.RegistryInfoLookup p_321617_) {
            RegistryDataLoader.loadContentsFromNetwork(p_321562_, p_326419_, p_321617_, this.registry, this.data.elementCodec, this.loadingErrors);
        }
    }

    public record RegistryData<T>(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec) {
        Loader<T> create(Lifecycle p_251662_, Map<ResourceKey<?>, Exception> p_251565_) {
            MappedRegistry $$2 = new MappedRegistry(this.key, p_251662_);
            return new Loader(this, $$2, p_251565_);
        }

        public void runWithArguments(BiConsumer<ResourceKey<? extends Registry<T>>, Codec<T>> p_312899_) {
            p_312899_.accept(this.key, this.elementCodec);
        }
    }
}

