/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private Map<ResourceLocation, AdvancementHolder> advancements = Map.of();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;

    public ServerAdvancementManager(HolderLookup.Provider p_323943_) {
        super(GSON, "advancements");
        this.registries = p_323943_;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> p_136034_, ResourceManager p_136035_, ProfilerFiller p_136036_) {
        RegistryOps $$3 = this.registries.createSerializationContext(JsonOps.INSTANCE);
        ImmutableMap.Builder $$4 = ImmutableMap.builder();
        p_136034_.forEach((p_337529_, p_337530_) -> {
            try {
                Advancement $$4 = (Advancement)Advancement.CODEC.parse((DynamicOps)$$3, p_337530_).getOrThrow(JsonParseException::new);
                this.validate((ResourceLocation)p_337529_, $$4);
                $$4.put(p_337529_, (Object)new AdvancementHolder((ResourceLocation)p_337529_, $$4));
            }
            catch (Exception $$5) {
                LOGGER.error("Parsing error loading custom advancement {}: {}", p_337529_, (Object)$$5.getMessage());
            }
        });
        this.advancements = $$4.buildOrThrow();
        AdvancementTree $$5 = new AdvancementTree();
        $$5.addAll(this.advancements.values());
        for (AdvancementNode $$6 : $$5.roots()) {
            if (!$$6.holder().value().display().isPresent()) continue;
            TreeNodePosition.run($$6);
        }
        this.tree = $$5;
    }

    private void validate(ResourceLocation p_312696_, Advancement p_312110_) {
        ProblemReporter.Collector $$2 = new ProblemReporter.Collector();
        p_312110_.validate($$2, this.registries.asGetterLookup());
        Multimap<String, String> $$3 = $$2.get();
        if (!$$3.isEmpty()) {
            String $$4 = $$3.asMap().entrySet().stream().map(p_311530_ -> "  at " + (String)p_311530_.getKey() + ": " + String.join((CharSequence)"; ", (Iterable)p_311530_.getValue())).collect(Collectors.joining("\n"));
            LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)p_312696_, (Object)$$4);
        }
    }

    @Nullable
    public AdvancementHolder get(ResourceLocation p_301079_) {
        return this.advancements.get(p_301079_);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

