/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Unit;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class ResetChunksCommand {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> p_183667_) {
        p_183667_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("resetchunks").requires(p_183683_ -> p_183683_.hasPermission(2))).executes(p_183693_ -> ResetChunksCommand.resetChunks((CommandSourceStack)p_183693_.getSource(), 0, true))).then(((RequiredArgumentBuilder)Commands.argument("range", IntegerArgumentType.integer((int)0, (int)5)).executes(p_183689_ -> ResetChunksCommand.resetChunks((CommandSourceStack)p_183689_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_183689_, (String)"range"), true))).then(Commands.argument("skipOldChunks", BoolArgumentType.bool()).executes(p_183669_ -> ResetChunksCommand.resetChunks((CommandSourceStack)p_183669_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_183669_, (String)"range"), BoolArgumentType.getBool((CommandContext)p_183669_, (String)"skipOldChunks"))))));
    }

    private static int resetChunks(CommandSourceStack p_183685_, int p_183686_, boolean p_183687_) {
        ServerLevel $$3 = p_183685_.getLevel();
        ServerChunkCache $$4 = $$3.getChunkSource();
        $$4.chunkMap.debugReloadGenerator();
        Vec3 $$5 = p_183685_.getPosition();
        ChunkPos $$6 = new ChunkPos(BlockPos.containing($$5));
        int $$7 = $$6.z - p_183686_;
        int $$8 = $$6.z + p_183686_;
        int $$9 = $$6.x - p_183686_;
        int $$10 = $$6.x + p_183686_;
        for (int $$11 = $$7; $$11 <= $$8; ++$$11) {
            for (int $$12 = $$9; $$12 <= $$10; ++$$12) {
                ChunkPos $$13 = new ChunkPos($$12, $$11);
                LevelChunk $$14 = $$4.getChunk($$12, $$11, false);
                if ($$14 == null || p_183687_ && $$14.isOldNoiseGeneration()) continue;
                for (BlockPos $$15 : BlockPos.betweenClosed($$13.getMinBlockX(), $$3.getMinBuildHeight(), $$13.getMinBlockZ(), $$13.getMaxBlockX(), $$3.getMaxBuildHeight() - 1, $$13.getMaxBlockZ())) {
                    $$3.setBlock($$15, Blocks.AIR.defaultBlockState(), 16);
                }
            }
        }
        ProcessorMailbox<Runnable> $$16 = ProcessorMailbox.create(Util.backgroundExecutor(), "worldgen-resetchunks");
        long $$17 = System.currentTimeMillis();
        int $$18 = (p_183686_ * 2 + 1) * (p_183686_ * 2 + 1);
        for (ChunkStatus $$19 : ImmutableList.of((Object)ChunkStatus.BIOMES, (Object)ChunkStatus.NOISE, (Object)ChunkStatus.SURFACE, (Object)ChunkStatus.CARVERS, (Object)ChunkStatus.FEATURES, (Object)ChunkStatus.INITIALIZE_LIGHT)) {
            long $$20 = System.currentTimeMillis();
            CompletionStage<Object> $$21 = CompletableFuture.supplyAsync(() -> Unit.INSTANCE, $$16::tell);
            WorldGenContext $$22 = new WorldGenContext($$3, $$4.getGenerator(), $$3.getStructureManager(), $$4.getLightEngine());
            for (int $$23 = $$6.z - p_183686_; $$23 <= $$6.z + p_183686_; ++$$23) {
                for (int $$24 = $$6.x - p_183686_; $$24 <= $$6.x + p_183686_; ++$$24) {
                    ChunkPos $$25 = new ChunkPos($$24, $$23);
                    LevelChunk $$26 = $$4.getChunk($$24, $$23, false);
                    if ($$26 == null || p_183687_ && $$26.isOldNoiseGeneration()) continue;
                    ArrayList $$27 = Lists.newArrayList();
                    int $$28 = Math.max(1, $$19.getRange());
                    for (int $$29 = $$25.z - $$28; $$29 <= $$25.z + $$28; ++$$29) {
                        for (int $$30 = $$25.x - $$28; $$30 <= $$25.x + $$28; ++$$30) {
                            ChunkAccess $$34;
                            ChunkAccess $$31 = $$4.getChunk($$30, $$29, $$19.getParent(), true);
                            if ($$31 instanceof ImposterProtoChunk) {
                                ImposterProtoChunk $$32 = new ImposterProtoChunk(((ImposterProtoChunk)$$31).getWrapped(), true);
                            } else if ($$31 instanceof LevelChunk) {
                                ImposterProtoChunk $$33 = new ImposterProtoChunk((LevelChunk)$$31, true);
                            } else {
                                $$34 = $$31;
                            }
                            $$27.add($$34);
                        }
                    }
                    $$21 = $$21.thenComposeAsync(p_329899_ -> $$19.generate($$22, $$16::tell, p_183691_ -> {
                        throw new UnsupportedOperationException("Not creating full chunks here");
                    }, $$27).thenApply(p_329901_ -> {
                        if ($$19 == ChunkStatus.NOISE) {
                            Heightmap.primeHeightmaps(p_329901_, ChunkStatus.POST_FEATURES);
                        }
                        return Unit.INSTANCE;
                    }), $$16::tell);
                }
            }
            p_183685_.getServer().managedBlock(() -> $$21.isDone());
            LOGGER.debug(String.valueOf($$19) + " took " + (System.currentTimeMillis() - $$20) + " ms");
        }
        long $$35 = System.currentTimeMillis();
        for (int $$36 = $$6.z - p_183686_; $$36 <= $$6.z + p_183686_; ++$$36) {
            for (int $$37 = $$6.x - p_183686_; $$37 <= $$6.x + p_183686_; ++$$37) {
                ChunkPos $$38 = new ChunkPos($$37, $$36);
                LevelChunk $$39 = $$4.getChunk($$37, $$36, false);
                if ($$39 == null || p_183687_ && $$39.isOldNoiseGeneration()) continue;
                for (BlockPos $$40 : BlockPos.betweenClosed($$38.getMinBlockX(), $$3.getMinBuildHeight(), $$38.getMinBlockZ(), $$38.getMaxBlockX(), $$3.getMaxBuildHeight() - 1, $$38.getMaxBlockZ())) {
                    $$4.blockChanged($$40);
                }
            }
        }
        LOGGER.debug("blockChanged took " + (System.currentTimeMillis() - $$35) + " ms");
        long $$41 = System.currentTimeMillis() - $$17;
        p_183685_.sendSuccess(() -> Component.literal(String.format(Locale.ROOT, "%d chunks have been reset. This took %d ms for %d chunks, or %02f ms per chunk", $$18, $$41, $$18, Float.valueOf((float)$$41 / (float)$$18))), true);
        return 1;
    }
}

