/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.DebugBuffer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ChunkHolder {
    public static final ChunkResult<ChunkAccess> UNLOADED_CHUNK = ChunkResult.error("Unloaded chunk");
    public static final CompletableFuture<ChunkResult<ChunkAccess>> UNLOADED_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK);
    public static final ChunkResult<LevelChunk> UNLOADED_LEVEL_CHUNK = ChunkResult.error("Unloaded level chunk");
    public static final ChunkResult<ChunkAccess> NOT_DONE_YET = ChunkResult.error("Not done yet");
    private static final CompletableFuture<ChunkResult<LevelChunk>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final AtomicReferenceArray<CompletableFuture<ChunkResult<ChunkAccess>>> futures = new AtomicReferenceArray(CHUNK_STATUSES.size());
    private final LevelHeightAccessor levelHeightAccessor;
    private volatile CompletableFuture<ChunkResult<LevelChunk>> fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<ChunkResult<LevelChunk>> tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<ChunkResult<LevelChunk>> entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private CompletableFuture<ChunkAccess> chunkToSave = CompletableFuture.completedFuture(null);
    @Nullable
    private final DebugBuffer<ChunkSaveDebug> chunkToSaveHistory = null;
    private int oldTicketLevel;
    private int ticketLevel;
    private int queueLevel;
    private final ChunkPos pos;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter = new BitSet();
    private final BitSet skyChangedLightSectionFilter = new BitSet();
    private final LevelLightEngine lightEngine;
    private final LevelChangeListener onLevelChange;
    private final PlayerProvider playerProvider;
    private boolean wasAccessibleSinceLastSave;
    private CompletableFuture<Void> pendingFullStateConfirmation = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> sendSync = CompletableFuture.completedFuture(null);

    public ChunkHolder(ChunkPos p_142986_, int p_142987_, LevelHeightAccessor p_142988_, LevelLightEngine p_142989_, LevelChangeListener p_142990_, PlayerProvider p_142991_) {
        this.pos = p_142986_;
        this.levelHeightAccessor = p_142988_;
        this.lightEngine = p_142989_;
        this.onLevelChange = p_142990_;
        this.playerProvider = p_142991_;
        this.ticketLevel = this.oldTicketLevel = ChunkLevel.MAX_LEVEL + 1;
        this.queueLevel = this.oldTicketLevel;
        this.setTicketLevel(p_142987_);
        this.changedBlocksPerSection = new ShortSet[p_142988_.getSectionsCount()];
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getFutureIfPresentUnchecked(ChunkStatus p_331374_) {
        CompletableFuture<ChunkResult<ChunkAccess>> $$1 = this.futures.get(p_331374_.getIndex());
        return $$1 == null ? UNLOADED_CHUNK_FUTURE : $$1;
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getFutureIfPresent(ChunkStatus p_330836_) {
        if (ChunkLevel.generationStatus(this.ticketLevel).isOrAfter(p_330836_)) {
            return this.getFutureIfPresentUnchecked(p_330836_);
        }
        return UNLOADED_CHUNK_FUTURE;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getTickingChunkFuture() {
        return this.tickingChunkFuture;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getEntityTickingChunkFuture() {
        return this.entityTickingChunkFuture;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getFullChunkFuture() {
        return this.fullChunkFuture;
    }

    @Nullable
    public LevelChunk getTickingChunk() {
        return this.getTickingChunkFuture().getNow(UNLOADED_LEVEL_CHUNK).orElse(null);
    }

    public CompletableFuture<?> getChunkSendSyncFuture() {
        return this.sendSync;
    }

    @Nullable
    public LevelChunk getChunkToSend() {
        if (!this.sendSync.isDone()) {
            return null;
        }
        return this.getTickingChunk();
    }

    @Nullable
    public ChunkStatus getLastAvailableStatus() {
        for (int $$0 = CHUNK_STATUSES.size() - 1; $$0 >= 0; --$$0) {
            ChunkStatus $$1 = CHUNK_STATUSES.get($$0);
            CompletableFuture<ChunkResult<ChunkAccess>> $$2 = this.getFutureIfPresentUnchecked($$1);
            if (!$$2.getNow(UNLOADED_CHUNK).isSuccess()) continue;
            return $$1;
        }
        return null;
    }

    @Nullable
    public ChunkAccess getLastAvailable() {
        for (int $$0 = CHUNK_STATUSES.size() - 1; $$0 >= 0; --$$0) {
            ChunkAccess $$3;
            ChunkStatus $$1 = CHUNK_STATUSES.get($$0);
            CompletableFuture<ChunkResult<ChunkAccess>> $$2 = this.getFutureIfPresentUnchecked($$1);
            if ($$2.isCompletedExceptionally() || ($$3 = (ChunkAccess)$$2.getNow(UNLOADED_CHUNK).orElse(null)) == null) continue;
            return $$3;
        }
        return null;
    }

    public CompletableFuture<ChunkAccess> getChunkToSave() {
        return this.chunkToSave;
    }

    public void blockChanged(BlockPos p_140057_) {
        LevelChunk $$1 = this.getTickingChunk();
        if ($$1 == null) {
            return;
        }
        int $$2 = this.levelHeightAccessor.getSectionIndex(p_140057_.getY());
        if (this.changedBlocksPerSection[$$2] == null) {
            this.hasChangedSections = true;
            this.changedBlocksPerSection[$$2] = new ShortOpenHashSet();
        }
        this.changedBlocksPerSection[$$2].add(SectionPos.sectionRelativePos(p_140057_));
    }

    public void sectionLightChanged(LightLayer p_140037_, int p_140038_) {
        ChunkAccess $$2 = this.getFutureIfPresent(ChunkStatus.INITIALIZE_LIGHT).getNow(UNLOADED_CHUNK).orElse(null);
        if ($$2 == null) {
            return;
        }
        $$2.setUnsaved(true);
        LevelChunk $$3 = this.getTickingChunk();
        if ($$3 == null) {
            return;
        }
        int $$4 = this.lightEngine.getMinLightSection();
        int $$5 = this.lightEngine.getMaxLightSection();
        if (p_140038_ < $$4 || p_140038_ > $$5) {
            return;
        }
        int $$6 = p_140038_ - $$4;
        if (p_140037_ == LightLayer.SKY) {
            this.skyChangedLightSectionFilter.set($$6);
        } else {
            this.blockChangedLightSectionFilter.set($$6);
        }
    }

    public void broadcastChanges(LevelChunk p_140055_) {
        if (!this.hasChangedSections && this.skyChangedLightSectionFilter.isEmpty() && this.blockChangedLightSectionFilter.isEmpty()) {
            return;
        }
        Level $$1 = p_140055_.getLevel();
        if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
            List<ServerPlayer> $$2 = this.playerProvider.getPlayers(this.pos, true);
            if (!$$2.isEmpty()) {
                ClientboundLightUpdatePacket $$3 = new ClientboundLightUpdatePacket(p_140055_.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                this.broadcast($$2, $$3);
            }
            this.skyChangedLightSectionFilter.clear();
            this.blockChangedLightSectionFilter.clear();
        }
        if (!this.hasChangedSections) {
            return;
        }
        List<ServerPlayer> $$4 = this.playerProvider.getPlayers(this.pos, false);
        for (int $$5 = 0; $$5 < this.changedBlocksPerSection.length; ++$$5) {
            ShortSet $$6 = this.changedBlocksPerSection[$$5];
            if ($$6 == null) continue;
            this.changedBlocksPerSection[$$5] = null;
            if ($$4.isEmpty()) continue;
            int $$7 = this.levelHeightAccessor.getSectionYFromSectionIndex($$5);
            SectionPos $$8 = SectionPos.of(p_140055_.getPos(), $$7);
            if ($$6.size() == 1) {
                BlockPos $$9 = $$8.relativeToBlockPos($$6.iterator().nextShort());
                BlockState $$10 = $$1.getBlockState($$9);
                this.broadcast($$4, new ClientboundBlockUpdatePacket($$9, $$10));
                this.broadcastBlockEntityIfNeeded($$4, $$1, $$9, $$10);
                continue;
            }
            LevelChunkSection $$11 = p_140055_.getSection($$5);
            ClientboundSectionBlocksUpdatePacket $$12 = new ClientboundSectionBlocksUpdatePacket($$8, $$6, $$11);
            this.broadcast($$4, $$12);
            $$12.runUpdates((p_288761_, p_288762_) -> this.broadcastBlockEntityIfNeeded($$4, $$1, (BlockPos)p_288761_, (BlockState)p_288762_));
        }
        this.hasChangedSections = false;
    }

    private void broadcastBlockEntityIfNeeded(List<ServerPlayer> p_288982_, Level p_289011_, BlockPos p_288969_, BlockState p_288973_) {
        if (p_288973_.hasBlockEntity()) {
            this.broadcastBlockEntity(p_288982_, p_289011_, p_288969_);
        }
    }

    private void broadcastBlockEntity(List<ServerPlayer> p_288988_, Level p_289005_, BlockPos p_288981_) {
        Packet<ClientGamePacketListener> $$4;
        BlockEntity $$3 = p_289005_.getBlockEntity(p_288981_);
        if ($$3 != null && ($$4 = $$3.getUpdatePacket()) != null) {
            this.broadcast(p_288988_, $$4);
        }
    }

    private void broadcast(List<ServerPlayer> p_288998_, Packet<?> p_289013_) {
        p_288998_.forEach(p_293798_ -> p_293798_.connection.send(p_289013_));
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getOrScheduleFuture(ChunkStatus p_331276_, ChunkMap p_140051_) {
        int $$2 = p_331276_.getIndex();
        CompletableFuture<ChunkResult<ChunkAccess>> $$3 = this.futures.get($$2);
        if ($$3 != null) {
            ChunkResult<ChunkAccess> $$4 = $$3.getNow(NOT_DONE_YET);
            if ($$4 == null) {
                String $$5 = "value in future for status: " + String.valueOf(p_331276_) + " was incorrectly set to null at chunk: " + String.valueOf(this.pos);
                throw p_140051_.debugFuturesAndCreateReportedException(new IllegalStateException("null value previously set for chunk status"), $$5);
            }
            if ($$4 == NOT_DONE_YET || $$4.isSuccess()) {
                return $$3;
            }
        }
        if (ChunkLevel.generationStatus(this.ticketLevel).isOrAfter(p_331276_)) {
            CompletableFuture<ChunkResult<ChunkAccess>> $$6 = p_140051_.schedule(this, p_331276_);
            this.updateChunkToSave($$6, "schedule " + String.valueOf(p_331276_));
            this.futures.set($$2, $$6);
            return $$6;
        }
        return $$3 == null ? UNLOADED_CHUNK_FUTURE : $$3;
    }

    protected void addSaveDependency(String p_200417_, CompletableFuture<?> p_200418_) {
        if (this.chunkToSaveHistory != null) {
            this.chunkToSaveHistory.push(new ChunkSaveDebug(Thread.currentThread(), p_200418_, p_200417_));
        }
        this.chunkToSave = this.chunkToSave.thenCombine(p_200418_, (p_200414_, p_200415_) -> p_200414_);
    }

    private void updateChunkToSave(CompletableFuture<? extends ChunkResult<? extends ChunkAccess>> p_143018_, String p_143019_) {
        if (this.chunkToSaveHistory != null) {
            this.chunkToSaveHistory.push(new ChunkSaveDebug(Thread.currentThread(), p_143018_, p_143019_));
        }
        this.chunkToSave = this.chunkToSave.thenCombine(p_143018_, (p_329906_, p_329907_) -> ChunkResult.orElse(p_329907_, p_329906_));
    }

    public void addSendDependency(CompletableFuture<?> p_301235_) {
        this.sendSync = this.sendSync.isDone() ? p_301235_ : this.sendSync.thenCombine(p_301235_, (p_300767_, p_300768_) -> null);
    }

    public FullChunkStatus getFullStatus() {
        return ChunkLevel.fullStatus(this.ticketLevel);
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    public int getQueueLevel() {
        return this.queueLevel;
    }

    private void setQueueLevel(int p_140087_) {
        this.queueLevel = p_140087_;
    }

    public void setTicketLevel(int p_140028_) {
        this.ticketLevel = p_140028_;
    }

    private void scheduleFullChunkPromotion(ChunkMap p_142999_, CompletableFuture<ChunkResult<LevelChunk>> p_143000_, Executor p_143001_, FullChunkStatus p_287621_) {
        this.pendingFullStateConfirmation.cancel(false);
        CompletableFuture $$4 = new CompletableFuture();
        $$4.thenRunAsync(() -> p_142999_.onFullChunkStatusChange(this.pos, p_287621_), p_143001_);
        this.pendingFullStateConfirmation = $$4;
        p_143000_.thenAccept(p_329909_ -> p_329909_.ifSuccess(p_200424_ -> $$4.complete(null)));
    }

    private void demoteFullChunk(ChunkMap p_287599_, FullChunkStatus p_287649_) {
        this.pendingFullStateConfirmation.cancel(false);
        p_287599_.onFullChunkStatusChange(this.pos, p_287649_);
    }

    protected void updateFutures(ChunkMap p_143004_, Executor p_143005_) {
        ChunkStatus $$2 = ChunkLevel.generationStatus(this.oldTicketLevel);
        ChunkStatus $$3 = ChunkLevel.generationStatus(this.ticketLevel);
        boolean $$4 = ChunkLevel.isLoaded(this.oldTicketLevel);
        boolean $$5 = ChunkLevel.isLoaded(this.ticketLevel);
        FullChunkStatus $$6 = ChunkLevel.fullStatus(this.oldTicketLevel);
        FullChunkStatus $$7 = ChunkLevel.fullStatus(this.ticketLevel);
        if ($$4) {
            int $$9;
            ChunkResult $$8 = ChunkResult.error(() -> "Unloaded ticket level " + String.valueOf(this.pos));
            int n = $$9 = $$5 ? $$3.getIndex() + 1 : 0;
            while ($$9 <= $$2.getIndex()) {
                CompletableFuture<ChunkResult<ChunkAccess>> $$10 = this.futures.get($$9);
                if ($$10 == null) {
                    this.futures.set($$9, CompletableFuture.completedFuture($$8));
                }
                ++$$9;
            }
        }
        boolean $$11 = $$6.isOrAfter(FullChunkStatus.FULL);
        boolean $$12 = $$7.isOrAfter(FullChunkStatus.FULL);
        this.wasAccessibleSinceLastSave |= $$12;
        if (!$$11 && $$12) {
            this.fullChunkFuture = p_143004_.prepareAccessibleChunk(this);
            this.scheduleFullChunkPromotion(p_143004_, this.fullChunkFuture, p_143005_, FullChunkStatus.FULL);
            this.updateChunkToSave(this.fullChunkFuture, "full");
        }
        if ($$11 && !$$12) {
            this.fullChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean $$13 = $$6.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        boolean $$14 = $$7.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        if (!$$13 && $$14) {
            this.tickingChunkFuture = p_143004_.prepareTickingChunk(this);
            this.scheduleFullChunkPromotion(p_143004_, this.tickingChunkFuture, p_143005_, FullChunkStatus.BLOCK_TICKING);
            this.updateChunkToSave(this.tickingChunkFuture, "ticking");
        }
        if ($$13 && !$$14) {
            this.tickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean $$15 = $$6.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        boolean $$16 = $$7.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        if (!$$15 && $$16) {
            if (this.entityTickingChunkFuture != UNLOADED_LEVEL_CHUNK_FUTURE) {
                throw Util.pauseInIde(new IllegalStateException());
            }
            this.entityTickingChunkFuture = p_143004_.prepareEntityTickingChunk(this);
            this.scheduleFullChunkPromotion(p_143004_, this.entityTickingChunkFuture, p_143005_, FullChunkStatus.ENTITY_TICKING);
            this.updateChunkToSave(this.entityTickingChunkFuture, "entity ticking");
        }
        if ($$15 && !$$16) {
            this.entityTickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        if (!$$7.isOrAfter($$6)) {
            this.demoteFullChunk(p_143004_, $$7);
        }
        this.onLevelChange.onLevelChange(this.pos, this::getQueueLevel, this.ticketLevel, this::setQueueLevel);
        this.oldTicketLevel = this.ticketLevel;
    }

    public boolean wasAccessibleSinceLastSave() {
        return this.wasAccessibleSinceLastSave;
    }

    public void refreshAccessibility() {
        this.wasAccessibleSinceLastSave = ChunkLevel.fullStatus(this.ticketLevel).isOrAfter(FullChunkStatus.FULL);
    }

    public void replaceProtoChunk(ImposterProtoChunk p_140053_) {
        for (int $$1 = 0; $$1 < this.futures.length(); ++$$1) {
            ChunkAccess $$3;
            CompletableFuture<ChunkResult<ChunkAccess>> $$2 = this.futures.get($$1);
            if ($$2 == null || !(($$3 = (ChunkAccess)$$2.getNow(UNLOADED_CHUNK).orElse(null)) instanceof ProtoChunk)) continue;
            this.futures.set($$1, CompletableFuture.completedFuture(ChunkResult.of(p_140053_)));
        }
        this.updateChunkToSave(CompletableFuture.completedFuture(ChunkResult.of(p_140053_.getWrapped())), "replaceProto");
    }

    public List<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>> getAllFutures() {
        ArrayList<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>> $$0 = new ArrayList<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>>();
        for (int $$1 = 0; $$1 < CHUNK_STATUSES.size(); ++$$1) {
            $$0.add((Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>)Pair.of((Object)CHUNK_STATUSES.get($$1), this.futures.get($$1)));
        }
        return $$0;
    }

    @FunctionalInterface
    public static interface LevelChangeListener {
        public void onLevelChange(ChunkPos var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface PlayerProvider {
        public List<ServerPlayer> getPlayers(ChunkPos var1, boolean var2);
    }

    record ChunkSaveDebug(Thread thread, CompletableFuture<?> future, String source) {
    }
}

