/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ServerItemCooldowns;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.slf4j.Logger;

public class ServerPlayer
extends Player {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_XZ = 32;
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_Y = 10;
    private static final int FLY_STAT_RECORDING_SPEED = 25;
    public static final double INTERACTION_DISTANCE_VERIFICATION_BUFFER = 1.0;
    private static final AttributeModifier CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER = new AttributeModifier(UUID.fromString("736565d2-e1a7-403d-a3f8-1aeb3e302542"), "Creative block interaction range modifier", 0.5, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER = new AttributeModifier(UUID.fromString("98491ef6-97b1-4584-ae82-71a8cc85cf73"), "Creative entity interaction range modifier", 2.0, AttributeModifier.Operation.ADD_VALUE);
    public ServerGamePacketListenerImpl connection;
    public final MinecraftServer server;
    public final ServerPlayerGameMode gameMode;
    private final PlayerAdvancements advancements;
    private final ServerStatsCounter stats;
    private float lastRecordedHealthAndAbsorption = Float.MIN_VALUE;
    private int lastRecordedFoodLevel = Integer.MIN_VALUE;
    private int lastRecordedAirLevel = Integer.MIN_VALUE;
    private int lastRecordedArmor = Integer.MIN_VALUE;
    private int lastRecordedLevel = Integer.MIN_VALUE;
    private int lastRecordedExperience = Integer.MIN_VALUE;
    private float lastSentHealth = -1.0E8f;
    private int lastSentFood = -99999999;
    private boolean lastFoodSaturationZero = true;
    private int lastSentExp = -99999999;
    private int spawnInvulnerableTime = 60;
    private ChatVisiblity chatVisibility = ChatVisiblity.FULL;
    private boolean canChatColor = true;
    private long lastActionTime = Util.getMillis();
    @Nullable
    private Entity camera;
    private boolean isChangingDimension;
    private boolean seenCredits;
    private final ServerRecipeBook recipeBook = new ServerRecipeBook();
    @Nullable
    private Vec3 levitationStartPos;
    private int levitationStartTime;
    private boolean disconnected;
    private int requestedViewDistance = 2;
    private String language = "en_us";
    @Nullable
    private Vec3 startingToFallPosition;
    @Nullable
    private Vec3 enteredNetherPosition;
    @Nullable
    private Vec3 enteredLavaOnVehiclePosition;
    private SectionPos lastSectionPos = SectionPos.of(0, 0, 0);
    private ChunkTrackingView chunkTrackingView = ChunkTrackingView.EMPTY;
    private ResourceKey<Level> respawnDimension = Level.OVERWORLD;
    @Nullable
    private BlockPos respawnPosition;
    private boolean respawnForced;
    private float respawnAngle;
    private final TextFilter textFilter;
    private boolean textFilteringEnabled;
    private boolean allowsListing;
    private boolean spawnExtraParticlesOnFall;
    private WardenSpawnTracker wardenSpawnTracker = new WardenSpawnTracker(0, 0, 0);
    @Nullable
    private BlockPos raidOmenPosition;
    private final ContainerSynchronizer containerSynchronizer = new ContainerSynchronizer(){

        @Override
        public void sendInitialData(AbstractContainerMenu p_143448_, NonNullList<ItemStack> p_143449_, ItemStack p_143450_, int[] p_143451_) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetContentPacket(p_143448_.containerId, p_143448_.incrementStateId(), p_143449_, p_143450_));
            for (int $$4 = 0; $$4 < p_143451_.length; ++$$4) {
                this.broadcastDataValue(p_143448_, $$4, p_143451_[$$4]);
            }
        }

        @Override
        public void sendSlotChange(AbstractContainerMenu p_143441_, int p_143442_, ItemStack p_143443_) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetSlotPacket(p_143441_.containerId, p_143441_.incrementStateId(), p_143442_, p_143443_));
        }

        @Override
        public void sendCarriedChange(AbstractContainerMenu p_143445_, ItemStack p_143446_) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetSlotPacket(-1, p_143445_.incrementStateId(), -1, p_143446_));
        }

        @Override
        public void sendDataChange(AbstractContainerMenu p_143437_, int p_143438_, int p_143439_) {
            this.broadcastDataValue(p_143437_, p_143438_, p_143439_);
        }

        private void broadcastDataValue(AbstractContainerMenu p_143455_, int p_143456_, int p_143457_) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetDataPacket(p_143455_.containerId, p_143456_, p_143457_));
        }
    };
    private final ContainerListener containerListener = new ContainerListener(){

        @Override
        public void slotChanged(AbstractContainerMenu p_143466_, int p_143467_, ItemStack p_143468_) {
            Slot $$3 = p_143466_.getSlot(p_143467_);
            if ($$3 instanceof ResultSlot) {
                return;
            }
            if ($$3.container == ServerPlayer.this.getInventory()) {
                CriteriaTriggers.INVENTORY_CHANGED.trigger(ServerPlayer.this, ServerPlayer.this.getInventory(), p_143468_);
            }
        }

        @Override
        public void dataChanged(AbstractContainerMenu p_143462_, int p_143463_, int p_143464_) {
        }
    };
    @Nullable
    private RemoteChatSession chatSession;
    @Nullable
    public final Object object;
    private int containerCounter;
    public boolean wonGame;

    public ServerPlayer(MinecraftServer p_254143_, ServerLevel p_254435_, GameProfile p_253651_, ClientInformation p_301997_) {
        super(p_254435_, p_254435_.getSharedSpawnPos(), p_254435_.getSharedSpawnAngle(), p_253651_);
        this.textFilter = p_254143_.createTextFilterForPlayer(this);
        this.gameMode = p_254143_.createGameModeForPlayer(this);
        this.server = p_254143_;
        this.stats = p_254143_.getPlayerList().getPlayerStats(this);
        this.advancements = p_254143_.getPlayerList().getPlayerAdvancements(this);
        this.fudgeSpawnLocation(p_254435_);
        this.updateOptions(p_301997_);
        this.object = null;
    }

    private void fudgeSpawnLocation(ServerLevel p_9202_) {
        BlockPos $$1 = p_9202_.getSharedSpawnPos();
        if (p_9202_.dimensionType().hasSkyLight() && p_9202_.getServer().getWorldData().getGameType() != GameType.ADVENTURE) {
            long $$4;
            long $$5;
            int $$2 = Math.max(0, this.server.getSpawnRadius(p_9202_));
            int $$3 = Mth.floor(p_9202_.getWorldBorder().getDistanceToBorder($$1.getX(), $$1.getZ()));
            if ($$3 < $$2) {
                $$2 = $$3;
            }
            if ($$3 <= 1) {
                $$2 = 1;
            }
            int $$6 = ($$5 = ($$4 = (long)($$2 * 2 + 1)) * $$4) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)$$5;
            int $$7 = this.getCoprime($$6);
            int $$8 = RandomSource.create().nextInt($$6);
            for (int $$9 = 0; $$9 < $$6; ++$$9) {
                int $$10 = ($$8 + $$7 * $$9) % $$6;
                int $$11 = $$10 % ($$2 * 2 + 1);
                int $$12 = $$10 / ($$2 * 2 + 1);
                BlockPos $$13 = PlayerRespawnLogic.getOverworldRespawnPos(p_9202_, $$1.getX() + $$11 - $$2, $$1.getZ() + $$12 - $$2);
                if ($$13 == null) continue;
                this.moveTo($$13, 0.0f, 0.0f);
                if (!p_9202_.noCollision(this)) {
                    continue;
                }
                break;
            }
        } else {
            this.moveTo($$1, 0.0f, 0.0f);
            while (!p_9202_.noCollision(this) && this.getY() < (double)(p_9202_.getMaxBuildHeight() - 1)) {
                this.setPos(this.getX(), this.getY() + 1.0, this.getZ());
            }
        }
    }

    private int getCoprime(int p_9238_) {
        return p_9238_ <= 16 ? p_9238_ - 1 : 17;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_9131_) {
        super.readAdditionalSaveData(p_9131_);
        if (p_9131_.contains("warden_spawn_tracker", 10)) {
            WardenSpawnTracker.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_9131_.get("warden_spawn_tracker"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_248205_ -> {
                this.wardenSpawnTracker = p_248205_;
            });
        }
        if (p_9131_.contains("enteredNetherPosition", 10)) {
            CompoundTag $$1 = p_9131_.getCompound("enteredNetherPosition");
            this.enteredNetherPosition = new Vec3($$1.getDouble("x"), $$1.getDouble("y"), $$1.getDouble("z"));
        }
        this.seenCredits = p_9131_.getBoolean("seenCredits");
        if (p_9131_.contains("recipeBook", 10)) {
            this.recipeBook.fromNbt(p_9131_.getCompound("recipeBook"), this.server.getRecipeManager());
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        if (p_9131_.contains("SpawnX", 99) && p_9131_.contains("SpawnY", 99) && p_9131_.contains("SpawnZ", 99)) {
            this.respawnPosition = new BlockPos(p_9131_.getInt("SpawnX"), p_9131_.getInt("SpawnY"), p_9131_.getInt("SpawnZ"));
            this.respawnForced = p_9131_.getBoolean("SpawnForced");
            this.respawnAngle = p_9131_.getFloat("SpawnAngle");
            if (p_9131_.contains("SpawnDimension")) {
                this.respawnDimension = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_9131_.get("SpawnDimension")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(Level.OVERWORLD);
            }
        }
        this.spawnExtraParticlesOnFall = p_9131_.getBoolean("spawn_extra_particles_on_fall");
        Tag $$2 = p_9131_.get("raid_omen_position");
        if ($$2 != null) {
            BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$2).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_337547_ -> {
                this.raidOmenPosition = p_337547_;
            });
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_9197_) {
        super.addAdditionalSaveData(p_9197_);
        WardenSpawnTracker.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.wardenSpawnTracker).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_9134_ -> p_9197_.put("warden_spawn_tracker", (Tag)p_9134_));
        this.storeGameTypes(p_9197_);
        p_9197_.putBoolean("seenCredits", this.seenCredits);
        if (this.enteredNetherPosition != null) {
            CompoundTag $$1 = new CompoundTag();
            $$1.putDouble("x", this.enteredNetherPosition.x);
            $$1.putDouble("y", this.enteredNetherPosition.y);
            $$1.putDouble("z", this.enteredNetherPosition.z);
            p_9197_.put("enteredNetherPosition", $$1);
        }
        Entity $$2 = this.getRootVehicle();
        Entity $$3 = this.getVehicle();
        if ($$3 != null && $$2 != this && $$2.hasExactlyOnePlayerPassenger()) {
            CompoundTag $$4 = new CompoundTag();
            CompoundTag $$5 = new CompoundTag();
            $$2.save($$5);
            $$4.putUUID("Attach", $$3.getUUID());
            $$4.put("Entity", $$5);
            p_9197_.put("RootVehicle", $$4);
        }
        p_9197_.put("recipeBook", this.recipeBook.toNbt());
        p_9197_.putString("Dimension", this.level().dimension().location().toString());
        if (this.respawnPosition != null) {
            p_9197_.putInt("SpawnX", this.respawnPosition.getX());
            p_9197_.putInt("SpawnY", this.respawnPosition.getY());
            p_9197_.putInt("SpawnZ", this.respawnPosition.getZ());
            p_9197_.putBoolean("SpawnForced", this.respawnForced);
            p_9197_.putFloat("SpawnAngle", this.respawnAngle);
            ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.respawnDimension.location()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_248207_ -> p_9197_.put("SpawnDimension", (Tag)p_248207_));
        }
        p_9197_.putBoolean("spawn_extra_particles_on_fall", this.spawnExtraParticlesOnFall);
        if (this.raidOmenPosition != null) {
            BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.raidOmenPosition).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_337549_ -> p_9197_.put("raid_omen_position", (Tag)p_337549_));
        }
    }

    public void setExperiencePoints(int p_8986_) {
        float $$1 = this.getXpNeededForNextLevel();
        float $$2 = ($$1 - 1.0f) / $$1;
        this.experienceProgress = Mth.clamp((float)p_8986_ / $$1, 0.0f, $$2);
        this.lastSentExp = -1;
    }

    public void setExperienceLevels(int p_9175_) {
        this.experienceLevel = p_9175_;
        this.lastSentExp = -1;
    }

    @Override
    public void giveExperienceLevels(int p_9200_) {
        super.giveExperienceLevels(p_9200_);
        this.lastSentExp = -1;
    }

    @Override
    public void onEnchantmentPerformed(ItemStack p_9079_, int p_9080_) {
        super.onEnchantmentPerformed(p_9079_, p_9080_);
        this.lastSentExp = -1;
    }

    private void initMenu(AbstractContainerMenu p_143400_) {
        p_143400_.addSlotListener(this.containerListener);
        p_143400_.setSynchronizer(this.containerSynchronizer);
    }

    public void initInventoryMenu() {
        this.initMenu(this.inventoryMenu);
    }

    @Override
    public void onEnterCombat() {
        super.onEnterCombat();
        this.connection.send(ClientboundPlayerCombatEnterPacket.INSTANCE);
    }

    @Override
    public void onLeaveCombat() {
        super.onLeaveCombat();
        this.connection.send(new ClientboundPlayerCombatEndPacket(this.getCombatTracker()));
    }

    @Override
    protected void onInsideBlock(BlockState p_9103_) {
        CriteriaTriggers.ENTER_BLOCK.trigger(this, p_9103_);
    }

    @Override
    protected ItemCooldowns createItemCooldowns() {
        return new ServerItemCooldowns(this);
    }

    @Override
    public void tick() {
        Entity $$0;
        this.gameMode.tick();
        this.wardenSpawnTracker.tick();
        --this.spawnInvulnerableTime;
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        this.containerMenu.broadcastChanges();
        if (!this.level().isClientSide && !this.containerMenu.stillValid(this)) {
            this.closeContainer();
            this.containerMenu = this.inventoryMenu;
        }
        if (($$0 = this.getCamera()) != this) {
            if ($$0.isAlive()) {
                this.absMoveTo($$0.getX(), $$0.getY(), $$0.getZ(), $$0.getYRot(), $$0.getXRot());
                this.serverLevel().getChunkSource().move(this);
                if (this.wantsToStopRiding()) {
                    this.setCamera(this);
                }
            } else {
                this.setCamera(this);
            }
        }
        CriteriaTriggers.TICK.trigger(this);
        if (this.levitationStartPos != null) {
            CriteriaTriggers.LEVITATION.trigger(this, this.levitationStartPos, this.tickCount - this.levitationStartTime);
        }
        this.trackStartFallingPosition();
        this.trackEnteredOrExitedLavaOnVehicle();
        this.updatePlayerAttributes();
        this.advancements.flushDirty(this);
    }

    private void updatePlayerAttributes() {
        AttributeInstance $$1;
        AttributeInstance $$0 = this.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if ($$0 != null) {
            if (this.isCreative()) {
                $$0.addOrUpdateTransientModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            } else {
                $$0.removeModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            }
        }
        if (($$1 = this.getAttribute(Attributes.ENTITY_INTERACTION_RANGE)) != null) {
            if (this.isCreative()) {
                $$1.addOrUpdateTransientModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            } else {
                $$1.removeModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            }
        }
    }

    public void doTick() {
        try {
            if (!this.isSpectator() || !this.touchingUnloadedChunk()) {
                super.tick();
            }
            for (int $$0 = 0; $$0 < this.getInventory().getContainerSize(); ++$$0) {
                Packet<?> $$2;
                ItemStack $$1 = this.getInventory().getItem($$0);
                if (!$$1.getItem().isComplex() || ($$2 = ((ComplexItem)$$1.getItem()).getUpdatePacket($$1, this.level(), this)) == null) continue;
                this.connection.send($$2);
            }
            if (this.getHealth() != this.lastSentHealth || this.lastSentFood != this.foodData.getFoodLevel() || this.foodData.getSaturationLevel() == 0.0f != this.lastFoodSaturationZero) {
                this.connection.send(new ClientboundSetHealthPacket(this.getHealth(), this.foodData.getFoodLevel(), this.foodData.getSaturationLevel()));
                this.lastSentHealth = this.getHealth();
                this.lastSentFood = this.foodData.getFoodLevel();
                boolean bl = this.lastFoodSaturationZero = this.foodData.getSaturationLevel() == 0.0f;
            }
            if (this.getHealth() + this.getAbsorptionAmount() != this.lastRecordedHealthAndAbsorption) {
                this.lastRecordedHealthAndAbsorption = this.getHealth() + this.getAbsorptionAmount();
                this.updateScoreForCriteria(ObjectiveCriteria.HEALTH, Mth.ceil(this.lastRecordedHealthAndAbsorption));
            }
            if (this.foodData.getFoodLevel() != this.lastRecordedFoodLevel) {
                this.lastRecordedFoodLevel = this.foodData.getFoodLevel();
                this.updateScoreForCriteria(ObjectiveCriteria.FOOD, Mth.ceil(this.lastRecordedFoodLevel));
            }
            if (this.getAirSupply() != this.lastRecordedAirLevel) {
                this.lastRecordedAirLevel = this.getAirSupply();
                this.updateScoreForCriteria(ObjectiveCriteria.AIR, Mth.ceil(this.lastRecordedAirLevel));
            }
            if (this.getArmorValue() != this.lastRecordedArmor) {
                this.lastRecordedArmor = this.getArmorValue();
                this.updateScoreForCriteria(ObjectiveCriteria.ARMOR, Mth.ceil(this.lastRecordedArmor));
            }
            if (this.totalExperience != this.lastRecordedExperience) {
                this.lastRecordedExperience = this.totalExperience;
                this.updateScoreForCriteria(ObjectiveCriteria.EXPERIENCE, Mth.ceil(this.lastRecordedExperience));
            }
            if (this.experienceLevel != this.lastRecordedLevel) {
                this.lastRecordedLevel = this.experienceLevel;
                this.updateScoreForCriteria(ObjectiveCriteria.LEVEL, Mth.ceil(this.lastRecordedLevel));
            }
            if (this.totalExperience != this.lastSentExp) {
                this.lastSentExp = this.totalExperience;
                this.connection.send(new ClientboundSetExperiencePacket(this.experienceProgress, this.totalExperience, this.experienceLevel));
            }
            if (this.tickCount % 20 == 0) {
                CriteriaTriggers.LOCATION.trigger(this);
            }
        }
        catch (Throwable $$3) {
            CrashReport $$4 = CrashReport.forThrowable($$3, "Ticking player");
            CrashReportCategory $$5 = $$4.addCategory("Player being ticked");
            this.fillCrashReportCategory($$5);
            throw new ReportedException($$4);
        }
    }

    @Override
    public void resetFallDistance() {
        if (this.getHealth() > 0.0f && this.startingToFallPosition != null) {
            CriteriaTriggers.FALL_FROM_HEIGHT.trigger(this, this.startingToFallPosition);
        }
        this.startingToFallPosition = null;
        super.resetFallDistance();
    }

    public void trackStartFallingPosition() {
        if (this.fallDistance > 0.0f && this.startingToFallPosition == null) {
            this.startingToFallPosition = this.position();
            if (this.currentImpulseImpactPos != null) {
                CriteriaTriggers.FALL_AFTER_EXPLOSION.trigger(this, this.currentImpulseImpactPos, this.currentExplosionCause);
            }
        }
    }

    public void trackEnteredOrExitedLavaOnVehicle() {
        if (this.getVehicle() != null && this.getVehicle().isInLava()) {
            if (this.enteredLavaOnVehiclePosition == null) {
                this.enteredLavaOnVehiclePosition = this.position();
            } else {
                CriteriaTriggers.RIDE_ENTITY_IN_LAVA_TRIGGER.trigger(this, this.enteredLavaOnVehiclePosition);
            }
        }
        if (!(this.enteredLavaOnVehiclePosition == null || this.getVehicle() != null && this.getVehicle().isInLava())) {
            this.enteredLavaOnVehiclePosition = null;
        }
    }

    private void updateScoreForCriteria(ObjectiveCriteria p_9105_, int p_9106_) {
        this.getScoreboard().forAllObjectives(p_9105_, this, p_313589_ -> p_313589_.set(p_9106_));
    }

    @Override
    public void die(DamageSource p_9035_) {
        this.gameEvent(GameEvent.ENTITY_DIE);
        boolean $$1 = this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES);
        if ($$1) {
            Component $$2 = this.getCombatTracker().getDeathMessage();
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), $$2), PacketSendListener.exceptionallySend(() -> {
                int $$1 = 256;
                String $$2 = $$2.getString(256);
                MutableComponent $$3 = Component.translatable("death.attack.message_too_long", Component.literal($$2).withStyle(ChatFormatting.YELLOW));
                MutableComponent $$4 = Component.translatable("death.attack.even_more_magic", this.getDisplayName()).withStyle(p_143420_ -> p_143420_.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, $$3)));
                return new ClientboundPlayerCombatKillPacket(this.getId(), $$4);
            }));
            PlayerTeam $$3 = this.getTeam();
            if ($$3 == null || ((Team)$$3).getDeathMessageVisibility() == Team.Visibility.ALWAYS) {
                this.server.getPlayerList().broadcastSystemMessage($$2, false);
            } else if (((Team)$$3).getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                this.server.getPlayerList().broadcastSystemToTeam(this, $$2);
            } else if (((Team)$$3).getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                this.server.getPlayerList().broadcastSystemToAllExceptTeam(this, $$2);
            }
        } else {
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), CommonComponents.EMPTY));
        }
        this.removeEntitiesOnShoulder();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            this.tellNeutralMobsThatIDied();
        }
        if (!this.isSpectator()) {
            this.dropAllDeathLoot(p_9035_);
        }
        this.getScoreboard().forAllObjectives(ObjectiveCriteria.DEATH_COUNT, this, ScoreAccess::increment);
        LivingEntity $$4 = this.getKillCredit();
        if ($$4 != null) {
            this.awardStat(Stats.ENTITY_KILLED_BY.get($$4.getType()));
            $$4.awardKillScore(this, this.deathScore, p_9035_);
            this.createWitherRose($$4);
        }
        this.level().broadcastEntityEvent(this, (byte)3);
        this.awardStat(Stats.DEATHS);
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_DEATH));
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        this.clearFire();
        this.setTicksFrozen(0);
        this.setSharedFlagOnFire(false);
        this.getCombatTracker().recheckStatus();
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    private void tellNeutralMobsThatIDied() {
        AABB $$0 = new AABB(this.blockPosition()).inflate(32.0, 10.0, 32.0);
        this.level().getEntitiesOfClass(Mob.class, $$0, EntitySelector.NO_SPECTATORS).stream().filter(p_9188_ -> p_9188_ instanceof NeutralMob).forEach(p_9057_ -> ((NeutralMob)((Object)p_9057_)).playerDied(this));
    }

    @Override
    public void awardKillScore(Entity p_9050_, int p_9051_, DamageSource p_9052_) {
        if (p_9050_ == this) {
            return;
        }
        super.awardKillScore(p_9050_, p_9051_, p_9052_);
        this.increaseScore(p_9051_);
        this.getScoreboard().forAllObjectives(ObjectiveCriteria.KILL_COUNT_ALL, this, ScoreAccess::increment);
        if (p_9050_ instanceof Player) {
            this.awardStat(Stats.PLAYER_KILLS);
            this.getScoreboard().forAllObjectives(ObjectiveCriteria.KILL_COUNT_PLAYERS, this, ScoreAccess::increment);
        } else {
            this.awardStat(Stats.MOB_KILLS);
        }
        this.handleTeamKill(this, p_9050_, ObjectiveCriteria.TEAM_KILL);
        this.handleTeamKill(p_9050_, this, ObjectiveCriteria.KILLED_BY_TEAM);
        CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(this, p_9050_, p_9052_);
    }

    private void handleTeamKill(ScoreHolder p_313693_, ScoreHolder p_313814_, ObjectiveCriteria[] p_9127_) {
        int $$4;
        PlayerTeam $$3 = this.getScoreboard().getPlayersTeam(p_313814_.getScoreboardName());
        if ($$3 != null && ($$4 = $$3.getColor().getId()) >= 0 && $$4 < p_9127_.length) {
            this.getScoreboard().forAllObjectives(p_9127_[$$4], p_313693_, ScoreAccess::increment);
        }
    }

    @Override
    public boolean hurt(DamageSource p_9037_, float p_9038_) {
        Player $$7;
        AbstractArrow $$5;
        Entity $$6;
        Player $$4;
        boolean $$2;
        if (this.isInvulnerableTo(p_9037_)) {
            return false;
        }
        boolean bl = $$2 = this.server.isDedicatedServer() && this.isPvpAllowed() && p_9037_.is(DamageTypeTags.IS_FALL);
        if (!$$2 && this.spawnInvulnerableTime > 0 && !p_9037_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        Entity $$3 = p_9037_.getEntity();
        if ($$3 instanceof Player && !this.canHarmPlayer($$4 = (Player)$$3)) {
            return false;
        }
        if ($$3 instanceof AbstractArrow && ($$6 = ($$5 = (AbstractArrow)$$3).getOwner()) instanceof Player && !this.canHarmPlayer($$7 = (Player)$$6)) {
            return false;
        }
        return super.hurt(p_9037_, p_9038_);
    }

    @Override
    public boolean canHarmPlayer(Player p_9064_) {
        if (!this.isPvpAllowed()) {
            return false;
        }
        return super.canHarmPlayer(p_9064_);
    }

    private boolean isPvpAllowed() {
        return this.server.isPvpAllowed();
    }

    @Override
    @Nullable
    protected PortalInfo findDimensionEntryPoint(ServerLevel p_8998_) {
        PortalInfo $$1 = super.findDimensionEntryPoint(p_8998_);
        if ($$1 != null && this.level().dimension() == Level.OVERWORLD && p_8998_.dimension() == Level.END) {
            Vec3 $$2 = $$1.pos.add(0.0, -1.0, 0.0);
            return new PortalInfo($$2, Vec3.ZERO, 90.0f, 0.0f);
        }
        return $$1;
    }

    @Override
    @Nullable
    public Entity changeDimension(ServerLevel p_9180_) {
        this.isChangingDimension = true;
        ServerLevel $$1 = this.serverLevel();
        ResourceKey<Level> $$2 = $$1.dimension();
        if ($$2 == Level.END && p_9180_.dimension() == Level.OVERWORLD) {
            this.unRide();
            this.serverLevel().removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
            if (!this.wonGame) {
                this.wonGame = true;
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, this.seenCredits ? 0.0f : 1.0f));
                this.seenCredits = true;
            }
            return this;
        }
        LevelData $$3 = p_9180_.getLevelData();
        this.connection.send(new ClientboundRespawnPacket(this.createCommonSpawnInfo(p_9180_), 3));
        this.connection.send(new ClientboundChangeDifficultyPacket($$3.getDifficulty(), $$3.isDifficultyLocked()));
        PlayerList $$4 = this.server.getPlayerList();
        $$4.sendPlayerPermissionLevel(this);
        $$1.removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        this.unsetRemoved();
        PortalInfo $$5 = this.findDimensionEntryPoint(p_9180_);
        if ($$5 != null) {
            $$1.getProfiler().push("moving");
            if ($$2 == Level.OVERWORLD && p_9180_.dimension() == Level.NETHER) {
                this.enteredNetherPosition = this.position();
            } else if (p_9180_.dimension() == Level.END) {
                this.createEndPlatform(p_9180_, BlockPos.containing($$5.pos));
            }
            $$1.getProfiler().pop();
            $$1.getProfiler().push("placing");
            this.setServerLevel(p_9180_);
            this.connection.teleport($$5.pos.x, $$5.pos.y, $$5.pos.z, $$5.yRot, $$5.xRot);
            this.connection.resetPosition();
            p_9180_.addDuringPortalTeleport(this);
            $$1.getProfiler().pop();
            this.triggerDimensionChangeTriggers($$1);
            this.connection.send(new ClientboundPlayerAbilitiesPacket(this.getAbilities()));
            $$4.sendLevelInfo(this, p_9180_);
            $$4.sendAllPlayerInfo(this);
            for (MobEffectInstance $$6 : this.getActiveEffects()) {
                this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), $$6, false));
            }
            this.connection.send(new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
            this.lastSentExp = -1;
            this.lastSentHealth = -1.0f;
            this.lastSentFood = -1;
        }
        return this;
    }

    private void createEndPlatform(ServerLevel p_9007_, BlockPos p_9008_) {
        BlockPos.MutableBlockPos $$2 = p_9008_.mutable();
        for (int $$3 = -2; $$3 <= 2; ++$$3) {
            for (int $$4 = -2; $$4 <= 2; ++$$4) {
                for (int $$5 = -1; $$5 < 3; ++$$5) {
                    BlockState $$6 = $$5 == -1 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                    p_9007_.setBlockAndUpdate($$2.set(p_9008_).move($$4, $$5, $$3), $$6);
                }
            }
        }
    }

    @Override
    protected Optional<BlockUtil.FoundRectangle> getExitPortal(ServerLevel p_184131_, BlockPos p_184132_, boolean p_184133_, WorldBorder p_184134_) {
        Optional<BlockUtil.FoundRectangle> $$4 = super.getExitPortal(p_184131_, p_184132_, p_184133_, p_184134_);
        if ($$4.isPresent()) {
            return $$4;
        }
        Direction.Axis $$5 = this.level().getBlockState(this.portalEntrancePos).getOptionalValue(NetherPortalBlock.AXIS).orElse(Direction.Axis.X);
        Optional<BlockUtil.FoundRectangle> $$6 = p_184131_.getPortalForcer().createPortal(p_184132_, $$5);
        if ($$6.isEmpty()) {
            LOGGER.error("Unable to create a portal, likely target out of worldborder");
        }
        return $$6;
    }

    private void triggerDimensionChangeTriggers(ServerLevel p_9210_) {
        ResourceKey<Level> $$1 = p_9210_.dimension();
        ResourceKey<Level> $$2 = this.level().dimension();
        CriteriaTriggers.CHANGED_DIMENSION.trigger(this, $$1, $$2);
        if ($$1 == Level.NETHER && $$2 == Level.OVERWORLD && this.enteredNetherPosition != null) {
            CriteriaTriggers.NETHER_TRAVEL.trigger(this, this.enteredNetherPosition);
        }
        if ($$2 != Level.NETHER) {
            this.enteredNetherPosition = null;
        }
    }

    @Override
    public boolean broadcastToPlayer(ServerPlayer p_9014_) {
        if (p_9014_.isSpectator()) {
            return this.getCamera() == this;
        }
        if (this.isSpectator()) {
            return false;
        }
        return super.broadcastToPlayer(p_9014_);
    }

    @Override
    public void take(Entity p_9047_, int p_9048_) {
        super.take(p_9047_, p_9048_);
        this.containerMenu.broadcastChanges();
    }

    @Override
    public Either<Player.BedSleepingProblem, Unit> startSleepInBed(BlockPos p_9115_) {
        Direction $$1 = this.level().getBlockState(p_9115_).getValue(HorizontalDirectionalBlock.FACING);
        if (this.isSleeping() || !this.isAlive()) {
            return Either.left((Object)((Object)Player.BedSleepingProblem.OTHER_PROBLEM));
        }
        if (!this.level().dimensionType().natural()) {
            return Either.left((Object)((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE));
        }
        if (!this.bedInRange(p_9115_, $$1)) {
            return Either.left((Object)((Object)Player.BedSleepingProblem.TOO_FAR_AWAY));
        }
        if (this.bedBlocked(p_9115_, $$1)) {
            return Either.left((Object)((Object)Player.BedSleepingProblem.OBSTRUCTED));
        }
        this.setRespawnPosition(this.level().dimension(), p_9115_, this.getYRot(), false, true);
        if (this.level().isDay()) {
            return Either.left((Object)((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW));
        }
        if (!this.isCreative()) {
            double $$2 = 8.0;
            double $$3 = 5.0;
            Vec3 $$4 = Vec3.atBottomCenterOf(p_9115_);
            List<Monster> $$5 = this.level().getEntitiesOfClass(Monster.class, new AABB($$4.x() - 8.0, $$4.y() - 5.0, $$4.z() - 8.0, $$4.x() + 8.0, $$4.y() + 5.0, $$4.z() + 8.0), p_9062_ -> p_9062_.isPreventingPlayerRest(this));
            if (!$$5.isEmpty()) {
                return Either.left((Object)((Object)Player.BedSleepingProblem.NOT_SAFE));
            }
        }
        Either $$6 = super.startSleepInBed(p_9115_).ifRight(p_9029_ -> {
            this.awardStat(Stats.SLEEP_IN_BED);
            CriteriaTriggers.SLEPT_IN_BED.trigger(this);
        });
        if (!this.serverLevel().canSleepThroughNights()) {
            this.displayClientMessage(Component.translatable("sleep.not_possible"), true);
        }
        ((ServerLevel)this.level()).updateSleepingPlayerList();
        return $$6;
    }

    @Override
    public void startSleeping(BlockPos p_9190_) {
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        super.startSleeping(p_9190_);
    }

    private boolean bedInRange(BlockPos p_9117_, Direction p_9118_) {
        return this.isReachableBedBlock(p_9117_) || this.isReachableBedBlock(p_9117_.relative(p_9118_.getOpposite()));
    }

    private boolean isReachableBedBlock(BlockPos p_9223_) {
        Vec3 $$1 = Vec3.atBottomCenterOf(p_9223_);
        return Math.abs(this.getX() - $$1.x()) <= 3.0 && Math.abs(this.getY() - $$1.y()) <= 2.0 && Math.abs(this.getZ() - $$1.z()) <= 3.0;
    }

    private boolean bedBlocked(BlockPos p_9192_, Direction p_9193_) {
        BlockPos $$2 = p_9192_.above();
        return !this.freeAt($$2) || !this.freeAt($$2.relative(p_9193_.getOpposite()));
    }

    @Override
    public void stopSleepInBed(boolean p_9165_, boolean p_9166_) {
        if (this.isSleeping()) {
            this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(this, 2));
        }
        super.stopSleepInBed(p_9165_, p_9166_);
        if (this.connection != null) {
            this.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    @Override
    public void dismountTo(double p_143389_, double p_143390_, double p_143391_) {
        this.removeVehicle();
        this.setPos(p_143389_, p_143390_, p_143391_);
    }

    @Override
    public boolean isInvulnerableTo(DamageSource p_9182_) {
        return super.isInvulnerableTo(p_9182_) || this.isChangingDimension();
    }

    @Override
    protected void checkFallDamage(double p_8976_, boolean p_8977_, BlockState p_8978_, BlockPos p_8979_) {
    }

    @Override
    protected void onChangedBlock(BlockPos p_9206_) {
        if (!this.isSpectator()) {
            super.onChangedBlock(p_9206_);
        }
    }

    public void doCheckFallDamage(double p_289676_, double p_289671_, double p_289665_, boolean p_289696_) {
        if (this.touchingUnloadedChunk()) {
            return;
        }
        this.checkSupportingBlock(p_289696_, new Vec3(p_289676_, p_289671_, p_289665_));
        BlockPos $$4 = this.getOnPosLegacy();
        BlockState $$5 = this.level().getBlockState($$4);
        if (this.spawnExtraParticlesOnFall && p_289696_ && this.fallDistance > 0.0f) {
            Vec3 $$6 = $$4.getCenter().add(0.0, 0.5, 0.0);
            int $$7 = (int)(50.0f * this.fallDistance);
            this.serverLevel().sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, $$5), $$6.x, $$6.y, $$6.z, $$7, 0.3f, 0.3f, 0.3f, 0.15f);
            this.spawnExtraParticlesOnFall = false;
        }
        super.checkFallDamage(p_289671_, p_289696_, $$5, $$4);
    }

    @Override
    public void onExplosionHit(@Nullable Entity p_326351_) {
        super.onExplosionHit(p_326351_);
        this.currentImpulseImpactPos = this.position();
        this.currentExplosionCause = p_326351_;
        this.ignoreFallDamageFromCurrentImpulse = p_326351_ != null && p_326351_.getType() == EntityType.WIND_CHARGE;
    }

    @Override
    protected void pushEntities() {
        if (this.level().tickRateManager().runsNormally()) {
            super.pushEntities();
        }
    }

    @Override
    public void openTextEdit(SignBlockEntity p_277909_, boolean p_277495_) {
        this.connection.send(new ClientboundBlockUpdatePacket(this.level(), p_277909_.getBlockPos()));
        this.connection.send(new ClientboundOpenSignEditorPacket(p_277909_.getBlockPos(), p_277495_));
    }

    private void nextContainerCounter() {
        this.containerCounter = this.containerCounter % 100 + 1;
    }

    @Override
    public OptionalInt openMenu(@Nullable MenuProvider p_9033_) {
        if (p_9033_ == null) {
            return OptionalInt.empty();
        }
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        this.nextContainerCounter();
        AbstractContainerMenu $$1 = p_9033_.createMenu(this.containerCounter, this.getInventory(), this);
        if ($$1 == null) {
            if (this.isSpectator()) {
                this.displayClientMessage(Component.translatable("container.spectatorCantOpen").withStyle(ChatFormatting.RED), true);
            }
            return OptionalInt.empty();
        }
        this.connection.send(new ClientboundOpenScreenPacket($$1.containerId, $$1.getType(), p_9033_.getDisplayName()));
        this.initMenu($$1);
        this.containerMenu = $$1;
        return OptionalInt.of(this.containerCounter);
    }

    @Override
    public void sendMerchantOffers(int p_8988_, MerchantOffers p_8989_, int p_8990_, int p_8991_, boolean p_8992_, boolean p_8993_) {
        this.connection.send(new ClientboundMerchantOffersPacket(p_8988_, p_8989_, p_8990_, p_8991_, p_8992_, p_8993_));
    }

    @Override
    public void openHorseInventory(AbstractHorse p_9059_, Container p_9060_) {
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        this.nextContainerCounter();
        this.connection.send(new ClientboundHorseScreenOpenPacket(this.containerCounter, p_9060_.getContainerSize(), p_9059_.getId()));
        this.containerMenu = new HorseInventoryMenu(this.containerCounter, this.getInventory(), p_9060_, p_9059_);
        this.initMenu(this.containerMenu);
    }

    @Override
    public void openItemGui(ItemStack p_9082_, InteractionHand p_9083_) {
        if (p_9082_.is(Items.WRITTEN_BOOK)) {
            if (WrittenBookItem.resolveBookComponents(p_9082_, this.createCommandSourceStack(), this)) {
                this.containerMenu.broadcastChanges();
            }
            this.connection.send(new ClientboundOpenBookPacket(p_9083_));
        }
    }

    @Override
    public void openCommandBlock(CommandBlockEntity p_9099_) {
        this.connection.send(ClientboundBlockEntityDataPacket.create(p_9099_, BlockEntity::saveCustomOnly));
    }

    @Override
    public void closeContainer() {
        this.connection.send(new ClientboundContainerClosePacket(this.containerMenu.containerId));
        this.doCloseContainer();
    }

    @Override
    public void doCloseContainer() {
        this.containerMenu.removed(this);
        this.inventoryMenu.transferState(this.containerMenu);
        this.containerMenu = this.inventoryMenu;
    }

    public void setPlayerInput(float p_8981_, float p_8982_, boolean p_8983_, boolean p_8984_) {
        if (this.isPassenger()) {
            if (p_8981_ >= -1.0f && p_8981_ <= 1.0f) {
                this.xxa = p_8981_;
            }
            if (p_8982_ >= -1.0f && p_8982_ <= 1.0f) {
                this.zza = p_8982_;
            }
            this.jumping = p_8983_;
            this.setShiftKeyDown(p_8984_);
        }
    }

    @Override
    public void travel(Vec3 p_308985_) {
        double $$1 = this.getX();
        double $$2 = this.getY();
        double $$3 = this.getZ();
        super.travel(p_308985_);
        this.checkMovementStatistics(this.getX() - $$1, this.getY() - $$2, this.getZ() - $$3);
    }

    @Override
    public void rideTick() {
        double $$0 = this.getX();
        double $$1 = this.getY();
        double $$2 = this.getZ();
        super.rideTick();
        this.checkRidingStatistics(this.getX() - $$0, this.getY() - $$1, this.getZ() - $$2);
    }

    public void checkMovementStatistics(double p_308996_, double p_309062_, double p_309170_) {
        if (this.isPassenger() || ServerPlayer.didNotMove(p_308996_, p_309062_, p_309170_)) {
            return;
        }
        if (this.isSwimming()) {
            int $$3 = Math.round((float)Math.sqrt(p_308996_ * p_308996_ + p_309062_ * p_309062_ + p_309170_ * p_309170_) * 100.0f);
            if ($$3 > 0) {
                this.awardStat(Stats.SWIM_ONE_CM, $$3);
                this.causeFoodExhaustion(0.01f * (float)$$3 * 0.01f);
            }
        } else if (this.isEyeInFluid(FluidTags.WATER)) {
            int $$4 = Math.round((float)Math.sqrt(p_308996_ * p_308996_ + p_309062_ * p_309062_ + p_309170_ * p_309170_) * 100.0f);
            if ($$4 > 0) {
                this.awardStat(Stats.WALK_UNDER_WATER_ONE_CM, $$4);
                this.causeFoodExhaustion(0.01f * (float)$$4 * 0.01f);
            }
        } else if (this.isInWater()) {
            int $$5 = Math.round((float)Math.sqrt(p_308996_ * p_308996_ + p_309170_ * p_309170_) * 100.0f);
            if ($$5 > 0) {
                this.awardStat(Stats.WALK_ON_WATER_ONE_CM, $$5);
                this.causeFoodExhaustion(0.01f * (float)$$5 * 0.01f);
            }
        } else if (this.onClimbable()) {
            if (p_309062_ > 0.0) {
                this.awardStat(Stats.CLIMB_ONE_CM, (int)Math.round(p_309062_ * 100.0));
            }
        } else if (this.onGround()) {
            int $$6 = Math.round((float)Math.sqrt(p_308996_ * p_308996_ + p_309170_ * p_309170_) * 100.0f);
            if ($$6 > 0) {
                if (this.isSprinting()) {
                    this.awardStat(Stats.SPRINT_ONE_CM, $$6);
                    this.causeFoodExhaustion(0.1f * (float)$$6 * 0.01f);
                } else if (this.isCrouching()) {
                    this.awardStat(Stats.CROUCH_ONE_CM, $$6);
                    this.causeFoodExhaustion(0.0f * (float)$$6 * 0.01f);
                } else {
                    this.awardStat(Stats.WALK_ONE_CM, $$6);
                    this.causeFoodExhaustion(0.0f * (float)$$6 * 0.01f);
                }
            }
        } else if (this.isFallFlying()) {
            int $$7 = Math.round((float)Math.sqrt(p_308996_ * p_308996_ + p_309062_ * p_309062_ + p_309170_ * p_309170_) * 100.0f);
            this.awardStat(Stats.AVIATE_ONE_CM, $$7);
        } else {
            int $$8 = Math.round((float)Math.sqrt(p_308996_ * p_308996_ + p_309170_ * p_309170_) * 100.0f);
            if ($$8 > 25) {
                this.awardStat(Stats.FLY_ONE_CM, $$8);
            }
        }
    }

    private void checkRidingStatistics(double p_308888_, double p_309131_, double p_308893_) {
        if (!this.isPassenger() || ServerPlayer.didNotMove(p_308888_, p_309131_, p_308893_)) {
            return;
        }
        int $$3 = Math.round((float)Math.sqrt(p_308888_ * p_308888_ + p_309131_ * p_309131_ + p_308893_ * p_308893_) * 100.0f);
        Entity $$4 = this.getVehicle();
        if ($$4 instanceof AbstractMinecart) {
            this.awardStat(Stats.MINECART_ONE_CM, $$3);
        } else if ($$4 instanceof Boat) {
            this.awardStat(Stats.BOAT_ONE_CM, $$3);
        } else if ($$4 instanceof Pig) {
            this.awardStat(Stats.PIG_ONE_CM, $$3);
        } else if ($$4 instanceof AbstractHorse) {
            this.awardStat(Stats.HORSE_ONE_CM, $$3);
        } else if ($$4 instanceof Strider) {
            this.awardStat(Stats.STRIDER_ONE_CM, $$3);
        }
    }

    private static boolean didNotMove(double p_309023_, double p_309067_, double p_309143_) {
        return p_309023_ == 0.0 && p_309067_ == 0.0 && p_309143_ == 0.0;
    }

    @Override
    public void awardStat(Stat<?> p_9026_, int p_9027_) {
        this.stats.increment(this, p_9026_, p_9027_);
        this.getScoreboard().forAllObjectives(p_9026_, this, p_313587_ -> p_313587_.add(p_9027_));
    }

    @Override
    public void resetStat(Stat<?> p_9024_) {
        this.stats.setValue(this, p_9024_, 0);
        this.getScoreboard().forAllObjectives(p_9024_, this, ScoreAccess::reset);
    }

    @Override
    public int awardRecipes(Collection<RecipeHolder<?>> p_9129_) {
        return this.recipeBook.addRecipes(p_9129_, this);
    }

    @Override
    public void triggerRecipeCrafted(RecipeHolder<?> p_301156_, List<ItemStack> p_282336_) {
        CriteriaTriggers.RECIPE_CRAFTED.trigger(this, p_301156_.id(), p_282336_);
    }

    @Override
    public void awardRecipesByKey(List<ResourceLocation> p_312811_) {
        List<RecipeHolder<?>> $$1 = p_312811_.stream().flatMap(p_311549_ -> this.server.getRecipeManager().byKey((ResourceLocation)p_311549_).stream()).collect(Collectors.toList());
        this.awardRecipes($$1);
    }

    @Override
    public int resetRecipes(Collection<RecipeHolder<?>> p_9195_) {
        return this.recipeBook.removeRecipes(p_9195_, this);
    }

    @Override
    public void giveExperiencePoints(int p_9208_) {
        super.giveExperiencePoints(p_9208_);
        this.lastSentExp = -1;
    }

    public void disconnect() {
        this.disconnected = true;
        this.ejectPassengers();
        if (this.isSleeping()) {
            this.stopSleepInBed(true, false);
        }
    }

    public boolean hasDisconnected() {
        return this.disconnected;
    }

    public void resetSentInfo() {
        this.lastSentHealth = -1.0E8f;
    }

    @Override
    public void displayClientMessage(Component p_9154_, boolean p_9155_) {
        this.sendSystemMessage(p_9154_, p_9155_);
    }

    @Override
    protected void completeUsingItem() {
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            this.connection.send(new ClientboundEntityEventPacket(this, 9));
            super.completeUsingItem();
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor p_9112_, Vec3 p_9113_) {
        super.lookAt(p_9112_, p_9113_);
        this.connection.send(new ClientboundPlayerLookAtPacket(p_9112_, p_9113_.x, p_9113_.y, p_9113_.z));
    }

    public void lookAt(EntityAnchorArgument.Anchor p_9108_, Entity p_9109_, EntityAnchorArgument.Anchor p_9110_) {
        Vec3 $$3 = p_9110_.apply(p_9109_);
        super.lookAt(p_9108_, $$3);
        this.connection.send(new ClientboundPlayerLookAtPacket(p_9108_, p_9109_, p_9110_));
    }

    public void restoreFrom(ServerPlayer p_9016_, boolean p_9017_) {
        this.wardenSpawnTracker = p_9016_.wardenSpawnTracker;
        this.chatSession = p_9016_.chatSession;
        this.gameMode.setGameModeForPlayer(p_9016_.gameMode.getGameModeForPlayer(), p_9016_.gameMode.getPreviousGameModeForPlayer());
        this.onUpdateAbilities();
        if (p_9017_) {
            this.getInventory().replaceWith(p_9016_.getInventory());
            this.setHealth(p_9016_.getHealth());
            this.foodData = p_9016_.foodData;
            this.experienceLevel = p_9016_.experienceLevel;
            this.totalExperience = p_9016_.totalExperience;
            this.experienceProgress = p_9016_.experienceProgress;
            this.setScore(p_9016_.getScore());
            this.portalEntrancePos = p_9016_.portalEntrancePos;
        } else if (this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || p_9016_.isSpectator()) {
            this.getInventory().replaceWith(p_9016_.getInventory());
            this.experienceLevel = p_9016_.experienceLevel;
            this.totalExperience = p_9016_.totalExperience;
            this.experienceProgress = p_9016_.experienceProgress;
            this.setScore(p_9016_.getScore());
        }
        this.enchantmentSeed = p_9016_.enchantmentSeed;
        this.enderChestInventory = p_9016_.enderChestInventory;
        this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (Byte)p_9016_.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION));
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        this.recipeBook.copyOverData(p_9016_.recipeBook);
        this.seenCredits = p_9016_.seenCredits;
        this.enteredNetherPosition = p_9016_.enteredNetherPosition;
        this.chunkTrackingView = p_9016_.chunkTrackingView;
        this.setShoulderEntityLeft(p_9016_.getShoulderEntityLeft());
        this.setShoulderEntityRight(p_9016_.getShoulderEntityRight());
        this.setLastDeathLocation(p_9016_.getLastDeathLocation());
    }

    @Override
    protected void onEffectAdded(MobEffectInstance p_143393_, @Nullable Entity p_143394_) {
        super.onEffectAdded(p_143393_, p_143394_);
        this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), p_143393_, true));
        if (p_143393_.is(MobEffects.LEVITATION)) {
            this.levitationStartTime = this.tickCount;
            this.levitationStartPos = this.position();
        }
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, p_143394_);
    }

    @Override
    protected void onEffectUpdated(MobEffectInstance p_143396_, boolean p_143397_, @Nullable Entity p_143398_) {
        super.onEffectUpdated(p_143396_, p_143397_, p_143398_);
        this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), p_143396_, false));
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, p_143398_);
    }

    @Override
    protected void onEffectRemoved(MobEffectInstance p_9184_) {
        super.onEffectRemoved(p_9184_);
        this.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), p_9184_.getEffect()));
        if (p_9184_.is(MobEffects.LEVITATION)) {
            this.levitationStartPos = null;
        }
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, (Entity)null);
    }

    @Override
    public void teleportTo(double p_8969_, double p_8970_, double p_8971_) {
        this.connection.teleport(p_8969_, p_8970_, p_8971_, this.getYRot(), this.getXRot(), RelativeMovement.ROTATION);
    }

    @Override
    public void teleportRelative(double p_251611_, double p_248861_, double p_252266_) {
        this.connection.teleport(this.getX() + p_251611_, this.getY() + p_248861_, this.getZ() + p_252266_, this.getYRot(), this.getXRot(), RelativeMovement.ALL);
    }

    @Override
    public boolean teleportTo(ServerLevel p_265564_, double p_265424_, double p_265680_, double p_265312_, Set<RelativeMovement> p_265192_, float p_265059_, float p_265266_) {
        ChunkPos $$7 = new ChunkPos(BlockPos.containing(p_265424_, p_265680_, p_265312_));
        p_265564_.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, $$7, 1, this.getId());
        this.stopRiding();
        if (this.isSleeping()) {
            this.stopSleepInBed(true, true);
        }
        if (p_265564_ == this.level()) {
            this.connection.teleport(p_265424_, p_265680_, p_265312_, p_265059_, p_265266_, p_265192_);
        } else {
            this.teleportTo(p_265564_, p_265424_, p_265680_, p_265312_, p_265059_, p_265266_);
        }
        this.setYHeadRot(p_265059_);
        return true;
    }

    @Override
    public void moveTo(double p_9171_, double p_9172_, double p_9173_) {
        super.moveTo(p_9171_, p_9172_, p_9173_);
        this.connection.resetPosition();
    }

    @Override
    public void crit(Entity p_9045_) {
        this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(p_9045_, 4));
    }

    @Override
    public void magicCrit(Entity p_9186_) {
        this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(p_9186_, 5));
    }

    @Override
    public void onUpdateAbilities() {
        if (this.connection == null) {
            return;
        }
        this.connection.send(new ClientboundPlayerAbilitiesPacket(this.getAbilities()));
        this.updateInvisibilityStatus();
    }

    public ServerLevel serverLevel() {
        return (ServerLevel)this.level();
    }

    public boolean setGameMode(GameType p_143404_) {
        if (!this.gameMode.changeGameModeForPlayer(p_143404_)) {
            return false;
        }
        this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.CHANGE_GAME_MODE, p_143404_.getId()));
        if (p_143404_ == GameType.SPECTATOR) {
            this.removeEntitiesOnShoulder();
            this.stopRiding();
        } else {
            this.setCamera(this);
        }
        this.onUpdateAbilities();
        this.updateEffectVisibility();
        return true;
    }

    @Override
    public boolean isSpectator() {
        return this.gameMode.getGameModeForPlayer() == GameType.SPECTATOR;
    }

    @Override
    public boolean isCreative() {
        return this.gameMode.getGameModeForPlayer() == GameType.CREATIVE;
    }

    @Override
    public void sendSystemMessage(Component p_215097_) {
        this.sendSystemMessage(p_215097_, false);
    }

    public void sendSystemMessage(Component p_240560_, boolean p_240545_) {
        if (!this.acceptsSystemMessages(p_240545_)) {
            return;
        }
        this.connection.send(new ClientboundSystemChatPacket(p_240560_, p_240545_), PacketSendListener.exceptionallySend(() -> {
            if (this.acceptsSystemMessages(false)) {
                int $$1 = 256;
                String $$2 = p_240560_.getString(256);
                MutableComponent $$3 = Component.literal($$2).withStyle(ChatFormatting.YELLOW);
                return new ClientboundSystemChatPacket(Component.translatable("multiplayer.message_not_delivered", $$3).withStyle(ChatFormatting.RED), false);
            }
            return null;
        }));
    }

    public void sendChatMessage(OutgoingChatMessage p_249852_, boolean p_250110_, ChatType.Bound p_252108_) {
        if (this.acceptsChatMessages()) {
            p_249852_.sendToPlayer(this, p_250110_, p_252108_);
        }
    }

    public String getIpAddress() {
        SocketAddress $$0 = this.connection.getRemoteAddress();
        if ($$0 instanceof InetSocketAddress) {
            InetSocketAddress $$1 = (InetSocketAddress)$$0;
            return InetAddresses.toAddrString((InetAddress)$$1.getAddress());
        }
        return "<unknown>";
    }

    public void updateOptions(ClientInformation p_301998_) {
        this.language = p_301998_.language();
        this.requestedViewDistance = p_301998_.viewDistance();
        this.chatVisibility = p_301998_.chatVisibility();
        this.canChatColor = p_301998_.chatColors();
        this.textFilteringEnabled = p_301998_.textFilteringEnabled();
        this.allowsListing = p_301998_.allowsListing();
        this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (byte)p_301998_.modelCustomisation());
        this.getEntityData().set(DATA_PLAYER_MAIN_HAND, (byte)p_301998_.mainHand().getId());
    }

    public ClientInformation clientInformation() {
        byte $$0 = (Byte)this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION);
        HumanoidArm $$1 = HumanoidArm.BY_ID.apply(((Byte)this.getEntityData().get(DATA_PLAYER_MAIN_HAND)).byteValue());
        return new ClientInformation(this.language, this.requestedViewDistance, this.chatVisibility, this.canChatColor, $$0, $$1, this.textFilteringEnabled, this.allowsListing);
    }

    public boolean canChatInColor() {
        return this.canChatColor;
    }

    public ChatVisiblity getChatVisibility() {
        return this.chatVisibility;
    }

    private boolean acceptsSystemMessages(boolean p_240568_) {
        if (this.chatVisibility == ChatVisiblity.HIDDEN) {
            return p_240568_;
        }
        return true;
    }

    private boolean acceptsChatMessages() {
        return this.chatVisibility == ChatVisiblity.FULL;
    }

    public int requestedViewDistance() {
        return this.requestedViewDistance;
    }

    public void sendServerStatus(ServerStatus p_215110_) {
        this.connection.send(new ClientboundServerDataPacket(p_215110_.description(), p_215110_.favicon().map(ServerStatus.Favicon::iconBytes)));
    }

    @Override
    protected int getPermissionLevel() {
        return this.server.getProfilePermissions(this.getGameProfile());
    }

    public void resetLastActionTime() {
        this.lastActionTime = Util.getMillis();
    }

    public ServerStatsCounter getStats() {
        return this.stats;
    }

    public ServerRecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    @Override
    protected void updateInvisibilityStatus() {
        if (this.isSpectator()) {
            this.removeEffectParticles();
            this.setInvisible(true);
        } else {
            super.updateInvisibilityStatus();
        }
    }

    public Entity getCamera() {
        return this.camera == null ? this : this.camera;
    }

    public void setCamera(@Nullable Entity p_9214_) {
        Entity $$1 = this.getCamera();
        Entity entity = this.camera = p_9214_ == null ? this : p_9214_;
        if ($$1 != this.camera) {
            Level level = this.camera.level();
            if (level instanceof ServerLevel) {
                ServerLevel $$2 = (ServerLevel)level;
                this.teleportTo($$2, this.camera.getX(), this.camera.getY(), this.camera.getZ(), Set.of(), this.getYRot(), this.getXRot());
            }
            if (p_9214_ != null) {
                this.serverLevel().getChunkSource().move(this);
            }
            this.connection.send(new ClientboundSetCameraPacket(this.camera));
            this.connection.resetPosition();
        }
    }

    @Override
    protected void processPortalCooldown() {
        if (!this.isChangingDimension) {
            super.processPortalCooldown();
        }
    }

    @Override
    public void attack(Entity p_9220_) {
        if (this.gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
            this.setCamera(p_9220_);
        } else {
            super.attack(p_9220_);
        }
    }

    public long getLastActionTime() {
        return this.lastActionTime;
    }

    @Nullable
    public Component getTabListDisplayName() {
        return null;
    }

    @Override
    public void swing(InteractionHand p_9031_) {
        super.swing(p_9031_);
        this.resetAttackStrengthTicker();
    }

    public boolean isChangingDimension() {
        return this.isChangingDimension;
    }

    public void hasChangedDimension() {
        this.isChangingDimension = false;
    }

    public PlayerAdvancements getAdvancements() {
        return this.advancements;
    }

    public void teleportTo(ServerLevel p_9000_, double p_9001_, double p_9002_, double p_9003_, float p_9004_, float p_9005_) {
        this.setCamera(this);
        this.stopRiding();
        if (p_9000_ == this.level()) {
            this.connection.teleport(p_9001_, p_9002_, p_9003_, p_9004_, p_9005_);
        } else {
            ServerLevel $$6 = this.serverLevel();
            LevelData $$7 = p_9000_.getLevelData();
            this.connection.send(new ClientboundRespawnPacket(this.createCommonSpawnInfo(p_9000_), 3));
            this.connection.send(new ClientboundChangeDifficultyPacket($$7.getDifficulty(), $$7.isDifficultyLocked()));
            this.server.getPlayerList().sendPlayerPermissionLevel(this);
            $$6.removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
            this.unsetRemoved();
            this.moveTo(p_9001_, p_9002_, p_9003_, p_9004_, p_9005_);
            this.setServerLevel(p_9000_);
            p_9000_.addDuringCommandTeleport(this);
            this.triggerDimensionChangeTriggers($$6);
            this.connection.teleport(p_9001_, p_9002_, p_9003_, p_9004_, p_9005_);
            this.server.getPlayerList().sendLevelInfo(this, p_9000_);
            this.server.getPlayerList().sendAllPlayerInfo(this);
        }
    }

    @Nullable
    public BlockPos getRespawnPosition() {
        return this.respawnPosition;
    }

    public float getRespawnAngle() {
        return this.respawnAngle;
    }

    public ResourceKey<Level> getRespawnDimension() {
        return this.respawnDimension;
    }

    public boolean isRespawnForced() {
        return this.respawnForced;
    }

    public void setRespawnPosition(ResourceKey<Level> p_9159_, @Nullable BlockPos p_9160_, float p_9161_, boolean p_9162_, boolean p_9163_) {
        if (p_9160_ != null) {
            boolean $$5;
            boolean bl = $$5 = p_9160_.equals(this.respawnPosition) && p_9159_.equals(this.respawnDimension);
            if (p_9163_ && !$$5) {
                this.sendSystemMessage(Component.translatable("block.minecraft.set_spawn"));
            }
            this.respawnPosition = p_9160_;
            this.respawnDimension = p_9159_;
            this.respawnAngle = p_9161_;
            this.respawnForced = p_9162_;
        } else {
            this.respawnPosition = null;
            this.respawnDimension = Level.OVERWORLD;
            this.respawnAngle = 0.0f;
            this.respawnForced = false;
        }
    }

    public SectionPos getLastSectionPos() {
        return this.lastSectionPos;
    }

    public void setLastSectionPos(SectionPos p_9120_) {
        this.lastSectionPos = p_9120_;
    }

    public ChunkTrackingView getChunkTrackingView() {
        return this.chunkTrackingView;
    }

    public void setChunkTrackingView(ChunkTrackingView p_296310_) {
        this.chunkTrackingView = p_296310_;
    }

    @Override
    public void playNotifySound(SoundEvent p_9019_, SoundSource p_9020_, float p_9021_, float p_9022_) {
        this.connection.send(new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(p_9019_), p_9020_, this.getX(), this.getY(), this.getZ(), p_9021_, p_9022_, this.random.nextLong()));
    }

    @Override
    public ItemEntity drop(ItemStack p_9085_, boolean p_9086_, boolean p_9087_) {
        ItemEntity $$3 = super.drop(p_9085_, p_9086_, p_9087_);
        if ($$3 == null) {
            return null;
        }
        this.level().addFreshEntity($$3);
        ItemStack $$4 = $$3.getItem();
        if (p_9087_) {
            if (!$$4.isEmpty()) {
                this.awardStat(Stats.ITEM_DROPPED.get($$4.getItem()), p_9085_.getCount());
            }
            this.awardStat(Stats.DROP);
        }
        return $$3;
    }

    public TextFilter getTextFilter() {
        return this.textFilter;
    }

    public void setServerLevel(ServerLevel p_284971_) {
        this.setLevel(p_284971_);
        this.gameMode.setLevel(p_284971_);
    }

    @Nullable
    private static GameType readPlayerMode(@Nullable CompoundTag p_143414_, String p_143415_) {
        return p_143414_ != null && p_143414_.contains(p_143415_, 99) ? GameType.byId(p_143414_.getInt(p_143415_)) : null;
    }

    private GameType calculateGameModeForNewPlayer(@Nullable GameType p_143424_) {
        GameType $$1 = this.server.getForcedGameType();
        if ($$1 != null) {
            return $$1;
        }
        return p_143424_ != null ? p_143424_ : this.server.getDefaultGameType();
    }

    public void loadGameTypes(@Nullable CompoundTag p_143428_) {
        this.gameMode.setGameModeForPlayer(this.calculateGameModeForNewPlayer(ServerPlayer.readPlayerMode(p_143428_, "playerGameType")), ServerPlayer.readPlayerMode(p_143428_, "previousPlayerGameType"));
    }

    private void storeGameTypes(CompoundTag p_143431_) {
        p_143431_.putInt("playerGameType", this.gameMode.getGameModeForPlayer().getId());
        GameType $$1 = this.gameMode.getPreviousGameModeForPlayer();
        if ($$1 != null) {
            p_143431_.putInt("previousPlayerGameType", $$1.getId());
        }
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean shouldFilterMessageTo(ServerPlayer p_143422_) {
        if (p_143422_ == this) {
            return false;
        }
        return this.textFilteringEnabled || p_143422_.textFilteringEnabled;
    }

    @Override
    public boolean mayInteract(Level p_143406_, BlockPos p_143407_) {
        return super.mayInteract(p_143406_, p_143407_) && p_143406_.mayInteract(this, p_143407_);
    }

    @Override
    protected void updateUsingItem(ItemStack p_143402_) {
        CriteriaTriggers.USING_ITEM.trigger(this, p_143402_);
        super.updateUsingItem(p_143402_);
    }

    public boolean drop(boolean p_182295_) {
        Inventory $$1 = this.getInventory();
        ItemStack $$2 = $$1.removeFromSelected(p_182295_);
        this.containerMenu.findSlot($$1, $$1.selected).ifPresent(p_287377_ -> this.containerMenu.setRemoteSlot(p_287377_, $$1.getSelected()));
        return this.drop($$2, false, true) != null;
    }

    public boolean allowsListing() {
        return this.allowsListing;
    }

    @Override
    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.of(this.wardenSpawnTracker);
    }

    public void setSpawnExtraParticlesOnFall(boolean p_334029_) {
        this.spawnExtraParticlesOnFall = p_334029_;
    }

    @Override
    public void onItemPickup(ItemEntity p_215095_) {
        super.onItemPickup(p_215095_);
        Entity $$1 = p_215095_.getOwner();
        if ($$1 != null) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_PLAYER.trigger(this, p_215095_.getItem(), $$1);
        }
    }

    public void setChatSession(RemoteChatSession p_254468_) {
        this.chatSession = p_254468_;
    }

    @Nullable
    public RemoteChatSession getChatSession() {
        if (this.chatSession != null && this.chatSession.hasExpired()) {
            return null;
        }
        return this.chatSession;
    }

    @Override
    public void indicateDamage(double p_270621_, double p_270478_) {
        this.hurtDir = (float)(Mth.atan2(p_270478_, p_270621_) * 57.2957763671875 - (double)this.getYRot());
        this.connection.send(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean startRiding(Entity p_277395_, boolean p_278062_) {
        if (super.startRiding(p_277395_, p_278062_)) {
            p_277395_.positionRider(this);
            this.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            if (p_277395_ instanceof LivingEntity) {
                LivingEntity $$2 = (LivingEntity)p_277395_;
                for (MobEffectInstance $$3 : $$2.getActiveEffects()) {
                    this.connection.send(new ClientboundUpdateMobEffectPacket(p_277395_.getId(), $$3, false));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void stopRiding() {
        Entity $$0 = this.getVehicle();
        super.stopRiding();
        if ($$0 instanceof LivingEntity) {
            LivingEntity $$1 = (LivingEntity)$$0;
            for (MobEffectInstance $$2 : $$1.getActiveEffects()) {
                this.connection.send(new ClientboundRemoveMobEffectPacket($$0.getId(), $$2.getEffect()));
            }
        }
    }

    public CommonPlayerSpawnInfo createCommonSpawnInfo(ServerLevel p_294169_) {
        return new CommonPlayerSpawnInfo(p_294169_.dimensionTypeRegistration(), p_294169_.dimension(), BiomeManager.obfuscateSeed(p_294169_.getSeed()), this.gameMode.getGameModeForPlayer(), this.gameMode.getPreviousGameModeForPlayer(), p_294169_.isDebug(), p_294169_.isFlat(), this.getLastDeathLocation(), this.getPortalCooldown());
    }

    public void setRaidOmenPosition(BlockPos p_338782_) {
        this.raidOmenPosition = p_338782_;
    }

    public void clearRaidOmenPosition() {
        this.raidOmenPosition = null;
    }

    @Nullable
    public BlockPos getRaidOmenPosition() {
        return this.raidOmenPosition;
    }
}

