/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.FutureChain;
import net.minecraft.util.Mth;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class ServerGamePacketListenerImpl
extends ServerCommonPacketListenerImpl
implements ServerGamePacketListener,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_BLOCK_UPDATES_TO_ACK = -1;
    private static final int TRACKED_MESSAGE_DISCONNECT_THRESHOLD = 4096;
    private static final int MAXIMUM_FLYING_TICKS = 80;
    private static final Component CHAT_VALIDATION_FAILED = Component.translatable("multiplayer.disconnect.chat_validation_failed");
    private static final Component INVALID_COMMAND_SIGNATURE = Component.translatable("chat.disabled.invalid_command_signature").withStyle(ChatFormatting.RED);
    private static final int MAX_COMMAND_SUGGESTIONS = 1000;
    public ServerPlayer player;
    public final PlayerChunkSender chunkSender;
    private int tickCount;
    private int ackBlockChangesUpTo = -1;
    private int chatSpamTickCount;
    private int dropSpamTickCount;
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    @Nullable
    private Entity lastVehicle;
    private double vehicleFirstGoodX;
    private double vehicleFirstGoodY;
    private double vehicleFirstGoodZ;
    private double vehicleLastGoodX;
    private double vehicleLastGoodY;
    private double vehicleLastGoodZ;
    @Nullable
    private Vec3 awaitingPositionFromClient;
    private int awaitingTeleport;
    private int awaitingTeleportTime;
    private boolean clientIsFloating;
    private int aboveGroundTickCount;
    private boolean clientVehicleIsFloating;
    private int aboveGroundVehicleTickCount;
    private int receivedMovePacketCount;
    private int knownMovePacketCount;
    @Nullable
    private RemoteChatSession chatSession;
    private SignedMessageChain.Decoder signedMessageDecoder;
    private final LastSeenMessagesValidator lastSeenMessages = new LastSeenMessagesValidator(20);
    private final MessageSignatureCache messageSignatureCache = MessageSignatureCache.createDefault();
    private final FutureChain chatMessageChain;
    private boolean waitingForSwitchToConfig;

    public ServerGamePacketListenerImpl(MinecraftServer p_9770_, Connection p_9771_, ServerPlayer p_9772_, CommonListenerCookie p_301978_) {
        super(p_9770_, p_9771_, p_301978_);
        this.chunkSender = new PlayerChunkSender(p_9771_.isMemoryConnection());
        this.player = p_9772_;
        p_9772_.connection = this;
        p_9772_.getTextFilter().join();
        this.signedMessageDecoder = SignedMessageChain.Decoder.unsigned(p_9772_.getUUID(), p_9770_::enforceSecureProfile);
        this.chatMessageChain = new FutureChain(p_9770_);
    }

    @Override
    public void tick() {
        if (this.ackBlockChangesUpTo > -1) {
            this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
            this.ackBlockChangesUpTo = -1;
        }
        this.resetPosition();
        this.player.xo = this.player.getX();
        this.player.yo = this.player.getY();
        this.player.zo = this.player.getZ();
        this.player.doTick();
        this.player.absMoveTo(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.player.getYRot(), this.player.getXRot());
        ++this.tickCount;
        this.knownMovePacketCount = this.receivedMovePacketCount;
        if (this.clientIsFloating && !this.player.isSleeping() && !this.player.isPassenger() && !this.player.isDeadOrDying()) {
            if (++this.aboveGroundTickCount > this.getMaximumFlyingTicks(this.player)) {
                LOGGER.warn("{} was kicked for floating too long!", (Object)this.player.getName().getString());
                this.disconnect(Component.translatable("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.clientIsFloating = false;
            this.aboveGroundTickCount = 0;
        }
        this.lastVehicle = this.player.getRootVehicle();
        if (this.lastVehicle == this.player || this.lastVehicle.getControllingPassenger() != this.player) {
            this.lastVehicle = null;
            this.clientVehicleIsFloating = false;
            this.aboveGroundVehicleTickCount = 0;
        } else {
            this.vehicleFirstGoodX = this.lastVehicle.getX();
            this.vehicleFirstGoodY = this.lastVehicle.getY();
            this.vehicleFirstGoodZ = this.lastVehicle.getZ();
            this.vehicleLastGoodX = this.lastVehicle.getX();
            this.vehicleLastGoodY = this.lastVehicle.getY();
            this.vehicleLastGoodZ = this.lastVehicle.getZ();
            if (this.clientVehicleIsFloating && this.lastVehicle.getControllingPassenger() == this.player) {
                if (++this.aboveGroundVehicleTickCount > this.getMaximumFlyingTicks(this.lastVehicle)) {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)this.player.getName().getString());
                    this.disconnect(Component.translatable("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.clientVehicleIsFloating = false;
                this.aboveGroundVehicleTickCount = 0;
            }
        }
        this.keepConnectionAlive();
        if (this.chatSpamTickCount > 0) {
            --this.chatSpamTickCount;
        }
        if (this.dropSpamTickCount > 0) {
            --this.dropSpamTickCount;
        }
        if (this.player.getLastActionTime() > 0L && this.server.getPlayerIdleTimeout() > 0 && Util.getMillis() - this.player.getLastActionTime() > (long)this.server.getPlayerIdleTimeout() * 1000L * 60L) {
            this.disconnect(Component.translatable("multiplayer.disconnect.idling"));
        }
    }

    private int getMaximumFlyingTicks(Entity p_326388_) {
        double $$1 = p_326388_.getGravity();
        if ($$1 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double $$2 = 0.08 / $$1;
        return Mth.ceil(80.0 * Math.max($$2, 1.0));
    }

    public void resetPosition() {
        this.firstGoodX = this.player.getX();
        this.firstGoodY = this.player.getY();
        this.firstGoodZ = this.player.getZ();
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected() && !this.waitingForSwitchToConfig;
    }

    @Override
    public boolean shouldHandleMessage(Packet<?> p_295183_) {
        if (super.shouldHandleMessage(p_295183_)) {
            return true;
        }
        return this.waitingForSwitchToConfig && this.connection.isConnected() && p_295183_ instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile playerProfile() {
        return this.player.getGameProfile();
    }

    private <T, R> CompletableFuture<R> filterTextPacket(T p_243240_, BiFunction<TextFilter, T, CompletableFuture<R>> p_243271_) {
        return p_243271_.apply(this.player.getTextFilter(), (TextFilter)p_243240_).thenApply(p_264862_ -> {
            if (!this.isAcceptingMessages()) {
                LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return p_264862_;
        });
    }

    private CompletableFuture<FilteredText> filterTextPacket(String p_243213_) {
        return this.filterTextPacket(p_243213_, TextFilter::processStreamMessage);
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(List<String> p_243258_) {
        return this.filterTextPacket(p_243258_, TextFilter::processMessageBundle);
    }

    @Override
    public void handlePlayerInput(ServerboundPlayerInputPacket p_9893_) {
        PacketUtils.ensureRunningOnSameThread(p_9893_, this, this.player.serverLevel());
        this.player.setPlayerInput(p_9893_.getXxa(), p_9893_.getZza(), p_9893_.isJumping(), p_9893_.isShiftKeyDown());
    }

    private static boolean containsInvalidValues(double p_143664_, double p_143665_, double p_143666_, float p_143667_, float p_143668_) {
        return Double.isNaN(p_143664_) || Double.isNaN(p_143665_) || Double.isNaN(p_143666_) || !Floats.isFinite((float)p_143668_) || !Floats.isFinite((float)p_143667_);
    }

    private static double clampHorizontal(double p_143610_) {
        return Mth.clamp(p_143610_, -3.0E7, 3.0E7);
    }

    private static double clampVertical(double p_143654_) {
        return Mth.clamp(p_143654_, -2.0E7, 2.0E7);
    }

    @Override
    public void handleMoveVehicle(ServerboundMoveVehiclePacket p_9876_) {
        PacketUtils.ensureRunningOnSameThread(p_9876_, this, this.player.serverLevel());
        if (ServerGamePacketListenerImpl.containsInvalidValues(p_9876_.getX(), p_9876_.getY(), p_9876_.getZ(), p_9876_.getYRot(), p_9876_.getXRot())) {
            this.disconnect(Component.translatable("multiplayer.disconnect.invalid_vehicle_movement"));
            return;
        }
        Entity $$1 = this.player.getRootVehicle();
        if ($$1 != this.player && $$1.getControllingPassenger() == this.player && $$1 == this.lastVehicle) {
            LivingEntity $$18;
            ServerLevel $$2 = this.player.serverLevel();
            double $$3 = $$1.getX();
            double $$4 = $$1.getY();
            double $$5 = $$1.getZ();
            double $$6 = ServerGamePacketListenerImpl.clampHorizontal(p_9876_.getX());
            double $$7 = ServerGamePacketListenerImpl.clampVertical(p_9876_.getY());
            double $$8 = ServerGamePacketListenerImpl.clampHorizontal(p_9876_.getZ());
            float $$9 = Mth.wrapDegrees(p_9876_.getYRot());
            float $$10 = Mth.wrapDegrees(p_9876_.getXRot());
            double $$11 = $$6 - this.vehicleFirstGoodX;
            double $$12 = $$7 - this.vehicleFirstGoodY;
            double $$13 = $$8 - this.vehicleFirstGoodZ;
            double $$15 = $$11 * $$11 + $$12 * $$12 + $$13 * $$13;
            double $$14 = $$1.getDeltaMovement().lengthSqr();
            if ($$15 - $$14 > 100.0 && !this.isSingleplayerOwner()) {
                LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{$$1.getName().getString(), this.player.getName().getString(), $$11, $$12, $$13});
                this.send(new ClientboundMoveVehiclePacket($$1));
                return;
            }
            boolean $$16 = $$2.noCollision($$1, $$1.getBoundingBox().deflate(0.0625));
            $$11 = $$6 - this.vehicleLastGoodX;
            $$12 = $$7 - this.vehicleLastGoodY - 1.0E-6;
            $$13 = $$8 - this.vehicleLastGoodZ;
            boolean $$17 = $$1.verticalCollisionBelow;
            if ($$1 instanceof LivingEntity && ($$18 = (LivingEntity)$$1).onClimbable()) {
                $$18.resetFallDistance();
            }
            $$1.move(MoverType.PLAYER, new Vec3($$11, $$12, $$13));
            double $$19 = $$12;
            $$11 = $$6 - $$1.getX();
            $$12 = $$7 - $$1.getY();
            if ($$12 > -0.5 || $$12 < 0.5) {
                $$12 = 0.0;
            }
            $$13 = $$8 - $$1.getZ();
            $$15 = $$11 * $$11 + $$12 * $$12 + $$13 * $$13;
            boolean $$20 = false;
            if ($$15 > 0.0625) {
                $$20 = true;
                LOGGER.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{$$1.getName().getString(), this.player.getName().getString(), Math.sqrt($$15)});
            }
            $$1.absMoveTo($$6, $$7, $$8, $$9, $$10);
            boolean $$21 = $$2.noCollision($$1, $$1.getBoundingBox().deflate(0.0625));
            if ($$16 && ($$20 || !$$21)) {
                $$1.absMoveTo($$3, $$4, $$5, $$9, $$10);
                this.send(new ClientboundMoveVehiclePacket($$1));
                return;
            }
            this.player.serverLevel().getChunkSource().move(this.player);
            this.player.checkMovementStatistics(this.player.getX() - $$3, this.player.getY() - $$4, this.player.getZ() - $$5);
            this.clientVehicleIsFloating = $$19 >= -0.03125 && !$$17 && !this.server.isFlightAllowed() && !$$1.isNoGravity() && this.noBlocksAround($$1);
            this.vehicleLastGoodX = $$1.getX();
            this.vehicleLastGoodY = $$1.getY();
            this.vehicleLastGoodZ = $$1.getZ();
        }
    }

    private boolean noBlocksAround(Entity p_9794_) {
        return p_9794_.level().getBlockStates(p_9794_.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0)).allMatch(BlockBehaviour.BlockStateBase::isAir);
    }

    @Override
    public void handleAcceptTeleportPacket(ServerboundAcceptTeleportationPacket p_9835_) {
        PacketUtils.ensureRunningOnSameThread(p_9835_, this, this.player.serverLevel());
        if (p_9835_.getId() == this.awaitingTeleport) {
            if (this.awaitingPositionFromClient == null) {
                this.disconnect(Component.translatable("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.player.absMoveTo(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            this.lastGoodX = this.awaitingPositionFromClient.x;
            this.lastGoodY = this.awaitingPositionFromClient.y;
            this.lastGoodZ = this.awaitingPositionFromClient.z;
            if (this.player.isChangingDimension()) {
                this.player.hasChangedDimension();
            }
            this.awaitingPositionFromClient = null;
        }
    }

    @Override
    public void handleRecipeBookSeenRecipePacket(ServerboundRecipeBookSeenRecipePacket p_9897_) {
        PacketUtils.ensureRunningOnSameThread(p_9897_, this, this.player.serverLevel());
        this.server.getRecipeManager().byKey(p_9897_.getRecipe()).ifPresent(this.player.getRecipeBook()::removeHighlight);
    }

    @Override
    public void handleRecipeBookChangeSettingsPacket(ServerboundRecipeBookChangeSettingsPacket p_9895_) {
        PacketUtils.ensureRunningOnSameThread(p_9895_, this, this.player.serverLevel());
        this.player.getRecipeBook().setBookSetting(p_9895_.getBookType(), p_9895_.isOpen(), p_9895_.isFiltering());
    }

    @Override
    public void handleSeenAdvancements(ServerboundSeenAdvancementsPacket p_9903_) {
        PacketUtils.ensureRunningOnSameThread(p_9903_, this, this.player.serverLevel());
        if (p_9903_.getAction() == ServerboundSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation $$1 = Objects.requireNonNull(p_9903_.getTab());
            AdvancementHolder $$2 = this.server.getAdvancements().get($$1);
            if ($$2 != null) {
                this.player.getAdvancements().setSelectedTab($$2);
            }
        }
    }

    @Override
    public void handleCustomCommandSuggestions(ServerboundCommandSuggestionPacket p_9847_) {
        PacketUtils.ensureRunningOnSameThread(p_9847_, this, this.player.serverLevel());
        StringReader $$1 = new StringReader(p_9847_.getCommand());
        if ($$1.canRead() && $$1.peek() == '/') {
            $$1.skip();
        }
        ParseResults $$2 = this.server.getCommands().getDispatcher().parse($$1, (Object)this.player.createCommandSourceStack());
        this.server.getCommands().getDispatcher().getCompletionSuggestions($$2).thenAccept(p_333513_ -> {
            Suggestions $$2 = p_333513_.getList().size() <= 1000 ? p_333513_ : new Suggestions(p_333513_.getRange(), p_333513_.getList().subList(0, 1000));
            this.send(new ClientboundCommandSuggestionsPacket(p_9847_.getId(), $$2));
        });
    }

    @Override
    public void handleSetCommandBlock(ServerboundSetCommandBlockPacket p_9911_) {
        PacketUtils.ensureRunningOnSameThread(p_9911_, this, this.player.serverLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(Component.translatable("advMode.notEnabled"));
            return;
        }
        if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(Component.translatable("advMode.notAllowed"));
            return;
        }
        BaseCommandBlock $$1 = null;
        CommandBlockEntity $$2 = null;
        BlockPos $$3 = p_9911_.getPos();
        BlockEntity $$4 = this.player.level().getBlockEntity($$3);
        if ($$4 instanceof CommandBlockEntity) {
            $$2 = (CommandBlockEntity)$$4;
            $$1 = $$2.getCommandBlock();
        }
        String $$5 = p_9911_.getCommand();
        boolean $$6 = p_9911_.isTrackOutput();
        if ($$1 != null) {
            CommandBlockEntity.Mode $$7 = $$2.getMode();
            BlockState $$8 = this.player.level().getBlockState($$3);
            Direction $$9 = $$8.getValue(CommandBlock.FACING);
            BlockState $$10 = switch (p_9911_.getMode()) {
                case CommandBlockEntity.Mode.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                case CommandBlockEntity.Mode.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                default -> Blocks.COMMAND_BLOCK.defaultBlockState();
            };
            BlockState $$11 = (BlockState)((BlockState)$$10.setValue(CommandBlock.FACING, $$9)).setValue(CommandBlock.CONDITIONAL, p_9911_.isConditional());
            if ($$11 != $$8) {
                this.player.level().setBlock($$3, $$11, 2);
                $$4.setBlockState($$11);
                this.player.level().getChunkAt($$3).setBlockEntity($$4);
            }
            $$1.setCommand($$5);
            $$1.setTrackOutput($$6);
            if (!$$6) {
                $$1.setLastOutput(null);
            }
            $$2.setAutomatic(p_9911_.isAutomatic());
            if ($$7 != p_9911_.getMode()) {
                $$2.onModeSwitch();
            }
            $$1.onUpdated();
            if (!StringUtil.isNullOrEmpty($$5)) {
                this.player.sendSystemMessage(Component.translatable("advMode.setCommand.success", $$5));
            }
        }
    }

    @Override
    public void handleSetCommandMinecart(ServerboundSetCommandMinecartPacket p_9913_) {
        PacketUtils.ensureRunningOnSameThread(p_9913_, this, this.player.serverLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(Component.translatable("advMode.notEnabled"));
            return;
        }
        if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(Component.translatable("advMode.notAllowed"));
            return;
        }
        BaseCommandBlock $$1 = p_9913_.getCommandBlock(this.player.level());
        if ($$1 != null) {
            $$1.setCommand(p_9913_.getCommand());
            $$1.setTrackOutput(p_9913_.isTrackOutput());
            if (!p_9913_.isTrackOutput()) {
                $$1.setLastOutput(null);
            }
            $$1.onUpdated();
            this.player.sendSystemMessage(Component.translatable("advMode.setCommand.success", p_9913_.getCommand()));
        }
    }

    @Override
    public void handlePickItem(ServerboundPickItemPacket p_9880_) {
        PacketUtils.ensureRunningOnSameThread(p_9880_, this, this.player.serverLevel());
        this.player.getInventory().pickSlot(p_9880_.getSlot());
        this.player.connection.send(new ClientboundContainerSetSlotPacket(-2, 0, this.player.getInventory().selected, this.player.getInventory().getItem(this.player.getInventory().selected)));
        this.player.connection.send(new ClientboundContainerSetSlotPacket(-2, 0, p_9880_.getSlot(), this.player.getInventory().getItem(p_9880_.getSlot())));
        this.player.connection.send(new ClientboundSetCarriedItemPacket(this.player.getInventory().selected));
    }

    @Override
    public void handleRenameItem(ServerboundRenameItemPacket p_9899_) {
        PacketUtils.ensureRunningOnSameThread(p_9899_, this, this.player.serverLevel());
        AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
        if (abstractContainerMenu instanceof AnvilMenu) {
            AnvilMenu $$1 = (AnvilMenu)abstractContainerMenu;
            if (!$$1.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)$$1);
                return;
            }
            $$1.setItemName(p_9899_.getName());
        }
    }

    @Override
    public void handleSetBeaconPacket(ServerboundSetBeaconPacket p_9907_) {
        PacketUtils.ensureRunningOnSameThread(p_9907_, this, this.player.serverLevel());
        AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
        if (abstractContainerMenu instanceof BeaconMenu) {
            BeaconMenu $$1 = (BeaconMenu)abstractContainerMenu;
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
                return;
            }
            $$1.updateEffects(p_9907_.primary(), p_9907_.secondary());
        }
    }

    @Override
    public void handleSetStructureBlock(ServerboundSetStructureBlockPacket p_9919_) {
        PacketUtils.ensureRunningOnSameThread(p_9919_, this, this.player.serverLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPos $$1 = p_9919_.getPos();
        BlockState $$2 = this.player.level().getBlockState($$1);
        BlockEntity $$3 = this.player.level().getBlockEntity($$1);
        if ($$3 instanceof StructureBlockEntity) {
            StructureBlockEntity $$4 = (StructureBlockEntity)$$3;
            $$4.setMode(p_9919_.getMode());
            $$4.setStructureName(p_9919_.getName());
            $$4.setStructurePos(p_9919_.getOffset());
            $$4.setStructureSize(p_9919_.getSize());
            $$4.setMirror(p_9919_.getMirror());
            $$4.setRotation(p_9919_.getRotation());
            $$4.setMetaData(p_9919_.getData());
            $$4.setIgnoreEntities(p_9919_.isIgnoreEntities());
            $$4.setShowAir(p_9919_.isShowAir());
            $$4.setShowBoundingBox(p_9919_.isShowBoundingBox());
            $$4.setIntegrity(p_9919_.getIntegrity());
            $$4.setSeed(p_9919_.getSeed());
            if ($$4.hasStructureName()) {
                String $$5 = $$4.getStructureName();
                if (p_9919_.getUpdateType() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                    if ($$4.saveStructure()) {
                        this.player.displayClientMessage(Component.translatable("structure_block.save_success", $$5), false);
                    } else {
                        this.player.displayClientMessage(Component.translatable("structure_block.save_failure", $$5), false);
                    }
                } else if (p_9919_.getUpdateType() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                    if (!$$4.isStructureLoadable()) {
                        this.player.displayClientMessage(Component.translatable("structure_block.load_not_found", $$5), false);
                    } else if ($$4.placeStructureIfSameSize(this.player.serverLevel())) {
                        this.player.displayClientMessage(Component.translatable("structure_block.load_success", $$5), false);
                    } else {
                        this.player.displayClientMessage(Component.translatable("structure_block.load_prepare", $$5), false);
                    }
                } else if (p_9919_.getUpdateType() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                    if ($$4.detectSize()) {
                        this.player.displayClientMessage(Component.translatable("structure_block.size_success", $$5), false);
                    } else {
                        this.player.displayClientMessage(Component.translatable("structure_block.size_failure"), false);
                    }
                }
            } else {
                this.player.displayClientMessage(Component.translatable("structure_block.invalid_structure_name", p_9919_.getName()), false);
            }
            $$4.setChanged();
            this.player.level().sendBlockUpdated($$1, $$2, $$2, 3);
        }
    }

    @Override
    public void handleSetJigsawBlock(ServerboundSetJigsawBlockPacket p_9917_) {
        PacketUtils.ensureRunningOnSameThread(p_9917_, this, this.player.serverLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPos $$1 = p_9917_.getPos();
        BlockState $$2 = this.player.level().getBlockState($$1);
        BlockEntity $$3 = this.player.level().getBlockEntity($$1);
        if ($$3 instanceof JigsawBlockEntity) {
            JigsawBlockEntity $$4 = (JigsawBlockEntity)$$3;
            $$4.setName(p_9917_.getName());
            $$4.setTarget(p_9917_.getTarget());
            $$4.setPool(ResourceKey.create(Registries.TEMPLATE_POOL, p_9917_.getPool()));
            $$4.setFinalState(p_9917_.getFinalState());
            $$4.setJoint(p_9917_.getJoint());
            $$4.setPlacementPriority(p_9917_.getPlacementPriority());
            $$4.setSelectionPriority(p_9917_.getSelectionPriority());
            $$4.setChanged();
            this.player.level().sendBlockUpdated($$1, $$2, $$2, 3);
        }
    }

    @Override
    public void handleJigsawGenerate(ServerboundJigsawGeneratePacket p_9868_) {
        PacketUtils.ensureRunningOnSameThread(p_9868_, this, this.player.serverLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPos $$1 = p_9868_.getPos();
        BlockEntity $$2 = this.player.level().getBlockEntity($$1);
        if ($$2 instanceof JigsawBlockEntity) {
            JigsawBlockEntity $$3 = (JigsawBlockEntity)$$2;
            $$3.generate(this.player.serverLevel(), p_9868_.levels(), p_9868_.keepJigsaws());
        }
    }

    @Override
    public void handleSelectTrade(ServerboundSelectTradePacket p_9905_) {
        PacketUtils.ensureRunningOnSameThread(p_9905_, this, this.player.serverLevel());
        int $$1 = p_9905_.getItem();
        AbstractContainerMenu abstractContainerMenu = this.player.containerMenu;
        if (abstractContainerMenu instanceof MerchantMenu) {
            MerchantMenu $$2 = (MerchantMenu)abstractContainerMenu;
            if (!$$2.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)$$2);
                return;
            }
            $$2.setSelectionHint($$1);
            $$2.tryMoveItems($$1);
        }
    }

    @Override
    public void handleEditBook(ServerboundEditBookPacket p_9862_) {
        int $$1 = p_9862_.slot();
        if (!Inventory.isHotbarSlot($$1) && $$1 != 40) {
            return;
        }
        ArrayList $$2 = Lists.newArrayList();
        Optional<String> $$3 = p_9862_.title();
        $$3.ifPresent($$2::add);
        p_9862_.pages().stream().limit(100L).forEach($$2::add);
        Consumer<List> $$4 = $$3.isPresent() ? p_238198_ -> this.signBook((FilteredText)p_238198_.get(0), p_238198_.subList(1, p_238198_.size()), $$1) : p_143627_ -> this.updateBookContents((List<FilteredText>)p_143627_, $$1);
        this.filterTextPacket($$2).thenAcceptAsync($$4, (Executor)this.server);
    }

    private void updateBookContents(List<FilteredText> p_9813_, int p_9814_) {
        ItemStack $$2 = this.player.getInventory().getItem(p_9814_);
        if (!$$2.is(Items.WRITABLE_BOOK)) {
            return;
        }
        List<Filterable<String>> $$3 = p_9813_.stream().map(this::filterableFromOutgoing).toList();
        $$2.set(DataComponents.WRITABLE_BOOK_CONTENT, new WritableBookContent($$3));
    }

    private void signBook(FilteredText p_215209_, List<FilteredText> p_215210_, int p_215211_) {
        ItemStack $$3 = this.player.getInventory().getItem(p_215211_);
        if (!$$3.is(Items.WRITABLE_BOOK)) {
            return;
        }
        ItemStack $$4 = $$3.transmuteCopy(Items.WRITTEN_BOOK, 1);
        $$4.remove(DataComponents.WRITABLE_BOOK_CONTENT);
        List<Filterable<Component>> $$5 = p_215210_.stream().map(p_329965_ -> this.filterableFromOutgoing((FilteredText)p_329965_).map(Component::literal)).toList();
        $$4.set(DataComponents.WRITTEN_BOOK_CONTENT, new WrittenBookContent(this.filterableFromOutgoing(p_215209_), this.player.getName().getString(), 0, $$5, true));
        this.player.getInventory().setItem(p_215211_, $$4);
    }

    private Filterable<String> filterableFromOutgoing(FilteredText p_332041_) {
        if (this.player.isTextFilteringEnabled()) {
            return Filterable.passThrough(p_332041_.filteredOrEmpty());
        }
        return Filterable.from(p_332041_);
    }

    @Override
    public void handleEntityTagQuery(ServerboundEntityTagQueryPacket p_320066_) {
        PacketUtils.ensureRunningOnSameThread(p_320066_, this, this.player.serverLevel());
        if (!this.player.hasPermissions(2)) {
            return;
        }
        Entity $$1 = this.player.level().getEntity(p_320066_.getEntityId());
        if ($$1 != null) {
            CompoundTag $$2 = $$1.saveWithoutId(new CompoundTag());
            this.player.connection.send(new ClientboundTagQueryPacket(p_320066_.getTransactionId(), $$2));
        }
    }

    @Override
    public void handleContainerSlotStateChanged(ServerboundContainerSlotStateChangedPacket p_307480_) {
        CrafterMenu $$1;
        PacketUtils.ensureRunningOnSameThread(p_307480_, this, this.player.serverLevel());
        if (this.player.isSpectator() || p_307480_.containerId() != this.player.containerMenu.containerId) {
            return;
        }
        Object object = this.player.containerMenu;
        if (object instanceof CrafterMenu && (object = ($$1 = (CrafterMenu)object).getContainer()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity $$2 = (CrafterBlockEntity)object;
            $$2.setSlotState(p_307480_.slotId(), p_307480_.newState());
        }
    }

    @Override
    public void handleBlockEntityTagQuery(ServerboundBlockEntityTagQueryPacket p_320124_) {
        PacketUtils.ensureRunningOnSameThread(p_320124_, this, this.player.serverLevel());
        if (!this.player.hasPermissions(2)) {
            return;
        }
        BlockEntity $$1 = this.player.level().getBlockEntity(p_320124_.getPos());
        CompoundTag $$2 = $$1 != null ? $$1.saveWithoutMetadata(this.player.registryAccess()) : null;
        this.player.connection.send(new ClientboundTagQueryPacket(p_320124_.getTransactionId(), $$2));
    }

    @Override
    public void handleMovePlayer(ServerboundMovePlayerPacket p_9874_) {
        boolean $$19;
        PacketUtils.ensureRunningOnSameThread(p_9874_, this, this.player.serverLevel());
        if (ServerGamePacketListenerImpl.containsInvalidValues(p_9874_.getX(0.0), p_9874_.getY(0.0), p_9874_.getZ(0.0), p_9874_.getYRot(0.0f), p_9874_.getXRot(0.0f))) {
            this.disconnect(Component.translatable("multiplayer.disconnect.invalid_player_movement"));
            return;
        }
        ServerLevel $$1 = this.player.serverLevel();
        if (this.player.wonGame) {
            return;
        }
        if (this.tickCount == 0) {
            this.resetPosition();
        }
        if (this.awaitingPositionFromClient != null) {
            if (this.tickCount - this.awaitingTeleportTime > 20) {
                this.awaitingTeleportTime = this.tickCount;
                this.teleport(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            }
            return;
        }
        this.awaitingTeleportTime = this.tickCount;
        double $$2 = ServerGamePacketListenerImpl.clampHorizontal(p_9874_.getX(this.player.getX()));
        double $$3 = ServerGamePacketListenerImpl.clampVertical(p_9874_.getY(this.player.getY()));
        double $$4 = ServerGamePacketListenerImpl.clampHorizontal(p_9874_.getZ(this.player.getZ()));
        float $$5 = Mth.wrapDegrees(p_9874_.getYRot(this.player.getYRot()));
        float $$6 = Mth.wrapDegrees(p_9874_.getXRot(this.player.getXRot()));
        if (this.player.isPassenger()) {
            this.player.absMoveTo(this.player.getX(), this.player.getY(), this.player.getZ(), $$5, $$6);
            this.player.serverLevel().getChunkSource().move(this.player);
            return;
        }
        double $$7 = this.player.getX();
        double $$8 = this.player.getY();
        double $$9 = this.player.getZ();
        double $$10 = $$2 - this.firstGoodX;
        double $$11 = $$3 - this.firstGoodY;
        double $$12 = $$4 - this.firstGoodZ;
        double $$13 = this.player.getDeltaMovement().lengthSqr();
        double $$14 = $$10 * $$10 + $$11 * $$11 + $$12 * $$12;
        if (this.player.isSleeping()) {
            if ($$14 > 1.0) {
                this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), $$5, $$6);
            }
            return;
        }
        boolean $$15 = this.player.isFallFlying();
        if ($$1.tickRateManager().runsNormally()) {
            ++this.receivedMovePacketCount;
            int $$16 = this.receivedMovePacketCount - this.knownMovePacketCount;
            if ($$16 > 5) {
                LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.player.getName().getString(), (Object)$$16);
                $$16 = 1;
            }
            if (!(this.player.isChangingDimension() || this.player.level().getGameRules().getBoolean(GameRules.RULE_DISABLE_ELYTRA_MOVEMENT_CHECK) && $$15)) {
                float $$17;
                float f = $$17 = $$15 ? 300.0f : 100.0f;
                if ($$14 - $$13 > (double)($$17 * (float)$$16) && !this.isSingleplayerOwner()) {
                    LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{this.player.getName().getString(), $$10, $$11, $$12});
                    this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot());
                    return;
                }
            }
        }
        AABB $$18 = this.player.getBoundingBox();
        $$10 = $$2 - this.lastGoodX;
        $$11 = $$3 - this.lastGoodY;
        $$12 = $$4 - this.lastGoodZ;
        boolean bl = $$19 = $$11 > 0.0;
        if (this.player.onGround() && !p_9874_.isOnGround() && $$19) {
            this.player.jumpFromGround();
        }
        boolean $$20 = this.player.verticalCollisionBelow;
        this.player.move(MoverType.PLAYER, new Vec3($$10, $$11, $$12));
        double $$21 = $$11;
        $$10 = $$2 - this.player.getX();
        $$11 = $$3 - this.player.getY();
        if ($$11 > -0.5 || $$11 < 0.5) {
            $$11 = 0.0;
        }
        $$12 = $$4 - this.player.getZ();
        $$14 = $$10 * $$10 + $$11 * $$11 + $$12 * $$12;
        boolean $$22 = false;
        if (!this.player.isChangingDimension() && $$14 > 0.0625 && !this.player.isSleeping() && !this.player.gameMode.isCreative() && this.player.gameMode.getGameModeForPlayer() != GameType.SPECTATOR) {
            $$22 = true;
            LOGGER.warn("{} moved wrongly!", (Object)this.player.getName().getString());
        }
        if (!this.player.noPhysics && !this.player.isSleeping() && ($$22 && $$1.noCollision(this.player, $$18) || this.isPlayerCollidingWithAnythingNew($$1, $$18, $$2, $$3, $$4))) {
            this.teleport($$7, $$8, $$9, $$5, $$6);
            this.player.doCheckFallDamage(this.player.getX() - $$7, this.player.getY() - $$8, this.player.getZ() - $$9, p_9874_.isOnGround());
            return;
        }
        this.player.absMoveTo($$2, $$3, $$4, $$5, $$6);
        boolean $$23 = this.player.isAutoSpinAttack();
        this.clientIsFloating = $$21 >= -0.03125 && !$$20 && this.player.gameMode.getGameModeForPlayer() != GameType.SPECTATOR && !this.server.isFlightAllowed() && !this.player.getAbilities().mayfly && !this.player.hasEffect(MobEffects.LEVITATION) && !$$15 && !$$23 && this.noBlocksAround(this.player);
        this.player.serverLevel().getChunkSource().move(this.player);
        this.player.doCheckFallDamage(this.player.getX() - $$7, this.player.getY() - $$8, this.player.getZ() - $$9, p_9874_.isOnGround());
        this.player.setOnGroundWithKnownMovement(p_9874_.isOnGround(), new Vec3(this.player.getX() - $$7, this.player.getY() - $$8, this.player.getZ() - $$9));
        if ($$19) {
            this.player.resetFallDistance();
        }
        if (p_9874_.isOnGround() || this.player.isInLiquid() || this.player.onClimbable() || this.player.isSpectator() || $$15 || $$23) {
            this.player.resetCurrentImpulseContext();
        }
        this.player.checkMovementStatistics(this.player.getX() - $$7, this.player.getY() - $$8, this.player.getZ() - $$9);
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    private boolean isPlayerCollidingWithAnythingNew(LevelReader p_289008_, AABB p_288986_, double p_288990_, double p_288991_, double p_288967_) {
        AABB $$5 = this.player.getBoundingBox().move(p_288990_ - this.player.getX(), p_288991_ - this.player.getY(), p_288967_ - this.player.getZ());
        Iterable<VoxelShape> $$6 = p_289008_.getCollisions(this.player, $$5.deflate(1.0E-5f));
        VoxelShape $$7 = Shapes.create(p_288986_.deflate(1.0E-5f));
        for (VoxelShape $$8 : $$6) {
            if (Shapes.joinIsNotEmpty($$8, $$7, BooleanOp.AND)) continue;
            return true;
        }
        return false;
    }

    public void teleport(double p_9775_, double p_9776_, double p_9777_, float p_9778_, float p_9779_) {
        this.teleport(p_9775_, p_9776_, p_9777_, p_9778_, p_9779_, Collections.emptySet());
    }

    public void teleport(double p_9781_, double p_9782_, double p_9783_, float p_9784_, float p_9785_, Set<RelativeMovement> p_9786_) {
        double $$6 = p_9786_.contains((Object)RelativeMovement.X) ? this.player.getX() : 0.0;
        double $$7 = p_9786_.contains((Object)RelativeMovement.Y) ? this.player.getY() : 0.0;
        double $$8 = p_9786_.contains((Object)RelativeMovement.Z) ? this.player.getZ() : 0.0;
        float $$9 = p_9786_.contains((Object)RelativeMovement.Y_ROT) ? this.player.getYRot() : 0.0f;
        float $$10 = p_9786_.contains((Object)RelativeMovement.X_ROT) ? this.player.getXRot() : 0.0f;
        this.awaitingPositionFromClient = new Vec3(p_9781_, p_9782_, p_9783_);
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.awaitingTeleportTime = this.tickCount;
        this.player.resetCurrentImpulseContext();
        this.player.absMoveTo(p_9781_, p_9782_, p_9783_, p_9784_, p_9785_);
        this.player.connection.send(new ClientboundPlayerPositionPacket(p_9781_ - $$6, p_9782_ - $$7, p_9783_ - $$8, p_9784_ - $$9, p_9785_ - $$10, p_9786_, this.awaitingTeleport));
    }

    @Override
    public void handlePlayerAction(ServerboundPlayerActionPacket p_9889_) {
        PacketUtils.ensureRunningOnSameThread(p_9889_, this, this.player.serverLevel());
        BlockPos $$1 = p_9889_.getPos();
        this.player.resetLastActionTime();
        ServerboundPlayerActionPacket.Action $$2 = p_9889_.getAction();
        switch ($$2) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.player.isSpectator()) {
                    ItemStack $$3 = this.player.getItemInHand(InteractionHand.OFF_HAND);
                    this.player.setItemInHand(InteractionHand.OFF_HAND, this.player.getItemInHand(InteractionHand.MAIN_HAND));
                    this.player.setItemInHand(InteractionHand.MAIN_HAND, $$3);
                    this.player.stopUsingItem();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.player.isSpectator()) {
                    this.player.drop(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.player.isSpectator()) {
                    this.player.drop(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.player.releaseUsingItem();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.player.gameMode.handleBlockBreakAction($$1, $$2, p_9889_.getDirection(), this.player.level().getMaxBuildHeight(), p_9889_.getSequence());
                this.player.connection.ackBlockChangesUpTo(p_9889_.getSequence());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean wasBlockPlacementAttempt(ServerPlayer p_9791_, ItemStack p_9792_) {
        if (p_9792_.isEmpty()) {
            return false;
        }
        Item $$2 = p_9792_.getItem();
        return ($$2 instanceof BlockItem || $$2 instanceof BucketItem) && !p_9791_.getCooldowns().isOnCooldown($$2);
    }

    @Override
    public void handleUseItemOn(ServerboundUseItemOnPacket p_9930_) {
        PacketUtils.ensureRunningOnSameThread(p_9930_, this, this.player.serverLevel());
        this.player.connection.ackBlockChangesUpTo(p_9930_.getSequence());
        ServerLevel $$1 = this.player.serverLevel();
        InteractionHand $$2 = p_9930_.getHand();
        ItemStack $$3 = this.player.getItemInHand($$2);
        if (!$$3.isItemEnabled($$1.enabledFeatures())) {
            return;
        }
        BlockHitResult $$4 = p_9930_.getHitResult();
        Vec3 $$5 = $$4.getLocation();
        BlockPos $$6 = $$4.getBlockPos();
        if (!this.player.canInteractWithBlock($$6, 1.0)) {
            return;
        }
        Vec3 $$7 = $$5.subtract(Vec3.atCenterOf($$6));
        double $$8 = 1.0000001;
        if (!(Math.abs($$7.x()) < 1.0000001 && Math.abs($$7.y()) < 1.0000001 && Math.abs($$7.z()) < 1.0000001)) {
            LOGGER.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.player.getGameProfile().getName(), $$5, $$6});
            return;
        }
        Direction $$9 = $$4.getDirection();
        this.player.resetLastActionTime();
        int $$10 = this.player.level().getMaxBuildHeight();
        if ($$6.getY() < $$10) {
            if (this.awaitingPositionFromClient == null && $$1.mayInteract(this.player, $$6)) {
                InteractionResult $$11 = this.player.gameMode.useItemOn(this.player, $$1, $$3, $$2, $$4);
                if ($$11.consumesAction()) {
                    CriteriaTriggers.ANY_BLOCK_USE.trigger(this.player, $$4.getBlockPos(), $$3.copy());
                }
                if ($$9 == Direction.UP && !$$11.consumesAction() && $$6.getY() >= $$10 - 1 && ServerGamePacketListenerImpl.wasBlockPlacementAttempt(this.player, $$3)) {
                    MutableComponent $$12 = Component.translatable("build.tooHigh", $$10 - 1).withStyle(ChatFormatting.RED);
                    this.player.sendSystemMessage($$12, true);
                } else if ($$11.shouldSwing()) {
                    this.player.swing($$2, true);
                }
            }
        } else {
            MutableComponent $$13 = Component.translatable("build.tooHigh", $$10 - 1).withStyle(ChatFormatting.RED);
            this.player.sendSystemMessage($$13, true);
        }
        this.player.connection.send(new ClientboundBlockUpdatePacket($$1, $$6));
        this.player.connection.send(new ClientboundBlockUpdatePacket($$1, $$6.relative($$9)));
    }

    @Override
    public void handleUseItem(ServerboundUseItemPacket p_9932_) {
        PacketUtils.ensureRunningOnSameThread(p_9932_, this, this.player.serverLevel());
        this.ackBlockChangesUpTo(p_9932_.getSequence());
        ServerLevel $$1 = this.player.serverLevel();
        InteractionHand $$2 = p_9932_.getHand();
        ItemStack $$3 = this.player.getItemInHand($$2);
        this.player.resetLastActionTime();
        if ($$3.isEmpty() || !$$3.isItemEnabled($$1.enabledFeatures())) {
            return;
        }
        InteractionResult $$4 = this.player.gameMode.useItem(this.player, $$1, $$3, $$2);
        if ($$4.shouldSwing()) {
            this.player.swing($$2, true);
        }
    }

    @Override
    public void handleTeleportToEntityPacket(ServerboundTeleportToEntityPacket p_9928_) {
        PacketUtils.ensureRunningOnSameThread(p_9928_, this, this.player.serverLevel());
        if (this.player.isSpectator()) {
            for (ServerLevel $$1 : this.server.getAllLevels()) {
                Entity $$2 = p_9928_.getEntity($$1);
                if ($$2 == null) continue;
                this.player.teleportTo($$1, $$2.getX(), $$2.getY(), $$2.getZ(), $$2.getYRot(), $$2.getXRot());
                return;
            }
        }
    }

    @Override
    public void handlePaddleBoat(ServerboundPaddleBoatPacket p_9878_) {
        PacketUtils.ensureRunningOnSameThread(p_9878_, this, this.player.serverLevel());
        Entity $$1 = this.player.getControlledVehicle();
        if ($$1 instanceof Boat) {
            Boat $$2 = (Boat)$$1;
            $$2.setPaddleState(p_9878_.getLeft(), p_9878_.getRight());
        }
    }

    @Override
    public void onDisconnect(Component p_9825_) {
        LOGGER.info("{} lost connection: {}", (Object)this.player.getName().getString(), (Object)p_9825_.getString());
        this.removePlayerFromWorld();
        super.onDisconnect(p_9825_);
    }

    private void removePlayerFromWorld() {
        this.chatMessageChain.close();
        this.server.invalidateStatus();
        this.server.getPlayerList().broadcastSystemMessage(Component.translatable("multiplayer.player.left", this.player.getDisplayName()).withStyle(ChatFormatting.YELLOW), false);
        this.player.disconnect();
        this.server.getPlayerList().remove(this.player);
        this.player.getTextFilter().leave();
    }

    public void ackBlockChangesUpTo(int p_215202_) {
        if (p_215202_ < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChangesUpTo = Math.max(p_215202_, this.ackBlockChangesUpTo);
    }

    @Override
    public void handleSetCarriedItem(ServerboundSetCarriedItemPacket p_9909_) {
        PacketUtils.ensureRunningOnSameThread(p_9909_, this, this.player.serverLevel());
        if (p_9909_.getSlot() < 0 || p_9909_.getSlot() >= Inventory.getSelectionSize()) {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getName().getString());
            return;
        }
        if (this.player.getInventory().selected != p_9909_.getSlot() && this.player.getUsedItemHand() == InteractionHand.MAIN_HAND) {
            this.player.stopUsingItem();
        }
        this.player.getInventory().selected = p_9909_.getSlot();
        this.player.resetLastActionTime();
    }

    @Override
    public void handleChat(ServerboundChatPacket p_9841_) {
        Optional<LastSeenMessages> $$1 = this.unpackAndApplyLastSeen(p_9841_.lastSeenMessages());
        if ($$1.isEmpty()) {
            return;
        }
        this.tryHandleChat(p_9841_.message(), () -> {
            void $$4;
            try {
                PlayerChatMessage $$2 = this.getSignedMessage(p_9841_, (LastSeenMessages)$$1.get());
            }
            catch (SignedMessageChain.DecodeException $$3) {
                this.handleMessageDecodeFailure($$3);
                return;
            }
            CompletableFuture<FilteredText> $$5 = this.filterTextPacket($$4.signedContent());
            Component $$6 = this.server.getChatDecorator().decorate(this.player, $$4.decoratedContent());
            this.chatMessageChain.append($$5, arg_0 -> this.lambda$handleChat$5((PlayerChatMessage)$$4, $$6, arg_0));
        });
    }

    @Override
    public void handleChatCommand(ServerboundChatCommandPacket p_215225_) {
        this.tryHandleChat(p_215225_.command(), () -> {
            this.performUnsignedChatCommand(p_215225_.command());
            this.detectRateSpam();
        });
    }

    private void performUnsignedChatCommand(String p_338482_) {
        ParseResults<CommandSourceStack> $$1 = this.parseCommand(p_338482_);
        if (this.server.enforceSecureProfile() && SignableCommand.hasSignableArguments($$1)) {
            LOGGER.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.player.getGameProfile().getName(), (Object)p_338482_);
            this.player.sendSystemMessage(INVALID_COMMAND_SIGNATURE);
            return;
        }
        this.server.getCommands().performCommand($$1, p_338482_);
    }

    @Override
    public void handleSignedChatCommand(ServerboundChatCommandSignedPacket p_338604_) {
        Optional<LastSeenMessages> $$1 = this.unpackAndApplyLastSeen(p_338604_.lastSeenMessages());
        if ($$1.isEmpty()) {
            return;
        }
        this.tryHandleChat(p_338604_.command(), () -> {
            this.performSignedChatCommand(p_338604_, (LastSeenMessages)$$1.get());
            this.detectRateSpam();
        });
    }

    /*
     * WARNING - void declaration
     */
    private void performSignedChatCommand(ServerboundChatCommandSignedPacket p_338593_, LastSeenMessages p_250484_) {
        void $$5;
        ParseResults<CommandSourceStack> $$2 = this.parseCommand(p_338593_.command());
        try {
            Map<String, PlayerChatMessage> $$3 = this.collectSignedArguments(p_338593_, SignableCommand.of($$2), p_250484_);
        }
        catch (SignedMessageChain.DecodeException $$4) {
            this.handleMessageDecodeFailure($$4);
            return;
        }
        CommandSigningContext.SignedArguments $$6 = new CommandSigningContext.SignedArguments((Map<String, PlayerChatMessage>)$$5);
        $$2 = Commands.mapSource($$2, p_301740_ -> p_301740_.withSigningContext($$6, this.chatMessageChain));
        this.server.getCommands().performCommand($$2, p_338593_.command());
    }

    private void handleMessageDecodeFailure(SignedMessageChain.DecodeException p_252068_) {
        LOGGER.warn("Failed to update secure chat state for {}: '{}'", (Object)this.player.getGameProfile().getName(), (Object)p_252068_.getComponent().getString());
        this.player.sendSystemMessage(p_252068_.getComponent().copy().withStyle(ChatFormatting.RED));
    }

    private <S> Map<String, PlayerChatMessage> collectSignedArguments(ServerboundChatCommandSignedPacket p_338222_, SignableCommand<S> p_250039_, LastSeenMessages p_249207_) throws SignedMessageChain.DecodeException {
        List<ArgumentSignatures.Entry> $$3 = p_338222_.argumentSignatures().entries();
        List<SignableCommand.Argument<S>> $$4 = p_250039_.arguments();
        if ($$3.isEmpty()) {
            return this.collectUnsignedArguments($$4);
        }
        Object2ObjectOpenHashMap $$5 = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.Entry entry : $$3) {
            SignableCommand.Argument<S> $$7 = p_250039_.getArgument(entry.name());
            if ($$7 == null) {
                this.signedMessageDecoder.setChainBroken();
                throw ServerGamePacketListenerImpl.createSignedArgumentMismatchException(p_338222_.command(), $$3, $$4);
            }
            SignedMessageBody $$8 = new SignedMessageBody($$7.value(), p_338222_.timeStamp(), p_338222_.salt(), p_249207_);
            $$5.put($$7.name(), this.signedMessageDecoder.unpack(entry.signature(), $$8));
        }
        for (SignableCommand.Argument argument : $$4) {
            if ($$5.containsKey(argument.name())) continue;
            throw ServerGamePacketListenerImpl.createSignedArgumentMismatchException(p_338222_.command(), $$3, $$4);
        }
        return $$5;
    }

    private <S> Map<String, PlayerChatMessage> collectUnsignedArguments(List<SignableCommand.Argument<S>> p_338744_) throws SignedMessageChain.DecodeException {
        HashMap<String, PlayerChatMessage> $$1 = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.Argument<S> $$2 : p_338744_) {
            SignedMessageBody $$3 = SignedMessageBody.unsigned($$2.value());
            $$1.put($$2.name(), this.signedMessageDecoder.unpack(null, $$3));
        }
        return $$1;
    }

    private static <S> SignedMessageChain.DecodeException createSignedArgumentMismatchException(String p_338499_, List<ArgumentSignatures.Entry> p_338388_, List<SignableCommand.Argument<S>> p_338708_) {
        String $$3 = p_338388_.stream().map(ArgumentSignatures.Entry::name).collect(Collectors.joining(", "));
        String $$4 = p_338708_.stream().map(SignableCommand.Argument::name).collect(Collectors.joining(", "));
        LOGGER.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{p_338499_, $$3, $$4});
        return new SignedMessageChain.DecodeException(INVALID_COMMAND_SIGNATURE);
    }

    private ParseResults<CommandSourceStack> parseCommand(String p_242938_) {
        CommandDispatcher<CommandSourceStack> $$1 = this.server.getCommands().getDispatcher();
        return $$1.parse(p_242938_, (Object)this.player.createCommandSourceStack());
    }

    private void tryHandleChat(String p_338775_, Runnable p_338235_) {
        if (ServerGamePacketListenerImpl.isChatMessageIllegal(p_338775_)) {
            this.disconnect(Component.translatable("multiplayer.disconnect.illegal_characters"));
            return;
        }
        if (this.player.getChatVisibility() == ChatVisiblity.HIDDEN) {
            this.send(new ClientboundSystemChatPacket(Component.translatable("chat.disabled.options").withStyle(ChatFormatting.RED), false));
            return;
        }
        this.player.resetLastActionTime();
        this.server.execute(p_338235_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> unpackAndApplyLastSeen(LastSeenMessages.Update p_249673_) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> $$1 = this.lastSeenMessages.applyUpdate(p_249673_);
            if ($$1.isEmpty()) {
                LOGGER.warn("Failed to validate message acknowledgements from {}", (Object)this.player.getName().getString());
                this.disconnect(CHAT_VALIDATION_FAILED);
            }
            return $$1;
        }
    }

    private static boolean isChatMessageIllegal(String p_215215_) {
        for (int $$1 = 0; $$1 < p_215215_.length(); ++$$1) {
            if (StringUtil.isAllowedChatCharacter(p_215215_.charAt($$1))) continue;
            return true;
        }
        return false;
    }

    private PlayerChatMessage getSignedMessage(ServerboundChatPacket p_251061_, LastSeenMessages p_250566_) throws SignedMessageChain.DecodeException {
        SignedMessageBody $$2 = new SignedMessageBody(p_251061_.message(), p_251061_.timeStamp(), p_251061_.salt(), p_250566_);
        return this.signedMessageDecoder.unpack(p_251061_.signature(), $$2);
    }

    private void broadcastChatMessage(PlayerChatMessage p_243277_) {
        this.server.getPlayerList().broadcastChatMessage(p_243277_, this.player, ChatType.bind(ChatType.CHAT, this.player));
        this.detectRateSpam();
    }

    private void detectRateSpam() {
        this.chatSpamTickCount += 20;
        if (this.chatSpamTickCount > 200 && !this.server.getPlayerList().isOp(this.player.getGameProfile())) {
            this.disconnect(Component.translatable("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChatAck(ServerboundChatAckPacket p_242387_) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            if (!this.lastSeenMessages.applyOffset(p_242387_.offset())) {
                LOGGER.warn("Failed to validate message acknowledgements from {}", (Object)this.player.getName().getString());
                this.disconnect(CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void handleAnimate(ServerboundSwingPacket p_9926_) {
        PacketUtils.ensureRunningOnSameThread(p_9926_, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        this.player.swing(p_9926_.getHand());
    }

    @Override
    public void handlePlayerCommand(ServerboundPlayerCommandPacket p_9891_) {
        PacketUtils.ensureRunningOnSameThread(p_9891_, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        switch (p_9891_.getAction()) {
            case PRESS_SHIFT_KEY: {
                this.player.setShiftKeyDown(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.player.setShiftKeyDown(false);
                break;
            }
            case START_SPRINTING: {
                this.player.setSprinting(true);
                break;
            }
            case STOP_SPRINTING: {
                this.player.setSprinting(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.player.isSleeping()) break;
                this.player.stopSleepInBed(false, true);
                this.awaitingPositionFromClient = this.player.position();
                break;
            }
            case START_RIDING_JUMP: {
                Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping $$1 = (PlayerRideableJumping)((Object)entity);
                int $$2 = p_9891_.getData();
                if (!$$1.canJump() || $$2 <= 0) break;
                $$1.handleStartJump($$2);
                break;
            }
            case STOP_RIDING_JUMP: {
                Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping $$3 = (PlayerRideableJumping)((Object)entity);
                $$3.handleStopJump();
                break;
            }
            case OPEN_INVENTORY: {
                Entity entity = this.player.getVehicle();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen $$4 = (HasCustomInventoryScreen)((Object)entity);
                $$4.openCustomInventoryScreen(this.player);
                break;
            }
            case START_FALL_FLYING: {
                if (this.player.tryToStartFallFlying()) break;
                this.player.stopFallFlying();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addPendingMessage(PlayerChatMessage p_242439_) {
        void $$3;
        MessageSignature $$1 = p_242439_.signature();
        if ($$1 == null) {
            return;
        }
        this.messageSignatureCache.push(p_242439_.signedBody(), p_242439_.signature());
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            this.lastSeenMessages.addPending($$1);
            int $$2 = this.lastSeenMessages.trackedMessagesCount();
        }
        if ($$3 > 4096) {
            this.disconnect(Component.translatable("multiplayer.disconnect.too_many_pending_chats"));
        }
    }

    public void sendPlayerChatMessage(PlayerChatMessage p_250321_, ChatType.Bound p_250910_) {
        this.send(new ClientboundPlayerChatPacket(p_250321_.link().sender(), p_250321_.link().index(), p_250321_.signature(), p_250321_.signedBody().pack(this.messageSignatureCache), p_250321_.unsignedContent(), p_250321_.filterMask(), p_250910_));
        this.addPendingMessage(p_250321_);
    }

    public void sendDisguisedChatMessage(Component p_251804_, ChatType.Bound p_250040_) {
        this.send(new ClientboundDisguisedChatPacket(p_251804_, p_250040_));
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public void switchToConfig() {
        this.waitingForSwitchToConfig = true;
        this.removePlayerFromWorld();
        this.send(ClientboundStartConfigurationPacket.INSTANCE);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.CLIENTBOUND);
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket p_320356_) {
        this.connection.send(new ClientboundPongResponsePacket(p_320356_.getTime()));
    }

    @Override
    public void handleInteract(ServerboundInteractPacket p_9866_) {
        PacketUtils.ensureRunningOnSameThread(p_9866_, this, this.player.serverLevel());
        final ServerLevel $$1 = this.player.serverLevel();
        final Entity $$2 = p_9866_.getTarget($$1);
        this.player.resetLastActionTime();
        this.player.setShiftKeyDown(p_9866_.isUsingSecondaryAction());
        if ($$2 != null) {
            if (!$$1.getWorldBorder().isWithinBounds($$2.blockPosition())) {
                return;
            }
            AABB $$3 = $$2.getBoundingBox();
            if (this.player.canInteractWithEntity($$3, 1.0)) {
                p_9866_.dispatch(new ServerboundInteractPacket.Handler(){

                    private void performInteraction(InteractionHand p_143679_, EntityInteraction p_143680_) {
                        ItemStack $$22 = ServerGamePacketListenerImpl.this.player.getItemInHand(p_143679_);
                        if (!$$22.isItemEnabled($$1.enabledFeatures())) {
                            return;
                        }
                        ItemStack $$3 = $$22.copy();
                        InteractionResult $$4 = p_143680_.run(ServerGamePacketListenerImpl.this.player, $$2, p_143679_);
                        if ($$4.consumesAction()) {
                            CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(ServerGamePacketListenerImpl.this.player, $$4.indicateItemUse() ? $$3 : ItemStack.EMPTY, $$2);
                            if ($$4.shouldSwing()) {
                                ServerGamePacketListenerImpl.this.player.swing(p_143679_, true);
                            }
                        }
                    }

                    @Override
                    public void onInteraction(InteractionHand p_143677_) {
                        this.performInteraction(p_143677_, Player::interactOn);
                    }

                    @Override
                    public void onInteraction(InteractionHand p_143682_, Vec3 p_143683_) {
                        this.performInteraction(p_143682_, (p_143686_, p_143687_, p_143688_) -> p_143687_.interactAt(p_143686_, p_143683_, p_143688_));
                    }

                    @Override
                    public void onAttack() {
                        AbstractArrow $$0;
                        if ($$2 instanceof ItemEntity || $$2 instanceof ExperienceOrb || $$2 == ServerGamePacketListenerImpl.this.player || $$2 instanceof AbstractArrow && !($$0 = (AbstractArrow)$$2).isAttackable()) {
                            ServerGamePacketListenerImpl.this.disconnect(Component.translatable("multiplayer.disconnect.invalid_entity_attacked"));
                            LOGGER.warn("Player {} tried to attack an invalid entity", (Object)ServerGamePacketListenerImpl.this.player.getName().getString());
                            return;
                        }
                        ItemStack $$12 = ServerGamePacketListenerImpl.this.player.getItemInHand(InteractionHand.MAIN_HAND);
                        if (!$$12.isItemEnabled($$1.enabledFeatures())) {
                            return;
                        }
                        ServerGamePacketListenerImpl.this.player.attack($$2);
                    }
                });
            }
        }
    }

    @Override
    public void handleClientCommand(ServerboundClientCommandPacket p_9843_) {
        PacketUtils.ensureRunningOnSameThread(p_9843_, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        ServerboundClientCommandPacket.Action $$1 = p_9843_.getAction();
        switch ($$1) {
            case PERFORM_RESPAWN: {
                if (this.player.wonGame) {
                    this.player.wonGame = false;
                    this.player = this.server.getPlayerList().respawn(this.player, true);
                    CriteriaTriggers.CHANGED_DIMENSION.trigger(this.player, Level.END, Level.OVERWORLD);
                    break;
                }
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.server.getPlayerList().respawn(this.player, false);
                if (!this.server.isHardcore()) break;
                this.player.setGameMode(GameType.SPECTATOR);
                this.player.level().getGameRules().getRule(GameRules.RULE_SPECTATORSGENERATECHUNKS).set(false, this.server);
                break;
            }
            case REQUEST_STATS: {
                this.player.getStats().sendStats(this.player);
            }
        }
    }

    @Override
    public void handleContainerClose(ServerboundContainerClosePacket p_9858_) {
        PacketUtils.ensureRunningOnSameThread(p_9858_, this, this.player.serverLevel());
        this.player.doCloseContainer();
    }

    @Override
    public void handleContainerClick(ServerboundContainerClickPacket p_9856_) {
        PacketUtils.ensureRunningOnSameThread(p_9856_, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId != p_9856_.getContainerId()) {
            return;
        }
        if (this.player.isSpectator()) {
            this.player.containerMenu.sendAllDataToRemote();
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        int $$1 = p_9856_.getSlotNum();
        if (!this.player.containerMenu.isValidSlotIndex($$1)) {
            LOGGER.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.player.getName(), $$1, this.player.containerMenu.slots.size()});
            return;
        }
        boolean $$2 = p_9856_.getStateId() != this.player.containerMenu.getStateId();
        this.player.containerMenu.suppressRemoteUpdates();
        this.player.containerMenu.clicked($$1, p_9856_.getButtonNum(), p_9856_.getClickType(), this.player);
        for (Int2ObjectMap.Entry $$3 : Int2ObjectMaps.fastIterable(p_9856_.getChangedSlots())) {
            this.player.containerMenu.setRemoteSlotNoCopy($$3.getIntKey(), (ItemStack)$$3.getValue());
        }
        this.player.containerMenu.setRemoteCarried(p_9856_.getCarriedItem());
        this.player.containerMenu.resumeRemoteUpdates();
        if ($$2) {
            this.player.containerMenu.broadcastFullState();
        } else {
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void handlePlaceRecipe(ServerboundPlaceRecipePacket p_9882_) {
        PacketUtils.ensureRunningOnSameThread(p_9882_, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        if (this.player.isSpectator() || this.player.containerMenu.containerId != p_9882_.getContainerId() || !(this.player.containerMenu instanceof RecipeBookMenu)) {
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        this.server.getRecipeManager().byKey(p_9882_.getRecipe()).ifPresent(p_300787_ -> ((RecipeBookMenu)this.player.containerMenu).handlePlacement(p_9882_.isShiftDown(), (RecipeHolder<?>)p_300787_, this.player));
    }

    @Override
    public void handleContainerButtonClick(ServerboundContainerButtonClickPacket p_9854_) {
        PacketUtils.ensureRunningOnSameThread(p_9854_, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId != p_9854_.containerId() || this.player.isSpectator()) {
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        boolean $$1 = this.player.containerMenu.clickMenuButton(this.player, p_9854_.buttonId());
        if ($$1) {
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void handleSetCreativeModeSlot(ServerboundSetCreativeModeSlotPacket p_9915_) {
        PacketUtils.ensureRunningOnSameThread(p_9915_, this, this.player.serverLevel());
        if (this.player.gameMode.isCreative()) {
            boolean $$7;
            boolean $$1 = p_9915_.slotNum() < 0;
            ItemStack $$2 = p_9915_.itemStack();
            if (!$$2.isItemEnabled(this.player.level().enabledFeatures())) {
                return;
            }
            CustomData $$3 = $$2.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
            if ($$3.contains("x") && $$3.contains("y") && $$3.contains("z")) {
                BlockEntity $$5;
                BlockPos $$4 = BlockEntity.getPosFromTag($$3.getUnsafe());
                if (this.player.level().isLoaded($$4) && ($$5 = this.player.level().getBlockEntity($$4)) != null) {
                    $$5.saveToItem($$2, this.player.level().registryAccess());
                }
            }
            boolean $$6 = p_9915_.slotNum() >= 1 && p_9915_.slotNum() <= 45;
            boolean bl = $$7 = $$2.isEmpty() || $$2.getCount() <= $$2.getMaxStackSize();
            if ($$6 && $$7) {
                this.player.inventoryMenu.getSlot(p_9915_.slotNum()).setByPlayer($$2);
                this.player.inventoryMenu.broadcastChanges();
            } else if ($$1 && $$7 && this.dropSpamTickCount < 200) {
                this.dropSpamTickCount += 20;
                this.player.drop($$2, true);
            }
        }
    }

    @Override
    public void handleSignUpdate(ServerboundSignUpdatePacket p_9921_) {
        List<String> $$1 = Stream.of(p_9921_.getLines()).map(ChatFormatting::stripFormatting).collect(Collectors.toList());
        this.filterTextPacket($$1).thenAcceptAsync(p_215245_ -> this.updateSignText(p_9921_, (List<FilteredText>)p_215245_), (Executor)this.server);
    }

    /*
     * WARNING - void declaration
     */
    private void updateSignText(ServerboundSignUpdatePacket p_9923_, List<FilteredText> p_9924_) {
        this.player.resetLastActionTime();
        ServerLevel $$2 = this.player.serverLevel();
        BlockPos $$3 = p_9923_.getPos();
        if ($$2.hasChunkAt($$3)) {
            void $$6;
            BlockEntity $$4 = $$2.getBlockEntity($$3);
            if (!($$4 instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity $$5 = (SignBlockEntity)$$4;
            $$6.updateSignText(this.player, p_9923_.isFrontText(), p_9924_);
        }
    }

    @Override
    public void handlePlayerAbilities(ServerboundPlayerAbilitiesPacket p_9887_) {
        PacketUtils.ensureRunningOnSameThread(p_9887_, this, this.player.serverLevel());
        this.player.getAbilities().flying = p_9887_.isFlying() && this.player.getAbilities().mayfly;
    }

    @Override
    public void handleClientInformation(ServerboundClientInformationPacket p_301979_) {
        PacketUtils.ensureRunningOnSameThread(p_301979_, this, this.player.serverLevel());
        this.player.updateOptions(p_301979_.information());
    }

    @Override
    public void handleChangeDifficulty(ServerboundChangeDifficultyPacket p_9839_) {
        PacketUtils.ensureRunningOnSameThread(p_9839_, this, this.player.serverLevel());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            return;
        }
        this.server.setDifficulty(p_9839_.getDifficulty(), false);
    }

    @Override
    public void handleLockDifficulty(ServerboundLockDifficultyPacket p_9872_) {
        PacketUtils.ensureRunningOnSameThread(p_9872_, this, this.player.serverLevel());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            return;
        }
        this.server.setDifficultyLocked(p_9872_.isLocked());
    }

    @Override
    public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket p_253950_) {
        PacketUtils.ensureRunningOnSameThread(p_253950_, this, this.player.serverLevel());
        RemoteChatSession.Data $$1 = p_253950_.chatSession();
        ProfilePublicKey.Data $$2 = this.chatSession != null ? this.chatSession.profilePublicKey().data() : null;
        ProfilePublicKey.Data $$3 = $$1.profilePublicKey();
        if (Objects.equals($$2, $$3)) {
            return;
        }
        if ($$2 != null && $$3.expiresAt().isBefore($$2.expiresAt())) {
            this.disconnect(ProfilePublicKey.EXPIRED_PROFILE_PUBLIC_KEY);
            return;
        }
        try {
            SignatureValidator $$4 = this.server.getProfileKeySignatureValidator();
            if ($$4 == null) {
                LOGGER.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.player.getGameProfile().getName());
                return;
            }
            this.resetPlayerChatState($$1.validate(this.player.getGameProfile(), $$4));
        }
        catch (ProfilePublicKey.ValidationException $$5) {
            LOGGER.error("Failed to validate profile key: {}", (Object)$$5.getMessage());
            this.disconnect($$5.getComponent());
        }
    }

    @Override
    public void handleConfigurationAcknowledged(ServerboundConfigurationAcknowledgedPacket p_294416_) {
        if (!this.waitingForSwitchToConfig) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.connection.setupInboundProtocol(ConfigurationProtocols.SERVERBOUND, new ServerConfigurationPacketListenerImpl(this.server, this.connection, this.createCookie(this.player.clientInformation())));
    }

    @Override
    public void handleChunkBatchReceived(ServerboundChunkBatchReceivedPacket p_295247_) {
        PacketUtils.ensureRunningOnSameThread(p_295247_, this, this.player.serverLevel());
        this.chunkSender.onChunkBatchReceivedByClient(p_295247_.desiredChunksPerTick());
    }

    @Override
    public void handleDebugSampleSubscription(ServerboundDebugSampleSubscriptionPacket p_324293_) {
        PacketUtils.ensureRunningOnSameThread(p_324293_, this, this.player.serverLevel());
        this.server.subscribeToDebugSample(this.player, p_324293_.sampleType());
    }

    private void resetPlayerChatState(RemoteChatSession p_253823_) {
        this.chatSession = p_253823_;
        this.signedMessageDecoder = p_253823_.createMessageDecoder(this.player.getUUID());
        this.chatMessageChain.append(() -> {
            this.player.setChatSession(p_253823_);
            this.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.INITIALIZE_CHAT), List.of(this.player)));
        });
    }

    @Override
    public void handleCustomPayload(ServerboundCustomPayloadPacket p_333887_) {
    }

    @Override
    public ServerPlayer getPlayer() {
        return this.player;
    }

    private /* synthetic */ void lambda$handleChat$5(PlayerChatMessage p_300783_, Component p_300784_, FilteredText p_300785_) {
        PlayerChatMessage $$3 = p_300783_.withUnsignedContent(p_300784_).filter(p_300785_.mask());
        this.broadcastChatMessage($$3);
    }

    @FunctionalInterface
    static interface EntityInteraction {
        public InteractionResult run(ServerPlayer var1, Entity var2, InteractionHand var3);
    }
}

