/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.slf4j.Logger;

public abstract class PlayerList {
    public static final File USERBANLIST_FILE = new File("banned-players.json");
    public static final File IPBANLIST_FILE = new File("banned-ips.json");
    public static final File OPLIST_FILE = new File("ops.json");
    public static final File WHITELIST_FILE = new File("whitelist.json");
    public static final Component CHAT_FILTERED_FULL = Component.translatable("chat.filtered_full");
    public static final Component DUPLICATE_LOGIN_DISCONNECT_MESSAGE = Component.translatable("multiplayer.disconnect.duplicate_login");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SEND_PLAYER_INFO_INTERVAL = 600;
    private static final SimpleDateFormat BAN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer server;
    private final List<ServerPlayer> players = Lists.newArrayList();
    private final Map<UUID, ServerPlayer> playersByUUID = Maps.newHashMap();
    private final UserBanList bans = new UserBanList(USERBANLIST_FILE);
    private final IpBanList ipBans = new IpBanList(IPBANLIST_FILE);
    private final ServerOpList ops = new ServerOpList(OPLIST_FILE);
    private final UserWhiteList whitelist = new UserWhiteList(WHITELIST_FILE);
    private final Map<UUID, ServerStatsCounter> stats = Maps.newHashMap();
    private final Map<UUID, PlayerAdvancements> advancements = Maps.newHashMap();
    private final PlayerDataStorage playerIo;
    private boolean doWhiteList;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    protected final int maxPlayers;
    private int viewDistance;
    private int simulationDistance;
    private boolean allowCommandsForAllPlayers;
    private static final boolean ALLOW_LOGOUTIVATOR = false;
    private int sendAllPlayerInfoIn;

    public PlayerList(MinecraftServer p_203842_, LayeredRegistryAccess<RegistryLayer> p_251844_, PlayerDataStorage p_203844_, int p_203845_) {
        this.server = p_203842_;
        this.registries = p_251844_;
        this.maxPlayers = p_203845_;
        this.playerIo = p_203844_;
    }

    public void placeNewPlayer(Connection p_11262_, ServerPlayer p_11263_, CommonListenerCookie p_301988_) {
        CompoundTag $$24;
        Entity $$25;
        MutableComponent $$21;
        ServerLevel $$12;
        String $$7;
        GameProfile $$3 = p_11263_.getGameProfile();
        GameProfileCache $$4 = this.server.getProfileCache();
        if ($$4 != null) {
            Optional<GameProfile> $$5 = $$4.get($$3.getId());
            String $$6 = $$5.map(GameProfile::getName).orElse($$3.getName());
            $$4.add($$3);
        } else {
            $$7 = $$3.getName();
        }
        Optional<CompoundTag> $$8 = this.load(p_11263_);
        ResourceKey<Level> $$9 = $$8.flatMap(p_337568_ -> DimensionType.parseLegacy(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_337568_.get("Dimension"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0))).orElse(Level.OVERWORLD);
        ServerLevel $$10 = this.server.getLevel($$9);
        if ($$10 == null) {
            LOGGER.warn("Unknown respawn dimension {}, defaulting to overworld", $$9);
            ServerLevel $$11 = this.server.overworld();
        } else {
            $$12 = $$10;
        }
        p_11263_.setServerLevel($$12);
        String $$13 = p_11262_.getLoggableAddress(this.server.logIPs());
        LOGGER.info("{}[{}] logged in with entity id {} at ({}, {}, {})", new Object[]{p_11263_.getName().getString(), $$13, p_11263_.getId(), p_11263_.getX(), p_11263_.getY(), p_11263_.getZ()});
        LevelData $$14 = $$12.getLevelData();
        p_11263_.loadGameTypes($$8.orElse(null));
        ServerGamePacketListenerImpl $$15 = new ServerGamePacketListenerImpl(this.server, p_11262_, p_11263_, p_301988_);
        p_11262_.setupInboundProtocol(GameProtocols.SERVERBOUND.bind(RegistryFriendlyByteBuf.decorator(this.server.registryAccess())), $$15);
        GameRules $$16 = $$12.getGameRules();
        boolean $$17 = $$16.getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN);
        boolean $$18 = $$16.getBoolean(GameRules.RULE_REDUCEDDEBUGINFO);
        boolean $$19 = $$16.getBoolean(GameRules.RULE_LIMITED_CRAFTING);
        $$15.send(new ClientboundLoginPacket(p_11263_.getId(), $$14.isHardcore(), this.server.levelKeys(), this.getMaxPlayers(), this.viewDistance, this.simulationDistance, $$18, !$$17, $$19, p_11263_.createCommonSpawnInfo($$12), this.server.enforceSecureProfile()));
        $$15.send(new ClientboundChangeDifficultyPacket($$14.getDifficulty(), $$14.isDifficultyLocked()));
        $$15.send(new ClientboundPlayerAbilitiesPacket(p_11263_.getAbilities()));
        $$15.send(new ClientboundSetCarriedItemPacket(p_11263_.getInventory().selected));
        $$15.send(new ClientboundUpdateRecipesPacket(this.server.getRecipeManager().getOrderedRecipes()));
        this.sendPlayerPermissionLevel(p_11263_);
        p_11263_.getStats().markAllDirty();
        p_11263_.getRecipeBook().sendInitialRecipeBook(p_11263_);
        this.updateEntireScoreboard($$12.getScoreboard(), p_11263_);
        this.server.invalidateStatus();
        if (p_11263_.getGameProfile().getName().equalsIgnoreCase($$7)) {
            MutableComponent $$20 = Component.translatable("multiplayer.player.joined", p_11263_.getDisplayName());
        } else {
            $$21 = Component.translatable("multiplayer.player.joined.renamed", p_11263_.getDisplayName(), $$7);
        }
        this.broadcastSystemMessage($$21.withStyle(ChatFormatting.YELLOW), false);
        $$15.teleport(p_11263_.getX(), p_11263_.getY(), p_11263_.getZ(), p_11263_.getYRot(), p_11263_.getXRot());
        ServerStatus $$22 = this.server.getStatus();
        if ($$22 != null && !p_301988_.transferred()) {
            p_11263_.sendServerStatus($$22);
        }
        p_11263_.connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(this.players));
        this.players.add(p_11263_);
        this.playersByUUID.put(p_11263_.getUUID(), p_11263_);
        this.broadcastAll(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(p_11263_)));
        this.sendLevelInfo(p_11263_, $$12);
        $$12.addNewPlayer(p_11263_);
        this.server.getCustomBossEvents().onPlayerConnect(p_11263_);
        for (MobEffectInstance $$23 : p_11263_.getActiveEffects()) {
            $$15.send(new ClientboundUpdateMobEffectPacket(p_11263_.getId(), $$23, false));
        }
        if ($$8.isPresent() && $$8.get().contains("RootVehicle", 10) && ($$25 = EntityType.loadEntityRecursive(($$24 = $$8.get().getCompound("RootVehicle")).getCompound("Entity"), $$12, p_215603_ -> {
            if (!$$12.addWithUUID((Entity)p_215603_)) {
                return null;
            }
            return p_215603_;
        })) != null) {
            Object $$27;
            if ($$24.hasUUID("Attach")) {
                UUID $$26 = $$24.getUUID("Attach");
            } else {
                $$27 = null;
            }
            if ($$25.getUUID().equals($$27)) {
                p_11263_.startRiding($$25, true);
            } else {
                for (Entity $$28 : $$25.getIndirectPassengers()) {
                    if (!$$28.getUUID().equals($$27)) continue;
                    p_11263_.startRiding($$28, true);
                    break;
                }
            }
            if (!p_11263_.isPassenger()) {
                LOGGER.warn("Couldn't reattach entity to player");
                $$25.discard();
                for (Entity $$29 : $$25.getIndirectPassengers()) {
                    $$29.discard();
                }
            }
        }
        p_11263_.initInventoryMenu();
    }

    protected void updateEntireScoreboard(ServerScoreboard p_11274_, ServerPlayer p_11275_) {
        HashSet $$2 = Sets.newHashSet();
        for (PlayerTeam $$3 : p_11274_.getPlayerTeams()) {
            p_11275_.connection.send(ClientboundSetPlayerTeamPacket.createAddOrModifyPacket($$3, true));
        }
        for (DisplaySlot $$4 : DisplaySlot.values()) {
            Objective $$5 = p_11274_.getDisplayObjective($$4);
            if ($$5 == null || $$2.contains($$5)) continue;
            List<Packet<?>> $$6 = p_11274_.getStartTrackingPackets($$5);
            for (Packet<?> $$7 : $$6) {
                p_11275_.connection.send($$7);
            }
            $$2.add($$5);
        }
    }

    public void addWorldborderListener(ServerLevel p_184210_) {
        p_184210_.getWorldBorder().addListener(new BorderChangeListener(){

            @Override
            public void onBorderSizeSet(WorldBorder p_11321_, double p_11322_) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderSizePacket(p_11321_));
            }

            @Override
            public void onBorderSizeLerping(WorldBorder p_11328_, double p_11329_, double p_11330_, long p_11331_) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderLerpSizePacket(p_11328_));
            }

            @Override
            public void onBorderCenterSet(WorldBorder p_11324_, double p_11325_, double p_11326_) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderCenterPacket(p_11324_));
            }

            @Override
            public void onBorderSetWarningTime(WorldBorder p_11333_, int p_11334_) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderWarningDelayPacket(p_11333_));
            }

            @Override
            public void onBorderSetWarningBlocks(WorldBorder p_11339_, int p_11340_) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderWarningDistancePacket(p_11339_));
            }

            @Override
            public void onBorderSetDamagePerBlock(WorldBorder p_11336_, double p_11337_) {
            }

            @Override
            public void onBorderSetDamageSafeZOne(WorldBorder p_11342_, double p_11343_) {
            }
        });
    }

    public Optional<CompoundTag> load(ServerPlayer p_11225_) {
        Optional<CompoundTag> $$3;
        CompoundTag $$1 = this.server.getWorldData().getLoadedPlayerTag();
        if (this.server.isSingleplayerOwner(p_11225_.getGameProfile()) && $$1 != null) {
            Optional<CompoundTag> $$2 = Optional.of($$1);
            p_11225_.load($$1);
            LOGGER.debug("loading single player");
        } else {
            $$3 = this.playerIo.load(p_11225_);
        }
        return $$3;
    }

    protected void save(ServerPlayer p_11277_) {
        PlayerAdvancements $$2;
        this.playerIo.save(p_11277_);
        ServerStatsCounter $$1 = this.stats.get(p_11277_.getUUID());
        if ($$1 != null) {
            $$1.save();
        }
        if (($$2 = this.advancements.get(p_11277_.getUUID())) != null) {
            $$2.save();
        }
    }

    public void remove(ServerPlayer p_11287_) {
        Entity $$2;
        ServerLevel $$1 = p_11287_.serverLevel();
        p_11287_.awardStat(Stats.LEAVE_GAME);
        this.save(p_11287_);
        if (p_11287_.isPassenger() && ($$2 = p_11287_.getRootVehicle()).hasExactlyOnePlayerPassenger()) {
            LOGGER.debug("Removing player mount");
            p_11287_.stopRiding();
            $$2.getPassengersAndSelf().forEach(p_215620_ -> p_215620_.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER));
        }
        p_11287_.unRide();
        $$1.removePlayerImmediately(p_11287_, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        p_11287_.getAdvancements().stopListening();
        this.players.remove(p_11287_);
        this.server.getCustomBossEvents().onPlayerDisconnect(p_11287_);
        UUID $$3 = p_11287_.getUUID();
        ServerPlayer $$4 = this.playersByUUID.get($$3);
        if ($$4 == p_11287_) {
            this.playersByUUID.remove($$3);
            this.stats.remove($$3);
            this.advancements.remove($$3);
        }
        this.broadcastAll(new ClientboundPlayerInfoRemovePacket(List.of(p_11287_.getUUID())));
    }

    @Nullable
    public Component canPlayerLogin(SocketAddress p_11257_, GameProfile p_11258_) {
        if (this.bans.isBanned(p_11258_)) {
            UserBanListEntry $$2 = (UserBanListEntry)this.bans.get(p_11258_);
            MutableComponent $$3 = Component.translatable("multiplayer.disconnect.banned.reason", $$2.getReason());
            if ($$2.getExpires() != null) {
                $$3.append(Component.translatable("multiplayer.disconnect.banned.expiration", BAN_DATE_FORMAT.format($$2.getExpires())));
            }
            return $$3;
        }
        if (!this.isWhiteListed(p_11258_)) {
            return Component.translatable("multiplayer.disconnect.not_whitelisted");
        }
        if (this.ipBans.isBanned(p_11257_)) {
            IpBanListEntry $$4 = this.ipBans.get(p_11257_);
            MutableComponent $$5 = Component.translatable("multiplayer.disconnect.banned_ip.reason", $$4.getReason());
            if ($$4.getExpires() != null) {
                $$5.append(Component.translatable("multiplayer.disconnect.banned_ip.expiration", BAN_DATE_FORMAT.format($$4.getExpires())));
            }
            return $$5;
        }
        if (this.players.size() >= this.maxPlayers && !this.canBypassPlayerLimit(p_11258_)) {
            return Component.translatable("multiplayer.disconnect.server_full");
        }
        return null;
    }

    public ServerPlayer getPlayerForLogin(GameProfile p_215625_, ClientInformation p_302018_) {
        return new ServerPlayer(this.server, this.server.overworld(), p_215625_, p_302018_);
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile p_295670_) {
        UUID $$1 = p_295670_.getId();
        Set $$2 = Sets.newIdentityHashSet();
        for (ServerPlayer $$3 : this.players) {
            if (!$$3.getUUID().equals($$1)) continue;
            $$2.add($$3);
        }
        ServerPlayer $$4 = this.playersByUUID.get(p_295670_.getId());
        if ($$4 != null) {
            $$2.add($$4);
        }
        for (ServerPlayer $$5 : $$2) {
            $$5.connection.disconnect(DUPLICATE_LOGIN_DISCONNECT_MESSAGE);
        }
        return !$$2.isEmpty();
    }

    public ServerPlayer respawn(ServerPlayer p_11237_, boolean p_11238_) {
        Optional $$7;
        this.players.remove(p_11237_);
        p_11237_.serverLevel().removePlayerImmediately(p_11237_, Entity.RemovalReason.DISCARDED);
        BlockPos $$2 = p_11237_.getRespawnPosition();
        float $$3 = p_11237_.getRespawnAngle();
        boolean $$4 = p_11237_.isRespawnForced();
        ServerLevel $$5 = this.server.getLevel(p_11237_.getRespawnDimension());
        if ($$5 != null && $$2 != null) {
            Optional<Vec3> $$6 = Player.findRespawnPositionAndUseSpawnBlock($$5, $$2, $$3, $$4, p_11238_);
        } else {
            $$7 = Optional.empty();
        }
        ServerLevel $$8 = $$5 != null && $$7.isPresent() ? $$5 : this.server.overworld();
        ServerPlayer $$9 = new ServerPlayer(this.server, $$8, p_11237_.getGameProfile(), p_11237_.clientInformation());
        $$9.connection = p_11237_.connection;
        $$9.restoreFrom(p_11237_, p_11238_);
        $$9.setId(p_11237_.getId());
        $$9.setMainArm(p_11237_.getMainArm());
        for (String $$10 : p_11237_.getTags()) {
            $$9.addTag($$10);
        }
        boolean $$11 = false;
        if ($$7.isPresent()) {
            float $$17;
            BlockState $$12 = $$8.getBlockState($$2);
            boolean $$13 = $$12.is(Blocks.RESPAWN_ANCHOR);
            Vec3 $$14 = (Vec3)$$7.get();
            if ($$12.is(BlockTags.BEDS) || $$13) {
                Vec3 $$15 = Vec3.atBottomCenterOf($$2).subtract($$14).normalize();
                float $$16 = (float)Mth.wrapDegrees(Mth.atan2($$15.z, $$15.x) * 57.2957763671875 - 90.0);
            } else {
                $$17 = $$3;
            }
            $$9.moveTo($$14.x, $$14.y, $$14.z, $$17, 0.0f);
            $$9.setRespawnPosition($$8.dimension(), $$2, $$3, $$4, false);
            $$11 = !p_11238_ && $$13;
        } else if ($$2 != null) {
            $$9.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
        }
        while (!$$8.noCollision($$9) && $$9.getY() < (double)$$8.getMaxBuildHeight()) {
            $$9.setPos($$9.getX(), $$9.getY() + 1.0, $$9.getZ());
        }
        byte $$18 = p_11238_ ? (byte)1 : 0;
        ServerLevel $$19 = $$9.serverLevel();
        LevelData $$20 = $$19.getLevelData();
        $$9.connection.send(new ClientboundRespawnPacket($$9.createCommonSpawnInfo($$19), $$18));
        $$9.connection.teleport($$9.getX(), $$9.getY(), $$9.getZ(), $$9.getYRot(), $$9.getXRot());
        $$9.connection.send(new ClientboundSetDefaultSpawnPositionPacket($$8.getSharedSpawnPos(), $$8.getSharedSpawnAngle()));
        $$9.connection.send(new ClientboundChangeDifficultyPacket($$20.getDifficulty(), $$20.isDifficultyLocked()));
        $$9.connection.send(new ClientboundSetExperiencePacket($$9.experienceProgress, $$9.totalExperience, $$9.experienceLevel));
        this.sendLevelInfo($$9, $$8);
        this.sendPlayerPermissionLevel($$9);
        $$8.addRespawnedPlayer($$9);
        this.players.add($$9);
        this.playersByUUID.put($$9.getUUID(), $$9);
        $$9.initInventoryMenu();
        $$9.setHealth($$9.getHealth());
        if ($$11) {
            $$9.connection.send(new ClientboundSoundPacket(SoundEvents.RESPAWN_ANCHOR_DEPLETE, SoundSource.BLOCKS, $$2.getX(), $$2.getY(), $$2.getZ(), 1.0f, 1.0f, $$8.getRandom().nextLong()));
        }
        return $$9;
    }

    public void sendPlayerPermissionLevel(ServerPlayer p_11290_) {
        GameProfile $$1 = p_11290_.getGameProfile();
        int $$2 = this.server.getProfilePermissions($$1);
        this.sendPlayerPermissionLevel(p_11290_, $$2);
    }

    public void tick() {
        if (++this.sendAllPlayerInfoIn > 600) {
            this.broadcastAll(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY), this.players));
            this.sendAllPlayerInfoIn = 0;
        }
    }

    public void broadcastAll(Packet<?> p_11269_) {
        for (ServerPlayer $$1 : this.players) {
            $$1.connection.send(p_11269_);
        }
    }

    public void broadcastAll(Packet<?> p_11271_, ResourceKey<Level> p_11272_) {
        for (ServerPlayer $$2 : this.players) {
            if ($$2.level().dimension() != p_11272_) continue;
            $$2.connection.send(p_11271_);
        }
    }

    public void broadcastSystemToTeam(Player p_215622_, Component p_215623_) {
        PlayerTeam $$2 = p_215622_.getTeam();
        if ($$2 == null) {
            return;
        }
        Collection<String> $$3 = ((Team)$$2).getPlayers();
        for (String $$4 : $$3) {
            ServerPlayer $$5 = this.getPlayerByName($$4);
            if ($$5 == null || $$5 == p_215622_) continue;
            $$5.sendSystemMessage(p_215623_);
        }
    }

    public void broadcastSystemToAllExceptTeam(Player p_215650_, Component p_215651_) {
        PlayerTeam $$2 = p_215650_.getTeam();
        if ($$2 == null) {
            this.broadcastSystemMessage(p_215651_, false);
            return;
        }
        for (int $$3 = 0; $$3 < this.players.size(); ++$$3) {
            ServerPlayer $$4 = this.players.get($$3);
            if ($$4.getTeam() == $$2) continue;
            $$4.sendSystemMessage(p_215651_);
        }
    }

    public String[] getPlayerNamesArray() {
        String[] $$0 = new String[this.players.size()];
        for (int $$1 = 0; $$1 < this.players.size(); ++$$1) {
            $$0[$$1] = this.players.get($$1).getGameProfile().getName();
        }
        return $$0;
    }

    public UserBanList getBans() {
        return this.bans;
    }

    public IpBanList getIpBans() {
        return this.ipBans;
    }

    public void op(GameProfile p_11254_) {
        this.ops.add(new ServerOpListEntry(p_11254_, this.server.getOperatorUserPermissionLevel(), this.ops.canBypassPlayerLimit(p_11254_)));
        ServerPlayer $$1 = this.getPlayer(p_11254_.getId());
        if ($$1 != null) {
            this.sendPlayerPermissionLevel($$1);
        }
    }

    public void deop(GameProfile p_11281_) {
        this.ops.remove(p_11281_);
        ServerPlayer $$1 = this.getPlayer(p_11281_.getId());
        if ($$1 != null) {
            this.sendPlayerPermissionLevel($$1);
        }
    }

    private void sendPlayerPermissionLevel(ServerPlayer p_11227_, int p_11228_) {
        if (p_11227_.connection != null) {
            byte $$4;
            if (p_11228_ <= 0) {
                int $$2 = 24;
            } else if (p_11228_ >= 4) {
                int $$3 = 28;
            } else {
                $$4 = (byte)(24 + p_11228_);
            }
            p_11227_.connection.send(new ClientboundEntityEventPacket(p_11227_, $$4));
        }
        this.server.getCommands().sendCommands(p_11227_);
    }

    public boolean isWhiteListed(GameProfile p_11294_) {
        return !this.doWhiteList || this.ops.contains(p_11294_) || this.whitelist.contains(p_11294_);
    }

    public boolean isOp(GameProfile p_11304_) {
        return this.ops.contains(p_11304_) || this.server.isSingleplayerOwner(p_11304_) && this.server.getWorldData().isAllowCommands() || this.allowCommandsForAllPlayers;
    }

    @Nullable
    public ServerPlayer getPlayerByName(String p_11256_) {
        int $$1 = this.players.size();
        for (int $$2 = 0; $$2 < $$1; ++$$2) {
            ServerPlayer $$3 = this.players.get($$2);
            if (!$$3.getGameProfile().getName().equalsIgnoreCase(p_11256_)) continue;
            return $$3;
        }
        return null;
    }

    public void broadcast(@Nullable Player p_11242_, double p_11243_, double p_11244_, double p_11245_, double p_11246_, ResourceKey<Level> p_11247_, Packet<?> p_11248_) {
        for (int $$7 = 0; $$7 < this.players.size(); ++$$7) {
            double $$11;
            double $$10;
            double $$9;
            ServerPlayer $$8 = this.players.get($$7);
            if ($$8 == p_11242_ || $$8.level().dimension() != p_11247_ || !(($$9 = p_11243_ - $$8.getX()) * $$9 + ($$10 = p_11244_ - $$8.getY()) * $$10 + ($$11 = p_11245_ - $$8.getZ()) * $$11 < p_11246_ * p_11246_)) continue;
            $$8.connection.send(p_11248_);
        }
    }

    public void saveAll() {
        for (int $$0 = 0; $$0 < this.players.size(); ++$$0) {
            this.save(this.players.get($$0));
        }
    }

    public UserWhiteList getWhiteList() {
        return this.whitelist;
    }

    public String[] getWhiteListNames() {
        return this.whitelist.getUserList();
    }

    public ServerOpList getOps() {
        return this.ops;
    }

    public String[] getOpNames() {
        return this.ops.getUserList();
    }

    public void reloadWhiteList() {
    }

    public void sendLevelInfo(ServerPlayer p_11230_, ServerLevel p_11231_) {
        WorldBorder $$2 = this.server.overworld().getWorldBorder();
        p_11230_.connection.send(new ClientboundInitializeBorderPacket($$2));
        p_11230_.connection.send(new ClientboundSetTimePacket(p_11231_.getGameTime(), p_11231_.getDayTime(), p_11231_.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        p_11230_.connection.send(new ClientboundSetDefaultSpawnPositionPacket(p_11231_.getSharedSpawnPos(), p_11231_.getSharedSpawnAngle()));
        if (p_11231_.isRaining()) {
            p_11230_.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f));
            p_11230_.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, p_11231_.getRainLevel(1.0f)));
            p_11230_.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, p_11231_.getThunderLevel(1.0f)));
        }
        p_11230_.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.LEVEL_CHUNKS_LOAD_START, 0.0f));
        this.server.tickRateManager().updateJoiningPlayer(p_11230_);
    }

    public void sendAllPlayerInfo(ServerPlayer p_11293_) {
        p_11293_.inventoryMenu.sendAllDataToRemote();
        p_11293_.resetSentInfo();
        p_11293_.connection.send(new ClientboundSetCarriedItemPacket(p_11293_.getInventory().selected));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public boolean isUsingWhitelist() {
        return this.doWhiteList;
    }

    public void setUsingWhiteList(boolean p_11276_) {
        this.doWhiteList = p_11276_;
    }

    public List<ServerPlayer> getPlayersWithAddress(String p_11283_) {
        ArrayList $$1 = Lists.newArrayList();
        for (ServerPlayer $$2 : this.players) {
            if (!$$2.getIpAddress().equals(p_11283_)) continue;
            $$1.add($$2);
        }
        return $$1;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Nullable
    public CompoundTag getSingleplayerData() {
        return null;
    }

    public void setAllowCommandsForAllPlayers(boolean p_321498_) {
        this.allowCommandsForAllPlayers = p_321498_;
    }

    public void removeAll() {
        for (int $$0 = 0; $$0 < this.players.size(); ++$$0) {
            this.players.get((int)$$0).connection.disconnect(Component.translatable("multiplayer.disconnect.server_shutdown"));
        }
    }

    public void broadcastSystemMessage(Component p_240618_, boolean p_240644_) {
        this.broadcastSystemMessage(p_240618_, p_215639_ -> p_240618_, p_240644_);
    }

    public void broadcastSystemMessage(Component p_240526_, Function<ServerPlayer, Component> p_240594_, boolean p_240648_) {
        this.server.sendSystemMessage(p_240526_);
        for (ServerPlayer $$3 : this.players) {
            Component $$4 = p_240594_.apply($$3);
            if ($$4 == null) continue;
            $$3.sendSystemMessage($$4, p_240648_);
        }
    }

    public void broadcastChatMessage(PlayerChatMessage p_243229_, CommandSourceStack p_243254_, ChatType.Bound p_243255_) {
        this.broadcastChatMessage(p_243229_, p_243254_::shouldFilterMessageTo, p_243254_.getPlayer(), p_243255_);
    }

    public void broadcastChatMessage(PlayerChatMessage p_243264_, ServerPlayer p_243234_, ChatType.Bound p_243204_) {
        this.broadcastChatMessage(p_243264_, p_243234_::shouldFilterMessageTo, p_243234_, p_243204_);
    }

    private void broadcastChatMessage(PlayerChatMessage p_249952_, Predicate<ServerPlayer> p_250784_, @Nullable ServerPlayer p_249623_, ChatType.Bound p_250276_) {
        boolean $$4 = this.verifyChatTrusted(p_249952_);
        this.server.logChatMessage(p_249952_.decoratedContent(), p_250276_, $$4 ? null : "Not Secure");
        OutgoingChatMessage $$5 = OutgoingChatMessage.create(p_249952_);
        boolean $$6 = false;
        for (ServerPlayer $$7 : this.players) {
            boolean $$8 = p_250784_.test($$7);
            $$7.sendChatMessage($$5, $$8, p_250276_);
            $$6 |= $$8 && p_249952_.isFullyFiltered();
        }
        if ($$6 && p_249623_ != null) {
            p_249623_.sendSystemMessage(CHAT_FILTERED_FULL);
        }
    }

    private boolean verifyChatTrusted(PlayerChatMessage p_251384_) {
        return p_251384_.hasSignature() && !p_251384_.hasExpiredServer(Instant.now());
    }

    public ServerStatsCounter getPlayerStats(Player p_11240_) {
        UUID $$1 = p_11240_.getUUID();
        ServerStatsCounter $$2 = this.stats.get($$1);
        if ($$2 == null) {
            File $$5;
            Path $$6;
            File $$3 = this.server.getWorldPath(LevelResource.PLAYER_STATS_DIR).toFile();
            File $$4 = new File($$3, String.valueOf($$1) + ".json");
            if (!$$4.exists() && FileUtil.isPathNormalized($$6 = ($$5 = new File($$3, p_11240_.getName().getString() + ".json")).toPath()) && FileUtil.isPathPortable($$6) && $$6.startsWith($$3.getPath()) && $$5.isFile()) {
                $$5.renameTo($$4);
            }
            $$2 = new ServerStatsCounter(this.server, $$4);
            this.stats.put($$1, $$2);
        }
        return $$2;
    }

    public PlayerAdvancements getPlayerAdvancements(ServerPlayer p_11297_) {
        UUID $$1 = p_11297_.getUUID();
        PlayerAdvancements $$2 = this.advancements.get($$1);
        if ($$2 == null) {
            Path $$3 = this.server.getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR).resolve(String.valueOf($$1) + ".json");
            $$2 = new PlayerAdvancements(this.server.getFixerUpper(), this, this.server.getAdvancements(), $$3, p_11297_);
            this.advancements.put($$1, $$2);
        }
        $$2.setPlayer(p_11297_);
        return $$2;
    }

    public void setViewDistance(int p_11218_) {
        this.viewDistance = p_11218_;
        this.broadcastAll(new ClientboundSetChunkCacheRadiusPacket(p_11218_));
        for (ServerLevel $$1 : this.server.getAllLevels()) {
            if ($$1 == null) continue;
            $$1.getChunkSource().setViewDistance(p_11218_);
        }
    }

    public void setSimulationDistance(int p_184212_) {
        this.simulationDistance = p_184212_;
        this.broadcastAll(new ClientboundSetSimulationDistancePacket(p_184212_));
        for (ServerLevel $$1 : this.server.getAllLevels()) {
            if ($$1 == null) continue;
            $$1.getChunkSource().setSimulationDistance(p_184212_);
        }
    }

    public List<ServerPlayer> getPlayers() {
        return this.players;
    }

    @Nullable
    public ServerPlayer getPlayer(UUID p_11260_) {
        return this.playersByUUID.get(p_11260_);
    }

    public boolean canBypassPlayerLimit(GameProfile p_11298_) {
        return false;
    }

    public void reloadResources() {
        for (PlayerAdvancements $$0 : this.advancements.values()) {
            $$0.reload(this.server.getAdvancements());
        }
        this.broadcastAll(new ClientboundUpdateTagsPacket(TagNetworkSerialization.serializeTagsToNetwork(this.registries)));
        ClientboundUpdateRecipesPacket $$1 = new ClientboundUpdateRecipesPacket(this.server.getRecipeManager().getOrderedRecipes());
        for (ServerPlayer $$2 : this.players) {
            $$2.connection.send($$1);
            $$2.getRecipeBook().sendInitialRecipeBook($$2);
        }
    }

    public boolean isAllowCommandsForAllPlayers() {
        return this.allowCommandsForAllPlayers;
    }
}

