/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class EntityZombieVillagerTypeFix
extends NamedEntityFix {
    private static final int PROFESSION_MAX = 6;
    private static final RandomSource RANDOM = RandomSource.create();

    public EntityZombieVillagerTypeFix(Schema p_15806_, boolean p_15807_) {
        super(p_15806_, p_15807_, "EntityZombieVillagerTypeFix", References.ENTITY, "Zombie");
    }

    public Dynamic<?> fixTag(Dynamic<?> p_15813_) {
        if (p_15813_.get("IsVillager").asBoolean(false)) {
            if (p_15813_.get("ZombieType").result().isEmpty()) {
                int $$1 = this.getVillagerProfession(p_15813_.get("VillagerProfession").asInt(-1));
                if ($$1 == -1) {
                    $$1 = this.getVillagerProfession(RANDOM.nextInt(6));
                }
                p_15813_ = p_15813_.set("ZombieType", p_15813_.createInt($$1));
            }
            p_15813_ = p_15813_.remove("IsVillager");
        }
        return p_15813_;
    }

    private int getVillagerProfession(int p_15809_) {
        if (p_15809_ < 0 || p_15809_ >= 6) {
            return -1;
        }
        return p_15809_;
    }

    @Override
    protected Typed<?> fix(Typed<?> p_15811_) {
        return p_15811_.update(DSL.remainderFinder(), this::fixTag);
    }
}

