/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.StringRepresentable;

public enum EquipmentSlot implements StringRepresentable
{
    MAINHAND(Type.HAND, 0, 0, "mainhand"),
    OFFHAND(Type.HAND, 1, 5, "offhand"),
    FEET(Type.ARMOR, 0, 1, "feet"),
    LEGS(Type.ARMOR, 1, 2, "legs"),
    CHEST(Type.ARMOR, 2, 3, "chest"),
    HEAD(Type.ARMOR, 3, 4, "head"),
    BODY(Type.BODY, 0, 6, "body");

    public static final StringRepresentable.EnumCodec<EquipmentSlot> CODEC;
    private final Type type;
    private final int index;
    private final int filterFlag;
    private final String name;

    private EquipmentSlot(Type p_20739_, int p_20740_, int p_20741_, String p_20742_) {
        this.type = p_20739_;
        this.index = p_20740_;
        this.filterFlag = p_20741_;
        this.name = p_20742_;
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndex(int p_147069_) {
        return p_147069_ + this.index;
    }

    public int getFilterFlag() {
        return this.filterFlag;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArmor() {
        return this.type == Type.ARMOR;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public static EquipmentSlot byName(String p_20748_) {
        EquipmentSlot $$1 = CODEC.byName(p_20748_);
        if ($$1 != null) {
            return $$1;
        }
        throw new IllegalArgumentException("Invalid slot '" + p_20748_ + "'");
    }

    public static EquipmentSlot byTypeAndIndex(Type p_20745_, int p_20746_) {
        for (EquipmentSlot $$2 : EquipmentSlot.values()) {
            if ($$2.getType() != p_20745_ || $$2.getIndex() != p_20746_) continue;
            return $$2;
        }
        throw new IllegalArgumentException("Invalid slot '" + String.valueOf((Object)p_20745_) + "': " + p_20746_);
    }

    static {
        CODEC = StringRepresentable.fromEnum(EquipmentSlot::values);
    }

    public static enum Type {
        HAND,
        ARMOR,
        BODY;

    }
}

