/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.slf4j.Logger;

public abstract class LivingEntity
extends Entity
implements Attackable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_ACTIVE_EFFECTS = "active_effects";
    private static final UUID SPEED_MODIFIER_SOUL_SPEED_UUID = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID SPEED_MODIFIER_POWDER_SNOW_UUID = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D"), "Sprinting speed boost", 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final int HAND_SLOTS = 2;
    public static final int ARMOR_SLOTS = 4;
    public static final int EQUIPMENT_SLOT_OFFSET = 98;
    public static final int ARMOR_SLOT_OFFSET = 100;
    public static final int BODY_ARMOR_OFFSET = 105;
    public static final int SWING_DURATION = 6;
    public static final int PLAYER_HURT_EXPERIENCE_TIME = 100;
    private static final int DAMAGE_SOURCE_TIMEOUT = 40;
    public static final double MIN_MOVEMENT_DISTANCE = 0.003;
    public static final double DEFAULT_BASE_GRAVITY = 0.08;
    public static final int DEATH_DURATION = 20;
    private static final int TICKS_PER_ELYTRA_FREE_FALL_EVENT = 10;
    private static final int FREE_FALL_EVENTS_PER_ELYTRA_BREAK = 2;
    public static final int USE_ITEM_INTERVAL = 4;
    public static final float BASE_JUMP_POWER = 0.42f;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 128.0;
    protected static final int LIVING_ENTITY_FLAG_IS_USING = 1;
    protected static final int LIVING_ENTITY_FLAG_OFF_HAND = 2;
    protected static final int LIVING_ENTITY_FLAG_SPIN_ATTACK = 4;
    protected static final EntityDataAccessor<Byte> DATA_LIVING_ENTITY_FLAGS = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Float> DATA_HEALTH_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<List<ParticleOptions>> DATA_EFFECT_PARTICLES = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.PARTICLES);
    private static final EntityDataAccessor<Boolean> DATA_EFFECT_AMBIENCE_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_ARROW_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_STINGER_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<BlockPos>> SLEEPING_POS_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final int PARTICLE_FREQUENCY_WHEN_INVISIBLE = 15;
    protected static final EntityDimensions SLEEPING_DIMENSIONS = EntityDimensions.fixed(0.2f, 0.2f).withEyeHeight(0.2f);
    public static final float EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT = 0.5f;
    public static final float DEFAULT_BABY_SCALE = 0.5f;
    private static final float ITEM_USE_EFFECT_START_FRACTION = 0.21875f;
    private final AttributeMap attributes;
    private final CombatTracker combatTracker = new CombatTracker(this);
    private final Map<Holder<MobEffect>, MobEffectInstance> activeEffects = Maps.newHashMap();
    private final NonNullList<ItemStack> lastHandItemStacks = NonNullList.withSize(2, ItemStack.EMPTY);
    private final NonNullList<ItemStack> lastArmorItemStacks = NonNullList.withSize(4, ItemStack.EMPTY);
    private ItemStack lastBodyItemStack = ItemStack.EMPTY;
    public boolean swinging;
    private boolean discardFriction = false;
    public InteractionHand swingingArm;
    public int swingTime;
    public int removeArrowTime;
    public int removeStingerTime;
    public int hurtTime;
    public int hurtDuration;
    public int deathTime;
    public float oAttackAnim;
    public float attackAnim;
    protected int attackStrengthTicker;
    public final WalkAnimationState walkAnimation = new WalkAnimationState();
    public final int invulnerableDuration = 20;
    public final float timeOffs;
    public final float rotA;
    public float yBodyRot;
    public float yBodyRotO;
    public float yHeadRot;
    public float yHeadRotO;
    @Nullable
    protected Player lastHurtByPlayer;
    protected int lastHurtByPlayerTime;
    protected boolean dead;
    protected int noActionTime;
    protected float oRun;
    protected float run;
    protected float animStep;
    protected float animStepO;
    protected float rotOffs;
    protected int deathScore;
    protected float lastHurt;
    protected boolean jumping;
    public float xxa;
    public float yya;
    public float zza;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    protected double lerpYHeadRot;
    protected int lerpHeadSteps;
    private boolean effectsDirty = true;
    @Nullable
    private LivingEntity lastHurtByMob;
    private int lastHurtByMobTimestamp;
    private LivingEntity lastHurtMob;
    private int lastHurtMobTimestamp;
    private float speed;
    private int noJumpDelay;
    private float absorptionAmount;
    protected ItemStack useItem = ItemStack.EMPTY;
    protected int useItemRemaining;
    protected int fallFlyTicks;
    private BlockPos lastPos;
    private Optional<BlockPos> lastClimbablePos = Optional.empty();
    @Nullable
    private DamageSource lastDamageSource;
    private long lastDamageStamp;
    protected int autoSpinAttackTicks;
    private float swimAmount;
    private float swimAmountO;
    protected Brain<?> brain;
    private boolean skipDropExperience;
    protected float appliedScale = 1.0f;

    protected LivingEntity(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
        this.attributes = new AttributeMap(DefaultAttributes.getSupplier(p_20966_));
        this.setHealth(this.getMaxHealth());
        this.blocksBuilding = true;
        this.rotA = (float)((Math.random() + 1.0) * (double)0.01f);
        this.reapplyPosition();
        this.timeOffs = (float)Math.random() * 12398.0f;
        this.setYRot((float)(Math.random() * 6.2831854820251465));
        this.yHeadRot = this.getYRot();
        NbtOps $$2 = NbtOps.INSTANCE;
        this.brain = this.makeBrain(new Dynamic((DynamicOps)$$2, (Object)((Tag)$$2.createMap((Map)ImmutableMap.of((Object)$$2.createString("memories"), (Object)((Tag)$$2.emptyMap()))))));
    }

    public Brain<?> getBrain() {
        return this.brain;
    }

    protected Brain.Provider<?> brainProvider() {
        return Brain.provider(ImmutableList.of(), ImmutableList.of());
    }

    protected Brain<?> makeBrain(Dynamic<?> p_21069_) {
        return this.brainProvider().makeBrain(p_21069_);
    }

    @Override
    public void kill() {
        this.hurt(this.damageSources().genericKill(), Float.MAX_VALUE);
    }

    public boolean canAttackType(EntityType<?> p_21032_) {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326178_) {
        p_326178_.define(DATA_LIVING_ENTITY_FLAGS, (byte)0);
        p_326178_.define(DATA_EFFECT_PARTICLES, List.of());
        p_326178_.define(DATA_EFFECT_AMBIENCE_ID, false);
        p_326178_.define(DATA_ARROW_COUNT_ID, 0);
        p_326178_.define(DATA_STINGER_COUNT_ID, 0);
        p_326178_.define(DATA_HEALTH_ID, Float.valueOf(1.0f));
        p_326178_.define(SLEEPING_POS_ID, Optional.empty());
    }

    public static AttributeSupplier.Builder createLivingAttributes() {
        return AttributeSupplier.builder().add(Attributes.MAX_HEALTH).add(Attributes.KNOCKBACK_RESISTANCE).add(Attributes.MOVEMENT_SPEED).add(Attributes.ARMOR).add(Attributes.ARMOR_TOUGHNESS).add(Attributes.MAX_ABSORPTION).add(Attributes.STEP_HEIGHT).add(Attributes.SCALE).add(Attributes.GRAVITY).add(Attributes.SAFE_FALL_DISTANCE).add(Attributes.FALL_DAMAGE_MULTIPLIER).add(Attributes.JUMP_STRENGTH);
    }

    @Override
    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
        if (!this.isInWater()) {
            this.updateInWaterStateAndDoWaterCurrentPushing();
        }
        if (!this.level().isClientSide && p_20991_ && this.fallDistance > 0.0f) {
            this.removeSoulSpeed();
            this.tryAddSoulSpeed();
            double $$4 = this.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
            if ((double)this.fallDistance > $$4 && !p_20992_.isAir()) {
                double $$5 = this.getX();
                double $$6 = this.getY();
                double $$7 = this.getZ();
                BlockPos $$8 = this.blockPosition();
                if (p_20993_.getX() != $$8.getX() || p_20993_.getZ() != $$8.getZ()) {
                    double $$9 = $$5 - (double)p_20993_.getX() - 0.5;
                    double $$10 = $$7 - (double)p_20993_.getZ() - 0.5;
                    double $$11 = Math.max(Math.abs($$9), Math.abs($$10));
                    $$5 = (double)p_20993_.getX() + 0.5 + $$9 / $$11 * 0.5;
                    $$7 = (double)p_20993_.getZ() + 0.5 + $$10 / $$11 * 0.5;
                }
                float $$12 = Mth.ceil((double)this.fallDistance - $$4);
                double $$13 = Math.min((double)(0.2f + $$12 / 15.0f), 2.5);
                int $$14 = (int)(150.0 * $$13);
                ((ServerLevel)this.level()).sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, p_20992_), $$5, $$6, $$7, $$14, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.checkFallDamage(p_20990_, p_20991_, p_20992_, p_20993_);
        if (p_20991_) {
            this.lastClimbablePos = Optional.empty();
        }
    }

    public final boolean canBreatheUnderwater() {
        return this.getType().is(EntityTypeTags.CAN_BREATHE_UNDER_WATER);
    }

    public float getSwimAmount(float p_20999_) {
        return Mth.lerp(p_20999_, this.swimAmountO, this.swimAmount);
    }

    @Override
    public void baseTick() {
        this.oAttackAnim = this.attackAnim;
        if (this.firstTick) {
            this.getSleepingPos().ifPresent(this::setPosToBed);
        }
        if (this.canSpawnSoulSpeedParticle()) {
            this.spawnSoulSpeedParticle();
        }
        super.baseTick();
        this.level().getProfiler().push("livingEntityBaseTick");
        if (this.fireImmune() || this.level().isClientSide) {
            this.clearFire();
        }
        if (this.isAlive()) {
            BlockPos $$9;
            boolean $$0 = this instanceof Player;
            if (!this.level().isClientSide) {
                double $$2;
                double $$1;
                if (this.isInWall()) {
                    this.hurt(this.damageSources().inWall(), 1.0f);
                } else if ($$0 && !this.level().getWorldBorder().isWithinBounds(this.getBoundingBox()) && ($$1 = this.level().getWorldBorder().getDistanceToBorder(this) + this.level().getWorldBorder().getDamageSafeZone()) < 0.0 && ($$2 = this.level().getWorldBorder().getDamagePerBlock()) > 0.0) {
                    this.hurt(this.damageSources().outOfBorder(), Math.max(1, Mth.floor(-$$1 * $$2)));
                }
            }
            if (this.isEyeInFluid(FluidTags.WATER) && !this.level().getBlockState(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                boolean $$3;
                boolean bl = $$3 = !this.canBreatheUnderwater() && !MobEffectUtil.hasWaterBreathing(this) && (!$$0 || !((Player)this).getAbilities().invulnerable);
                if ($$3) {
                    this.setAirSupply(this.decreaseAirSupply(this.getAirSupply()));
                    if (this.getAirSupply() == -20) {
                        this.setAirSupply(0);
                        Vec3 $$4 = this.getDeltaMovement();
                        for (int $$5 = 0; $$5 < 8; ++$$5) {
                            double $$6 = this.random.nextDouble() - this.random.nextDouble();
                            double $$7 = this.random.nextDouble() - this.random.nextDouble();
                            double $$8 = this.random.nextDouble() - this.random.nextDouble();
                            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + $$6, this.getY() + $$7, this.getZ() + $$8, $$4.x, $$4.y, $$4.z);
                        }
                        this.hurt(this.damageSources().drown(), 2.0f);
                    }
                }
                if (!this.level().isClientSide && this.isPassenger() && this.getVehicle() != null && this.getVehicle().dismountsUnderwater()) {
                    this.stopRiding();
                }
            } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
            }
            if (!this.level().isClientSide && !Objects.equal((Object)this.lastPos, (Object)($$9 = this.blockPosition()))) {
                this.lastPos = $$9;
                this.onChangedBlock($$9);
            }
        }
        if (this.isAlive() && (this.isInWaterRainOrBubble() || this.isInPowderSnow)) {
            this.extinguishFire();
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0 && !(this instanceof ServerPlayer)) {
            --this.invulnerableTime;
        }
        if (this.isDeadOrDying() && this.level().shouldTickDeath(this)) {
            this.tickDeath();
        }
        if (this.lastHurtByPlayerTime > 0) {
            --this.lastHurtByPlayerTime;
        } else {
            this.lastHurtByPlayer = null;
        }
        if (this.lastHurtMob != null && !this.lastHurtMob.isAlive()) {
            this.lastHurtMob = null;
        }
        if (this.lastHurtByMob != null) {
            if (!this.lastHurtByMob.isAlive()) {
                this.setLastHurtByMob(null);
            } else if (this.tickCount - this.lastHurtByMobTimestamp > 100) {
                this.setLastHurtByMob(null);
            }
        }
        this.tickEffects();
        this.animStepO = this.animStep;
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.level().getProfiler().pop();
    }

    public boolean canSpawnSoulSpeedParticle() {
        return this.tickCount % 5 == 0 && this.getDeltaMovement().x != 0.0 && this.getDeltaMovement().z != 0.0 && !this.isSpectator() && EnchantmentHelper.hasSoulSpeed(this) && this.onSoulSpeedBlock();
    }

    protected void spawnSoulSpeedParticle() {
        Vec3 $$0 = this.getDeltaMovement();
        this.level().addParticle(ParticleTypes.SOUL, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + 0.1, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), $$0.x * -0.2, 0.1, $$0.z * -0.2);
        float $$1 = this.random.nextFloat() * 0.4f + this.random.nextFloat() > 0.9f ? 0.6f : 0.0f;
        this.playSound(SoundEvents.SOUL_ESCAPE, $$1, 0.6f + this.random.nextFloat() * 0.4f);
    }

    protected boolean onSoulSpeedBlock() {
        return this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).is(BlockTags.SOUL_SPEED_BLOCKS);
    }

    @Override
    protected float getBlockSpeedFactor() {
        if (this.onSoulSpeedBlock() && EnchantmentHelper.getEnchantmentLevel(Enchantments.SOUL_SPEED, this) > 0) {
            return 1.0f;
        }
        return super.getBlockSpeedFactor();
    }

    protected boolean shouldRemoveSoulSpeed(BlockState p_21140_) {
        return !p_21140_.isAir() || this.isFallFlying();
    }

    protected void removeSoulSpeed() {
        AttributeInstance $$0 = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if ($$0 == null) {
            return;
        }
        if ($$0.getModifier(SPEED_MODIFIER_SOUL_SPEED_UUID) != null) {
            $$0.removeModifier(SPEED_MODIFIER_SOUL_SPEED_UUID);
        }
    }

    protected void tryAddSoulSpeed() {
        int $$0;
        if (!this.getBlockStateOnLegacy().isAir() && ($$0 = EnchantmentHelper.getEnchantmentLevel(Enchantments.SOUL_SPEED, this)) > 0 && this.onSoulSpeedBlock()) {
            AttributeInstance $$1 = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if ($$1 == null) {
                return;
            }
            $$1.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_SOUL_SPEED_UUID, "Soul speed boost", 0.03f * (1.0f + (float)$$0 * 0.35f), AttributeModifier.Operation.ADD_VALUE));
            if (this.getRandom().nextFloat() < 0.04f) {
                ItemStack $$2 = this.getItemBySlot(EquipmentSlot.FEET);
                $$2.hurtAndBreak(1, this, EquipmentSlot.FEET);
            }
        }
    }

    protected void removeFrost() {
        AttributeInstance $$0 = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if ($$0 == null) {
            return;
        }
        if ($$0.getModifier(SPEED_MODIFIER_POWDER_SNOW_UUID) != null) {
            $$0.removeModifier(SPEED_MODIFIER_POWDER_SNOW_UUID);
        }
    }

    protected void tryAddFrost() {
        int $$0;
        if (!this.getBlockStateOnLegacy().isAir() && ($$0 = this.getTicksFrozen()) > 0) {
            AttributeInstance $$1 = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if ($$1 == null) {
                return;
            }
            float $$2 = -0.05f * this.getPercentFrozen();
            $$1.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_UUID, "Powder snow slow", $$2, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    protected void onChangedBlock(BlockPos p_21175_) {
        int $$1 = EnchantmentHelper.getEnchantmentLevel(Enchantments.FROST_WALKER, this);
        if ($$1 > 0) {
            FrostWalkerEnchantment.onEntityMoved(this, this.level(), p_21175_, $$1);
        }
        if (this.shouldRemoveSoulSpeed(this.getBlockStateOnLegacy())) {
            this.removeSoulSpeed();
        }
        this.tryAddSoulSpeed();
    }

    public boolean isBaby() {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.5f : 1.0f;
    }

    public float getScale() {
        AttributeMap $$0 = this.getAttributes();
        if ($$0 == null) {
            return 1.0f;
        }
        return this.sanitizeScale((float)$$0.getValue(Attributes.SCALE));
    }

    protected float sanitizeScale(float p_320290_) {
        return p_320290_;
    }

    protected boolean isAffectedByFluids() {
        return true;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent(this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean shouldDropExperience() {
        return !this.isBaby();
    }

    protected boolean shouldDropLoot() {
        return !this.isBaby();
    }

    protected int decreaseAirSupply(int p_21303_) {
        int $$1 = EnchantmentHelper.getRespiration(this);
        if ($$1 > 0 && this.random.nextInt($$1 + 1) > 0) {
            return p_21303_;
        }
        return p_21303_ - 1;
    }

    protected int increaseAirSupply(int p_21307_) {
        return Math.min(p_21307_ + 4, this.getMaxAirSupply());
    }

    public int getExperienceReward() {
        return 0;
    }

    protected boolean isAlwaysExperienceDropper() {
        return false;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    @Nullable
    public LivingEntity getLastHurtByMob() {
        return this.lastHurtByMob;
    }

    @Override
    public LivingEntity getLastAttacker() {
        return this.getLastHurtByMob();
    }

    public int getLastHurtByMobTimestamp() {
        return this.lastHurtByMobTimestamp;
    }

    public void setLastHurtByPlayer(@Nullable Player p_21248_) {
        this.lastHurtByPlayer = p_21248_;
        this.lastHurtByPlayerTime = this.tickCount;
    }

    public void setLastHurtByMob(@Nullable LivingEntity p_21039_) {
        this.lastHurtByMob = p_21039_;
        this.lastHurtByMobTimestamp = this.tickCount;
    }

    @Nullable
    public LivingEntity getLastHurtMob() {
        return this.lastHurtMob;
    }

    public int getLastHurtMobTimestamp() {
        return this.lastHurtMobTimestamp;
    }

    public void setLastHurtMob(Entity p_21336_) {
        this.lastHurtMob = p_21336_ instanceof LivingEntity ? (LivingEntity)p_21336_ : null;
        this.lastHurtMobTimestamp = this.tickCount;
    }

    public int getNoActionTime() {
        return this.noActionTime;
    }

    public void setNoActionTime(int p_21311_) {
        this.noActionTime = p_21311_;
    }

    public boolean shouldDiscardFriction() {
        return this.discardFriction;
    }

    public void setDiscardFriction(boolean p_147245_) {
        this.discardFriction = p_147245_;
    }

    protected boolean doesEmitEquipEvent(EquipmentSlot p_217035_) {
        return true;
    }

    public void onEquipItem(EquipmentSlot p_238393_, ItemStack p_238394_, ItemStack p_238395_) {
        boolean $$3;
        boolean bl = $$3 = p_238395_.isEmpty() && p_238394_.isEmpty();
        if ($$3 || ItemStack.isSameItemSameComponents(p_238394_, p_238395_) || this.firstTick) {
            return;
        }
        Equipable $$4 = Equipable.get(p_238395_);
        if (!this.level().isClientSide() && !this.isSpectator()) {
            if (!this.isSilent() && $$4 != null && $$4.getEquipmentSlot() == p_238393_) {
                this.level().playSeededSound(null, this.getX(), this.getY(), this.getZ(), $$4.getEquipSound(), this.getSoundSource(), 1.0f, 1.0f, this.random.nextLong());
            }
            if (this.doesEmitEquipEvent(p_238393_)) {
                this.gameEvent($$4 != null ? GameEvent.EQUIP : GameEvent.UNEQUIP);
            }
        }
    }

    @Override
    public void remove(Entity.RemovalReason p_276115_) {
        if (p_276115_ == Entity.RemovalReason.KILLED || p_276115_ == Entity.RemovalReason.DISCARDED) {
            for (MobEffectInstance $$1 : this.getActiveEffects()) {
                $$1.onMobRemoved(this, p_276115_);
            }
        }
        super.remove(p_276115_);
        this.brain.clearMemories();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_21145_) {
        p_21145_.putFloat("Health", this.getHealth());
        p_21145_.putShort("HurtTime", (short)this.hurtTime);
        p_21145_.putInt("HurtByTimestamp", this.lastHurtByMobTimestamp);
        p_21145_.putShort("DeathTime", (short)this.deathTime);
        p_21145_.putFloat("AbsorptionAmount", this.getAbsorptionAmount());
        p_21145_.put("Attributes", this.getAttributes().save());
        if (!this.activeEffects.isEmpty()) {
            ListTag $$1 = new ListTag();
            for (MobEffectInstance $$2 : this.activeEffects.values()) {
                $$1.add($$2.save());
            }
            p_21145_.put(TAG_ACTIVE_EFFECTS, $$1);
        }
        p_21145_.putBoolean("FallFlying", this.isFallFlying());
        this.getSleepingPos().ifPresent(p_21099_ -> {
            p_21145_.putInt("SleepingX", p_21099_.getX());
            p_21145_.putInt("SleepingY", p_21099_.getY());
            p_21145_.putInt("SleepingZ", p_21099_.getZ());
        });
        DataResult<Tag> $$3 = this.brain.serializeStart(NbtOps.INSTANCE);
        $$3.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_21102_ -> p_21145_.put("Brain", (Tag)p_21102_));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_21096_) {
        this.internalSetAbsorptionAmount(p_21096_.getFloat("AbsorptionAmount"));
        if (p_21096_.contains("Attributes", 9) && this.level() != null && !this.level().isClientSide) {
            this.getAttributes().load(p_21096_.getList("Attributes", 10));
        }
        if (p_21096_.contains(TAG_ACTIVE_EFFECTS, 9)) {
            ListTag $$1 = p_21096_.getList(TAG_ACTIVE_EFFECTS, 10);
            for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
                CompoundTag $$3 = $$1.getCompound($$2);
                MobEffectInstance $$4 = MobEffectInstance.load($$3);
                if ($$4 == null) continue;
                this.activeEffects.put($$4.getEffect(), $$4);
            }
        }
        if (p_21096_.contains("Health", 99)) {
            this.setHealth(p_21096_.getFloat("Health"));
        }
        this.hurtTime = p_21096_.getShort("HurtTime");
        this.deathTime = p_21096_.getShort("DeathTime");
        this.lastHurtByMobTimestamp = p_21096_.getInt("HurtByTimestamp");
        if (p_21096_.contains("Team", 8)) {
            boolean $$8;
            String $$5 = p_21096_.getString("Team");
            Scoreboard $$6 = this.level().getScoreboard();
            PlayerTeam $$7 = $$6.getPlayerTeam($$5);
            boolean bl = $$8 = $$7 != null && $$6.addPlayerToTeam(this.getStringUUID(), $$7);
            if (!$$8) {
                LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", (Object)$$5);
            }
        }
        if (p_21096_.getBoolean("FallFlying")) {
            this.setSharedFlag(7, true);
        }
        if (p_21096_.contains("SleepingX", 99) && p_21096_.contains("SleepingY", 99) && p_21096_.contains("SleepingZ", 99)) {
            BlockPos $$9 = new BlockPos(p_21096_.getInt("SleepingX"), p_21096_.getInt("SleepingY"), p_21096_.getInt("SleepingZ"));
            this.setSleepingPos($$9);
            this.entityData.set(DATA_POSE, Pose.SLEEPING);
            if (!this.firstTick) {
                this.setPosToBed($$9);
            }
        }
        if (p_21096_.contains("Brain", 10)) {
            this.brain = this.makeBrain(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_21096_.get("Brain")));
        }
    }

    protected void tickEffects() {
        List<ParticleOptions> $$3;
        Iterator<Holder<MobEffect>> $$0 = this.activeEffects.keySet().iterator();
        try {
            while ($$0.hasNext()) {
                Holder<MobEffect> $$1 = $$0.next();
                MobEffectInstance $$2 = this.activeEffects.get($$1);
                if (!$$2.tick(this, () -> this.onEffectUpdated($$2, true, null))) {
                    if (this.level().isClientSide) continue;
                    $$0.remove();
                    this.onEffectRemoved($$2);
                    continue;
                }
                if ($$2.getDuration() % 600 != 0) continue;
                this.onEffectUpdated($$2, false, null);
            }
        }
        catch (ConcurrentModificationException $$1) {
            // empty catch block
        }
        if (this.effectsDirty) {
            if (!this.level().isClientSide) {
                this.updateInvisibilityStatus();
                this.updateGlowingStatus();
            }
            this.effectsDirty = false;
        }
        if (!($$3 = this.entityData.get(DATA_EFFECT_PARTICLES)).isEmpty()) {
            int $$6;
            boolean $$4 = this.entityData.get(DATA_EFFECT_AMBIENCE_ID);
            int $$5 = this.isInvisible() ? 15 : 4;
            int n = $$6 = $$4 ? 5 : 1;
            if (this.random.nextInt($$5 * $$6) == 0) {
                this.level().addParticle(Util.getRandom($$3, this.random), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 1.0, 1.0, 1.0);
            }
        }
    }

    protected void updateInvisibilityStatus() {
        if (this.activeEffects.isEmpty()) {
            this.removeEffectParticles();
            this.setInvisible(false);
            return;
        }
        this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
        this.updateSynchronizedMobEffectParticles();
    }

    private void updateSynchronizedMobEffectParticles() {
        List<ParticleOptions> $$0 = this.activeEffects.values().stream().filter(MobEffectInstance::isVisible).map(MobEffectInstance::getParticleOptions).toList();
        this.entityData.set(DATA_EFFECT_PARTICLES, $$0);
        this.entityData.set(DATA_EFFECT_AMBIENCE_ID, LivingEntity.areAllEffectsAmbient(this.activeEffects.values()));
    }

    private void updateGlowingStatus() {
        boolean $$0 = this.isCurrentlyGlowing();
        if (this.getSharedFlag(6) != $$0) {
            this.setSharedFlag(6, $$0);
        }
    }

    public double getVisibilityPercent(@Nullable Entity p_20969_) {
        double $$1 = 1.0;
        if (this.isDiscrete()) {
            $$1 *= 0.8;
        }
        if (this.isInvisible()) {
            float $$2 = this.getArmorCoverPercentage();
            if ($$2 < 0.1f) {
                $$2 = 0.1f;
            }
            $$1 *= 0.7 * (double)$$2;
        }
        if (p_20969_ != null) {
            ItemStack $$3 = this.getItemBySlot(EquipmentSlot.HEAD);
            EntityType<?> $$4 = p_20969_.getType();
            if ($$4 == EntityType.SKELETON && $$3.is(Items.SKELETON_SKULL) || $$4 == EntityType.ZOMBIE && $$3.is(Items.ZOMBIE_HEAD) || $$4 == EntityType.PIGLIN && $$3.is(Items.PIGLIN_HEAD) || $$4 == EntityType.PIGLIN_BRUTE && $$3.is(Items.PIGLIN_HEAD) || $$4 == EntityType.CREEPER && $$3.is(Items.CREEPER_HEAD)) {
                $$1 *= 0.5;
            }
        }
        return $$1;
    }

    public boolean canAttack(LivingEntity p_21171_) {
        if (p_21171_ instanceof Player && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        return p_21171_.canBeSeenAsEnemy();
    }

    public boolean canAttack(LivingEntity p_21041_, TargetingConditions p_21042_) {
        return p_21042_.test(this, p_21041_);
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isInvulnerable() && this.canBeSeenByAnyone();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isSpectator() && this.isAlive();
    }

    public static boolean areAllEffectsAmbient(Collection<MobEffectInstance> p_21180_) {
        for (MobEffectInstance $$1 : p_21180_) {
            if (!$$1.isVisible() || $$1.isAmbient()) continue;
            return false;
        }
        return true;
    }

    protected void removeEffectParticles() {
        this.entityData.set(DATA_EFFECT_PARTICLES, List.of());
    }

    public boolean removeAllEffects() {
        if (this.level().isClientSide) {
            return false;
        }
        Iterator<MobEffectInstance> $$0 = this.activeEffects.values().iterator();
        boolean $$1 = false;
        while ($$0.hasNext()) {
            this.onEffectRemoved($$0.next());
            $$0.remove();
            $$1 = true;
        }
        return $$1;
    }

    public Collection<MobEffectInstance> getActiveEffects() {
        return this.activeEffects.values();
    }

    public Map<Holder<MobEffect>, MobEffectInstance> getActiveEffectsMap() {
        return this.activeEffects;
    }

    public boolean hasEffect(Holder<MobEffect> p_316430_) {
        return this.activeEffects.containsKey(p_316430_);
    }

    @Nullable
    public MobEffectInstance getEffect(Holder<MobEffect> p_316375_) {
        return this.activeEffects.get(p_316375_);
    }

    public final boolean addEffect(MobEffectInstance p_21165_) {
        return this.addEffect(p_21165_, null);
    }

    public boolean addEffect(MobEffectInstance p_147208_, @Nullable Entity p_147209_) {
        if (!this.canBeAffected(p_147208_)) {
            return false;
        }
        MobEffectInstance $$2 = this.activeEffects.get(p_147208_.getEffect());
        boolean $$3 = false;
        if ($$2 == null) {
            this.activeEffects.put(p_147208_.getEffect(), p_147208_);
            this.onEffectAdded(p_147208_, p_147209_);
            $$3 = true;
            p_147208_.onEffectAdded(this);
        } else if ($$2.update(p_147208_)) {
            this.onEffectUpdated($$2, true, p_147209_);
            $$3 = true;
        }
        p_147208_.onEffectStarted(this);
        return $$3;
    }

    public boolean canBeAffected(MobEffectInstance p_21197_) {
        if (this.getType().is(EntityTypeTags.IMMUNE_TO_INFESTED)) {
            return !p_21197_.is(MobEffects.INFESTED);
        }
        if (this.getType().is(EntityTypeTags.IMMUNE_TO_OOZING)) {
            return !p_21197_.is(MobEffects.OOZING);
        }
        if (this.getType().is(EntityTypeTags.IGNORES_POISON_AND_REGEN)) {
            return !p_21197_.is(MobEffects.REGENERATION) && !p_21197_.is(MobEffects.POISON);
        }
        return true;
    }

    public void forceAddEffect(MobEffectInstance p_147216_, @Nullable Entity p_147217_) {
        if (!this.canBeAffected(p_147216_)) {
            return;
        }
        MobEffectInstance $$2 = this.activeEffects.put(p_147216_.getEffect(), p_147216_);
        if ($$2 == null) {
            this.onEffectAdded(p_147216_, p_147217_);
        } else {
            p_147216_.copyBlendState($$2);
            this.onEffectUpdated(p_147216_, true, p_147217_);
        }
    }

    public boolean isInvertedHealAndHarm() {
        return this.getType().is(EntityTypeTags.INVERTED_HEALING_AND_HARM);
    }

    @Nullable
    public MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> p_316233_) {
        return this.activeEffects.remove(p_316233_);
    }

    public boolean removeEffect(Holder<MobEffect> p_316570_) {
        MobEffectInstance $$1 = this.removeEffectNoUpdate(p_316570_);
        if ($$1 != null) {
            this.onEffectRemoved($$1);
            return true;
        }
        return false;
    }

    protected void onEffectAdded(MobEffectInstance p_147190_, @Nullable Entity p_147191_) {
        this.effectsDirty = true;
        if (!this.level().isClientSide) {
            p_147190_.getEffect().value().addAttributeModifiers(this.getAttributes(), p_147190_.getAmplifier());
            this.sendEffectToPassengers(p_147190_);
        }
    }

    public void sendEffectToPassengers(MobEffectInstance p_289695_) {
        for (Entity $$1 : this.getPassengers()) {
            if (!($$1 instanceof ServerPlayer)) continue;
            ServerPlayer $$2 = (ServerPlayer)$$1;
            $$2.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), p_289695_, false));
        }
    }

    protected void onEffectUpdated(MobEffectInstance p_147192_, boolean p_147193_, @Nullable Entity p_147194_) {
        this.effectsDirty = true;
        if (p_147193_ && !this.level().isClientSide) {
            MobEffect $$3 = p_147192_.getEffect().value();
            $$3.removeAttributeModifiers(this.getAttributes());
            $$3.addAttributeModifiers(this.getAttributes(), p_147192_.getAmplifier());
            this.refreshDirtyAttributes();
        }
        if (!this.level().isClientSide) {
            this.sendEffectToPassengers(p_147192_);
        }
    }

    protected void onEffectRemoved(MobEffectInstance p_21126_) {
        this.effectsDirty = true;
        if (!this.level().isClientSide) {
            p_21126_.getEffect().value().removeAttributeModifiers(this.getAttributes());
            this.refreshDirtyAttributes();
            for (Entity $$1 : this.getPassengers()) {
                if (!($$1 instanceof ServerPlayer)) continue;
                ServerPlayer $$2 = (ServerPlayer)$$1;
                $$2.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), p_21126_.getEffect()));
            }
        }
    }

    private void refreshDirtyAttributes() {
        for (AttributeInstance $$0 : this.getAttributes().getDirtyAttributes()) {
            this.onAttributeUpdated($$0.getAttribute());
        }
    }

    private void onAttributeUpdated(Holder<Attribute> p_316778_) {
        if (p_316778_.is(Attributes.MAX_HEALTH)) {
            float $$1 = this.getMaxHealth();
            if (this.getHealth() > $$1) {
                this.setHealth($$1);
            }
        } else if (p_316778_.is(Attributes.MAX_ABSORPTION)) {
            float $$2 = this.getMaxAbsorption();
            if (this.getAbsorptionAmount() > $$2) {
                this.setAbsorptionAmount($$2);
            }
        }
    }

    public void heal(float p_21116_) {
        float $$1 = this.getHealth();
        if ($$1 > 0.0f) {
            this.setHealth($$1 + p_21116_);
        }
    }

    public float getHealth() {
        return this.entityData.get(DATA_HEALTH_ID).floatValue();
    }

    public void setHealth(float p_21154_) {
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(Mth.clamp(p_21154_, 0.0f, this.getMaxHealth())));
    }

    public boolean isDeadOrDying() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean hurt(DamageSource p_21016_, float p_21017_) {
        boolean $$15;
        if (this.isInvulnerableTo(p_21016_)) {
            return false;
        }
        if (this.level().isClientSide) {
            return false;
        }
        if (this.isDeadOrDying()) {
            return false;
        }
        if (p_21016_.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.isSleeping() && !this.level().isClientSide) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        float $$2 = p_21017_;
        boolean $$3 = false;
        float $$4 = 0.0f;
        if (p_21017_ > 0.0f && this.isDamageSourceBlocked(p_21016_)) {
            Entity $$5;
            this.hurtCurrentlyUsedShield(p_21017_);
            $$4 = p_21017_;
            p_21017_ = 0.0f;
            if (!p_21016_.is(DamageTypeTags.IS_PROJECTILE) && ($$5 = p_21016_.getDirectEntity()) instanceof LivingEntity) {
                LivingEntity $$6 = (LivingEntity)$$5;
                this.blockUsingShield($$6);
            }
            $$3 = true;
        }
        if (p_21016_.is(DamageTypeTags.IS_FREEZING) && this.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
            p_21017_ *= 5.0f;
        }
        if (p_21016_.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            this.hurtHelmet(p_21016_, p_21017_);
            p_21017_ *= 0.75f;
        }
        this.walkAnimation.setSpeed(1.5f);
        boolean $$7 = true;
        if ((float)this.invulnerableTime > 10.0f && !p_21016_.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (p_21017_ <= this.lastHurt) {
                return false;
            }
            this.actuallyHurt(p_21016_, p_21017_ - this.lastHurt);
            this.lastHurt = p_21017_;
            $$7 = false;
        } else {
            this.lastHurt = p_21017_;
            this.invulnerableTime = 20;
            this.actuallyHurt(p_21016_, p_21017_);
            this.hurtTime = this.hurtDuration = 10;
        }
        Entity $$8 = p_21016_.getEntity();
        if ($$8 != null) {
            Wolf $$11;
            if ($$8 instanceof LivingEntity) {
                LivingEntity $$9 = (LivingEntity)$$8;
                if (!(p_21016_.is(DamageTypeTags.NO_ANGER) || p_21016_.is(DamageTypes.WIND_CHARGE) && this.getType().is(EntityTypeTags.NO_ANGER_FROM_WIND_CHARGE))) {
                    this.setLastHurtByMob($$9);
                }
            }
            if ($$8 instanceof Player) {
                Player $$10 = (Player)$$8;
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = $$10;
            } else if ($$8 instanceof Wolf && ($$11 = (Wolf)$$8).isTame()) {
                Player $$12;
                this.lastHurtByPlayerTime = 100;
                LivingEntity livingEntity = $$11.getOwner();
                this.lastHurtByPlayer = livingEntity instanceof Player ? ($$12 = (Player)livingEntity) : null;
            }
        }
        if ($$7) {
            if ($$3) {
                this.level().broadcastEntityEvent(this, (byte)29);
            } else {
                this.level().broadcastDamageEvent(this, p_21016_);
            }
            if (!(p_21016_.is(DamageTypeTags.NO_IMPACT) || $$3 && !(p_21017_ > 0.0f))) {
                this.markHurt();
            }
            if ($$8 != null && !p_21016_.is(DamageTypeTags.NO_KNOCKBACK)) {
                double $$13 = $$8.getX() - this.getX();
                double $$14 = $$8.getZ() - this.getZ();
                while ($$13 * $$13 + $$14 * $$14 < 1.0E-4) {
                    $$13 = (Math.random() - Math.random()) * 0.01;
                    $$14 = (Math.random() - Math.random()) * 0.01;
                }
                this.knockback(0.4f, $$13, $$14);
                if (!$$3) {
                    this.indicateDamage($$13, $$14);
                }
            }
        }
        if (this.isDeadOrDying()) {
            if (!this.checkTotemDeathProtection(p_21016_)) {
                if ($$7) {
                    this.makeSound(this.getDeathSound());
                }
                this.die(p_21016_);
            }
        } else if ($$7) {
            this.playHurtSound(p_21016_);
        }
        boolean bl = $$15 = !$$3 || p_21017_ > 0.0f;
        if ($$15) {
            this.lastDamageSource = p_21016_;
            this.lastDamageStamp = this.level().getGameTime();
            for (MobEffectInstance $$16 : this.getActiveEffects()) {
                $$16.onMobHurt(this, p_21016_, p_21017_);
            }
        }
        if (this instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayer)this, p_21016_, $$2, p_21017_, $$3);
            if ($$4 > 0.0f && $$4 < 3.4028235E37f) {
                ((ServerPlayer)this).awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round($$4 * 10.0f));
            }
        }
        if ($$8 instanceof ServerPlayer) {
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayer)$$8, this, p_21016_, $$2, p_21017_, $$3);
        }
        return $$15;
    }

    protected void blockUsingShield(LivingEntity p_21200_) {
        p_21200_.blockedByShield(this);
    }

    protected void blockedByShield(LivingEntity p_21246_) {
        p_21246_.knockback(0.5, p_21246_.getX() - this.getX(), p_21246_.getZ() - this.getZ());
    }

    private boolean checkTotemDeathProtection(DamageSource p_21263_) {
        if (p_21263_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        ItemStack $$1 = null;
        for (InteractionHand $$2 : InteractionHand.values()) {
            ItemStack $$3 = this.getItemInHand($$2);
            if (!$$3.is(Items.TOTEM_OF_UNDYING)) continue;
            $$1 = $$3.copy();
            $$3.shrink(1);
            break;
        }
        if ($$1 != null) {
            LivingEntity livingEntity = this;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer $$4 = (ServerPlayer)livingEntity;
                $$4.awardStat(Stats.ITEM_USED.get(Items.TOTEM_OF_UNDYING));
                CriteriaTriggers.USED_TOTEM.trigger($$4, $$1);
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
            this.setHealth(1.0f);
            this.removeAllEffects();
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            this.level().broadcastEntityEvent(this, (byte)35);
        }
        return $$1 != null;
    }

    @Nullable
    public DamageSource getLastDamageSource() {
        if (this.level().getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
        return this.lastDamageSource;
    }

    protected void playHurtSound(DamageSource p_21160_) {
        this.makeSound(this.getHurtSound(p_21160_));
    }

    public void makeSound(@Nullable SoundEvent p_320810_) {
        if (p_320810_ != null) {
            this.playSound(p_320810_, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean isDamageSourceBlocked(DamageSource p_21276_) {
        Vec3 $$4;
        AbstractArrow $$3;
        Entity $$1 = p_21276_.getDirectEntity();
        boolean $$2 = false;
        if ($$1 instanceof AbstractArrow && ($$3 = (AbstractArrow)$$1).getPierceLevel() > 0) {
            $$2 = true;
        }
        if (!p_21276_.is(DamageTypeTags.BYPASSES_SHIELD) && this.isBlocking() && !$$2 && ($$4 = p_21276_.getSourcePosition()) != null) {
            Vec3 $$5 = this.calculateViewVector(0.0f, this.getYHeadRot());
            Vec3 $$6 = $$4.vectorTo(this.position());
            $$6 = new Vec3($$6.x, 0.0, $$6.z).normalize();
            return $$6.dot($$5) < 0.0;
        }
        return false;
    }

    private void breakItem(ItemStack p_21279_) {
        if (!p_21279_.isEmpty()) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), p_21279_.getBreakingSound(), this.getSoundSource(), 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(p_21279_, 5);
        }
    }

    public void die(DamageSource p_21014_) {
        if (this.isRemoved() || this.dead) {
            return;
        }
        Entity $$1 = p_21014_.getEntity();
        LivingEntity $$2 = this.getKillCredit();
        if (this.deathScore >= 0 && $$2 != null) {
            $$2.awardKillScore(this, this.deathScore, p_21014_);
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        if (!this.level().isClientSide && this.hasCustomName()) {
            LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
        }
        this.dead = true;
        this.getCombatTracker().recheckStatus();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$3 = (ServerLevel)level;
            if ($$1 == null || $$1.killedEntity($$3, this)) {
                this.gameEvent(GameEvent.ENTITY_DIE);
                this.dropAllDeathLoot(p_21014_);
                this.createWitherRose($$2);
            }
            this.level().broadcastEntityEvent(this, (byte)3);
        }
        this.setPose(Pose.DYING);
    }

    protected void createWitherRose(@Nullable LivingEntity p_21269_) {
        if (this.level().isClientSide) {
            return;
        }
        boolean $$1 = false;
        if (p_21269_ instanceof WitherBoss) {
            if (this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                BlockPos $$2 = this.blockPosition();
                BlockState $$3 = Blocks.WITHER_ROSE.defaultBlockState();
                if (this.level().getBlockState($$2).isAir() && $$3.canSurvive(this.level(), $$2)) {
                    this.level().setBlock($$2, $$3, 3);
                    $$1 = true;
                }
            }
            if (!$$1) {
                ItemEntity $$4 = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(Items.WITHER_ROSE));
                this.level().addFreshEntity($$4);
            }
        }
    }

    protected void dropAllDeathLoot(DamageSource p_21192_) {
        boolean $$4;
        int $$3;
        Entity $$1 = p_21192_.getEntity();
        if ($$1 instanceof Player) {
            int $$2 = EnchantmentHelper.getMobLooting((LivingEntity)$$1);
        } else {
            $$3 = 0;
        }
        boolean bl = $$4 = this.lastHurtByPlayerTime > 0;
        if (this.shouldDropLoot() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropFromLootTable(p_21192_, $$4);
            this.dropCustomDeathLoot(p_21192_, $$3, $$4);
        }
        this.dropEquipment();
        this.dropExperience();
    }

    protected void dropEquipment() {
    }

    protected void dropExperience() {
        if (this.level() instanceof ServerLevel && !this.wasExperienceConsumed() && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerTime > 0 && this.shouldDropExperience() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT))) {
            ExperienceOrb.award((ServerLevel)this.level(), this.position(), this.getExperienceReward());
        }
    }

    protected void dropCustomDeathLoot(DamageSource p_21018_, int p_21019_, boolean p_21020_) {
    }

    public ResourceKey<LootTable> getLootTable() {
        return this.getType().getDefaultLootTable();
    }

    public long getLootTableSeed() {
        return 0L;
    }

    protected void dropFromLootTable(DamageSource p_21021_, boolean p_21022_) {
        ResourceKey<LootTable> $$2 = this.getLootTable();
        LootTable $$3 = this.level().getServer().reloadableRegistries().getLootTable($$2);
        LootParams.Builder $$4 = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, this).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, p_21021_).withOptionalParameter(LootContextParams.KILLER_ENTITY, p_21021_.getEntity()).withOptionalParameter(LootContextParams.DIRECT_KILLER_ENTITY, p_21021_.getDirectEntity());
        if (p_21022_ && this.lastHurtByPlayer != null) {
            $$4 = $$4.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        LootParams $$5 = $$4.create(LootContextParamSets.ENTITY);
        $$3.getRandomItems($$5, this.getLootTableSeed(), this::spawnAtLocation);
    }

    public void knockback(double p_147241_, double p_147242_, double p_147243_) {
        if ((p_147241_ *= 1.0 - this.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE)) <= 0.0) {
            return;
        }
        this.hasImpulse = true;
        Vec3 $$3 = this.getDeltaMovement();
        Vec3 $$4 = new Vec3(p_147242_, 0.0, p_147243_).normalize().scale(p_147241_);
        this.setDeltaMovement($$3.x / 2.0 - $$4.x, this.onGround() ? Math.min(0.4, $$3.y / 2.0 + p_147241_) : $$3.y, $$3.z / 2.0 - $$4.z);
    }

    public void indicateDamage(double p_270514_, double p_270826_) {
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return SoundEvents.GENERIC_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }

    private SoundEvent getFallDamageSound(int p_21313_) {
        return p_21313_ > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public void skipDropExperience() {
        this.skipDropExperience = true;
    }

    public boolean wasExperienceConsumed() {
        return this.skipDropExperience;
    }

    public float getHurtDir() {
        return 0.0f;
    }

    protected AABB getHitbox() {
        AABB $$0 = this.getBoundingBox();
        Entity $$1 = this.getVehicle();
        if ($$1 != null) {
            Vec3 $$2 = $$1.getPassengerRidingPosition(this);
            return $$0.setMinY(Math.max($$2.y, $$0.minY));
        }
        return $$0;
    }

    public Fallsounds getFallSounds() {
        return new Fallsounds(SoundEvents.GENERIC_SMALL_FALL, SoundEvents.GENERIC_BIG_FALL);
    }

    protected SoundEvent getDrinkingSound(ItemStack p_21174_) {
        return p_21174_.getDrinkingSound();
    }

    public SoundEvent getEatingSound(ItemStack p_21202_) {
        return p_21202_.getEatingSound();
    }

    public Optional<BlockPos> getLastClimbablePos() {
        return this.lastClimbablePos;
    }

    public boolean onClimbable() {
        if (this.isSpectator()) {
            return false;
        }
        BlockPos $$0 = this.blockPosition();
        BlockState $$1 = this.getInBlockState();
        if ($$1.is(BlockTags.CLIMBABLE)) {
            this.lastClimbablePos = Optional.of($$0);
            return true;
        }
        if ($$1.getBlock() instanceof TrapDoorBlock && this.trapdoorUsableAsLadder($$0, $$1)) {
            this.lastClimbablePos = Optional.of($$0);
            return true;
        }
        return false;
    }

    private boolean trapdoorUsableAsLadder(BlockPos p_21177_, BlockState p_21178_) {
        BlockState $$2;
        return p_21178_.getValue(TrapDoorBlock.OPEN) != false && ($$2 = this.level().getBlockState(p_21177_.below())).is(Blocks.LADDER) && $$2.getValue(LadderBlock.FACING) == p_21178_.getValue(TrapDoorBlock.FACING);
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved() && this.getHealth() > 0.0f;
    }

    @Override
    public int getMaxFallDistance() {
        return this.getComfortableFallDistance(0.0f);
    }

    protected final int getComfortableFallDistance(float p_326294_) {
        return Mth.floor(p_326294_ + 3.0f);
    }

    @Override
    public boolean causeFallDamage(float p_147187_, float p_147188_, DamageSource p_147189_) {
        boolean $$3 = super.causeFallDamage(p_147187_, p_147188_, p_147189_);
        int $$4 = this.calculateFallDamage(p_147187_, p_147188_);
        if ($$4 > 0) {
            this.playSound(this.getFallDamageSound($$4), 1.0f, 1.0f);
            this.playBlockFallSound();
            this.hurt(p_147189_, $$4);
            return true;
        }
        return $$3;
    }

    protected int calculateFallDamage(float p_21237_, float p_21238_) {
        if (this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return 0;
        }
        float $$2 = (float)this.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
        float $$3 = p_21237_ - $$2;
        return Mth.ceil((double)($$3 * p_21238_) * this.getAttributeValue(Attributes.FALL_DAMAGE_MULTIPLIER));
    }

    protected void playBlockFallSound() {
        if (this.isSilent()) {
            return;
        }
        int $$0 = Mth.floor(this.getX());
        int $$1 = Mth.floor(this.getY() - (double)0.2f);
        int $$2 = Mth.floor(this.getZ());
        BlockState $$3 = this.level().getBlockState(new BlockPos($$0, $$1, $$2));
        if (!$$3.isAir()) {
            SoundType $$4 = $$3.getSoundType();
            this.playSound($$4.getFallSound(), $$4.getVolume() * 0.5f, $$4.getPitch() * 0.75f);
        }
    }

    @Override
    public void animateHurt(float p_265265_) {
        this.hurtTime = this.hurtDuration = 10;
    }

    public int getArmorValue() {
        return Mth.floor(this.getAttributeValue(Attributes.ARMOR));
    }

    protected void hurtArmor(DamageSource p_21122_, float p_21123_) {
    }

    protected void hurtHelmet(DamageSource p_147213_, float p_147214_) {
    }

    protected void hurtCurrentlyUsedShield(float p_21316_) {
    }

    protected void doHurtEquipment(DamageSource p_330843_, float p_330394_, EquipmentSlot ... p_331314_) {
        if (p_330394_ <= 0.0f) {
            return;
        }
        int $$3 = (int)Math.max(1.0f, p_330394_ / 4.0f);
        for (EquipmentSlot $$4 : p_331314_) {
            ItemStack $$5 = this.getItemBySlot($$4);
            if (!($$5.getItem() instanceof ArmorItem) || !$$5.canBeHurtBy(p_330843_)) continue;
            $$5.hurtAndBreak($$3, this, $$4);
        }
    }

    protected float getDamageAfterArmorAbsorb(DamageSource p_21162_, float p_21163_) {
        if (!p_21162_.is(DamageTypeTags.BYPASSES_ARMOR)) {
            this.hurtArmor(p_21162_, p_21163_);
            p_21163_ = CombatRules.getDamageAfterAbsorb(p_21163_, p_21162_, this.getArmorValue(), (float)this.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        }
        return p_21163_;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource p_21193_, float p_21194_) {
        int $$2;
        int $$3;
        float $$4;
        float $$5;
        float $$6;
        if (p_21193_.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return p_21194_;
        }
        if (this.hasEffect(MobEffects.DAMAGE_RESISTANCE) && !p_21193_.is(DamageTypeTags.BYPASSES_RESISTANCE) && ($$6 = ($$5 = p_21194_) - (p_21194_ = Math.max(($$4 = p_21194_ * (float)($$3 = 25 - ($$2 = (this.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && $$6 < 3.4028235E37f) {
            if (this instanceof ServerPlayer) {
                ((ServerPlayer)this).awardStat(Stats.DAMAGE_RESISTED, Math.round($$6 * 10.0f));
            } else if (p_21193_.getEntity() instanceof ServerPlayer) {
                ((ServerPlayer)p_21193_.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round($$6 * 10.0f));
            }
        }
        if (p_21194_ <= 0.0f) {
            return 0.0f;
        }
        if (p_21193_.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return p_21194_;
        }
        int $$7 = EnchantmentHelper.getDamageProtection(this.getArmorAndBodyArmorSlots(), p_21193_);
        if ($$7 > 0) {
            p_21194_ = CombatRules.getDamageAfterMagicAbsorb(p_21194_, $$7);
        }
        return p_21194_;
    }

    protected void actuallyHurt(DamageSource p_21240_, float p_21241_) {
        Entity entity;
        if (this.isInvulnerableTo(p_21240_)) {
            return;
        }
        p_21241_ = this.getDamageAfterArmorAbsorb(p_21240_, p_21241_);
        float $$2 = p_21241_ = this.getDamageAfterMagicAbsorb(p_21240_, p_21241_);
        p_21241_ = Math.max(p_21241_ - this.getAbsorptionAmount(), 0.0f);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - ($$2 - p_21241_));
        float $$3 = $$2 - p_21241_;
        if ($$3 > 0.0f && $$3 < 3.4028235E37f && (entity = p_21240_.getEntity()) instanceof ServerPlayer) {
            ServerPlayer $$4 = (ServerPlayer)entity;
            $$4.awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round($$3 * 10.0f));
        }
        if (p_21241_ == 0.0f) {
            return;
        }
        this.getCombatTracker().recordDamage(p_21240_, p_21241_);
        this.setHealth(this.getHealth() - p_21241_);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - p_21241_);
        this.gameEvent(GameEvent.ENTITY_DAMAGE);
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    @Nullable
    public LivingEntity getKillCredit() {
        if (this.lastHurtByPlayer != null) {
            return this.lastHurtByPlayer;
        }
        if (this.lastHurtByMob != null) {
            return this.lastHurtByMob;
        }
        return null;
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeValue(Attributes.MAX_HEALTH);
    }

    public final float getMaxAbsorption() {
        return (float)this.getAttributeValue(Attributes.MAX_ABSORPTION);
    }

    public final int getArrowCount() {
        return this.entityData.get(DATA_ARROW_COUNT_ID);
    }

    public final void setArrowCount(int p_21318_) {
        this.entityData.set(DATA_ARROW_COUNT_ID, p_21318_);
    }

    public final int getStingerCount() {
        return this.entityData.get(DATA_STINGER_COUNT_ID);
    }

    public final void setStingerCount(int p_21322_) {
        this.entityData.set(DATA_STINGER_COUNT_ID, p_21322_);
    }

    private int getCurrentSwingDuration() {
        if (MobEffectUtil.hasDigSpeed(this)) {
            return 6 - (1 + MobEffectUtil.getDigSpeedAmplification(this));
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            return 6 + (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2;
        }
        return 6;
    }

    public void swing(InteractionHand p_21007_) {
        this.swing(p_21007_, false);
    }

    public void swing(InteractionHand p_21012_, boolean p_21013_) {
        if (!this.swinging || this.swingTime >= this.getCurrentSwingDuration() / 2 || this.swingTime < 0) {
            this.swingTime = -1;
            this.swinging = true;
            this.swingingArm = p_21012_;
            if (this.level() instanceof ServerLevel) {
                ClientboundAnimatePacket $$2 = new ClientboundAnimatePacket(this, p_21012_ == InteractionHand.MAIN_HAND ? 0 : 3);
                ServerChunkCache $$3 = ((ServerLevel)this.level()).getChunkSource();
                if (p_21013_) {
                    $$3.broadcastAndSend(this, $$2);
                } else {
                    $$3.broadcast(this, $$2);
                }
            }
        }
    }

    @Override
    public void handleDamageEvent(DamageSource p_270229_) {
        this.walkAnimation.setSpeed(1.5f);
        this.invulnerableTime = 20;
        this.hurtTime = this.hurtDuration = 10;
        SoundEvent $$1 = this.getHurtSound(p_270229_);
        if ($$1 != null) {
            this.playSound($$1, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.hurt(this.damageSources().generic(), 0.0f);
        this.lastDamageSource = p_270229_;
        this.lastDamageStamp = this.level().getGameTime();
    }

    @Override
    public void handleEntityEvent(byte p_20975_) {
        switch (p_20975_) {
            case 3: {
                SoundEvent $$1 = this.getDeathSound();
                if ($$1 != null) {
                    this.playSound($$1, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof Player) break;
                this.setHealth(0.0f);
                this.die(this.damageSources().generic());
                break;
            }
            case 30: {
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
                break;
            }
            case 29: {
                this.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, 0.8f + this.level().random.nextFloat() * 0.4f);
                break;
            }
            case 46: {
                int $$2 = 128;
                for (int $$3 = 0; $$3 < 128; ++$$3) {
                    double $$4 = (double)$$3 / 127.0;
                    float $$5 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float $$6 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float $$7 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    double $$8 = Mth.lerp($$4, this.xo, this.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    double $$9 = Mth.lerp($$4, this.yo, this.getY()) + this.random.nextDouble() * (double)this.getBbHeight();
                    double $$10 = Mth.lerp($$4, this.zo, this.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    this.level().addParticle(ParticleTypes.PORTAL, $$8, $$9, $$10, $$5, $$6, $$7);
                }
                break;
            }
            case 47: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
                break;
            }
            case 48: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.OFFHAND));
                break;
            }
            case 49: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.HEAD));
                break;
            }
            case 50: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.CHEST));
                break;
            }
            case 51: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.LEGS));
                break;
            }
            case 52: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.FEET));
                break;
            }
            case 65: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.BODY));
                break;
            }
            case 54: {
                HoneyBlock.showJumpParticles(this);
                break;
            }
            case 55: {
                this.swapHandItems();
                break;
            }
            case 60: {
                this.makePoofParticles();
                break;
            }
            default: {
                super.handleEntityEvent(p_20975_);
            }
        }
    }

    private void makePoofParticles() {
        for (int $$0 = 0; $$0 < 20; ++$$0) {
            double $$1 = this.random.nextGaussian() * 0.02;
            double $$2 = this.random.nextGaussian() * 0.02;
            double $$3 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(ParticleTypes.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), $$1, $$2, $$3);
        }
    }

    private void swapHandItems() {
        ItemStack $$0 = this.getItemBySlot(EquipmentSlot.OFFHAND);
        this.setItemSlot(EquipmentSlot.OFFHAND, this.getItemBySlot(EquipmentSlot.MAINHAND));
        this.setItemSlot(EquipmentSlot.MAINHAND, $$0);
    }

    @Override
    protected void onBelowWorld() {
        this.hurt(this.damageSources().fellOutOfWorld(), 4.0f);
    }

    protected void updateSwingTime() {
        int $$0 = this.getCurrentSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= $$0) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)$$0;
    }

    @Nullable
    public AttributeInstance getAttribute(Holder<Attribute> p_316333_) {
        return this.getAttributes().getInstance(p_316333_);
    }

    public double getAttributeValue(Holder<Attribute> p_251296_) {
        return this.getAttributes().getValue(p_251296_);
    }

    public double getAttributeBaseValue(Holder<Attribute> p_248605_) {
        return this.getAttributes().getBaseValue(p_248605_);
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public ItemStack getMainHandItem() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND);
    }

    public ItemStack getOffhandItem() {
        return this.getItemBySlot(EquipmentSlot.OFFHAND);
    }

    public boolean isHolding(Item p_21056_) {
        return this.isHolding((ItemStack p_147200_) -> p_147200_.is(p_21056_));
    }

    public boolean isHolding(Predicate<ItemStack> p_21094_) {
        return p_21094_.test(this.getMainHandItem()) || p_21094_.test(this.getOffhandItem());
    }

    public ItemStack getItemInHand(InteractionHand p_21121_) {
        if (p_21121_ == InteractionHand.MAIN_HAND) {
            return this.getItemBySlot(EquipmentSlot.MAINHAND);
        }
        if (p_21121_ == InteractionHand.OFF_HAND) {
            return this.getItemBySlot(EquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)p_21121_));
    }

    public void setItemInHand(InteractionHand p_21009_, ItemStack p_21010_) {
        if (p_21009_ == InteractionHand.MAIN_HAND) {
            this.setItemSlot(EquipmentSlot.MAINHAND, p_21010_);
        } else if (p_21009_ == InteractionHand.OFF_HAND) {
            this.setItemSlot(EquipmentSlot.OFFHAND, p_21010_);
        } else {
            throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)p_21009_));
        }
    }

    public boolean hasItemInSlot(EquipmentSlot p_21034_) {
        return !this.getItemBySlot(p_21034_).isEmpty();
    }

    public boolean canUseSlot(EquipmentSlot p_326058_) {
        return false;
    }

    public abstract Iterable<ItemStack> getArmorSlots();

    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    public abstract void setItemSlot(EquipmentSlot var1, ItemStack var2);

    public Iterable<ItemStack> getHandSlots() {
        return List.of();
    }

    public Iterable<ItemStack> getArmorAndBodyArmorSlots() {
        return this.getArmorSlots();
    }

    public Iterable<ItemStack> getAllSlots() {
        return Iterables.concat(this.getHandSlots(), this.getArmorAndBodyArmorSlots());
    }

    protected void verifyEquippedItem(ItemStack p_181123_) {
        p_181123_.getItem().verifyComponentsAfterLoad(p_181123_);
    }

    public float getArmorCoverPercentage() {
        Iterable<ItemStack> $$0 = this.getArmorSlots();
        int $$1 = 0;
        int $$2 = 0;
        for (ItemStack $$3 : $$0) {
            if (!$$3.isEmpty()) {
                ++$$2;
            }
            ++$$1;
        }
        return $$1 > 0 ? (float)$$2 / (float)$$1 : 0.0f;
    }

    @Override
    public void setSprinting(boolean p_21284_) {
        super.setSprinting(p_21284_);
        AttributeInstance $$1 = this.getAttribute(Attributes.MOVEMENT_SPEED);
        $$1.removeModifier(SPEED_MODIFIER_SPRINTING.id());
        if (p_21284_) {
            $$1.addTransientModifier(SPEED_MODIFIER_SPRINTING);
        }
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        if (this.isBaby()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    @Override
    public void push(Entity p_21294_) {
        if (!this.isSleeping()) {
            super.push(p_21294_);
        }
    }

    private void dismountVehicle(Entity p_21029_) {
        Vec3 $$4;
        if (this.isRemoved()) {
            Vec3 $$1 = this.position();
        } else if (p_21029_.isRemoved() || this.level().getBlockState(p_21029_.blockPosition()).is(BlockTags.PORTALS)) {
            double $$2 = Math.max(this.getY(), p_21029_.getY());
            Vec3 $$3 = new Vec3(this.getX(), $$2, this.getZ());
        } else {
            $$4 = p_21029_.getDismountLocationForPassenger(this);
        }
        this.dismountTo($$4.x, $$4.y, $$4.z);
    }

    @Override
    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.0f);
    }

    protected float getJumpPower(float p_326107_) {
        return (float)this.getAttributeValue(Attributes.JUMP_STRENGTH) * p_326107_ * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public float getJumpBoostPower() {
        return this.hasEffect(MobEffects.JUMP) ? 0.1f * ((float)this.getEffect(MobEffects.JUMP).getAmplifier() + 1.0f) : 0.0f;
    }

    protected void jumpFromGround() {
        float $$0 = this.getJumpPower();
        if ($$0 <= 1.0E-5f) {
            return;
        }
        Vec3 $$1 = this.getDeltaMovement();
        this.setDeltaMovement($$1.x, $$0, $$1.z);
        if (this.isSprinting()) {
            float $$2 = this.getYRot() * ((float)Math.PI / 180);
            this.addDeltaMovement(new Vec3((double)(-Mth.sin($$2)) * 0.2, 0.0, (double)Mth.cos($$2) * 0.2));
        }
        this.hasImpulse = true;
    }

    protected void goDownInWater() {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04f, 0.0));
    }

    protected void jumpInLiquid(TagKey<Fluid> p_204043_) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public boolean canStandOnFluid(FluidState p_204042_) {
        return false;
    }

    @Override
    protected double getDefaultGravity() {
        return this.getAttributeValue(Attributes.GRAVITY);
    }

    public void travel(Vec3 p_21280_) {
        if (this.isControlledByLocalInstance()) {
            boolean $$2;
            double $$1 = this.getGravity();
            boolean bl = $$2 = this.getDeltaMovement().y <= 0.0;
            if ($$2 && this.hasEffect(MobEffects.SLOW_FALLING)) {
                $$1 = Math.min($$1, 0.01);
            }
            FluidState $$3 = this.level().getFluidState(this.blockPosition());
            if (this.isInWater() && this.isAffectedByFluids() && !this.canStandOnFluid($$3)) {
                double $$4 = this.getY();
                float $$5 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                float $$6 = 0.02f;
                float $$7 = EnchantmentHelper.getDepthStrider(this);
                if ($$7 > 3.0f) {
                    $$7 = 3.0f;
                }
                if (!this.onGround()) {
                    $$7 *= 0.5f;
                }
                if ($$7 > 0.0f) {
                    $$5 += (0.54600006f - $$5) * $$7 / 3.0f;
                    $$6 += (this.getSpeed() - $$6) * $$7 / 3.0f;
                }
                if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    $$5 = 0.96f;
                }
                this.moveRelative($$6, p_21280_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                Vec3 $$8 = this.getDeltaMovement();
                if (this.horizontalCollision && this.onClimbable()) {
                    $$8 = new Vec3($$8.x, 0.2, $$8.z);
                }
                this.setDeltaMovement($$8.multiply($$5, 0.8f, $$5));
                Vec3 $$9 = this.getFluidFallingAdjustedMovement($$1, $$2, this.getDeltaMovement());
                this.setDeltaMovement($$9);
                if (this.horizontalCollision && this.isFree($$9.x, $$9.y + (double)0.6f - this.getY() + $$4, $$9.z)) {
                    this.setDeltaMovement($$9.x, 0.3f, $$9.z);
                }
            } else if (this.isInLava() && this.isAffectedByFluids() && !this.canStandOnFluid($$3)) {
                double $$10 = this.getY();
                this.moveRelative(0.02f, p_21280_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.8f, 0.5));
                    Vec3 $$11 = this.getFluidFallingAdjustedMovement($$1, $$2, this.getDeltaMovement());
                    this.setDeltaMovement($$11);
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                }
                if ($$1 != 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -$$1 / 4.0, 0.0));
                }
                Vec3 $$12 = this.getDeltaMovement();
                if (this.horizontalCollision && this.isFree($$12.x, $$12.y + (double)0.6f - this.getY() + $$10, $$12.z)) {
                    this.setDeltaMovement($$12.x, 0.3f, $$12.z);
                }
            } else if (this.isFallFlying()) {
                double $$22;
                double $$23;
                float $$24;
                this.checkSlowFallDistance();
                Vec3 $$13 = this.getDeltaMovement();
                Vec3 $$14 = this.getLookAngle();
                float $$15 = this.getXRot() * ((float)Math.PI / 180);
                double $$16 = Math.sqrt($$14.x * $$14.x + $$14.z * $$14.z);
                double $$17 = $$13.horizontalDistance();
                double $$18 = $$14.length();
                double $$19 = Math.cos($$15);
                $$19 = $$19 * $$19 * Math.min(1.0, $$18 / 0.4);
                $$13 = this.getDeltaMovement().add(0.0, $$1 * (-1.0 + $$19 * 0.75), 0.0);
                if ($$13.y < 0.0 && $$16 > 0.0) {
                    double $$20 = $$13.y * -0.1 * $$19;
                    $$13 = $$13.add($$14.x * $$20 / $$16, $$20, $$14.z * $$20 / $$16);
                }
                if ($$15 < 0.0f && $$16 > 0.0) {
                    double $$21 = $$17 * (double)(-Mth.sin($$15)) * 0.04;
                    $$13 = $$13.add(-$$14.x * $$21 / $$16, $$21 * 3.2, -$$14.z * $$21 / $$16);
                }
                if ($$16 > 0.0) {
                    $$13 = $$13.add(($$14.x / $$16 * $$17 - $$13.x) * 0.1, 0.0, ($$14.z / $$16 * $$17 - $$13.z) * 0.1);
                }
                this.setDeltaMovement($$13.multiply(0.99f, 0.98f, 0.99f));
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (this.horizontalCollision && !this.level().isClientSide && ($$24 = (float)(($$23 = $$17 - ($$22 = this.getDeltaMovement().horizontalDistance())) * 10.0 - 3.0)) > 0.0f) {
                    this.playSound(this.getFallDamageSound((int)$$24), 1.0f, 1.0f);
                    this.hurt(this.damageSources().flyIntoWall(), $$24);
                }
                if (this.onGround() && !this.level().isClientSide) {
                    this.setSharedFlag(7, false);
                }
            } else {
                BlockPos $$25 = this.getBlockPosBelowThatAffectsMyMovement();
                float $$26 = this.level().getBlockState($$25).getBlock().getFriction();
                float $$27 = this.onGround() ? $$26 * 0.91f : 0.91f;
                Vec3 $$28 = this.handleRelativeFrictionAndCalculateMovement(p_21280_, $$26);
                double $$29 = $$28.y;
                $$29 = this.hasEffect(MobEffects.LEVITATION) ? ($$29 += (0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - $$28.y) * 0.2) : (!this.level().isClientSide || this.level().hasChunkAt($$25) ? ($$29 -= $$1) : (this.getY() > (double)this.level().getMinBuildHeight() ? -0.1 : 0.0));
                if (this.shouldDiscardFriction()) {
                    this.setDeltaMovement($$28.x, $$29, $$28.z);
                } else {
                    this.setDeltaMovement($$28.x * (double)$$27, this instanceof FlyingAnimal ? $$29 * (double)$$27 : $$29 * (double)0.98f, $$28.z * (double)$$27);
                }
            }
        }
        this.calculateEntityAnimation(this instanceof FlyingAnimal);
    }

    private void travelRidden(Player p_278244_, Vec3 p_278231_) {
        Vec3 $$2 = this.getRiddenInput(p_278244_, p_278231_);
        this.tickRidden(p_278244_, $$2);
        if (this.isControlledByLocalInstance()) {
            this.setSpeed(this.getRiddenSpeed(p_278244_));
            this.travel($$2);
        } else {
            this.calculateEntityAnimation(false);
            this.setDeltaMovement(Vec3.ZERO);
            this.tryCheckInsideBlocks();
        }
    }

    protected void tickRidden(Player p_278262_, Vec3 p_275242_) {
    }

    protected Vec3 getRiddenInput(Player p_278326_, Vec3 p_275300_) {
        return p_275300_;
    }

    protected float getRiddenSpeed(Player p_278286_) {
        return this.getSpeed();
    }

    public void calculateEntityAnimation(boolean p_268129_) {
        float $$1 = (float)Mth.length(this.getX() - this.xo, p_268129_ ? this.getY() - this.yo : 0.0, this.getZ() - this.zo);
        this.updateWalkAnimation($$1);
    }

    protected void updateWalkAnimation(float p_268283_) {
        float $$1 = Math.min(p_268283_ * 4.0f, 1.0f);
        this.walkAnimation.update($$1, 0.4f);
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 p_21075_, float p_21076_) {
        this.moveRelative(this.getFrictionInfluencedSpeed(p_21076_), p_21075_);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 $$2 = this.getDeltaMovement();
        if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.getInBlockState().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow(this))) {
            $$2 = new Vec3($$2.x, 0.2, $$2.z);
        }
        return $$2;
    }

    public Vec3 getFluidFallingAdjustedMovement(double p_20995_, boolean p_20996_, Vec3 p_20997_) {
        if (p_20995_ != 0.0 && !this.isSprinting()) {
            double $$4;
            if (p_20996_ && Math.abs(p_20997_.y - 0.005) >= 0.003 && Math.abs(p_20997_.y - p_20995_ / 16.0) < 0.003) {
                double $$3 = -0.003;
            } else {
                $$4 = p_20997_.y - p_20995_ / 16.0;
            }
            return new Vec3(p_20997_.x, $$4, p_20997_.z);
        }
        return p_20997_;
    }

    private Vec3 handleOnClimbable(Vec3 p_21298_) {
        if (this.onClimbable()) {
            this.resetFallDistance();
            float $$1 = 0.15f;
            double $$2 = Mth.clamp(p_21298_.x, (double)-0.15f, (double)0.15f);
            double $$3 = Mth.clamp(p_21298_.z, (double)-0.15f, (double)0.15f);
            double $$4 = Math.max(p_21298_.y, (double)-0.15f);
            if ($$4 < 0.0 && !this.getInBlockState().is(Blocks.SCAFFOLDING) && this.isSuppressingSlidingDownLadder() && this instanceof Player) {
                $$4 = 0.0;
            }
            p_21298_ = new Vec3($$2, $$4, $$3);
        }
        return p_21298_;
    }

    private float getFrictionInfluencedSpeed(float p_21331_) {
        if (this.onGround()) {
            return this.getSpeed() * (0.21600002f / (p_21331_ * p_21331_ * p_21331_));
        }
        return this.getFlyingSpeed();
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof Player ? this.getSpeed() * 0.1f : 0.02f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float p_21320_) {
        this.speed = p_21320_;
    }

    public boolean doHurtTarget(Entity p_20970_) {
        this.setLastHurtMob(p_20970_);
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        this.updatingUsingItem();
        this.updateSwimAmount();
        if (!this.level().isClientSide) {
            int $$1;
            int $$0 = this.getArrowCount();
            if ($$0 > 0) {
                if (this.removeArrowTime <= 0) {
                    this.removeArrowTime = 20 * (30 - $$0);
                }
                --this.removeArrowTime;
                if (this.removeArrowTime <= 0) {
                    this.setArrowCount($$0 - 1);
                }
            }
            if (($$1 = this.getStingerCount()) > 0) {
                if (this.removeStingerTime <= 0) {
                    this.removeStingerTime = 20 * (30 - $$1);
                }
                --this.removeStingerTime;
                if (this.removeStingerTime <= 0) {
                    this.setStingerCount($$1 - 1);
                }
            }
            this.detectEquipmentUpdates();
            if (this.tickCount % 20 == 0) {
                this.getCombatTracker().recheckStatus();
            }
            if (this.isSleeping() && !this.checkBedExists()) {
                this.stopSleeping();
            }
        }
        if (!this.isRemoved()) {
            this.aiStep();
        }
        double $$2 = this.getX() - this.xo;
        double $$3 = this.getZ() - this.zo;
        float $$4 = (float)($$2 * $$2 + $$3 * $$3);
        float $$5 = this.yBodyRot;
        float $$6 = 0.0f;
        this.oRun = this.run;
        float $$7 = 0.0f;
        if ($$4 > 0.0025000002f) {
            $$7 = 1.0f;
            $$6 = (float)Math.sqrt($$4) * 3.0f;
            float $$8 = (float)Mth.atan2($$3, $$2) * 57.295776f - 90.0f;
            float $$9 = Mth.abs(Mth.wrapDegrees(this.getYRot()) - $$8);
            $$5 = 95.0f < $$9 && $$9 < 265.0f ? $$8 - 180.0f : $$8;
        }
        if (this.attackAnim > 0.0f) {
            $$5 = this.getYRot();
        }
        if (!this.onGround()) {
            $$7 = 0.0f;
        }
        this.run += ($$7 - this.run) * 0.3f;
        this.level().getProfiler().push("headTurn");
        $$6 = this.tickHeadTurn($$5, $$6);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("rangeChecks");
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO < -180.0f) {
            this.yHeadRotO -= 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO >= 180.0f) {
            this.yHeadRotO += 360.0f;
        }
        this.level().getProfiler().pop();
        this.animStep += $$6;
        this.fallFlyTicks = this.isFallFlying() ? ++this.fallFlyTicks : 0;
        if (this.isSleeping()) {
            this.setXRot(0.0f);
        }
        this.refreshDirtyAttributes();
        float $$10 = this.getScale();
        if ($$10 != this.appliedScale) {
            this.appliedScale = $$10;
            this.refreshDimensions();
        }
    }

    private void detectEquipmentUpdates() {
        Map<EquipmentSlot, ItemStack> $$0 = this.collectEquipmentChanges();
        if ($$0 != null) {
            this.handleHandSwap($$0);
            if (!$$0.isEmpty()) {
                this.handleEquipmentChanges($$0);
            }
        }
    }

    @Nullable
    private Map<EquipmentSlot, ItemStack> collectEquipmentChanges() {
        EnumMap $$0 = null;
        for (EquipmentSlot $$1 : EquipmentSlot.values()) {
            ItemStack $$2 = switch ($$1.getType()) {
                default -> throw new MatchException(null, null);
                case EquipmentSlot.Type.HAND -> this.getLastHandItem($$1);
                case EquipmentSlot.Type.ARMOR -> this.getLastArmorItem($$1);
                case EquipmentSlot.Type.BODY -> this.lastBodyItemStack;
            };
            ItemStack $$3 = this.getItemBySlot($$1);
            if (!this.equipmentHasChanged($$2, $$3)) continue;
            if ($$0 == null) {
                $$0 = Maps.newEnumMap(EquipmentSlot.class);
            }
            $$0.put($$1, $$3);
            AttributeMap $$4 = this.getAttributes();
            if (!$$2.isEmpty()) {
                $$2.forEachModifier($$1, (p_330002_, p_330003_) -> {
                    AttributeInstance $$3 = $$4.getInstance((Holder<Attribute>)p_330002_);
                    if ($$3 != null) {
                        $$3.removeModifier((AttributeModifier)p_330003_);
                    }
                });
            }
            if ($$3.isEmpty()) continue;
            $$3.forEachModifier($$1, (p_332602_, p_332603_) -> {
                AttributeInstance $$3 = $$4.getInstance((Holder<Attribute>)p_332602_);
                if ($$3 != null) {
                    $$3.removeModifier(p_332603_.id());
                    $$3.addTransientModifier((AttributeModifier)p_332603_);
                }
            });
        }
        return $$0;
    }

    public boolean equipmentHasChanged(ItemStack p_252265_, ItemStack p_251043_) {
        return !ItemStack.matches(p_251043_, p_252265_);
    }

    private void handleHandSwap(Map<EquipmentSlot, ItemStack> p_21092_) {
        ItemStack $$1 = p_21092_.get(EquipmentSlot.MAINHAND);
        ItemStack $$2 = p_21092_.get(EquipmentSlot.OFFHAND);
        if ($$1 != null && $$2 != null && ItemStack.matches($$1, this.getLastHandItem(EquipmentSlot.OFFHAND)) && ItemStack.matches($$2, this.getLastHandItem(EquipmentSlot.MAINHAND))) {
            ((ServerLevel)this.level()).getChunkSource().broadcast(this, new ClientboundEntityEventPacket(this, 55));
            p_21092_.remove(EquipmentSlot.MAINHAND);
            p_21092_.remove(EquipmentSlot.OFFHAND);
            this.setLastHandItem(EquipmentSlot.MAINHAND, $$1.copy());
            this.setLastHandItem(EquipmentSlot.OFFHAND, $$2.copy());
        }
    }

    private void handleEquipmentChanges(Map<EquipmentSlot, ItemStack> p_21143_) {
        ArrayList $$1 = Lists.newArrayListWithCapacity((int)p_21143_.size());
        p_21143_.forEach((p_323229_, p_323230_) -> {
            ItemStack $$3 = p_323230_.copy();
            $$1.add(Pair.of((Object)p_323229_, (Object)$$3));
            switch (p_323229_.getType()) {
                case HAND: {
                    this.setLastHandItem((EquipmentSlot)p_323229_, $$3);
                    break;
                }
                case ARMOR: {
                    this.setLastArmorItem((EquipmentSlot)p_323229_, $$3);
                    break;
                }
                case BODY: {
                    this.lastBodyItemStack = $$3;
                }
            }
        });
        ((ServerLevel)this.level()).getChunkSource().broadcast(this, new ClientboundSetEquipmentPacket(this.getId(), $$1));
    }

    private ItemStack getLastArmorItem(EquipmentSlot p_21199_) {
        return this.lastArmorItemStacks.get(p_21199_.getIndex());
    }

    private void setLastArmorItem(EquipmentSlot p_21129_, ItemStack p_21130_) {
        this.lastArmorItemStacks.set(p_21129_.getIndex(), p_21130_);
    }

    private ItemStack getLastHandItem(EquipmentSlot p_21245_) {
        return this.lastHandItemStacks.get(p_21245_.getIndex());
    }

    private void setLastHandItem(EquipmentSlot p_21169_, ItemStack p_21170_) {
        this.lastHandItemStacks.set(p_21169_.getIndex(), p_21170_);
    }

    protected float tickHeadTurn(float p_21260_, float p_21261_) {
        boolean $$5;
        float $$2 = Mth.wrapDegrees(p_21260_ - this.yBodyRot);
        this.yBodyRot += $$2 * 0.3f;
        float $$3 = Mth.wrapDegrees(this.getYRot() - this.yBodyRot);
        float $$4 = this.getMaxHeadRotationRelativeToBody();
        if (Math.abs($$3) > $$4) {
            this.yBodyRot += $$3 - (float)Mth.sign($$3) * $$4;
        }
        boolean bl = $$5 = $$3 < -90.0f || $$3 >= 90.0f;
        if ($$5) {
            p_21261_ *= -1.0f;
        }
        return p_21261_;
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void aiStep() {
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        } else if (!this.isEffectiveAi()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (this.lerpHeadSteps > 0) {
            this.lerpHeadRotationStep(this.lerpHeadSteps, this.lerpYHeadRot);
            --this.lerpHeadSteps;
        }
        $$0 = this.getDeltaMovement();
        $$1 = $$0.x;
        $$2 = $$0.y;
        $$3 = $$0.z;
        if (Math.abs($$0.x) < 0.003) {
            $$1 = 0.0;
        }
        if (Math.abs($$0.y) < 0.003) {
            $$2 = 0.0;
        }
        if (Math.abs($$0.z) < 0.003) {
            $$3 = 0.0;
        }
        this.setDeltaMovement($$1, $$2, $$3);
        this.level().getProfiler().push("ai");
        if (this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi()) {
            this.level().getProfiler().push("newAi");
            this.serverAiStep();
            this.level().getProfiler().pop();
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("jump");
        if (this.jumping && this.isAffectedByFluids()) {
            if (this.isInLava()) {
                $$4 = this.getFluidHeight(FluidTags.LAVA);
            } else {
                $$5 = this.getFluidHeight(FluidTags.WATER);
            }
            $$6 = this.isInWater() != false && $$5 > 0.0;
            $$7 = this.getFluidJumpThreshold();
            if ($$6 && (!this.onGround() || $$5 > $$7)) {
                this.jumpInLiquid(FluidTags.WATER);
            } else if (this.isInLava() && (!this.onGround() || $$5 > $$7)) {
                this.jumpInLiquid(FluidTags.LAVA);
            } else if ((this.onGround() || $$6 && $$5 <= $$7) && this.noJumpDelay == 0) {
                this.jumpFromGround();
                this.noJumpDelay = 10;
            }
        } else {
            this.noJumpDelay = 0;
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("travel");
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
        this.updateFallFlying();
        $$8 = this.getBoundingBox();
        $$9 = new Vec3(this.xxa, this.yya, this.zza);
        if (this.hasEffect(MobEffects.SLOW_FALLING) || this.hasEffect(MobEffects.LEVITATION)) {
            this.resetFallDistance();
        }
        if (!((var11_11 = this.getControllingPassenger()) instanceof Player)) ** GOTO lbl-1000
        $$10 = (Player)var11_11;
        if (this.isAlive()) {
            this.travelRidden($$10, $$9);
        } else lbl-1000:
        // 2 sources

        {
            this.travel($$9);
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("freezing");
        if (!this.level().isClientSide && !this.isDeadOrDying()) {
            $$11 = this.getTicksFrozen();
            if (this.isInPowderSnow && this.canFreeze()) {
                this.setTicksFrozen(Math.min(this.getTicksRequiredToFreeze(), $$11 + 1));
            } else {
                this.setTicksFrozen(Math.max(0, $$11 - 2));
            }
        }
        this.removeFrost();
        this.tryAddFrost();
        if (!this.level().isClientSide && this.tickCount % 40 == 0 && this.isFullyFrozen() && this.canFreeze()) {
            this.hurt(this.damageSources().freeze(), 1.0f);
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("push");
        if (this.autoSpinAttackTicks > 0) {
            --this.autoSpinAttackTicks;
            this.checkAutoSpinAttack($$8, this.getBoundingBox());
        }
        this.pushEntities();
        this.level().getProfiler().pop();
        if (!this.level().isClientSide && this.isSensitiveToWater() && this.isInWaterRainOrBubble()) {
            this.hurt(this.damageSources().drown(), 1.0f);
        }
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    private void updateFallFlying() {
        boolean $$0 = this.getSharedFlag(7);
        if ($$0 && !this.onGround() && !this.isPassenger() && !this.hasEffect(MobEffects.LEVITATION)) {
            ItemStack $$1 = this.getItemBySlot(EquipmentSlot.CHEST);
            if ($$1.is(Items.ELYTRA) && ElytraItem.isFlyEnabled($$1)) {
                $$0 = true;
                int $$2 = this.fallFlyTicks + 1;
                if (!this.level().isClientSide && $$2 % 10 == 0) {
                    int $$3 = $$2 / 10;
                    if ($$3 % 2 == 0) {
                        $$1.hurtAndBreak(1, this, EquipmentSlot.CHEST);
                    }
                    this.gameEvent(GameEvent.ELYTRA_GLIDE);
                }
            } else {
                $$0 = false;
            }
        } else {
            $$0 = false;
        }
        if (!this.level().isClientSide) {
            this.setSharedFlag(7, $$0);
        }
    }

    protected void serverAiStep() {
    }

    protected void pushEntities() {
        if (this.level().isClientSide()) {
            this.level().getEntities(EntityTypeTest.forClass(Player.class), this.getBoundingBox(), EntitySelector.pushableBy(this)).forEach(this::doPush);
            return;
        }
        List<Entity> $$0 = this.level().getEntities(this, this.getBoundingBox(), EntitySelector.pushableBy(this));
        if (!$$0.isEmpty()) {
            int $$1 = this.level().getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            if ($$1 > 0 && $$0.size() > $$1 - 1 && this.random.nextInt(4) == 0) {
                int $$2 = 0;
                for (Entity $$3 : $$0) {
                    if ($$3.isPassenger()) continue;
                    ++$$2;
                }
                if ($$2 > $$1 - 1) {
                    this.hurt(this.damageSources().cramming(), 6.0f);
                }
            }
            for (Entity $$4 : $$0) {
                this.doPush($$4);
            }
        }
    }

    protected void checkAutoSpinAttack(AABB p_21072_, AABB p_21073_) {
        AABB $$2 = p_21072_.minmax(p_21073_);
        List<Entity> $$3 = this.level().getEntities(this, $$2);
        if (!$$3.isEmpty()) {
            for (Entity $$4 : $$3) {
                if (!($$4 instanceof LivingEntity)) continue;
                this.doAutoAttackOnTouch((LivingEntity)$$4);
                this.autoSpinAttackTicks = 0;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.2));
                break;
            }
        } else if (this.horizontalCollision) {
            this.autoSpinAttackTicks = 0;
        }
        if (!this.level().isClientSide && this.autoSpinAttackTicks <= 0) {
            this.setLivingEntityFlag(4, false);
        }
    }

    protected void doPush(Entity p_20971_) {
        p_20971_.push(this);
    }

    protected void doAutoAttackOnTouch(LivingEntity p_21277_) {
    }

    public boolean isAutoSpinAttack() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 4) != 0;
    }

    @Override
    public void stopRiding() {
        Entity $$0 = this.getVehicle();
        super.stopRiding();
        if ($$0 != null && $$0 != this.getVehicle() && !this.level().isClientSide) {
            this.dismountVehicle($$0);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.oRun = this.run;
        this.run = 0.0f;
        this.resetFallDistance();
    }

    @Override
    public void lerpTo(double p_20977_, double p_20978_, double p_20979_, float p_20980_, float p_20981_, int p_20982_) {
        this.lerpX = p_20977_;
        this.lerpY = p_20978_;
        this.lerpZ = p_20979_;
        this.lerpYRot = p_20980_;
        this.lerpXRot = p_20981_;
        this.lerpSteps = p_20982_;
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpHeadTo(float p_21005_, int p_21006_) {
        this.lerpYHeadRot = p_21005_;
        this.lerpHeadSteps = p_21006_;
    }

    public void setJumping(boolean p_21314_) {
        this.jumping = p_21314_;
    }

    public void onItemPickup(ItemEntity p_21054_) {
        Entity $$1 = p_21054_.getOwner();
        if ($$1 instanceof ServerPlayer) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.trigger((ServerPlayer)$$1, p_21054_.getItem(), this);
        }
    }

    public void take(Entity p_21030_, int p_21031_) {
        if (!p_21030_.isRemoved() && !this.level().isClientSide && (p_21030_ instanceof ItemEntity || p_21030_ instanceof AbstractArrow || p_21030_ instanceof ExperienceOrb)) {
            ((ServerLevel)this.level()).getChunkSource().broadcast(p_21030_, new ClientboundTakeItemEntityPacket(p_21030_.getId(), this.getId(), p_21031_));
        }
    }

    public boolean hasLineOfSight(Entity p_147185_) {
        if (p_147185_.level() != this.level()) {
            return false;
        }
        Vec3 $$1 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 $$2 = new Vec3(p_147185_.getX(), p_147185_.getEyeY(), p_147185_.getZ());
        if ($$2.distanceTo($$1) > 128.0) {
            return false;
        }
        return this.level().clip(new ClipContext($$1, $$2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this)).getType() == HitResult.Type.MISS;
    }

    @Override
    public float getViewYRot(float p_21286_) {
        if (p_21286_ == 1.0f) {
            return this.yHeadRot;
        }
        return Mth.lerp(p_21286_, this.yHeadRotO, this.yHeadRot);
    }

    public float getAttackAnim(float p_21325_) {
        float $$1 = this.attackAnim - this.oAttackAnim;
        if ($$1 < 0.0f) {
            $$1 += 1.0f;
        }
        return this.oAttackAnim + $$1 * p_21325_;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable();
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public void setYHeadRot(float p_21306_) {
        this.yHeadRot = p_21306_;
    }

    @Override
    public void setYBodyRot(float p_21309_) {
        this.yBodyRot = p_21309_;
    }

    @Override
    protected Vec3 getRelativePortalPosition(Direction.Axis p_21085_, BlockUtil.FoundRectangle p_21086_) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(p_21085_, p_21086_));
    }

    public static Vec3 resetForwardDirectionOfRelativePortalPosition(Vec3 p_21290_) {
        return new Vec3(p_21290_.x, p_21290_.y, 0.0);
    }

    public float getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public final void setAbsorptionAmount(float p_21328_) {
        this.internalSetAbsorptionAmount(Mth.clamp(p_21328_, 0.0f, this.getMaxAbsorption()));
    }

    protected void internalSetAbsorptionAmount(float p_295258_) {
        this.absorptionAmount = p_295258_;
    }

    public void onEnterCombat() {
    }

    public void onLeaveCombat() {
    }

    protected void updateEffectVisibility() {
        this.effectsDirty = true;
    }

    public abstract HumanoidArm getMainArm();

    public boolean isUsingItem() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
    }

    public InteractionHand getUsedItemHand() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    private void updatingUsingItem() {
        if (this.isUsingItem()) {
            if (ItemStack.isSameItem(this.getItemInHand(this.getUsedItemHand()), this.useItem)) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                this.updateUsingItem(this.useItem);
            } else {
                this.stopUsingItem();
            }
        }
    }

    protected void updateUsingItem(ItemStack p_147201_) {
        p_147201_.onUseTick(this.level(), this, this.getUseItemRemainingTicks());
        if (this.shouldTriggerItemUseEffects()) {
            this.triggerItemUseEffects(p_147201_, 5);
        }
        if (--this.useItemRemaining == 0 && !this.level().isClientSide && !p_147201_.useOnRelease()) {
            this.completeUsingItem();
        }
    }

    private boolean shouldTriggerItemUseEffects() {
        int $$1;
        int $$0 = this.useItem.getUseDuration() - this.getUseItemRemainingTicks();
        boolean $$2 = $$0 > ($$1 = (int)((float)this.useItem.getUseDuration() * 0.21875f));
        return $$2 && this.getUseItemRemainingTicks() % 4 == 0;
    }

    private void updateSwimAmount() {
        this.swimAmountO = this.swimAmount;
        this.swimAmount = this.isVisuallySwimming() ? Math.min(1.0f, this.swimAmount + 0.09f) : Math.max(0.0f, this.swimAmount - 0.09f);
    }

    protected void setLivingEntityFlag(int p_21156_, boolean p_21157_) {
        int $$2 = this.entityData.get(DATA_LIVING_ENTITY_FLAGS).byteValue();
        $$2 = p_21157_ ? ($$2 |= p_21156_) : ($$2 &= ~p_21156_);
        this.entityData.set(DATA_LIVING_ENTITY_FLAGS, (byte)$$2);
    }

    public void startUsingItem(InteractionHand p_21159_) {
        ItemStack $$1 = this.getItemInHand(p_21159_);
        if ($$1.isEmpty() || this.isUsingItem()) {
            return;
        }
        this.useItem = $$1;
        this.useItemRemaining = $$1.getUseDuration();
        if (!this.level().isClientSide) {
            this.setLivingEntityFlag(1, true);
            this.setLivingEntityFlag(2, p_21159_ == InteractionHand.OFF_HAND);
            this.gameEvent(GameEvent.ITEM_INTERACT_START);
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_21104_) {
        super.onSyncedDataUpdated(p_21104_);
        if (SLEEPING_POS_ID.equals(p_21104_)) {
            if (this.level().isClientSide) {
                this.getSleepingPos().ifPresent(this::setPosToBed);
            }
        } else if (DATA_LIVING_ENTITY_FLAGS.equals(p_21104_) && this.level().isClientSide) {
            if (this.isUsingItem() && this.useItem.isEmpty()) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                if (!this.useItem.isEmpty()) {
                    this.useItemRemaining = this.useItem.getUseDuration();
                }
            } else if (!this.isUsingItem() && !this.useItem.isEmpty()) {
                this.useItem = ItemStack.EMPTY;
                this.useItemRemaining = 0;
            }
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor p_21078_, Vec3 p_21079_) {
        super.lookAt(p_21078_, p_21079_);
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot = this.yHeadRot;
    }

    protected void triggerItemUseEffects(ItemStack p_21138_, int p_21139_) {
        if (p_21138_.isEmpty() || !this.isUsingItem()) {
            return;
        }
        if (p_21138_.getUseAnimation() == UseAnim.DRINK) {
            this.playSound(this.getDrinkingSound(p_21138_), 0.5f, this.level().random.nextFloat() * 0.1f + 0.9f);
        }
        if (p_21138_.getUseAnimation() == UseAnim.EAT) {
            this.spawnItemParticles(p_21138_, p_21139_);
            this.playSound(this.getEatingSound(p_21138_), 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    private void spawnItemParticles(ItemStack p_21061_, int p_21062_) {
        for (int $$2 = 0; $$2 < p_21062_; ++$$2) {
            Vec3 $$3 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            $$3 = $$3.xRot(-this.getXRot() * ((float)Math.PI / 180));
            $$3 = $$3.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double $$4 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3 $$5 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.3, $$4, 0.6);
            $$5 = $$5.xRot(-this.getXRot() * ((float)Math.PI / 180));
            $$5 = $$5.yRot(-this.getYRot() * ((float)Math.PI / 180));
            $$5 = $$5.add(this.getX(), this.getEyeY(), this.getZ());
            this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, p_21061_), $$5.x, $$5.y, $$5.z, $$3.x, $$3.y + 0.05, $$3.z);
        }
    }

    protected void completeUsingItem() {
        if (this.level().isClientSide && !this.isUsingItem()) {
            return;
        }
        InteractionHand $$0 = this.getUsedItemHand();
        if (!this.useItem.equals(this.getItemInHand($$0))) {
            this.releaseUsingItem();
            return;
        }
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            this.triggerItemUseEffects(this.useItem, 16);
            ItemStack $$1 = this.useItem.finishUsingItem(this.level(), this);
            if ($$1 != this.useItem) {
                this.setItemInHand($$0, $$1);
            }
            this.stopUsingItem();
        }
    }

    public ItemStack getUseItem() {
        return this.useItem;
    }

    public int getUseItemRemainingTicks() {
        return this.useItemRemaining;
    }

    public int getTicksUsingItem() {
        if (this.isUsingItem()) {
            return this.useItem.getUseDuration() - this.getUseItemRemainingTicks();
        }
        return 0;
    }

    public void releaseUsingItem() {
        if (!this.useItem.isEmpty()) {
            this.useItem.releaseUsing(this.level(), this, this.getUseItemRemainingTicks());
            if (this.useItem.useOnRelease()) {
                this.updatingUsingItem();
            }
        }
        this.stopUsingItem();
    }

    public void stopUsingItem() {
        if (!this.level().isClientSide) {
            boolean $$0 = this.isUsingItem();
            this.setLivingEntityFlag(1, false);
            if ($$0) {
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
        }
        this.useItem = ItemStack.EMPTY;
        this.useItemRemaining = 0;
    }

    public boolean isBlocking() {
        if (!this.isUsingItem() || this.useItem.isEmpty()) {
            return false;
        }
        Item $$0 = this.useItem.getItem();
        if ($$0.getUseAnimation(this.useItem) != UseAnim.BLOCK) {
            return false;
        }
        return $$0.getUseDuration(this.useItem) - this.useItemRemaining >= 5;
    }

    public boolean isSuppressingSlidingDownLadder() {
        return this.isShiftKeyDown();
    }

    public boolean isFallFlying() {
        return this.getSharedFlag(7);
    }

    @Override
    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming() || !this.isFallFlying() && this.hasPose(Pose.FALL_FLYING);
    }

    public int getFallFlyingTicks() {
        return this.fallFlyTicks;
    }

    public boolean randomTeleport(double p_20985_, double p_20986_, double p_20987_, boolean p_20988_) {
        LivingEntity livingEntity;
        double $$4 = this.getX();
        double $$5 = this.getY();
        double $$6 = this.getZ();
        double $$7 = p_20986_;
        boolean $$8 = false;
        BlockPos $$9 = BlockPos.containing(p_20985_, $$7, p_20987_);
        Level $$10 = this.level();
        if ($$10.hasChunkAt($$9)) {
            boolean $$11 = false;
            while (!$$11 && $$9.getY() > $$10.getMinBuildHeight()) {
                BlockPos $$12 = $$9.below();
                BlockState $$13 = $$10.getBlockState($$12);
                if ($$13.blocksMotion()) {
                    $$11 = true;
                    continue;
                }
                $$7 -= 1.0;
                $$9 = $$12;
            }
            if ($$11) {
                this.teleportTo(p_20985_, $$7, p_20987_);
                if ($$10.noCollision(this) && !$$10.containsAnyLiquid(this.getBoundingBox())) {
                    $$8 = true;
                }
            }
        }
        if (!$$8) {
            this.teleportTo($$4, $$5, $$6);
            return false;
        }
        if (p_20988_) {
            $$10.broadcastEntityEvent(this, (byte)46);
        }
        if ((livingEntity = this) instanceof PathfinderMob) {
            PathfinderMob $$14 = (PathfinderMob)livingEntity;
            $$14.getNavigation().stop();
        }
        return true;
    }

    public boolean isAffectedByPotions() {
        return !this.isDeadOrDying();
    }

    public boolean attackable() {
        return true;
    }

    public void setRecordPlayingNearby(BlockPos p_21082_, boolean p_21083_) {
    }

    public boolean canTakeItem(ItemStack p_21249_) {
        return false;
    }

    @Override
    public final EntityDimensions getDimensions(Pose p_21047_) {
        return p_21047_ == Pose.SLEEPING ? SLEEPING_DIMENSIONS : this.getDefaultDimensions(p_21047_).scale(this.getScale());
    }

    protected EntityDimensions getDefaultDimensions(Pose p_316700_) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)Pose.STANDING));
    }

    public AABB getLocalBoundsForPose(Pose p_21271_) {
        EntityDimensions $$1 = this.getDimensions(p_21271_);
        return new AABB(-$$1.width() / 2.0f, 0.0, -$$1.width() / 2.0f, $$1.width() / 2.0f, $$1.height(), $$1.width() / 2.0f);
    }

    protected boolean wouldNotSuffocateAtTargetPose(Pose p_294977_) {
        AABB $$1 = this.getDimensions(p_294977_).makeBoundingBox(this.position());
        return this.level().noBlockCollision(this, $$1);
    }

    @Override
    public boolean canChangeDimensions() {
        return super.canChangeDimensions() && !this.isSleeping();
    }

    public Optional<BlockPos> getSleepingPos() {
        return this.entityData.get(SLEEPING_POS_ID);
    }

    public void setSleepingPos(BlockPos p_21251_) {
        this.entityData.set(SLEEPING_POS_ID, Optional.of(p_21251_));
    }

    public void clearSleepingPos() {
        this.entityData.set(SLEEPING_POS_ID, Optional.empty());
    }

    public boolean isSleeping() {
        return this.getSleepingPos().isPresent();
    }

    public void startSleeping(BlockPos p_21141_) {
        BlockState $$1;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if (($$1 = this.level().getBlockState(p_21141_)).getBlock() instanceof BedBlock) {
            this.level().setBlock(p_21141_, (BlockState)$$1.setValue(BedBlock.OCCUPIED, true), 3);
        }
        this.setPose(Pose.SLEEPING);
        this.setPosToBed(p_21141_);
        this.setSleepingPos(p_21141_);
        this.setDeltaMovement(Vec3.ZERO);
        this.hasImpulse = true;
    }

    private void setPosToBed(BlockPos p_21081_) {
        this.setPos((double)p_21081_.getX() + 0.5, (double)p_21081_.getY() + 0.6875, (double)p_21081_.getZ() + 0.5);
    }

    private boolean checkBedExists() {
        return this.getSleepingPos().map(p_337701_ -> this.level().getBlockState((BlockPos)p_337701_).getBlock() instanceof BedBlock).orElse(false);
    }

    public void stopSleeping() {
        this.getSleepingPos().filter(this.level()::hasChunkAt).ifPresent(p_261435_ -> {
            BlockState $$1 = this.level().getBlockState((BlockPos)p_261435_);
            if ($$1.getBlock() instanceof BedBlock) {
                Direction $$2 = $$1.getValue(BedBlock.FACING);
                this.level().setBlock((BlockPos)p_261435_, (BlockState)$$1.setValue(BedBlock.OCCUPIED, false), 3);
                Vec3 $$3 = BedBlock.findStandUpPosition(this.getType(), this.level(), p_261435_, $$2, this.getYRot()).orElseGet(() -> {
                    BlockPos $$1 = p_261435_.above();
                    return new Vec3((double)$$1.getX() + 0.5, (double)$$1.getY() + 0.1, (double)$$1.getZ() + 0.5);
                });
                Vec3 $$4 = Vec3.atBottomCenterOf(p_261435_).subtract($$3).normalize();
                float $$5 = (float)Mth.wrapDegrees(Mth.atan2($$4.z, $$4.x) * 57.2957763671875 - 90.0);
                this.setPos($$3.x, $$3.y, $$3.z);
                this.setYRot($$5);
                this.setXRot(0.0f);
            }
        });
        Vec3 $$0 = this.position();
        this.setPose(Pose.STANDING);
        this.setPos($$0.x, $$0.y, $$0.z);
        this.clearSleepingPos();
    }

    @Nullable
    public Direction getBedOrientation() {
        BlockPos $$0 = this.getSleepingPos().orElse(null);
        return $$0 != null ? BedBlock.getBedOrientation(this.level(), $$0) : null;
    }

    @Override
    public boolean isInWall() {
        return !this.isSleeping() && super.isInWall();
    }

    public ItemStack getProjectile(ItemStack p_21272_) {
        return ItemStack.EMPTY;
    }

    public ItemStack eat(Level p_21067_, ItemStack p_21068_) {
        FoodProperties $$2 = p_21068_.get(DataComponents.FOOD);
        if ($$2 != null) {
            p_21067_.playSound(null, this.getX(), this.getY(), this.getZ(), this.getEatingSound(p_21068_), SoundSource.NEUTRAL, 1.0f, 1.0f + (p_21067_.random.nextFloat() - p_21067_.random.nextFloat()) * 0.4f);
            this.addEatEffect($$2);
            p_21068_.consume(1, this);
            this.gameEvent(GameEvent.EAT);
        }
        return p_21068_;
    }

    private void addEatEffect(FoodProperties p_335472_) {
        if (this.level().isClientSide()) {
            return;
        }
        List<FoodProperties.PossibleEffect> $$1 = p_335472_.effects();
        for (FoodProperties.PossibleEffect $$2 : $$1) {
            if (!(this.random.nextFloat() < $$2.probability())) continue;
            this.addEffect($$2.effect());
        }
    }

    private static byte entityEventForEquipmentBreak(EquipmentSlot p_21267_) {
        return switch (p_21267_) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAINHAND -> 47;
            case EquipmentSlot.OFFHAND -> 48;
            case EquipmentSlot.HEAD -> 49;
            case EquipmentSlot.CHEST -> 50;
            case EquipmentSlot.FEET -> 52;
            case EquipmentSlot.LEGS -> 51;
            case EquipmentSlot.BODY -> 65;
        };
    }

    public void broadcastBreakEvent(EquipmentSlot p_21167_) {
        this.level().broadcastEntityEvent(this, LivingEntity.entityEventForEquipmentBreak(p_21167_));
    }

    public static EquipmentSlot getSlotForHand(InteractionHand p_320526_) {
        return p_320526_ == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    @Override
    public AABB getBoundingBoxForCulling() {
        if (this.getItemBySlot(EquipmentSlot.HEAD).is(Items.DRAGON_HEAD)) {
            float $$0 = 0.5f;
            return this.getBoundingBox().inflate(0.5, 0.5, 0.5);
        }
        return super.getBoundingBoxForCulling();
    }

    public static EquipmentSlot getEquipmentSlotForItem(ItemStack p_147234_) {
        Equipable $$1 = Equipable.get(p_147234_);
        if ($$1 != null) {
            return $$1.getEquipmentSlot();
        }
        return EquipmentSlot.MAINHAND;
    }

    private static SlotAccess createEquipmentSlotAccess(LivingEntity p_147196_, EquipmentSlot p_147197_) {
        if (p_147197_ == EquipmentSlot.HEAD || p_147197_ == EquipmentSlot.MAINHAND || p_147197_ == EquipmentSlot.OFFHAND) {
            return SlotAccess.forEquipmentSlot(p_147196_, p_147197_);
        }
        return SlotAccess.forEquipmentSlot(p_147196_, p_147197_, p_269791_ -> p_269791_.isEmpty() || Mob.getEquipmentSlotForItem(p_269791_) == p_147197_);
    }

    @Nullable
    private static EquipmentSlot getEquipmentSlot(int p_147212_) {
        if (p_147212_ == 100 + EquipmentSlot.HEAD.getIndex()) {
            return EquipmentSlot.HEAD;
        }
        if (p_147212_ == 100 + EquipmentSlot.CHEST.getIndex()) {
            return EquipmentSlot.CHEST;
        }
        if (p_147212_ == 100 + EquipmentSlot.LEGS.getIndex()) {
            return EquipmentSlot.LEGS;
        }
        if (p_147212_ == 100 + EquipmentSlot.FEET.getIndex()) {
            return EquipmentSlot.FEET;
        }
        if (p_147212_ == 98) {
            return EquipmentSlot.MAINHAND;
        }
        if (p_147212_ == 99) {
            return EquipmentSlot.OFFHAND;
        }
        if (p_147212_ == 105) {
            return EquipmentSlot.BODY;
        }
        return null;
    }

    @Override
    public SlotAccess getSlot(int p_147238_) {
        EquipmentSlot $$1 = LivingEntity.getEquipmentSlot(p_147238_);
        if ($$1 != null) {
            return LivingEntity.createEquipmentSlotAccess(this, $$1);
        }
        return super.getSlot(p_147238_);
    }

    @Override
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        boolean $$0 = !this.getItemBySlot(EquipmentSlot.HEAD).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.CHEST).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.LEGS).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.FEET).is(ItemTags.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EquipmentSlot.BODY).is(ItemTags.FREEZE_IMMUNE_WEARABLES);
        return $$0 && super.canFreeze();
    }

    @Override
    public boolean isCurrentlyGlowing() {
        return !this.level().isClientSide() && this.hasEffect(MobEffects.GLOWING) || super.isCurrentlyGlowing();
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.yBodyRot;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_217037_) {
        double $$1 = p_217037_.getX();
        double $$2 = p_217037_.getY();
        double $$3 = p_217037_.getZ();
        float $$4 = p_217037_.getYRot();
        float $$5 = p_217037_.getXRot();
        this.syncPacketPositionCodec($$1, $$2, $$3);
        this.yBodyRot = p_217037_.getYHeadRot();
        this.yHeadRot = p_217037_.getYHeadRot();
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.setId(p_217037_.getId());
        this.setUUID(p_217037_.getUUID());
        this.absMoveTo($$1, $$2, $$3, $$4, $$5);
        this.setDeltaMovement(p_217037_.getXa(), p_217037_.getYa(), p_217037_.getZa());
    }

    public boolean canDisableShield() {
        return this.getMainHandItem().getItem() instanceof AxeItem;
    }

    @Override
    public float maxUpStep() {
        float $$0 = (float)this.getAttributeValue(Attributes.STEP_HEIGHT);
        return this.getControllingPassenger() instanceof Player ? Math.max($$0, 1.0f) : $$0;
    }

    @Override
    public Vec3 getPassengerRidingPosition(Entity p_295664_) {
        return this.position().add(this.getPassengerAttachmentPoint(p_295664_, this.getDimensions(this.getPose()), this.getScale() * this.getAgeScale()));
    }

    protected void lerpHeadRotationStep(int p_296134_, double p_296397_) {
        this.yHeadRot = (float)Mth.rotLerp(1.0 / (double)p_296134_, (double)this.yHeadRot, p_296397_);
    }

    @Override
    public void igniteForTicks(int p_319861_) {
        super.igniteForTicks(ProtectionEnchantment.getFireAfterDampener(this, p_319861_));
    }

    public boolean hasInfiniteMaterials() {
        return false;
    }

    public record Fallsounds(SoundEvent small, SoundEvent big) {
    }
}

