/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensing;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public abstract class Mob
extends LivingEntity
implements EquipmentUser,
Targeting {
    private static final EntityDataAccessor<Byte> DATA_MOB_FLAGS_ID = SynchedEntityData.defineId(Mob.class, EntityDataSerializers.BYTE);
    private static final int MOB_FLAG_NO_AI = 1;
    private static final int MOB_FLAG_LEFTHANDED = 2;
    private static final int MOB_FLAG_AGGRESSIVE = 4;
    protected static final int PICKUP_REACH = 1;
    private static final Vec3i ITEM_PICKUP_REACH = new Vec3i(1, 0, 1);
    public static final float MAX_WEARING_ARMOR_CHANCE = 0.15f;
    public static final float MAX_PICKUP_LOOT_CHANCE = 0.55f;
    public static final float MAX_ENCHANTED_ARMOR_CHANCE = 0.5f;
    public static final float MAX_ENCHANTED_WEAPON_CHANCE = 0.25f;
    public static final String LEASH_TAG = "leash";
    public static final float DEFAULT_EQUIPMENT_DROP_CHANCE = 0.085f;
    public static final int PRESERVE_ITEM_DROP_CHANCE = 2;
    public static final int UPDATE_GOAL_SELECTOR_EVERY_N_TICKS = 2;
    private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    public int ambientSoundTime;
    protected int xpReward;
    protected LookControl lookControl;
    protected MoveControl moveControl;
    protected JumpControl jumpControl;
    private final BodyRotationControl bodyRotationControl;
    protected PathNavigation navigation;
    protected final GoalSelector goalSelector;
    protected final GoalSelector targetSelector;
    @Nullable
    private LivingEntity target;
    private final Sensing sensing;
    private final NonNullList<ItemStack> handItems = NonNullList.withSize(2, ItemStack.EMPTY);
    protected final float[] handDropChances = new float[2];
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize(4, ItemStack.EMPTY);
    protected final float[] armorDropChances = new float[4];
    private ItemStack bodyArmorItem = ItemStack.EMPTY;
    protected float bodyArmorDropChance;
    private boolean canPickUpLoot;
    private boolean persistenceRequired;
    private final Map<PathType, Float> pathfindingMalus = Maps.newEnumMap(PathType.class);
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;
    @Nullable
    private Entity leashHolder;
    private int delayedLeashHolderId;
    @Nullable
    private Either<UUID, BlockPos> delayedLeashInfo;
    private BlockPos restrictCenter = BlockPos.ZERO;
    private float restrictRadius = -1.0f;

    protected Mob(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super((EntityType<? extends LivingEntity>)p_21368_, p_21369_);
        this.goalSelector = new GoalSelector(p_21369_.getProfilerSupplier());
        this.targetSelector = new GoalSelector(p_21369_.getProfilerSupplier());
        this.lookControl = new LookControl(this);
        this.moveControl = new MoveControl(this);
        this.jumpControl = new JumpControl(this);
        this.bodyRotationControl = this.createBodyControl();
        this.navigation = this.createNavigation(p_21369_);
        this.sensing = new Sensing(this);
        Arrays.fill(this.armorDropChances, 0.085f);
        Arrays.fill(this.handDropChances, 0.085f);
        this.bodyArmorDropChance = 0.085f;
        if (p_21369_ != null && !p_21369_.isClientSide) {
            this.registerGoals();
        }
    }

    protected void registerGoals() {
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_KNOCKBACK);
    }

    protected PathNavigation createNavigation(Level p_21480_) {
        return new GroundPathNavigation(this, p_21480_);
    }

    protected boolean shouldPassengersInheritMalus() {
        return false;
    }

    public float getPathfindingMalus(PathType p_326934_) {
        Mob $$3;
        Mob $$1;
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob && ($$1 = (Mob)entity).shouldPassengersInheritMalus()) {
            Mob $$2 = $$1;
        } else {
            $$3 = this;
        }
        Float $$4 = $$3.pathfindingMalus.get((Object)p_326934_);
        return $$4 == null ? p_326934_.getMalus() : $$4.floatValue();
    }

    public void setPathfindingMalus(PathType p_326826_, float p_21443_) {
        this.pathfindingMalus.put(p_326826_, Float.valueOf(p_21443_));
    }

    public void onPathfindingStart() {
    }

    public void onPathfindingDone() {
    }

    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl(this);
    }

    public LookControl getLookControl() {
        return this.lookControl;
    }

    public MoveControl getMoveControl() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob $$0 = (Mob)entity;
            return $$0.getMoveControl();
        }
        return this.moveControl;
    }

    public JumpControl getJumpControl() {
        return this.jumpControl;
    }

    public PathNavigation getNavigation() {
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Mob) {
            Mob $$0 = (Mob)entity;
            return $$0.getNavigation();
        }
        return this.navigation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity $$0 = this.getFirstPassenger();
        if (this.isNoAi()) return null;
        if (!($$0 instanceof Mob)) return null;
        Mob $$1 = (Mob)$$0;
        if (!$$0.canControlVehicle()) return null;
        Mob mob = $$1;
        return mob;
    }

    public Sensing getSensing() {
        return this.sensing;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    @Nullable
    protected final LivingEntity getTargetFromBrain() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public void setTarget(@Nullable LivingEntity p_21544_) {
        this.target = p_21544_;
    }

    @Override
    public boolean canAttackType(EntityType<?> p_21399_) {
        return p_21399_ != EntityType.GHAST;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem p_21430_) {
        return false;
    }

    public void ate() {
        this.gameEvent(GameEvent.EAT);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326499_) {
        super.defineSynchedData(p_326499_);
        p_326499_.define(DATA_MOB_FLAGS_ID, (byte)0);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    public void playAmbientSound() {
        this.makeSound(this.getAmbientSound());
    }

    @Override
    public void baseTick() {
        super.baseTick();
        this.level().getProfiler().push("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.ambientSoundTime++) {
            this.resetAmbientSoundTime();
            this.playAmbientSound();
        }
        this.level().getProfiler().pop();
    }

    @Override
    protected void playHurtSound(DamageSource p_21493_) {
        this.resetAmbientSoundTime();
        super.playHurtSound(p_21493_);
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    @Override
    public int getExperienceReward() {
        if (this.xpReward > 0) {
            int $$0 = this.xpReward;
            for (int $$1 = 0; $$1 < this.armorItems.size(); ++$$1) {
                if (this.armorItems.get($$1).isEmpty() || !(this.armorDropChances[$$1] <= 1.0f)) continue;
                $$0 += 1 + this.random.nextInt(3);
            }
            for (int $$2 = 0; $$2 < this.handItems.size(); ++$$2) {
                if (this.handItems.get($$2).isEmpty() || !(this.handDropChances[$$2] <= 1.0f)) continue;
                $$0 += 1 + this.random.nextInt(3);
            }
            if (!this.bodyArmorItem.isEmpty() && this.bodyArmorDropChance <= 1.0f) {
                $$0 += 1 + this.random.nextInt(3);
            }
            return $$0;
        }
        return this.xpReward;
    }

    public void spawnAnim() {
        if (this.level().isClientSide) {
            for (int $$0 = 0; $$0 < 20; ++$$0) {
                double $$1 = this.random.nextGaussian() * 0.02;
                double $$2 = this.random.nextGaussian() * 0.02;
                double $$3 = this.random.nextGaussian() * 0.02;
                double $$4 = 10.0;
                this.level().addParticle(ParticleTypes.POOF, this.getX(1.0) - $$1 * 10.0, this.getRandomY() - $$2 * 10.0, this.getRandomZ(1.0) - $$3 * 10.0, $$1, $$2, $$3);
            }
        } else {
            this.level().broadcastEntityEvent(this, (byte)20);
        }
    }

    @Override
    public void handleEntityEvent(byte p_21375_) {
        if (p_21375_ == 20) {
            this.spawnAnim();
        } else {
            super.handleEntityEvent(p_21375_);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.tickLeash();
            if (this.tickCount % 5 == 0) {
                this.updateControlFlags();
            }
        }
    }

    protected void updateControlFlags() {
        boolean $$0 = !(this.getControllingPassenger() instanceof Mob);
        boolean $$1 = !(this.getVehicle() instanceof Boat);
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, $$0);
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, $$0 && $$1);
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, $$0);
    }

    @Override
    protected float tickHeadTurn(float p_21538_, float p_21539_) {
        this.bodyRotationControl.clientTick();
        return p_21539_;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_21484_) {
        super.addAdditionalSaveData(p_21484_);
        p_21484_.putBoolean("CanPickUpLoot", this.canPickUpLoot());
        p_21484_.putBoolean("PersistenceRequired", this.persistenceRequired);
        ListTag $$1 = new ListTag();
        for (ItemStack itemStack : this.armorItems) {
            if (!itemStack.isEmpty()) {
                $$1.add(itemStack.save(this.registryAccess()));
                continue;
            }
            $$1.add(new CompoundTag());
        }
        p_21484_.put("ArmorItems", $$1);
        ListTag $$3 = new ListTag();
        for (float $$4 : this.armorDropChances) {
            $$3.add(FloatTag.valueOf($$4));
        }
        p_21484_.put("ArmorDropChances", $$3);
        ListTag listTag = new ListTag();
        for (ItemStack $$6 : this.handItems) {
            if (!$$6.isEmpty()) {
                listTag.add($$6.save(this.registryAccess()));
                continue;
            }
            listTag.add(new CompoundTag());
        }
        p_21484_.put("HandItems", listTag);
        ListTag $$7 = new ListTag();
        for (float $$8 : this.handDropChances) {
            $$7.add(FloatTag.valueOf($$8));
        }
        p_21484_.put("HandDropChances", $$7);
        if (!this.bodyArmorItem.isEmpty()) {
            p_21484_.put("body_armor_item", this.bodyArmorItem.save(this.registryAccess()));
            p_21484_.putFloat("body_armor_drop_chance", this.bodyArmorDropChance);
        }
        Either $$9 = this.delayedLeashInfo;
        if (this.leashHolder instanceof LivingEntity) {
            $$9 = Either.left((Object)this.leashHolder.getUUID());
        } else {
            Entity entity = this.leashHolder;
            if (entity instanceof HangingEntity) {
                HangingEntity $$10 = (HangingEntity)entity;
                $$9 = Either.right((Object)$$10.getPos());
            }
        }
        if ($$9 != null) {
            p_21484_.put(LEASH_TAG, (Tag)$$9.map(p_325668_ -> {
                CompoundTag $$1 = new CompoundTag();
                $$1.putUUID("UUID", (UUID)p_325668_);
                return $$1;
            }, NbtUtils::writeBlockPos));
        }
        p_21484_.putBoolean("LeftHanded", this.isLeftHanded());
        if (this.lootTable != null) {
            p_21484_.putString("DeathLootTable", this.lootTable.location().toString());
            if (this.lootTableSeed != 0L) {
                p_21484_.putLong("DeathLootTableSeed", this.lootTableSeed);
            }
        }
        if (this.isNoAi()) {
            p_21484_.putBoolean("NoAI", this.isNoAi());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_21450_) {
        super.readAdditionalSaveData(p_21450_);
        if (p_21450_.contains("CanPickUpLoot", 1)) {
            this.setCanPickUpLoot(p_21450_.getBoolean("CanPickUpLoot"));
        }
        this.persistenceRequired = p_21450_.getBoolean("PersistenceRequired");
        if (p_21450_.contains("ArmorItems", 9)) {
            ListTag $$1 = p_21450_.getList("ArmorItems", 10);
            for (int $$2 = 0; $$2 < this.armorItems.size(); ++$$2) {
                CompoundTag $$3 = $$1.getCompound($$2);
                this.armorItems.set($$2, ItemStack.parseOptional(this.registryAccess(), $$3));
            }
        }
        if (p_21450_.contains("ArmorDropChances", 9)) {
            ListTag $$4 = p_21450_.getList("ArmorDropChances", 5);
            for (int $$5 = 0; $$5 < $$4.size(); ++$$5) {
                this.armorDropChances[$$5] = $$4.getFloat($$5);
            }
        }
        if (p_21450_.contains("HandItems", 9)) {
            ListTag $$6 = p_21450_.getList("HandItems", 10);
            for (int $$7 = 0; $$7 < this.handItems.size(); ++$$7) {
                CompoundTag $$8 = $$6.getCompound($$7);
                this.handItems.set($$7, ItemStack.parseOptional(this.registryAccess(), $$8));
            }
        }
        if (p_21450_.contains("HandDropChances", 9)) {
            ListTag $$9 = p_21450_.getList("HandDropChances", 5);
            for (int $$10 = 0; $$10 < $$9.size(); ++$$10) {
                this.handDropChances[$$10] = $$9.getFloat($$10);
            }
        }
        if (p_21450_.contains("body_armor_item", 10)) {
            this.bodyArmorItem = ItemStack.parse(this.registryAccess(), p_21450_.getCompound("body_armor_item")).orElse(ItemStack.EMPTY);
            this.bodyArmorDropChance = p_21450_.getFloat("body_armor_drop_chance");
        } else {
            this.bodyArmorItem = ItemStack.EMPTY;
        }
        this.delayedLeashInfo = p_21450_.contains(LEASH_TAG, 10) ? Either.left((Object)p_21450_.getCompound(LEASH_TAG).getUUID("UUID")) : (p_21450_.contains(LEASH_TAG, 11) ? (Either)NbtUtils.readBlockPos(p_21450_, LEASH_TAG).map(Either::right).orElse(null) : null);
        this.setLeftHanded(p_21450_.getBoolean("LeftHanded"));
        if (p_21450_.contains("DeathLootTable", 8)) {
            this.lootTable = ResourceKey.create(Registries.LOOT_TABLE, new ResourceLocation(p_21450_.getString("DeathLootTable")));
            this.lootTableSeed = p_21450_.getLong("DeathLootTableSeed");
        }
        this.setNoAi(p_21450_.getBoolean("NoAI"));
    }

    @Override
    protected void dropFromLootTable(DamageSource p_21389_, boolean p_21390_) {
        super.dropFromLootTable(p_21389_, p_21390_);
        this.lootTable = null;
    }

    @Override
    public final ResourceKey<LootTable> getLootTable() {
        return this.lootTable == null ? this.getDefaultLootTable() : this.lootTable;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return super.getLootTable();
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setZza(float p_21565_) {
        this.zza = p_21565_;
    }

    public void setYya(float p_21568_) {
        this.yya = p_21568_;
    }

    public void setXxa(float p_21571_) {
        this.xxa = p_21571_;
    }

    @Override
    public void setSpeed(float p_21556_) {
        super.setSpeed(p_21556_);
        this.setZza(p_21556_);
    }

    public void stopInPlace() {
        this.getNavigation().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.level().getProfiler().push("looting");
        if (!this.level().isClientSide && this.canPickUpLoot() && this.isAlive() && !this.dead && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            Vec3i $$0 = this.getPickupReach();
            List<ItemEntity> $$1 = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate($$0.getX(), $$0.getY(), $$0.getZ()));
            for (ItemEntity $$2 : $$1) {
                if ($$2.isRemoved() || $$2.getItem().isEmpty() || $$2.hasPickUpDelay() || !this.wantsToPickUp($$2.getItem())) continue;
                this.pickUpItem($$2);
            }
        }
        this.level().getProfiler().pop();
    }

    protected Vec3i getPickupReach() {
        return ITEM_PICKUP_REACH;
    }

    protected void pickUpItem(ItemEntity p_21471_) {
        ItemStack $$1 = p_21471_.getItem();
        ItemStack $$2 = this.equipItemIfPossible($$1.copy());
        if (!$$2.isEmpty()) {
            this.onItemPickup(p_21471_);
            this.take(p_21471_, $$2.getCount());
            $$1.shrink($$2.getCount());
            if ($$1.isEmpty()) {
                p_21471_.discard();
            }
        }
    }

    public ItemStack equipItemIfPossible(ItemStack p_255842_) {
        EquipmentSlot $$1 = Mob.getEquipmentSlotForItem(p_255842_);
        ItemStack $$2 = this.getItemBySlot($$1);
        boolean $$3 = this.canReplaceCurrentItem(p_255842_, $$2);
        if ($$1.isArmor() && !$$3) {
            $$1 = EquipmentSlot.MAINHAND;
            $$2 = this.getItemBySlot($$1);
            $$3 = $$2.isEmpty();
        }
        if ($$3 && this.canHoldItem(p_255842_)) {
            double $$4 = this.getEquipmentDropChance($$1);
            if (!$$2.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < $$4) {
                this.spawnAtLocation($$2);
            }
            if ($$1.isArmor() && p_255842_.getCount() > 1) {
                ItemStack $$5 = p_255842_.copyWithCount(1);
                this.setItemSlotAndDropWhenKilled($$1, $$5);
                return $$5;
            }
            this.setItemSlotAndDropWhenKilled($$1, p_255842_);
            return p_255842_;
        }
        return ItemStack.EMPTY;
    }

    protected void setItemSlotAndDropWhenKilled(EquipmentSlot p_21469_, ItemStack p_21470_) {
        this.setItemSlot(p_21469_, p_21470_);
        this.setGuaranteedDrop(p_21469_);
        this.persistenceRequired = true;
    }

    public void setGuaranteedDrop(EquipmentSlot p_21509_) {
        switch (p_21509_.getType()) {
            case HAND: {
                this.handDropChances[p_21509_.getIndex()] = 2.0f;
                break;
            }
            case ARMOR: {
                this.armorDropChances[p_21509_.getIndex()] = 2.0f;
                break;
            }
            case BODY: {
                this.bodyArmorDropChance = 2.0f;
            }
        }
    }

    protected boolean canReplaceCurrentItem(ItemStack p_21428_, ItemStack p_21429_) {
        if (p_21429_.isEmpty()) {
            return true;
        }
        if (p_21428_.getItem() instanceof SwordItem) {
            double $$3;
            if (!(p_21429_.getItem() instanceof SwordItem)) {
                return true;
            }
            double $$2 = this.getApproximateAttackDamageWithItem(p_21428_);
            if ($$2 != ($$3 = this.getApproximateAttackDamageWithItem(p_21429_))) {
                return $$2 > $$3;
            }
            return this.canReplaceEqualItem(p_21428_, p_21429_);
        }
        if (p_21428_.getItem() instanceof BowItem && p_21429_.getItem() instanceof BowItem) {
            return this.canReplaceEqualItem(p_21428_, p_21429_);
        }
        if (p_21428_.getItem() instanceof CrossbowItem && p_21429_.getItem() instanceof CrossbowItem) {
            return this.canReplaceEqualItem(p_21428_, p_21429_);
        }
        Item $$2 = p_21428_.getItem();
        if ($$2 instanceof ArmorItem) {
            ArmorItem $$4 = (ArmorItem)$$2;
            if (EnchantmentHelper.hasBindingCurse(p_21429_)) {
                return false;
            }
            if (!(p_21429_.getItem() instanceof ArmorItem)) {
                return true;
            }
            ArmorItem $$5 = (ArmorItem)p_21429_.getItem();
            if ($$4.getDefense() != $$5.getDefense()) {
                return $$4.getDefense() > $$5.getDefense();
            }
            if ($$4.getToughness() != $$5.getToughness()) {
                return $$4.getToughness() > $$5.getToughness();
            }
            return this.canReplaceEqualItem(p_21428_, p_21429_);
        }
        if (p_21428_.getItem() instanceof DiggerItem) {
            if (p_21429_.getItem() instanceof BlockItem) {
                return true;
            }
            if (p_21429_.getItem() instanceof DiggerItem) {
                double $$7;
                double $$6 = this.getApproximateAttackDamageWithItem(p_21428_);
                if ($$6 != ($$7 = this.getApproximateAttackDamageWithItem(p_21429_))) {
                    return $$6 > $$7;
                }
                return this.canReplaceEqualItem(p_21428_, p_21429_);
            }
        }
        return false;
    }

    private double getApproximateAttackDamageWithItem(ItemStack p_330413_) {
        ItemAttributeModifiers $$1 = p_330413_.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        return $$1.compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND);
    }

    public boolean canReplaceEqualItem(ItemStack p_21478_, ItemStack p_21479_) {
        if (p_21478_.getDamageValue() < p_21479_.getDamageValue()) {
            return true;
        }
        return Mob.hasAnyComponentExceptDamage(p_21478_) && !Mob.hasAnyComponentExceptDamage(p_21479_);
    }

    private static boolean hasAnyComponentExceptDamage(ItemStack p_332136_) {
        DataComponentMap $$1 = p_332136_.getComponents();
        int $$2 = $$1.size();
        return $$2 > 1 || $$2 == 1 && !$$1.has(DataComponents.DAMAGE);
    }

    public boolean canHoldItem(ItemStack p_21545_) {
        return true;
    }

    public boolean wantsToPickUp(ItemStack p_21546_) {
        return this.canHoldItem(p_21546_);
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return this.isPassenger();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
            return;
        }
        if (this.isPersistenceRequired() || this.requiresCustomPersistence()) {
            this.noActionTime = 0;
            return;
        }
        Player $$0 = this.level().getNearestPlayer(this, -1.0);
        if ($$0 != null) {
            int $$2;
            int $$3;
            double $$1 = $$0.distanceToSqr(this);
            if ($$1 > (double)($$3 = ($$2 = this.getType().getCategory().getDespawnDistance()) * $$2) && this.removeWhenFarAway($$1)) {
                this.discard();
            }
            int $$4 = this.getType().getCategory().getNoDespawnDistance();
            int $$5 = $$4 * $$4;
            if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && $$1 > (double)$$5 && this.removeWhenFarAway($$1)) {
                this.discard();
            } else if ($$1 < (double)$$5) {
                this.noActionTime = 0;
            }
        }
    }

    @Override
    protected final void serverAiStep() {
        ++this.noActionTime;
        ProfilerFiller $$0 = this.level().getProfiler();
        $$0.push("sensing");
        this.sensing.tick();
        $$0.pop();
        int $$1 = this.tickCount + this.getId();
        if ($$1 % 2 == 0 || this.tickCount <= 1) {
            $$0.push("targetSelector");
            this.targetSelector.tick();
            $$0.pop();
            $$0.push("goalSelector");
            this.goalSelector.tick();
            $$0.pop();
        } else {
            $$0.push("targetSelector");
            this.targetSelector.tickRunningGoals(false);
            $$0.pop();
            $$0.push("goalSelector");
            this.goalSelector.tickRunningGoals(false);
            $$0.pop();
        }
        $$0.push("navigation");
        this.navigation.tick();
        $$0.pop();
        $$0.push("mob tick");
        this.customServerAiStep();
        $$0.pop();
        $$0.push("controls");
        $$0.push("move");
        this.moveControl.tick();
        $$0.popPush("look");
        this.lookControl.tick();
        $$0.popPush("jump");
        this.jumpControl.tick();
        $$0.pop();
        $$0.pop();
        this.sendDebugPackets();
    }

    protected void sendDebugPackets() {
        DebugPackets.sendGoalSelector(this.level(), this, this.goalSelector);
    }

    protected void customServerAiStep() {
    }

    public int getMaxHeadXRot() {
        return 40;
    }

    public int getMaxHeadYRot() {
        return 75;
    }

    protected void clampHeadRotationToBody() {
        float $$0 = this.getMaxHeadYRot();
        float $$1 = this.getYHeadRot();
        float $$2 = Mth.wrapDegrees(this.yBodyRot - $$1);
        float $$3 = Mth.clamp(Mth.wrapDegrees(this.yBodyRot - $$1), -$$0, $$0);
        float $$4 = $$1 + $$2 - $$3;
        this.setYHeadRot($$4);
    }

    public int getHeadRotSpeed() {
        return 10;
    }

    public void lookAt(Entity p_21392_, float p_21393_, float p_21394_) {
        double $$7;
        double $$3 = p_21392_.getX() - this.getX();
        double $$4 = p_21392_.getZ() - this.getZ();
        if (p_21392_ instanceof LivingEntity) {
            LivingEntity $$5 = (LivingEntity)p_21392_;
            double $$6 = $$5.getEyeY() - this.getEyeY();
        } else {
            $$7 = (p_21392_.getBoundingBox().minY + p_21392_.getBoundingBox().maxY) / 2.0 - this.getEyeY();
        }
        double $$8 = Math.sqrt($$3 * $$3 + $$4 * $$4);
        float $$9 = (float)(Mth.atan2($$4, $$3) * 57.2957763671875) - 90.0f;
        float $$10 = (float)(-(Mth.atan2($$7, $$8) * 57.2957763671875));
        this.setXRot(this.rotlerp(this.getXRot(), $$10, p_21394_));
        this.setYRot(this.rotlerp(this.getYRot(), $$9, p_21393_));
    }

    private float rotlerp(float p_21377_, float p_21378_, float p_21379_) {
        float $$3 = Mth.wrapDegrees(p_21378_ - p_21377_);
        if ($$3 > p_21379_) {
            $$3 = p_21379_;
        }
        if ($$3 < -p_21379_) {
            $$3 = -p_21379_;
        }
        return p_21377_ + $$3;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> p_217058_, LevelAccessor p_217059_, MobSpawnType p_217060_, BlockPos p_217061_, RandomSource p_217062_) {
        BlockPos $$5 = p_217061_.below();
        return p_217060_ == MobSpawnType.SPAWNER || p_217059_.getBlockState($$5).isValidSpawn(p_217059_, $$5, p_217058_);
    }

    public boolean checkSpawnRules(LevelAccessor p_21431_, MobSpawnType p_21432_) {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader p_21433_) {
        return !p_21433_.containsAnyLiquid(this.getBoundingBox()) && p_21433_.isUnobstructed(this);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    public boolean isMaxGroupSizeReached(int p_21489_) {
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        if (this.getTarget() == null) {
            return this.getComfortableFallDistance(0.0f);
        }
        int $$0 = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if (($$0 -= (3 - this.level().getDifficulty().getId()) * 4) < 0) {
            $$0 = 0;
        }
        return this.getComfortableFallDistance($$0);
    }

    @Override
    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    @Override
    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    public ItemStack getBodyArmorItem() {
        return this.bodyArmorItem;
    }

    public boolean canWearBodyArmor() {
        return false;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot p_326379_) {
        return true;
    }

    public boolean isWearingBodyArmor() {
        return !this.getItemBySlot(EquipmentSlot.BODY).isEmpty();
    }

    public boolean isBodyArmorItem(ItemStack p_324454_) {
        return false;
    }

    public void setBodyArmorItem(ItemStack p_323721_) {
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.BODY, p_323721_);
    }

    @Override
    public Iterable<ItemStack> getArmorAndBodyArmorSlots() {
        if (this.bodyArmorItem.isEmpty()) {
            return this.armorItems;
        }
        return Iterables.concat(this.armorItems, List.of(this.bodyArmorItem));
    }

    @Override
    public ItemStack getItemBySlot(EquipmentSlot p_21467_) {
        return switch (p_21467_.getType()) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.Type.HAND -> this.handItems.get(p_21467_.getIndex());
            case EquipmentSlot.Type.ARMOR -> this.armorItems.get(p_21467_.getIndex());
            case EquipmentSlot.Type.BODY -> this.bodyArmorItem;
        };
    }

    @Override
    public void setItemSlot(EquipmentSlot p_21416_, ItemStack p_21417_) {
        this.verifyEquippedItem(p_21417_);
        switch (p_21416_.getType()) {
            case HAND: {
                this.onEquipItem(p_21416_, this.handItems.set(p_21416_.getIndex(), p_21417_), p_21417_);
                break;
            }
            case ARMOR: {
                this.onEquipItem(p_21416_, this.armorItems.set(p_21416_.getIndex(), p_21417_), p_21417_);
                break;
            }
            case BODY: {
                ItemStack $$2 = this.bodyArmorItem;
                this.bodyArmorItem = p_21417_;
                this.onEquipItem(p_21416_, $$2, p_21417_);
            }
        }
    }

    @Override
    protected void dropCustomDeathLoot(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        super.dropCustomDeathLoot(p_21385_, p_21386_, p_21387_);
        for (EquipmentSlot $$3 : EquipmentSlot.values()) {
            boolean $$6;
            ItemStack $$4 = this.getItemBySlot($$3);
            float $$5 = this.getEquipmentDropChance($$3);
            boolean bl = $$6 = $$5 > 1.0f;
            if ($$4.isEmpty() || EnchantmentHelper.hasVanishingCurse($$4) || !p_21387_ && !$$6 || !(Math.max(this.random.nextFloat() - (float)p_21386_ * 0.01f, 0.0f) < $$5)) continue;
            if (!$$6 && $$4.isDamageableItem()) {
                $$4.setDamageValue($$4.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max($$4.getMaxDamage() - 3, 1))));
            }
            this.spawnAtLocation($$4);
            this.setItemSlot($$3, ItemStack.EMPTY);
        }
    }

    protected float getEquipmentDropChance(EquipmentSlot p_21520_) {
        return switch (p_21520_.getType()) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.Type.HAND -> this.handDropChances[p_21520_.getIndex()];
            case EquipmentSlot.Type.ARMOR -> this.armorDropChances[p_21520_.getIndex()];
            case EquipmentSlot.Type.BODY -> this.bodyArmorDropChance;
        };
    }

    private LootParams createEquipmentParams(ServerLevel p_338758_) {
        return new LootParams.Builder(p_338758_).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).create(LootContextParamSets.EQUIPMENT);
    }

    public void equip(EquipmentTable p_341198_) {
        this.equip(p_341198_.lootTable(), p_341198_.slotDropChances());
    }

    public void equip(ResourceKey<LootTable> p_340912_, Map<EquipmentSlot, Float> p_340996_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)level;
            this.equip(p_340912_, this.createEquipmentParams($$2), p_340996_);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_217055_, DifficultyInstance p_217056_) {
        if (p_217055_.nextFloat() < 0.15f * p_217056_.getSpecialMultiplier()) {
            float $$3;
            int $$2 = p_217055_.nextInt(2);
            float f = $$3 = this.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
            if (p_217055_.nextFloat() < 0.095f) {
                ++$$2;
            }
            if (p_217055_.nextFloat() < 0.095f) {
                ++$$2;
            }
            if (p_217055_.nextFloat() < 0.095f) {
                ++$$2;
            }
            boolean $$4 = true;
            for (EquipmentSlot $$5 : EquipmentSlot.values()) {
                Item $$7;
                if ($$5.getType() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack $$6 = this.getItemBySlot($$5);
                if (!$$4 && p_217055_.nextFloat() < $$3) break;
                $$4 = false;
                if (!$$6.isEmpty() || ($$7 = Mob.getEquipmentForSlot($$5, $$2)) == null) continue;
                this.setItemSlot($$5, new ItemStack($$7));
            }
        }
    }

    @Nullable
    public static Item getEquipmentForSlot(EquipmentSlot p_21413_, int p_21414_) {
        switch (p_21413_) {
            case HEAD: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_HELMET;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_HELMET;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_HELMET;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_HELMET;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_HELMET;
                }
            }
            case CHEST: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_CHESTPLATE;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_CHESTPLATE;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_CHESTPLATE;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_CHESTPLATE;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_CHESTPLATE;
                }
            }
            case LEGS: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_LEGGINGS;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_LEGGINGS;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_LEGGINGS;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_LEGGINGS;
                }
                if (p_21414_ == 4) {
                    return Items.DIAMOND_LEGGINGS;
                }
            }
            case FEET: {
                if (p_21414_ == 0) {
                    return Items.LEATHER_BOOTS;
                }
                if (p_21414_ == 1) {
                    return Items.GOLDEN_BOOTS;
                }
                if (p_21414_ == 2) {
                    return Items.CHAINMAIL_BOOTS;
                }
                if (p_21414_ == 3) {
                    return Items.IRON_BOOTS;
                }
                if (p_21414_ != 4) break;
                return Items.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void populateDefaultEquipmentEnchantments(RandomSource p_217063_, DifficultyInstance p_217064_) {
        float $$2 = p_217064_.getSpecialMultiplier();
        this.enchantSpawnedWeapon(p_217063_, $$2);
        for (EquipmentSlot $$3 : EquipmentSlot.values()) {
            if ($$3.getType() != EquipmentSlot.Type.ARMOR) continue;
            this.enchantSpawnedArmor(p_217063_, $$2, $$3);
        }
    }

    protected void enchantSpawnedWeapon(RandomSource p_217049_, float p_217050_) {
        if (!this.getMainHandItem().isEmpty() && p_217049_.nextFloat() < 0.25f * p_217050_) {
            this.setItemSlot(EquipmentSlot.MAINHAND, EnchantmentHelper.enchantItem(this.level().enabledFeatures(), p_217049_, this.getMainHandItem(), (int)(5.0f + p_217050_ * (float)p_217049_.nextInt(18)), false));
        }
    }

    protected void enchantSpawnedArmor(RandomSource p_217052_, float p_217053_, EquipmentSlot p_217054_) {
        ItemStack $$3 = this.getItemBySlot(p_217054_);
        if (!$$3.isEmpty() && p_217052_.nextFloat() < 0.5f * p_217053_) {
            this.setItemSlot(p_217054_, EnchantmentHelper.enchantItem(this.level().enabledFeatures(), p_217052_, $$3, (int)(5.0f + p_217053_ * (float)p_217052_.nextInt(18)), false));
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_) {
        RandomSource $$4 = p_21434_.getRandom();
        this.getAttribute(Attributes.FOLLOW_RANGE).addPermanentModifier(new AttributeModifier("Random spawn bonus", $$4.triangle(0.0, 0.11485000000000001), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        this.setLeftHanded($$4.nextFloat() < 0.05f);
        return p_21437_;
    }

    public void setPersistenceRequired() {
        this.persistenceRequired = true;
    }

    @Override
    public void setDropChance(EquipmentSlot p_21410_, float p_21411_) {
        switch (p_21410_.getType()) {
            case HAND: {
                this.handDropChances[p_21410_.getIndex()] = p_21411_;
                break;
            }
            case ARMOR: {
                this.armorDropChances[p_21410_.getIndex()] = p_21411_;
                break;
            }
            case BODY: {
                this.bodyArmorDropChance = p_21411_;
            }
        }
    }

    public boolean canPickUpLoot() {
        return this.canPickUpLoot;
    }

    public void setCanPickUpLoot(boolean p_21554_) {
        this.canPickUpLoot = p_21554_;
    }

    @Override
    public boolean canTakeItem(ItemStack p_21522_) {
        EquipmentSlot $$1 = Mob.getEquipmentSlotForItem(p_21522_);
        return this.getItemBySlot($$1).isEmpty() && this.canPickUpLoot();
    }

    public boolean isPersistenceRequired() {
        return this.persistenceRequired;
    }

    @Override
    public final InteractionResult interact(Player p_21420_, InteractionHand p_21421_) {
        if (!this.isAlive()) {
            return InteractionResult.PASS;
        }
        if (this.getLeashHolder() == p_21420_) {
            this.dropLeash(true, !p_21420_.hasInfiniteMaterials());
            this.gameEvent(GameEvent.ENTITY_INTERACT, p_21420_);
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        InteractionResult $$2 = this.checkAndHandleImportantInteractions(p_21420_, p_21421_);
        if ($$2.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, p_21420_);
            return $$2;
        }
        $$2 = this.mobInteract(p_21420_, p_21421_);
        if ($$2.consumesAction()) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, p_21420_);
            return $$2;
        }
        return super.interact(p_21420_, p_21421_);
    }

    private InteractionResult checkAndHandleImportantInteractions(Player p_21500_, InteractionHand p_21501_) {
        InteractionResult $$3;
        ItemStack $$2 = p_21500_.getItemInHand(p_21501_);
        if ($$2.is(Items.LEAD) && this.canBeLeashed(p_21500_)) {
            this.setLeashedTo(p_21500_, true);
            $$2.shrink(1);
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if ($$2.is(Items.NAME_TAG) && ($$3 = $$2.interactLivingEntity(p_21500_, this, p_21501_)).consumesAction()) {
            return $$3;
        }
        if ($$2.getItem() instanceof SpawnEggItem) {
            if (this.level() instanceof ServerLevel) {
                SpawnEggItem $$4 = (SpawnEggItem)$$2.getItem();
                Optional<Mob> $$5 = $$4.spawnOffspringFromSpawnEgg(p_21500_, this, this.getType(), (ServerLevel)this.level(), this.position(), $$2);
                $$5.ifPresent(p_21476_ -> this.onOffspringSpawnedFromEgg(p_21500_, (Mob)p_21476_));
                return $$5.isPresent() ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected void onOffspringSpawnedFromEgg(Player p_21422_, Mob p_21423_) {
    }

    protected InteractionResult mobInteract(Player p_21472_, InteractionHand p_21473_) {
        return InteractionResult.PASS;
    }

    public boolean isWithinRestriction() {
        return this.isWithinRestriction(this.blockPosition());
    }

    public boolean isWithinRestriction(BlockPos p_21445_) {
        if (this.restrictRadius == -1.0f) {
            return true;
        }
        return this.restrictCenter.distSqr(p_21445_) < (double)(this.restrictRadius * this.restrictRadius);
    }

    public void restrictTo(BlockPos p_21447_, int p_21448_) {
        this.restrictCenter = p_21447_;
        this.restrictRadius = p_21448_;
    }

    public BlockPos getRestrictCenter() {
        return this.restrictCenter;
    }

    public float getRestrictRadius() {
        return this.restrictRadius;
    }

    public void clearRestriction() {
        this.restrictRadius = -1.0f;
    }

    public boolean hasRestriction() {
        return this.restrictRadius != -1.0f;
    }

    @Nullable
    public <T extends Mob> T convertTo(EntityType<T> p_21407_, boolean p_21408_) {
        if (this.isRemoved()) {
            return null;
        }
        Mob $$2 = (Mob)p_21407_.create(this.level());
        if ($$2 == null) {
            return null;
        }
        $$2.copyPosition(this);
        $$2.setBaby(this.isBaby());
        $$2.setNoAi(this.isNoAi());
        if (this.hasCustomName()) {
            $$2.setCustomName(this.getCustomName());
            $$2.setCustomNameVisible(this.isCustomNameVisible());
        }
        if (this.isPersistenceRequired()) {
            $$2.setPersistenceRequired();
        }
        $$2.setInvulnerable(this.isInvulnerable());
        if (p_21408_) {
            $$2.setCanPickUpLoot(this.canPickUpLoot());
            for (EquipmentSlot $$3 : EquipmentSlot.values()) {
                ItemStack $$4 = this.getItemBySlot($$3);
                if ($$4.isEmpty()) continue;
                $$2.setItemSlot($$3, $$4.copyAndClear());
                $$2.setDropChance($$3, this.getEquipmentDropChance($$3));
            }
        }
        this.level().addFreshEntity($$2);
        if (this.isPassenger()) {
            Entity $$5 = this.getVehicle();
            this.stopRiding();
            $$2.startRiding($$5, true);
        }
        this.discard();
        return (T)$$2;
    }

    protected void tickLeash() {
        if (this.delayedLeashInfo != null) {
            this.restoreLeashFromSave();
        }
        if (this.leashHolder == null) {
            return;
        }
        if (!this.isAlive() || !this.leashHolder.isAlive()) {
            this.dropLeash(true, true);
        }
    }

    public void dropLeash(boolean p_21456_, boolean p_21457_) {
        if (this.leashHolder != null) {
            this.leashHolder = null;
            this.delayedLeashInfo = null;
            this.clearRestriction();
            if (!this.level().isClientSide && p_21457_) {
                this.spawnAtLocation(Items.LEAD);
            }
            if (!this.level().isClientSide && p_21456_ && this.level() instanceof ServerLevel) {
                ((ServerLevel)this.level()).getChunkSource().broadcast(this, new ClientboundSetEntityLinkPacket(this, null));
            }
        }
    }

    public boolean canBeLeashed(Player p_21418_) {
        return !this.isLeashed() && !(this instanceof Enemy);
    }

    public boolean isLeashed() {
        return this.leashHolder != null;
    }

    public boolean mayBeLeashed() {
        return this.isLeashed() || this.delayedLeashInfo != null;
    }

    @Nullable
    public Entity getLeashHolder() {
        if (this.leashHolder == null && this.delayedLeashHolderId != 0 && this.level().isClientSide) {
            this.leashHolder = this.level().getEntity(this.delayedLeashHolderId);
        }
        return this.leashHolder;
    }

    public void setLeashedTo(Entity p_21464_, boolean p_21465_) {
        this.leashHolder = p_21464_;
        this.delayedLeashInfo = null;
        if (!this.level().isClientSide && p_21465_ && this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).getChunkSource().broadcast(this, new ClientboundSetEntityLinkPacket(this, this.leashHolder));
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void setDelayedLeashHolderId(int p_21507_) {
        this.delayedLeashHolderId = p_21507_;
        this.dropLeash(false, false);
    }

    @Override
    public boolean startRiding(Entity p_21396_, boolean p_21397_) {
        boolean $$2 = super.startRiding(p_21396_, p_21397_);
        if ($$2 && this.isLeashed()) {
            this.dropLeash(true, true);
        }
        return $$2;
    }

    private void restoreLeashFromSave() {
        Level level;
        if (this.delayedLeashInfo != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel $$0 = (ServerLevel)level;
            Optional $$1 = this.delayedLeashInfo.left();
            Optional $$2 = this.delayedLeashInfo.right();
            if ($$1.isPresent()) {
                Entity $$3 = $$0.getEntity((UUID)$$1.get());
                if ($$3 != null) {
                    this.setLeashedTo($$3, true);
                    return;
                }
            } else if ($$2.isPresent()) {
                this.setLeashedTo(LeashFenceKnotEntity.getOrCreateKnot(this.level(), (BlockPos)$$2.get()), true);
                return;
            }
            if (this.tickCount > 100) {
                this.spawnAtLocation(Items.LEAD);
                this.delayedLeashInfo = null;
            }
        }
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && !this.isNoAi();
    }

    public void setNoAi(boolean p_21558_) {
        byte $$1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21558_ ? (byte)($$1 | 1) : (byte)($$1 & 0xFFFFFFFE));
    }

    public void setLeftHanded(boolean p_21560_) {
        byte $$1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21560_ ? (byte)($$1 | 2) : (byte)($$1 & 0xFFFFFFFD));
    }

    public void setAggressive(boolean p_21562_) {
        byte $$1 = this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, p_21562_ ? (byte)($$1 | 4) : (byte)($$1 & 0xFFFFFFFB));
    }

    public boolean isNoAi() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 1) != 0;
    }

    public boolean isLeftHanded() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 2) != 0;
    }

    public boolean isAggressive() {
        return (this.entityData.get(DATA_MOB_FLAGS_ID) & 4) != 0;
    }

    public void setBaby(boolean p_21451_) {
    }

    @Override
    public HumanoidArm getMainArm() {
        return this.isLeftHanded() ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity p_217067_) {
        return this.getAttackBoundingBox().intersects(p_217067_.getHitbox());
    }

    protected AABB getAttackBoundingBox() {
        AABB $$4;
        Entity $$0 = this.getVehicle();
        if ($$0 != null) {
            AABB $$1 = $$0.getBoundingBox();
            AABB $$2 = this.getBoundingBox();
            AABB $$3 = new AABB(Math.min($$2.minX, $$1.minX), $$2.minY, Math.min($$2.minZ, $$1.minZ), Math.max($$2.maxX, $$1.maxX), $$2.maxY, Math.max($$2.maxZ, $$1.maxZ));
        } else {
            $$4 = this.getBoundingBox();
        }
        return $$4.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
    }

    @Override
    public boolean doHurtTarget(Entity p_21372_) {
        boolean $$4;
        int $$3;
        float $$1 = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float $$2 = (float)this.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        if (p_21372_ instanceof LivingEntity) {
            $$1 += EnchantmentHelper.getDamageBonus(this.getMainHandItem(), p_21372_.getType());
            $$2 += (float)EnchantmentHelper.getKnockbackBonus(this);
        }
        if (($$3 = EnchantmentHelper.getFireAspect(this)) > 0) {
            p_21372_.igniteForSeconds($$3 * 4);
        }
        if ($$4 = p_21372_.hurt(this.damageSources().mobAttack(this), $$1)) {
            if ($$2 > 0.0f && p_21372_ instanceof LivingEntity) {
                ((LivingEntity)p_21372_).knockback($$2 * 0.5f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            this.doEnchantDamageEffects(this, p_21372_);
            this.setLastHurtMob(p_21372_);
        }
        return $$4;
    }

    protected boolean isSunBurnTick() {
        if (this.level().isDay() && !this.level().isClientSide) {
            boolean $$2;
            float $$0 = this.getLightLevelDependentMagicValue();
            BlockPos $$1 = BlockPos.containing(this.getX(), this.getEyeY(), this.getZ());
            boolean bl = $$2 = this.isInWaterRainOrBubble() || this.isInPowderSnow || this.wasInPowderSnow;
            if ($$0 > 0.5f && this.random.nextFloat() * 30.0f < ($$0 - 0.4f) * 2.0f && !$$2 && this.level().canSeeSky($$1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void jumpInLiquid(TagKey<Fluid> p_204045_) {
        if (this.getNavigation().canFloat()) {
            super.jumpInLiquid(p_204045_);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void removeFreeWill() {
        this.removeAllGoals(p_262562_ -> true);
        this.getBrain().removeAllBehaviors();
    }

    public void removeAllGoals(Predicate<Goal> p_262667_) {
        this.goalSelector.removeAllGoals(p_262667_);
    }

    @Override
    protected void removeAfterChangingDimensions() {
        super.removeAfterChangingDimensions();
        this.dropLeash(true, false);
        this.getAllSlots().forEach(p_278936_ -> {
            if (!p_278936_.isEmpty()) {
                p_278936_.setCount(0);
            }
        });
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        SpawnEggItem $$0 = SpawnEggItem.byId(this.getType());
        if ($$0 == null) {
            return null;
        }
        return new ItemStack($$0);
    }
}

