/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public abstract class PathfinderMob
extends Mob {
    protected static final float DEFAULT_WALK_TARGET_VALUE = 0.0f;

    protected PathfinderMob(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super((EntityType<? extends Mob>)p_21683_, p_21684_);
    }

    public float getWalkTargetValue(BlockPos p_21693_) {
        return this.getWalkTargetValue(p_21693_, this.level());
    }

    public float getWalkTargetValue(BlockPos p_21688_, LevelReader p_21689_) {
        return 0.0f;
    }

    @Override
    public boolean checkSpawnRules(LevelAccessor p_21686_, MobSpawnType p_21687_) {
        return this.getWalkTargetValue(this.blockPosition(), p_21686_) >= 0.0f;
    }

    public boolean isPathFinding() {
        return !this.getNavigation().isDone();
    }

    public boolean isPanicking() {
        if (this.brain.hasMemoryValue(MemoryModuleType.IS_PANICKING)) {
            return this.brain.getMemory(MemoryModuleType.IS_PANICKING).isPresent();
        }
        for (WrappedGoal $$0 : this.goalSelector.getAvailableGoals()) {
            if (!$$0.isRunning() || !($$0.getGoal() instanceof PanicGoal)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void tickLeash() {
        super.tickLeash();
        Entity $$0 = this.getLeashHolder();
        if ($$0 != null && $$0.level() == this.level()) {
            this.restrictTo($$0.blockPosition(), 5);
            float $$1 = this.distanceTo($$0);
            if (this instanceof TamableAnimal && ((TamableAnimal)this).isInSittingPose()) {
                if ($$1 > 10.0f) {
                    this.dropLeash(true, true);
                }
                return;
            }
            this.onLeashDistance($$1);
            if ($$1 > 10.0f) {
                this.dropLeash(true, true);
                this.goalSelector.disableControlFlag(Goal.Flag.MOVE);
            } else if ($$1 > 6.0f) {
                double $$2 = ($$0.getX() - this.getX()) / (double)$$1;
                double $$3 = ($$0.getY() - this.getY()) / (double)$$1;
                double $$4 = ($$0.getZ() - this.getZ()) / (double)$$1;
                this.setDeltaMovement(this.getDeltaMovement().add(Math.copySign($$2 * $$2 * 0.4, $$2), Math.copySign($$3 * $$3 * 0.4, $$3), Math.copySign($$4 * $$4 * 0.4, $$4)));
                this.checkSlowFallDistance();
            } else if (this.shouldStayCloseToLeashHolder() && !this.isPanicking()) {
                this.goalSelector.enableControlFlag(Goal.Flag.MOVE);
                float $$5 = 2.0f;
                Vec3 $$6 = new Vec3($$0.getX() - this.getX(), $$0.getY() - this.getY(), $$0.getZ() - this.getZ()).normalize().scale(Math.max($$1 - 2.0f, 0.0f));
                this.getNavigation().moveTo(this.getX() + $$6.x, this.getY() + $$6.y, this.getZ() + $$6.z, this.followLeashSpeed());
            }
        }
    }

    protected boolean shouldStayCloseToLeashHolder() {
        return true;
    }

    protected double followLeashSpeed() {
        return 1.0;
    }

    protected void onLeashDistance(float p_21694_) {
    }
}

