/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;

public abstract class TamableAnimal
extends Animal
implements OwnableEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(TamableAnimal.class, EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.defineId(TamableAnimal.class, EntityDataSerializers.OPTIONAL_UUID);
    private boolean orderedToSit;

    protected TamableAnimal(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super((EntityType<? extends Animal>)p_21803_, p_21804_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326034_) {
        super.defineSynchedData(p_326034_);
        p_326034_.define(DATA_FLAGS_ID, (byte)0);
        p_326034_.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_21819_) {
        super.addAdditionalSaveData(p_21819_);
        if (this.getOwnerUUID() != null) {
            p_21819_.putUUID("Owner", this.getOwnerUUID());
        }
        p_21819_.putBoolean("Sitting", this.orderedToSit);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_21815_) {
        UUID $$3;
        super.readAdditionalSaveData(p_21815_);
        if (p_21815_.hasUUID("Owner")) {
            UUID $$1 = p_21815_.getUUID("Owner");
        } else {
            String $$2 = p_21815_.getString("Owner");
            $$3 = OldUsersConverter.convertMobOwnerIfNecessary(this.getServer(), $$2);
        }
        if ($$3 != null) {
            try {
                this.setOwnerUUID($$3);
                this.setTame(true, false);
            }
            catch (Throwable $$4) {
                this.setTame(false, true);
            }
        }
        this.orderedToSit = p_21815_.getBoolean("Sitting");
        this.setInSittingPose(this.orderedToSit);
    }

    @Override
    public boolean canBeLeashed(Player p_21813_) {
        return !this.isLeashed();
    }

    protected void spawnTamingParticles(boolean p_21835_) {
        SimpleParticleType $$1 = ParticleTypes.HEART;
        if (!p_21835_) {
            $$1 = ParticleTypes.SMOKE;
        }
        for (int $$2 = 0; $$2 < 7; ++$$2) {
            double $$3 = this.random.nextGaussian() * 0.02;
            double $$4 = this.random.nextGaussian() * 0.02;
            double $$5 = this.random.nextGaussian() * 0.02;
            ((Level)this.level()).addParticle($$1, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), $$3, $$4, $$5);
        }
    }

    @Override
    public void handleEntityEvent(byte p_21807_) {
        if (p_21807_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_21807_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(p_21807_);
        }
    }

    public boolean isTame() {
        return (this.entityData.get(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean p_21836_, boolean p_326134_) {
        byte $$2 = this.entityData.get(DATA_FLAGS_ID);
        if (p_21836_) {
            this.entityData.set(DATA_FLAGS_ID, (byte)($$2 | 4));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)($$2 & 0xFFFFFFFB));
        }
        if (p_326134_) {
            this.applyTamingSideEffects();
        }
    }

    protected void applyTamingSideEffects() {
    }

    public boolean isInSittingPose() {
        return (this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean p_21838_) {
        byte $$1 = this.entityData.get(DATA_FLAGS_ID);
        if (p_21838_) {
            this.entityData.set(DATA_FLAGS_ID, (byte)($$1 | 1));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)($$1 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return this.entityData.get(DATA_OWNERUUID_ID).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(p_21817_));
    }

    public void tame(Player p_21829_) {
        this.setTame(true, true);
        this.setOwnerUUID(p_21829_.getUUID());
        if (p_21829_ instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)p_21829_;
            CriteriaTriggers.TAME_ANIMAL.trigger($$1, this);
        }
    }

    @Override
    public boolean canAttack(LivingEntity p_21822_) {
        if (this.isOwnedBy(p_21822_)) {
            return false;
        }
        return super.canAttack(p_21822_);
    }

    public boolean isOwnedBy(LivingEntity p_21831_) {
        return p_21831_ == this.getOwner();
    }

    public boolean wantsToAttack(LivingEntity p_21810_, LivingEntity p_21811_) {
        return true;
    }

    @Override
    public PlayerTeam getTeam() {
        LivingEntity $$0;
        if (this.isTame() && ($$0 = this.getOwner()) != null) {
            return $$0.getTeam();
        }
        return super.getTeam();
    }

    @Override
    public boolean isAlliedTo(Entity p_21833_) {
        if (this.isTame()) {
            LivingEntity $$1 = this.getOwner();
            if (p_21833_ == $$1) {
                return true;
            }
            if ($$1 != null) {
                return $$1.isAlliedTo(p_21833_);
            }
        }
        return super.isAlliedTo(p_21833_);
    }

    @Override
    public void die(DamageSource p_21809_) {
        if (!((Level)this.level()).isClientSide && ((Level)this.level()).getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(p_21809_);
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOrderedToSit(boolean p_21840_) {
        this.orderedToSit = p_21840_;
    }

    @Override
    public /* synthetic */ EntityGetter level() {
        return super.level();
    }
}

