/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class HarvestFarmland
extends Behavior<Villager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    @Nullable
    private BlockPos aboveFarmlandPos;
    private long nextOkStartTime;
    private int timeWorkedSoFar;
    private final List<BlockPos> validFarmlandAroundVillager = Lists.newArrayList();

    public HarvestFarmland() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.SECONDARY_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel p_23174_, Villager p_23175_) {
        if (!p_23174_.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (p_23175_.getVillagerData().getProfession() != VillagerProfession.FARMER) {
            return false;
        }
        BlockPos.MutableBlockPos $$2 = p_23175_.blockPosition().mutable();
        this.validFarmlandAroundVillager.clear();
        for (int $$3 = -1; $$3 <= 1; ++$$3) {
            for (int $$4 = -1; $$4 <= 1; ++$$4) {
                for (int $$5 = -1; $$5 <= 1; ++$$5) {
                    $$2.set(p_23175_.getX() + (double)$$3, p_23175_.getY() + (double)$$4, p_23175_.getZ() + (double)$$5);
                    if (!this.validPos($$2, p_23174_)) continue;
                    this.validFarmlandAroundVillager.add(new BlockPos($$2));
                }
            }
        }
        this.aboveFarmlandPos = this.getValidFarmland(p_23174_);
        return this.aboveFarmlandPos != null;
    }

    @Nullable
    private BlockPos getValidFarmland(ServerLevel p_23165_) {
        return this.validFarmlandAroundVillager.isEmpty() ? null : this.validFarmlandAroundVillager.get(p_23165_.getRandom().nextInt(this.validFarmlandAroundVillager.size()));
    }

    private boolean validPos(BlockPos p_23181_, ServerLevel p_23182_) {
        BlockState $$2 = p_23182_.getBlockState(p_23181_);
        Block $$3 = $$2.getBlock();
        Block $$4 = p_23182_.getBlockState(p_23181_.below()).getBlock();
        return $$3 instanceof CropBlock && ((CropBlock)$$3).isMaxAge($$2) || $$2.isAir() && $$4 instanceof FarmBlock;
    }

    @Override
    protected void start(ServerLevel p_23177_, Villager p_23178_, long p_23179_) {
        if (p_23179_ > this.nextOkStartTime && this.aboveFarmlandPos != null) {
            p_23178_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(this.aboveFarmlandPos));
            p_23178_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new BlockPosTracker(this.aboveFarmlandPos), 0.5f, 1));
        }
    }

    @Override
    protected void stop(ServerLevel p_23188_, Villager p_23189_, long p_23190_) {
        p_23189_.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        p_23189_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorkedSoFar = 0;
        this.nextOkStartTime = p_23190_ + 40L;
    }

    @Override
    protected void tick(ServerLevel p_23196_, Villager p_23197_, long p_23198_) {
        if (this.aboveFarmlandPos != null && !this.aboveFarmlandPos.closerToCenterThan(p_23197_.position(), 1.0)) {
            return;
        }
        if (this.aboveFarmlandPos != null && p_23198_ > this.nextOkStartTime) {
            BlockState $$3 = p_23196_.getBlockState(this.aboveFarmlandPos);
            Block $$4 = $$3.getBlock();
            Block $$5 = p_23196_.getBlockState(this.aboveFarmlandPos.below()).getBlock();
            if ($$4 instanceof CropBlock && ((CropBlock)$$4).isMaxAge($$3)) {
                p_23196_.destroyBlock(this.aboveFarmlandPos, true, p_23197_);
            }
            if ($$3.isAir() && $$5 instanceof FarmBlock && p_23197_.hasFarmSeeds()) {
                SimpleContainer $$6 = p_23197_.getInventory();
                for (int $$7 = 0; $$7 < $$6.getContainerSize(); ++$$7) {
                    Item item;
                    ItemStack $$8 = $$6.getItem($$7);
                    boolean $$9 = false;
                    if (!$$8.isEmpty() && $$8.is(ItemTags.VILLAGER_PLANTABLE_SEEDS) && (item = $$8.getItem()) instanceof BlockItem) {
                        BlockItem $$10 = (BlockItem)item;
                        BlockState $$11 = $$10.getBlock().defaultBlockState();
                        p_23196_.setBlockAndUpdate(this.aboveFarmlandPos, $$11);
                        p_23196_.gameEvent(GameEvent.BLOCK_PLACE, this.aboveFarmlandPos, GameEvent.Context.of(p_23197_, $$11));
                        $$9 = true;
                    }
                    if (!$$9) continue;
                    p_23196_.playSound(null, this.aboveFarmlandPos.getX(), this.aboveFarmlandPos.getY(), this.aboveFarmlandPos.getZ(), SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    $$8.shrink(1);
                    if (!$$8.isEmpty()) break;
                    $$6.setItem($$7, ItemStack.EMPTY);
                    break;
                }
            }
            if ($$4 instanceof CropBlock && !((CropBlock)$$4).isMaxAge($$3)) {
                this.validFarmlandAroundVillager.remove(this.aboveFarmlandPos);
                this.aboveFarmlandPos = this.getValidFarmland(p_23196_);
                if (this.aboveFarmlandPos != null) {
                    this.nextOkStartTime = p_23198_ + 20L;
                    p_23197_.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new BlockPosTracker(this.aboveFarmlandPos), 0.5f, 1));
                    p_23197_.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(this.aboveFarmlandPos));
                }
            }
        }
        ++this.timeWorkedSoFar;
    }

    @Override
    protected boolean canStillUse(ServerLevel p_23204_, Villager p_23205_, long p_23206_) {
        return this.timeWorkedSoFar < 200;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Villager)livingEntity, l);
    }
}

