/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class Camel
extends AbstractHorse
implements PlayerRideableJumping,
Saddleable {
    public static final float BABY_SCALE = 0.45f;
    public static final int DASH_COOLDOWN_TICKS = 55;
    public static final int MAX_HEAD_Y_ROT = 30;
    private static final float RUNNING_SPEED_BONUS = 0.1f;
    private static final float DASH_VERTICAL_MOMENTUM = 1.4285f;
    private static final float DASH_HORIZONTAL_MOMENTUM = 22.2222f;
    private static final int DASH_MINIMUM_DURATION_TICKS = 5;
    private static final int SITDOWN_DURATION_TICKS = 40;
    private static final int STANDUP_DURATION_TICKS = 52;
    private static final int IDLE_MINIMAL_DURATION_TICKS = 80;
    private static final float SITTING_HEIGHT_DIFFERENCE = 1.43f;
    public static final EntityDataAccessor<Boolean> DASH = SynchedEntityData.defineId(Camel.class, EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.defineId(Camel.class, EntityDataSerializers.LONG);
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState dashAnimationState = new AnimationState();
    private static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.scalable(EntityType.CAMEL.getWidth(), EntityType.CAMEL.getHeight() - 1.43f).withEyeHeight(0.845f);
    private int dashCooldown = 0;
    private int idleAnimationTimeout = 0;

    public Camel(EntityType<? extends Camel> p_248516_, Level p_249295_) {
        super((EntityType<? extends AbstractHorse>)p_248516_, p_249295_);
        this.moveControl = new CamelMoveControl();
        this.lookControl = new CamelLookControl();
        GroundPathNavigation $$2 = (GroundPathNavigation)this.getNavigation();
        $$2.setCanFloat(true);
        $$2.setCanWalkOverFences(true);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_250330_) {
        super.addAdditionalSaveData(p_250330_);
        p_250330_.putLong("LastPoseTick", this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_250781_) {
        super.readAdditionalSaveData(p_250781_);
        long $$1 = p_250781_.getLong("LastPoseTick");
        if ($$1 < 0L) {
            this.setPose(Pose.SITTING);
        }
        this.resetLastPoseChangeTick($$1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Camel.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 32.0).add(Attributes.MOVEMENT_SPEED, 0.09f).add(Attributes.JUMP_STRENGTH, 0.42f).add(Attributes.STEP_HEIGHT, 1.5);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326213_) {
        super.defineSynchedData(p_326213_);
        p_326213_.define(DASH, false);
        p_326213_.define(LAST_POSE_CHANGE_TICK, 0L);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_249190_, DifficultyInstance p_251264_, MobSpawnType p_250254_, @Nullable SpawnGroupData p_249259_) {
        CamelAi.initMemories(this, p_249190_.getRandom());
        this.resetLastPoseChangeTickToFullStand(p_249190_.getLevel().getGameTime());
        return super.finalizeSpawn(p_249190_, p_251264_, p_250254_, p_249259_);
    }

    protected Brain.Provider<Camel> brainProvider() {
        return CamelAi.brainProvider();
    }

    @Override
    protected void registerGoals() {
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> p_251586_) {
        return CamelAi.makeBrain(this.brainProvider().makeBrain(p_251586_));
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose p_316664_) {
        return p_316664_ == Pose.SITTING ? SITTING_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(p_316664_);
    }

    @Override
    protected void customServerAiStep() {
        ((Level)this.level()).getProfiler().push("camelBrain");
        Brain<?> $$0 = this.getBrain();
        $$0.tick((ServerLevel)this.level(), this);
        ((Level)this.level()).getProfiler().pop();
        ((Level)this.level()).getProfiler().push("camelActivityUpdate");
        CamelAi.updateActivity(this);
        ((Level)this.level()).getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isDashing() && this.dashCooldown < 50 && (this.onGround() || this.isInLiquid() || this.isPassenger())) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                ((Level)this.level()).playSound(null, this.blockPosition(), SoundEvents.CAMEL_DASH_READY, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (((Level)this.level()).isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.refuseToMove()) {
            this.clampHeadRotationToBody();
        }
        if (this.isCamelSitting() && this.isInWater()) {
            this.standUpInstantly();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isCamelVisuallySitting()) {
            this.sitUpAnimationState.stop();
            this.dashAnimationState.stop();
            if (this.isVisuallySittingDown()) {
                this.sitAnimationState.startIfStopped(this.tickCount);
                this.sitPoseAnimationState.stop();
            } else {
                this.sitAnimationState.stop();
                this.sitPoseAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.sitAnimationState.stop();
            this.sitPoseAnimationState.stop();
            this.dashAnimationState.animateWhen(this.isDashing(), this.tickCount);
            this.sitUpAnimationState.animateWhen(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.tickCount);
        }
    }

    @Override
    protected void updateWalkAnimation(float p_268362_) {
        float $$2;
        if (this.getPose() == Pose.STANDING && !this.dashAnimationState.isStarted()) {
            float $$1 = Math.min(p_268362_ * 6.0f, 1.0f);
        } else {
            $$2 = 0.0f;
        }
        this.walkAnimation.update($$2, 0.2f);
    }

    @Override
    public void travel(Vec3 p_250068_) {
        if (this.refuseToMove() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            p_250068_ = p_250068_.multiply(0.0, 1.0, 0.0);
        }
        super.travel(p_250068_);
    }

    @Override
    protected void tickRidden(Player p_278319_, Vec3 p_278301_) {
        super.tickRidden(p_278319_, p_278301_);
        if (p_278319_.zza > 0.0f && this.isCamelSitting() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    public boolean refuseToMove() {
        return this.isCamelSitting() || this.isInPoseTransition();
    }

    @Override
    protected float getRiddenSpeed(Player p_278241_) {
        float $$1 = p_278241_.isSprinting() && this.getJumpCooldown() == 0 ? 0.1f : 0.0f;
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) + $$1;
    }

    @Override
    protected Vec2 getRiddenRotation(LivingEntity p_275271_) {
        if (this.refuseToMove()) {
            return new Vec2(this.getXRot(), this.getYRot());
        }
        return super.getRiddenRotation(p_275271_);
    }

    @Override
    protected Vec3 getRiddenInput(Player p_278264_, Vec3 p_278298_) {
        if (this.refuseToMove()) {
            return Vec3.ZERO;
        }
        return super.getRiddenInput(p_278264_, p_278298_);
    }

    @Override
    public boolean canJump() {
        return !this.refuseToMove() && super.canJump();
    }

    @Override
    public void onPlayerJump(int p_249138_) {
        if (!this.isSaddled() || this.dashCooldown > 0 || !this.onGround()) {
            return;
        }
        super.onPlayerJump(p_249138_);
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected void executeRidersJump(float p_251967_, Vec3 p_275627_) {
        double $$2 = this.getJumpPower();
        this.addDeltaMovement(this.getLookAngle().multiply(1.0, 0.0, 1.0).normalize().scale((double)(22.2222f * p_251967_) * this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)this.getBlockSpeedFactor()).add(0.0, (double)(1.4285f * p_251967_) * $$2, 0.0));
        this.dashCooldown = 55;
        this.setDashing(true);
        this.hasImpulse = true;
    }

    public boolean isDashing() {
        return this.entityData.get(DASH);
    }

    public void setDashing(boolean p_251380_) {
        this.entityData.set(DASH, p_251380_);
    }

    @Override
    public void handleStartJump(int p_249968_) {
        this.makeSound(SoundEvents.CAMEL_DASH);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.setDashing(true);
    }

    @Override
    public void handleStopJump() {
    }

    @Override
    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.CAMEL_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.CAMEL_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_250052_) {
        return SoundEvents.CAMEL_HURT;
    }

    @Override
    protected void playStepSound(BlockPos p_252056_, BlockState p_251457_) {
        if (p_251457_.is(BlockTags.CAMEL_SAND_STEP_SOUND_BLOCKS)) {
            this.playSound(SoundEvents.CAMEL_STEP_SAND, 1.0f, 1.0f);
        } else {
            this.playSound(SoundEvents.CAMEL_STEP, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isFood(ItemStack p_248671_) {
        return p_248671_.is(ItemTags.CAMEL_FOOD);
    }

    @Override
    public InteractionResult mobInteract(Player p_249032_, InteractionHand p_251004_) {
        ItemStack $$2 = p_249032_.getItemInHand(p_251004_);
        if (p_249032_.isSecondaryUseActive() && !this.isBaby()) {
            this.openCustomInventoryScreen(p_249032_);
            return InteractionResult.sidedSuccess(((Level)this.level()).isClientSide);
        }
        InteractionResult $$3 = $$2.interactLivingEntity(p_249032_, this, p_251004_);
        if ($$3.consumesAction()) {
            return $$3;
        }
        if (this.isFood($$2)) {
            return this.fedFood(p_249032_, $$2);
        }
        if (this.getPassengers().size() < 2 && !this.isBaby()) {
            this.doPlayerRide(p_249032_);
        }
        return InteractionResult.sidedSuccess(((Level)this.level()).isClientSide);
    }

    @Override
    protected void onLeashDistance(float p_251143_) {
        if (p_251143_ > 6.0f && this.isCamelSitting() && !this.isInPoseTransition() && this.canCamelChangePose()) {
            this.standUp();
        }
    }

    public boolean canCamelChangePose() {
        return this.wouldNotSuffocateAtTargetPose(this.isCamelSitting() ? Pose.STANDING : Pose.SITTING);
    }

    @Override
    protected boolean handleEating(Player p_249923_, ItemStack p_248995_) {
        boolean $$4;
        boolean $$3;
        boolean $$2;
        if (!this.isFood(p_248995_)) {
            return false;
        }
        boolean bl = $$2 = this.getHealth() < this.getMaxHealth();
        if ($$2) {
            this.heal(2.0f);
        }
        boolean bl2 = $$3 = this.isTamed() && this.getAge() == 0 && this.canFallInLove();
        if ($$3) {
            this.setInLove(p_249923_);
        }
        if ($$4 = this.isBaby()) {
            ((Level)this.level()).addParticle(ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!((Level)this.level()).isClientSide) {
                this.ageUp(10);
            }
        }
        if ($$2 || $$3 || $$4) {
            SoundEvent $$5;
            if (!this.isSilent() && ($$5 = this.getEatingSound()) != null) {
                ((Level)this.level()).playSound(null, this.getX(), this.getY(), this.getZ(), $$5, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            this.gameEvent(GameEvent.EAT);
            return true;
        }
        return false;
    }

    @Override
    protected boolean canPerformRearing() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canMate(Animal p_251650_) {
        if (p_251650_ == this) return false;
        if (!(p_251650_ instanceof Camel)) return false;
        Camel $$1 = (Camel)p_251650_;
        if (!this.canParent()) return false;
        if (!$$1.canParent()) return false;
        return true;
    }

    @Override
    @Nullable
    public Camel getBreedOffspring(ServerLevel p_251227_, AgeableMob p_251047_) {
        return EntityType.CAMEL.create(p_251227_);
    }

    @Override
    @Nullable
    protected SoundEvent getEatingSound() {
        return SoundEvents.CAMEL_EAT;
    }

    @Override
    protected void actuallyHurt(DamageSource p_250410_, float p_251451_) {
        this.standUpInstantly();
        super.actuallyHurt(p_250410_, p_251451_);
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity p_295101_, EntityDimensions p_294765_, float p_294716_) {
        int $$3 = Math.max(this.getPassengers().indexOf(p_295101_), 0);
        boolean $$4 = $$3 == 0;
        float $$5 = 0.5f;
        float $$6 = (float)(this.isRemoved() ? (double)0.01f : this.getBodyAnchorAnimationYOffset($$4, 0.0f, p_294765_, p_294716_));
        if (this.getPassengers().size() > 1) {
            if (!$$4) {
                $$5 = -0.7f;
            }
            if (p_295101_ instanceof Animal) {
                $$5 += 0.2f;
            }
        }
        return new Vec3(0.0, $$6, $$5 * p_294716_).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    @Override
    public float getAgeScale() {
        return this.isBaby() ? 0.45f : 1.0f;
    }

    private double getBodyAnchorAnimationYOffset(boolean p_249228_, float p_251763_, EntityDimensions p_296157_, float p_296299_) {
        double $$4 = p_296157_.height() - 0.375f * p_296299_;
        float $$5 = p_296299_ * 1.43f;
        float $$6 = $$5 - p_296299_ * 0.2f;
        float $$7 = $$5 - $$6;
        boolean $$8 = this.isInPoseTransition();
        boolean $$9 = this.isCamelSitting();
        if ($$8) {
            float $$14;
            int $$13;
            int $$10;
            int n = $$10 = $$9 ? 40 : 52;
            if ($$9) {
                int $$11 = 28;
                float $$12 = p_249228_ ? 0.5f : 0.1f;
            } else {
                $$13 = p_249228_ ? 24 : 32;
                $$14 = p_249228_ ? 0.6f : 0.35f;
            }
            float $$15 = Mth.clamp((float)this.getPoseTime() + p_251763_, 0.0f, (float)$$10);
            boolean $$16 = $$15 < (float)$$13;
            float $$17 = $$16 ? $$15 / (float)$$13 : ($$15 - (float)$$13) / (float)($$10 - $$13);
            float $$18 = $$5 - $$14 * $$6;
            $$4 += $$9 ? (double)Mth.lerp($$17, $$16 ? $$5 : $$18, $$16 ? $$18 : $$7) : (double)Mth.lerp($$17, $$16 ? $$7 - $$5 : $$7 - $$18, $$16 ? $$7 - $$18 : 0.0f);
        }
        if ($$9 && !$$8) {
            $$4 += (double)$$7;
        }
        return $$4;
    }

    @Override
    public Vec3 getLeashOffset(float p_251477_) {
        EntityDimensions $$1 = this.getDimensions(this.getPose());
        float $$2 = this.getAgeScale();
        return new Vec3(0.0, this.getBodyAnchorAnimationYOffset(true, p_251477_, $$1, $$2) - (double)(0.2f * $$2), $$1.width() * 0.56f);
    }

    @Override
    public int getMaxHeadYRot() {
        return 30;
    }

    @Override
    protected boolean canAddPassenger(Entity p_248594_) {
        return this.getPassengers().size() <= 2;
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain(this);
    }

    public boolean isCamelSitting() {
        return this.entityData.get(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isCamelVisuallySitting() {
        return this.getPoseTime() < 0L != this.isCamelSitting();
    }

    public boolean isInPoseTransition() {
        long $$0 = this.getPoseTime();
        return $$0 < (long)(this.isCamelSitting() ? 40 : 52);
    }

    private boolean isVisuallySittingDown() {
        return this.isCamelSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void sitDown() {
        if (this.isCamelSitting()) {
            return;
        }
        this.makeSound(SoundEvents.CAMEL_SIT);
        this.setPose(Pose.SITTING);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTick(-((Level)this.level()).getGameTime());
    }

    public void standUp() {
        if (!this.isCamelSitting()) {
            return;
        }
        this.makeSound(SoundEvents.CAMEL_STAND);
        this.setPose(Pose.STANDING);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTick(((Level)this.level()).getGameTime());
    }

    public void standUpInstantly() {
        this.setPose(Pose.STANDING);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTickToFullStand(((Level)this.level()).getGameTime());
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long p_248642_) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, p_248642_);
    }

    private void resetLastPoseChangeTickToFullStand(long p_265447_) {
        this.resetLastPoseChangeTick(Math.max(0L, p_265447_ - 52L - 1L));
    }

    public long getPoseTime() {
        return ((Level)this.level()).getGameTime() - Math.abs(this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    public SoundEvent getSaddleSoundEvent() {
        return SoundEvents.CAMEL_SADDLE;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_252215_) {
        if (!this.firstTick && DASH.equals(p_252215_)) {
            this.dashCooldown = this.dashCooldown == 0 ? 55 : this.dashCooldown;
        }
        super.onSyncedDataUpdated(p_252215_);
    }

    @Override
    public boolean isTamed() {
        return true;
    }

    @Override
    public void openCustomInventoryScreen(Player p_248613_) {
        if (!((Level)this.level()).isClientSide) {
            p_248613_.openHorseInventory(this, this.inventory);
        }
    }

    @Override
    protected BodyRotationControl createBodyControl() {
        return new CamelBodyRotationControl(this);
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    class CamelMoveControl
    extends MoveControl {
        public CamelMoveControl() {
            super(Camel.this);
        }

        @Override
        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && !Camel.this.isLeashed() && Camel.this.isCamelSitting() && !Camel.this.isInPoseTransition() && Camel.this.canCamelChangePose()) {
                Camel.this.standUp();
            }
            super.tick();
        }
    }

    class CamelLookControl
    extends LookControl {
        CamelLookControl() {
            super(Camel.this);
        }

        @Override
        public void tick() {
            if (!Camel.this.hasControllingPassenger()) {
                super.tick();
            }
        }
    }

    class CamelBodyRotationControl
    extends BodyRotationControl {
        public CamelBodyRotationControl(Camel p_248635_) {
            super(p_248635_);
        }

        @Override
        public void clientTick() {
            if (!Camel.this.refuseToMove()) {
                super.clientTick();
            }
        }
    }
}

