/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Sniffer
extends Animal {
    private static final int DIGGING_PARTICLES_DELAY_TICKS = 1700;
    private static final int DIGGING_PARTICLES_DURATION_TICKS = 6000;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final int DIGGING_DROP_SEED_OFFSET_TICKS = 120;
    private static final int SNIFFER_BABY_AGE_TICKS = 48000;
    private static final float DIGGING_BB_HEIGHT_OFFSET = 0.4f;
    private static final EntityDimensions DIGGING_DIMENSIONS = EntityDimensions.scalable(EntityType.SNIFFER.getWidth(), EntityType.SNIFFER.getHeight() - 0.4f).withEyeHeight(0.81f);
    private static final EntityDataAccessor<State> DATA_STATE = SynchedEntityData.defineId(Sniffer.class, EntityDataSerializers.SNIFFER_STATE);
    private static final EntityDataAccessor<Integer> DATA_DROP_SEED_AT_TICK = SynchedEntityData.defineId(Sniffer.class, EntityDataSerializers.INT);
    public final AnimationState feelingHappyAnimationState = new AnimationState();
    public final AnimationState scentingAnimationState = new AnimationState();
    public final AnimationState sniffingAnimationState = new AnimationState();
    public final AnimationState diggingAnimationState = new AnimationState();
    public final AnimationState risingAnimationState = new AnimationState();

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.1f).add(Attributes.MAX_HEALTH, 14.0);
    }

    public Sniffer(EntityType<? extends Animal> p_273717_, Level p_273562_) {
        super(p_273717_, p_273562_);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_CAUTIOUS, -1.0f);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326082_) {
        super.defineSynchedData(p_326082_);
        p_326082_.define(DATA_STATE, State.IDLING);
        p_326082_.define(DATA_DROP_SEED_AT_TICK, 0);
    }

    @Override
    public void onPathfindingStart() {
        super.onPathfindingStart();
        if (this.isOnFire() || this.isInWater()) {
            this.setPathfindingMalus(PathType.WATER, 0.0f);
        }
    }

    @Override
    public void onPathfindingDone() {
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose p_316489_) {
        if (this.getState() == State.DIGGING) {
            return DIGGING_DIMENSIONS.scale(this.getAgeScale());
        }
        return super.getDefaultDimensions(p_316489_);
    }

    public boolean isSearching() {
        return this.getState() == State.SEARCHING;
    }

    public boolean isTempted() {
        return this.brain.getMemory(MemoryModuleType.IS_TEMPTED).orElse(false);
    }

    public boolean canSniff() {
        return !this.isTempted() && !this.isPanicking() && !this.isInWater() && !this.isInLove() && this.onGround() && !this.isPassenger() && !this.isLeashed();
    }

    public boolean canPlayDiggingSound() {
        return this.getState() == State.DIGGING || this.getState() == State.SEARCHING;
    }

    private BlockPos getHeadBlock() {
        Vec3 $$0 = this.getHeadPosition();
        return BlockPos.containing($$0.x(), this.getY() + (double)0.2f, $$0.z());
    }

    private Vec3 getHeadPosition() {
        return this.position().add(this.getForward().scale(2.25));
    }

    private State getState() {
        return this.entityData.get(DATA_STATE);
    }

    private Sniffer setState(State p_273359_) {
        this.entityData.set(DATA_STATE, p_273359_);
        return this;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_272936_) {
        if (DATA_STATE.equals(p_272936_)) {
            State $$1 = this.getState();
            this.resetAnimations();
            switch ($$1.ordinal()) {
                case 2: {
                    this.scentingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 3: {
                    this.sniffingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 5: {
                    this.diggingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 6: {
                    this.risingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case 1: {
                    this.feelingHappyAnimationState.startIfStopped(this.tickCount);
                }
            }
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(p_272936_);
    }

    private void resetAnimations() {
        this.diggingAnimationState.stop();
        this.sniffingAnimationState.stop();
        this.risingAnimationState.stop();
        this.feelingHappyAnimationState.stop();
        this.scentingAnimationState.stop();
    }

    public Sniffer transitionTo(State p_273096_) {
        switch (p_273096_.ordinal()) {
            case 0: {
                this.setState(State.IDLING);
                break;
            }
            case 2: {
                this.setState(State.SCENTING).onScentingStart();
                break;
            }
            case 3: {
                this.playSound(SoundEvents.SNIFFER_SNIFFING, 1.0f, 1.0f);
                this.setState(State.SNIFFING);
                break;
            }
            case 4: {
                this.setState(State.SEARCHING);
                break;
            }
            case 5: {
                this.setState(State.DIGGING).onDiggingStart();
                break;
            }
            case 6: {
                this.playSound(SoundEvents.SNIFFER_DIGGING_STOP, 1.0f, 1.0f);
                this.setState(State.RISING);
                break;
            }
            case 1: {
                this.playSound(SoundEvents.SNIFFER_HAPPY, 1.0f, 1.0f);
                this.setState(State.FEELING_HAPPY);
            }
        }
        return this;
    }

    private Sniffer onScentingStart() {
        this.playSound(SoundEvents.SNIFFER_SCENTING, 1.0f, this.isBaby() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer onDiggingStart() {
        this.entityData.set(DATA_DROP_SEED_AT_TICK, this.tickCount + 120);
        this.level().broadcastEntityEvent(this, (byte)63);
        return this;
    }

    public Sniffer onDiggingComplete(boolean p_272677_) {
        if (p_272677_) {
            this.storeExploredPosition(this.getOnPos());
        }
        return this;
    }

    Optional<BlockPos> calculateDigPosition() {
        return IntStream.range(0, 5).mapToObj(p_273771_ -> LandRandomPos.getPos(this, 10 + 2 * p_273771_, 3)).filter(Objects::nonNull).map(BlockPos::containing).filter(p_337844_ -> this.level().getWorldBorder().isWithinBounds((BlockPos)p_337844_)).map(BlockPos::below).filter(this::canDig).findFirst();
    }

    boolean canDig() {
        return !this.isPanicking() && !this.isTempted() && !this.isBaby() && !this.isInWater() && this.onGround() && !this.isPassenger() && this.canDig(this.getHeadBlock().below());
    }

    private boolean canDig(BlockPos p_272757_) {
        return this.level().getBlockState(p_272757_).is(BlockTags.SNIFFER_DIGGABLE_BLOCK) && this.getExploredPositions().noneMatch(p_337843_ -> GlobalPos.of(this.level().dimension(), p_272757_).equals(p_337843_)) && Optional.ofNullable(this.getNavigation().createPath(p_272757_, 1)).map(Path::canReach).orElse(false) != false;
    }

    private void dropSeed() {
        if (this.level().isClientSide() || this.entityData.get(DATA_DROP_SEED_AT_TICK) != this.tickCount) {
            return;
        }
        ServerLevel $$0 = (ServerLevel)this.level();
        LootTable $$1 = $$0.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.SNIFFER_DIGGING);
        LootParams $$2 = new LootParams.Builder($$0).withParameter(LootContextParams.ORIGIN, this.getHeadPosition()).withParameter(LootContextParams.THIS_ENTITY, this).create(LootContextParamSets.GIFT);
        ObjectArrayList<ItemStack> $$3 = $$1.getRandomItems($$2);
        BlockPos $$4 = this.getHeadBlock();
        for (ItemStack $$5 : $$3) {
            ItemEntity $$6 = new ItemEntity($$0, $$4.getX(), $$4.getY(), $$4.getZ(), $$5);
            $$6.setDefaultPickUpDelay();
            $$0.addFreshEntity($$6);
        }
        this.playSound(SoundEvents.SNIFFER_DROP_SEED, 1.0f, 1.0f);
    }

    private Sniffer emitDiggingParticles(AnimationState p_273528_) {
        boolean $$1;
        boolean bl = $$1 = p_273528_.getAccumulatedTime() > 1700L && p_273528_.getAccumulatedTime() < 6000L;
        if ($$1) {
            BlockPos $$2 = this.getHeadBlock();
            BlockState $$3 = this.level().getBlockState($$2.below());
            if ($$3.getRenderShape() != RenderShape.INVISIBLE) {
                for (int $$4 = 0; $$4 < 30; ++$$4) {
                    Vec3 $$5 = Vec3.atCenterOf($$2).add(0.0, -0.65f, 0.0);
                    this.level().addParticle(new BlockParticleOption(ParticleTypes.BLOCK, $$3), $$5.x, $$5.y, $$5.z, 0.0, 0.0, 0.0);
                }
                if (this.tickCount % 10 == 0) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), $$3.getSoundType().getHitSound(), this.getSoundSource(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.tickCount % 10 == 0) {
            this.level().gameEvent(GameEvent.ENTITY_ACTION, this.getHeadBlock(), GameEvent.Context.of(this));
        }
        return this;
    }

    private Sniffer storeExploredPosition(BlockPos p_273015_) {
        List $$1 = this.getExploredPositions().limit(20L).collect(Collectors.toList());
        $$1.add(0, GlobalPos.of(this.level().dimension(), p_273015_));
        this.getBrain().setMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS, $$1);
        return this;
    }

    private Stream<GlobalPos> getExploredPositions() {
        return this.getBrain().getMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS).stream().flatMap(Collection::stream);
    }

    @Override
    protected void jumpFromGround() {
        double $$1;
        super.jumpFromGround();
        double $$0 = this.moveControl.getSpeedModifier();
        if ($$0 > 0.0 && ($$1 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void spawnChildFromBreeding(ServerLevel p_277923_, Animal p_277857_) {
        ItemStack $$2 = new ItemStack(Items.SNIFFER_EGG);
        ItemEntity $$3 = new ItemEntity(p_277923_, this.position().x(), this.position().y(), this.position().z(), $$2);
        $$3.setDefaultPickUpDelay();
        this.finalizeSpawnChildFromBreeding(p_277923_, p_277857_, null);
        this.playSound(SoundEvents.SNIFFER_EGG_PLOP, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.5f);
        p_277923_.addFreshEntity($$3);
    }

    @Override
    public void die(DamageSource p_277689_) {
        this.transitionTo(State.IDLING);
        super.die(p_277689_);
    }

    @Override
    public void tick() {
        switch (this.getState().ordinal()) {
            case 5: {
                this.emitDiggingParticles(this.diggingAnimationState).dropSeed();
                break;
            }
            case 4: {
                this.playSearchingSound();
            }
        }
        super.tick();
    }

    @Override
    public InteractionResult mobInteract(Player p_273046_, InteractionHand p_272687_) {
        ItemStack $$2 = p_273046_.getItemInHand(p_272687_);
        boolean $$3 = this.isFood($$2);
        InteractionResult $$4 = super.mobInteract(p_273046_, p_272687_);
        if ($$4.consumesAction() && $$3) {
            this.level().playSound(null, this, this.getEatingSound($$2), SoundSource.NEUTRAL, 1.0f, Mth.randomBetween(this.level().random, 0.8f, 1.2f));
        }
        return $$4;
    }

    private void playSearchingSound() {
        if (this.level().isClientSide() && this.tickCount % 20 == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.SNIFFER_SEARCHING, this.getSoundSource(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void playStepSound(BlockPos p_272953_, BlockState p_273729_) {
        this.playSound(SoundEvents.SNIFFER_STEP, 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getEatingSound(ItemStack p_272747_) {
        return SoundEvents.SNIFFER_EAT;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return Set.of(State.DIGGING, State.SEARCHING).contains((Object)this.getState()) ? null : SoundEvents.SNIFFER_IDLE;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_273718_) {
        return SoundEvents.SNIFFER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.SNIFFER_DEATH;
    }

    @Override
    public int getMaxHeadYRot() {
        return 50;
    }

    @Override
    public void setBaby(boolean p_272995_) {
        this.setAge(p_272995_ ? -48000 : 0);
    }

    @Override
    public AgeableMob getBreedOffspring(ServerLevel p_273401_, AgeableMob p_273310_) {
        return EntityType.SNIFFER.create(p_273401_);
    }

    @Override
    public boolean canMate(Animal p_272966_) {
        if (p_272966_ instanceof Sniffer) {
            Sniffer $$1 = (Sniffer)p_272966_;
            Set<State> $$2 = Set.of(State.IDLING, State.SCENTING, State.FEELING_HAPPY);
            return $$2.contains((Object)this.getState()) && $$2.contains((Object)$$1.getState()) && super.canMate(p_272966_);
        }
        return false;
    }

    @Override
    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(0.6f);
    }

    @Override
    public boolean isFood(ItemStack p_273659_) {
        return p_273659_.is(ItemTags.SNIFFER_FOOD);
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> p_273174_) {
        return SnifferAi.makeBrain(this.brainProvider().makeBrain(p_273174_));
    }

    public Brain<Sniffer> getBrain() {
        return super.getBrain();
    }

    protected Brain.Provider<Sniffer> brainProvider() {
        return Brain.provider(SnifferAi.MEMORY_TYPES, SnifferAi.SENSOR_TYPES);
    }

    @Override
    protected void customServerAiStep() {
        this.level().getProfiler().push("snifferBrain");
        this.getBrain().tick((ServerLevel)this.level(), this);
        this.level().getProfiler().popPush("snifferActivityUpdate");
        SnifferAi.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain(this);
    }

    public static enum State {
        IDLING(0),
        FEELING_HAPPY(1),
        SCENTING(2),
        SNIFFING(3),
        SEARCHING(4),
        DIGGING(5),
        RISING(6);

        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int p_319911_) {
            this.id = p_319911_;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.continuous(State::id, State.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }
}

