/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class ItemFrame
extends HangingEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(ItemFrame.class, EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> DATA_ROTATION = SynchedEntityData.defineId(ItemFrame.class, EntityDataSerializers.INT);
    public static final int NUM_ROTATIONS = 8;
    private float dropChance = 1.0f;
    private boolean fixed;

    public ItemFrame(EntityType<? extends ItemFrame> p_31761_, Level p_31762_) {
        super((EntityType<? extends HangingEntity>)p_31761_, p_31762_);
    }

    public ItemFrame(Level p_31764_, BlockPos p_31765_, Direction p_31766_) {
        this(EntityType.ITEM_FRAME, p_31764_, p_31765_, p_31766_);
    }

    public ItemFrame(EntityType<? extends ItemFrame> p_149621_, Level p_149622_, BlockPos p_149623_, Direction p_149624_) {
        super(p_149621_, p_149622_, p_149623_);
        this.setDirection(p_149624_);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325987_) {
        p_325987_.define(DATA_ITEM, ItemStack.EMPTY);
        p_325987_.define(DATA_ROTATION, 0);
    }

    @Override
    protected void setDirection(Direction p_31793_) {
        Validate.notNull((Object)p_31793_);
        this.direction = p_31793_;
        if (p_31793_.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * p_31793_.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    @Override
    protected void recalculateBoundingBox() {
        if (this.direction == null) {
            return;
        }
        double $$0 = 0.46875;
        double $$1 = (double)this.pos.getX() + 0.5 - (double)this.direction.getStepX() * 0.46875;
        double $$2 = (double)this.pos.getY() + 0.5 - (double)this.direction.getStepY() * 0.46875;
        double $$3 = (double)this.pos.getZ() + 0.5 - (double)this.direction.getStepZ() * 0.46875;
        this.setPosRaw($$1, $$2, $$3);
        double $$4 = this.getWidth();
        double $$5 = this.getHeight();
        double $$6 = this.getWidth();
        Direction.Axis $$7 = this.direction.getAxis();
        switch ($$7) {
            case X: {
                $$4 = 1.0;
                break;
            }
            case Y: {
                $$5 = 1.0;
                break;
            }
            case Z: {
                $$6 = 1.0;
            }
        }
        this.setBoundingBox(new AABB($$1 - ($$4 /= 32.0), $$2 - ($$5 /= 32.0), $$3 - ($$6 /= 32.0), $$1 + $$4, $$2 + $$5, $$3 + $$6));
    }

    @Override
    public boolean survives() {
        if (this.fixed) {
            return true;
        }
        if (!this.level().noCollision(this)) {
            return false;
        }
        BlockState $$0 = this.level().getBlockState(this.pos.relative(this.direction.getOpposite()));
        if (!($$0.isSolid() || this.direction.getAxis().isHorizontal() && DiodeBlock.isDiode($$0))) {
            return false;
        }
        return this.level().getEntities(this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    @Override
    public void move(MoverType p_31781_, Vec3 p_31782_) {
        if (!this.fixed) {
            super.move(p_31781_, p_31782_);
        }
    }

    @Override
    public void push(double p_31817_, double p_31818_, double p_31819_) {
        if (!this.fixed) {
            super.push(p_31817_, p_31818_, p_31819_);
        }
    }

    @Override
    public void kill() {
        this.removeFramedMap(this.getItem());
        super.kill();
    }

    @Override
    public boolean hurt(DamageSource p_31776_, float p_31777_) {
        if (this.fixed) {
            if (p_31776_.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || p_31776_.isCreativePlayer()) {
                return super.hurt(p_31776_, p_31777_);
            }
            return false;
        }
        if (this.isInvulnerableTo(p_31776_)) {
            return false;
        }
        if (!p_31776_.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty()) {
            if (!this.level().isClientSide) {
                this.dropItem(p_31776_.getEntity(), false);
                this.gameEvent(GameEvent.BLOCK_CHANGE, p_31776_.getEntity());
                this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.hurt(p_31776_, p_31777_);
    }

    public SoundEvent getRemoveItemSound() {
        return SoundEvents.ITEM_FRAME_REMOVE_ITEM;
    }

    @Override
    public int getWidth() {
        return 12;
    }

    @Override
    public int getHeight() {
        return 12;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_31769_) {
        double $$1 = 16.0;
        return p_31769_ < ($$1 *= 64.0 * ItemFrame.getViewScale()) * $$1;
    }

    @Override
    public void dropItem(@Nullable Entity p_31779_) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(p_31779_, true);
        this.gameEvent(GameEvent.BLOCK_CHANGE, p_31779_);
    }

    public SoundEvent getBreakSound() {
        return SoundEvents.ITEM_FRAME_BREAK;
    }

    @Override
    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.ITEM_FRAME_PLACE;
    }

    private void dropItem(@Nullable Entity p_31803_, boolean p_31804_) {
        Player $$3;
        if (this.fixed) {
            return;
        }
        ItemStack $$2 = this.getItem();
        this.setItem(ItemStack.EMPTY);
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            if (p_31803_ == null) {
                this.removeFramedMap($$2);
            }
            return;
        }
        if (p_31803_ instanceof Player && ($$3 = (Player)p_31803_).hasInfiniteMaterials()) {
            this.removeFramedMap($$2);
            return;
        }
        if (p_31804_) {
            this.spawnAtLocation(this.getFrameItemStack());
        }
        if (!$$2.isEmpty()) {
            $$2 = $$2.copy();
            this.removeFramedMap($$2);
            if (this.random.nextFloat() < this.dropChance) {
                this.spawnAtLocation($$2);
            }
        }
    }

    private void removeFramedMap(ItemStack p_31811_) {
        MapItemSavedData $$2;
        MapId $$1 = this.getFramedMapId();
        if ($$1 != null && ($$2 = MapItem.getSavedData($$1, this.level())) != null) {
            $$2.removedFromFrame(this.pos, this.getId());
            $$2.setDirty(true);
        }
        p_31811_.setEntityRepresentation(null);
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    @Nullable
    public MapId getFramedMapId() {
        return this.getItem().get(DataComponents.MAP_ID);
    }

    public boolean hasFramedMap() {
        return this.getItem().has(DataComponents.MAP_ID);
    }

    public void setItem(ItemStack p_31806_) {
        this.setItem(p_31806_, true);
    }

    public void setItem(ItemStack p_31790_, boolean p_31791_) {
        if (!p_31790_.isEmpty()) {
            p_31790_ = p_31790_.copyWithCount(1);
        }
        this.onItemChanged(p_31790_);
        this.getEntityData().set(DATA_ITEM, p_31790_);
        if (!p_31790_.isEmpty()) {
            this.playSound(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (p_31791_ && this.pos != null) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.ITEM_FRAME_ADD_ITEM;
    }

    @Override
    public SlotAccess getSlot(int p_149629_) {
        if (p_149629_ == 0) {
            return SlotAccess.of(this::getItem, this::setItem);
        }
        return super.getSlot(p_149629_);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_31797_) {
        if (p_31797_.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    private void onItemChanged(ItemStack p_218866_) {
        if (!p_218866_.isEmpty() && p_218866_.getFrame() != this) {
            p_218866_.setEntityRepresentation(this);
        }
        this.recalculateBoundingBox();
    }

    public int getRotation() {
        return this.getEntityData().get(DATA_ROTATION);
    }

    public void setRotation(int p_31771_) {
        this.setRotation(p_31771_, true);
    }

    private void setRotation(int p_31773_, boolean p_31774_) {
        this.getEntityData().set(DATA_ROTATION, p_31773_ % 8);
        if (p_31774_ && this.pos != null) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_31808_) {
        super.addAdditionalSaveData(p_31808_);
        if (!this.getItem().isEmpty()) {
            p_31808_.put("Item", this.getItem().save(this.registryAccess()));
            p_31808_.putByte("ItemRotation", (byte)this.getRotation());
            p_31808_.putFloat("ItemDropChance", this.dropChance);
        }
        p_31808_.putByte("Facing", (byte)this.direction.get3DDataValue());
        p_31808_.putBoolean("Invisible", this.isInvisible());
        p_31808_.putBoolean("Fixed", this.fixed);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_31795_) {
        ItemStack $$3;
        super.readAdditionalSaveData(p_31795_);
        if (p_31795_.contains("Item", 10)) {
            CompoundTag $$1 = p_31795_.getCompound("Item");
            ItemStack $$2 = ItemStack.parse(this.registryAccess(), $$1).orElse(ItemStack.EMPTY);
        } else {
            $$3 = ItemStack.EMPTY;
        }
        ItemStack $$4 = this.getItem();
        if (!$$4.isEmpty() && !ItemStack.matches($$3, $$4)) {
            this.removeFramedMap($$4);
        }
        this.setItem($$3, false);
        if (!$$3.isEmpty()) {
            this.setRotation(p_31795_.getByte("ItemRotation"), false);
            if (p_31795_.contains("ItemDropChance", 99)) {
                this.dropChance = p_31795_.getFloat("ItemDropChance");
            }
        }
        this.setDirection(Direction.from3DDataValue(p_31795_.getByte("Facing")));
        this.setInvisible(p_31795_.getBoolean("Invisible"));
        this.fixed = p_31795_.getBoolean("Fixed");
    }

    @Override
    public InteractionResult interact(Player p_31787_, InteractionHand p_31788_) {
        boolean $$4;
        ItemStack $$2 = p_31787_.getItemInHand(p_31788_);
        boolean $$3 = !this.getItem().isEmpty();
        boolean bl = $$4 = !$$2.isEmpty();
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return $$3 || $$4 ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (!$$3) {
            if ($$4 && !this.isRemoved()) {
                MapItemSavedData $$5;
                if ($$2.is(Items.FILLED_MAP) && ($$5 = MapItem.getSavedData($$2, this.level())) != null && $$5.isTrackedCountOverLimit(256)) {
                    return InteractionResult.FAIL;
                }
                this.setItem($$2);
                this.gameEvent(GameEvent.BLOCK_CHANGE, p_31787_);
                $$2.consume(1, p_31787_);
            }
        } else {
            this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
            this.setRotation(this.getRotation() + 1);
            this.gameEvent(GameEvent.BLOCK_CHANGE, p_31787_);
        }
        return InteractionResult.CONSUME;
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.ITEM_FRAME_ROTATE_ITEM;
    }

    public int getAnalogOutput() {
        if (this.getItem().isEmpty()) {
            return 0;
        }
        return this.getRotation() % 8 + 1;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket(this, this.direction.get3DDataValue(), this.getPos());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_149626_) {
        super.recreateFromPacket(p_149626_);
        this.setDirection(Direction.from3DDataValue(p_149626_.getData()));
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack $$0 = this.getItem();
        if ($$0.isEmpty()) {
            return this.getFrameItemStack();
        }
        return $$0.copy();
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack(Items.ITEM_FRAME);
    }

    @Override
    public float getVisualRotationYInDegrees() {
        Direction $$0 = this.getDirection();
        int $$1 = $$0.getAxis().isVertical() ? 90 * $$0.getAxisDirection().getStep() : 0;
        return Mth.wrapDegrees(180 + $$0.get2DDataValue() * 90 + this.getRotation() * 45 + $$1);
    }
}

