/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Shulker
extends AbstractGolem
implements VariantHolder<Optional<DyeColor>>,
Enemy {
    private static final UUID COVERED_ARMOR_MODIFIER_UUID = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier COVERED_ARMOR_MODIFIER = new AttributeModifier(COVERED_ARMOR_MODIFIER_UUID, "Covered armor bonus", 20.0, AttributeModifier.Operation.ADD_VALUE);
    protected static final EntityDataAccessor<Direction> DATA_ATTACH_FACE_ID = SynchedEntityData.defineId(Shulker.class, EntityDataSerializers.DIRECTION);
    protected static final EntityDataAccessor<Byte> DATA_PEEK_ID = SynchedEntityData.defineId(Shulker.class, EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Byte> DATA_COLOR_ID = SynchedEntityData.defineId(Shulker.class, EntityDataSerializers.BYTE);
    private static final int TELEPORT_STEPS = 6;
    private static final byte NO_COLOR = 16;
    private static final byte DEFAULT_COLOR = 16;
    private static final int MAX_TELEPORT_DISTANCE = 8;
    private static final int OTHER_SHULKER_SCAN_RADIUS = 8;
    private static final int OTHER_SHULKER_LIMIT = 5;
    private static final float PEEK_PER_TICK = 0.05f;
    static final Vector3f FORWARD = Util.make(() -> {
        Vec3i $$0 = Direction.SOUTH.getNormal();
        return new Vector3f((float)$$0.getX(), (float)$$0.getY(), (float)$$0.getZ());
    });
    private static final float MAX_SCALE = 3.0f;
    private float currentPeekAmountO;
    private float currentPeekAmount;
    @Nullable
    private BlockPos clientOldAttachPosition;
    private int clientSideTeleportInterpolation;
    private static final float MAX_LID_OPEN = 1.0f;

    public Shulker(EntityType<? extends Shulker> p_33404_, Level p_33405_) {
        super((EntityType<? extends AbstractGolem>)p_33404_, p_33405_);
        this.xpReward = 5;
        this.lookControl = new ShulkerLookControl(this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new LookAtPlayerGoal(this, Player.class, 8.0f, 0.02f, true));
        this.goalSelector.addGoal(4, new ShulkerAttackGoal());
        this.goalSelector.addGoal(7, new ShulkerPeekGoal());
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(1, new HurtByTargetGoal(this, this.getClass()).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new ShulkerNearestAttackGoal(this));
        this.targetSelector.addGoal(3, new ShulkerDefenseAttackGoal(this));
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.SHULKER_AMBIENT;
    }

    @Override
    public void playAmbientSound() {
        if (!this.isClosed()) {
            super.playAmbientSound();
        }
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.SHULKER_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_33457_) {
        if (this.isClosed()) {
            return SoundEvents.SHULKER_HURT_CLOSED;
        }
        return SoundEvents.SHULKER_HURT;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326069_) {
        super.defineSynchedData(p_326069_);
        p_326069_.define(DATA_ATTACH_FACE_ID, Direction.DOWN);
        p_326069_.define(DATA_PEEK_ID, (byte)0);
        p_326069_.define(DATA_COLOR_ID, (byte)16);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0);
    }

    @Override
    protected BodyRotationControl createBodyControl() {
        return new ShulkerBodyRotationControl(this);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_33432_) {
        super.readAdditionalSaveData(p_33432_);
        this.setAttachFace(Direction.from3DDataValue(p_33432_.getByte("AttachFace")));
        this.entityData.set(DATA_PEEK_ID, p_33432_.getByte("Peek"));
        if (p_33432_.contains("Color", 99)) {
            this.entityData.set(DATA_COLOR_ID, p_33432_.getByte("Color"));
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_33443_) {
        super.addAdditionalSaveData(p_33443_);
        p_33443_.putByte("AttachFace", (byte)this.getAttachFace().get3DDataValue());
        p_33443_.putByte("Peek", this.entityData.get(DATA_PEEK_ID));
        p_33443_.putByte("Color", this.entityData.get(DATA_COLOR_ID));
    }

    @Override
    public void tick() {
        super.tick();
        if (!(this.level().isClientSide || this.isPassenger() || this.canStayAt(this.blockPosition(), this.getAttachFace()))) {
            this.findNewAttachment();
        }
        if (this.updatePeekAmount()) {
            this.onPeekAmountChange();
        }
        if (this.level().isClientSide) {
            if (this.clientSideTeleportInterpolation > 0) {
                --this.clientSideTeleportInterpolation;
            } else {
                this.clientOldAttachPosition = null;
            }
        }
    }

    private void findNewAttachment() {
        Direction $$0 = this.findAttachableSurface(this.blockPosition());
        if ($$0 != null) {
            this.setAttachFace($$0);
        } else {
            this.teleportSomewhere();
        }
    }

    @Override
    protected AABB makeBoundingBox() {
        float $$0 = Shulker.getPhysicalPeek(this.currentPeekAmount);
        Direction $$1 = this.getAttachFace().getOpposite();
        float $$2 = this.getBbWidth() / 2.0f;
        return Shulker.getProgressAabb(this.getScale(), $$1, $$0).move(this.getX() - (double)$$2, this.getY(), this.getZ() - (double)$$2);
    }

    private static float getPhysicalPeek(float p_149769_) {
        return 0.5f - Mth.sin((0.5f + p_149769_) * (float)Math.PI) * 0.5f;
    }

    private boolean updatePeekAmount() {
        this.currentPeekAmountO = this.currentPeekAmount;
        float $$0 = (float)this.getRawPeekAmount() * 0.01f;
        if (this.currentPeekAmount == $$0) {
            return false;
        }
        this.currentPeekAmount = this.currentPeekAmount > $$0 ? Mth.clamp(this.currentPeekAmount - 0.05f, $$0, 1.0f) : Mth.clamp(this.currentPeekAmount + 0.05f, 0.0f, $$0);
        return true;
    }

    private void onPeekAmountChange() {
        this.reapplyPosition();
        float $$0 = Shulker.getPhysicalPeek(this.currentPeekAmount);
        float $$1 = Shulker.getPhysicalPeek(this.currentPeekAmountO);
        Direction $$2 = this.getAttachFace().getOpposite();
        float $$3 = ($$0 - $$1) * this.getScale();
        if ($$3 <= 0.0f) {
            return;
        }
        List<Entity> $$4 = this.level().getEntities(this, Shulker.getProgressDeltaAabb(this.getScale(), $$2, $$1, $$0).move(this.getX() - 0.5, this.getY(), this.getZ() - 0.5), EntitySelector.NO_SPECTATORS.and(p_149771_ -> !p_149771_.isPassengerOfSameVehicle(this)));
        for (Entity $$5 : $$4) {
            if ($$5 instanceof Shulker || $$5.noPhysics) continue;
            $$5.move(MoverType.SHULKER, new Vec3($$3 * (float)$$2.getStepX(), $$3 * (float)$$2.getStepY(), $$3 * (float)$$2.getStepZ()));
        }
    }

    public static AABB getProgressAabb(float p_149792_, Direction p_149791_, float p_320551_) {
        return Shulker.getProgressDeltaAabb(p_149792_, p_149791_, -1.0f, p_320551_);
    }

    public static AABB getProgressDeltaAabb(float p_149795_, Direction p_149794_, float p_149796_, float p_320876_) {
        AABB $$4 = new AABB(0.0, 0.0, 0.0, p_149795_, p_149795_, p_149795_);
        double $$5 = Math.max(p_149796_, p_320876_);
        double $$6 = Math.min(p_149796_, p_320876_);
        return $$4.expandTowards((double)p_149794_.getStepX() * $$5 * (double)p_149795_, (double)p_149794_.getStepY() * $$5 * (double)p_149795_, (double)p_149794_.getStepZ() * $$5 * (double)p_149795_).contract((double)(-p_149794_.getStepX()) * (1.0 + $$6) * (double)p_149795_, (double)(-p_149794_.getStepY()) * (1.0 + $$6) * (double)p_149795_, (double)(-p_149794_.getStepZ()) * (1.0 + $$6) * (double)p_149795_);
    }

    @Override
    public boolean startRiding(Entity p_149773_, boolean p_149774_) {
        if (this.level().isClientSide()) {
            this.clientOldAttachPosition = null;
            this.clientSideTeleportInterpolation = 0;
        }
        this.setAttachFace(Direction.DOWN);
        return super.startRiding(p_149773_, p_149774_);
    }

    @Override
    public void stopRiding() {
        super.stopRiding();
        if (this.level().isClientSide) {
            this.clientOldAttachPosition = this.blockPosition();
        }
        this.yBodyRotO = 0.0f;
        this.yBodyRot = 0.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_149780_, DifficultyInstance p_149781_, MobSpawnType p_149782_, @Nullable SpawnGroupData p_149783_) {
        this.setYRot(0.0f);
        this.yHeadRot = this.getYRot();
        this.setOldPosAndRot();
        return super.finalizeSpawn(p_149780_, p_149781_, p_149782_, p_149783_);
    }

    @Override
    public void move(MoverType p_33424_, Vec3 p_33425_) {
        if (p_33424_ == MoverType.SHULKER_BOX) {
            this.teleportSomewhere();
        } else {
            super.move(p_33424_, p_33425_);
        }
    }

    @Override
    public Vec3 getDeltaMovement() {
        return Vec3.ZERO;
    }

    @Override
    public void setDeltaMovement(Vec3 p_149804_) {
    }

    @Override
    public void setPos(double p_33449_, double p_33450_, double p_33451_) {
        BlockPos $$3 = this.blockPosition();
        if (this.isPassenger()) {
            super.setPos(p_33449_, p_33450_, p_33451_);
        } else {
            super.setPos((double)Mth.floor(p_33449_) + 0.5, Mth.floor(p_33450_ + 0.5), (double)Mth.floor(p_33451_) + 0.5);
        }
        if (this.tickCount == 0) {
            return;
        }
        BlockPos $$4 = this.blockPosition();
        if (!$$4.equals($$3)) {
            this.entityData.set(DATA_PEEK_ID, (byte)0);
            this.hasImpulse = true;
            if (this.level().isClientSide && !this.isPassenger() && !$$4.equals(this.clientOldAttachPosition)) {
                this.clientOldAttachPosition = $$3;
                this.clientSideTeleportInterpolation = 6;
                this.xOld = this.getX();
                this.yOld = this.getY();
                this.zOld = this.getZ();
            }
        }
    }

    @Nullable
    protected Direction findAttachableSurface(BlockPos p_149811_) {
        for (Direction $$1 : Direction.values()) {
            if (!this.canStayAt(p_149811_, $$1)) continue;
            return $$1;
        }
        return null;
    }

    boolean canStayAt(BlockPos p_149786_, Direction p_149787_) {
        if (this.isPositionBlocked(p_149786_)) {
            return false;
        }
        Direction $$2 = p_149787_.getOpposite();
        if (!this.level().loadedAndEntityCanStandOnFace(p_149786_.relative(p_149787_), this, $$2)) {
            return false;
        }
        AABB $$3 = Shulker.getProgressAabb(this.getScale(), $$2, 1.0f).move(p_149786_).deflate(1.0E-6);
        return this.level().noCollision(this, $$3);
    }

    private boolean isPositionBlocked(BlockPos p_149813_) {
        BlockState $$1 = this.level().getBlockState(p_149813_);
        if ($$1.isAir()) {
            return false;
        }
        boolean $$2 = $$1.is(Blocks.MOVING_PISTON) && p_149813_.equals(this.blockPosition());
        return !$$2;
    }

    protected boolean teleportSomewhere() {
        if (this.isNoAi() || !this.isAlive()) {
            return false;
        }
        BlockPos $$0 = this.blockPosition();
        for (int $$1 = 0; $$1 < 5; ++$$1) {
            Direction $$3;
            BlockPos $$2 = $$0.offset(Mth.randomBetweenInclusive(this.random, -8, 8), Mth.randomBetweenInclusive(this.random, -8, 8), Mth.randomBetweenInclusive(this.random, -8, 8));
            if ($$2.getY() <= this.level().getMinBuildHeight() || !this.level().isEmptyBlock($$2) || !this.level().getWorldBorder().isWithinBounds($$2) || !this.level().noCollision(this, new AABB($$2).deflate(1.0E-6)) || ($$3 = this.findAttachableSurface($$2)) == null) continue;
            this.unRide();
            this.setAttachFace($$3);
            this.playSound(SoundEvents.SHULKER_TELEPORT, 1.0f, 1.0f);
            this.setPos((double)$$2.getX() + 0.5, $$2.getY(), (double)$$2.getZ() + 0.5);
            this.level().gameEvent(GameEvent.TELEPORT, $$0, GameEvent.Context.of(this));
            this.entityData.set(DATA_PEEK_ID, (byte)0);
            this.setTarget(null);
            return true;
        }
        return false;
    }

    @Override
    public void lerpTo(double p_33411_, double p_33412_, double p_33413_, float p_33414_, float p_33415_, int p_33416_) {
        this.lerpSteps = 0;
        this.setPos(p_33411_, p_33412_, p_33413_);
        this.setRot(p_33414_, p_33415_);
    }

    @Override
    public boolean hurt(DamageSource p_33421_, float p_33422_) {
        Entity $$2;
        if (this.isClosed() && ($$2 = p_33421_.getDirectEntity()) instanceof AbstractArrow) {
            return false;
        }
        if (super.hurt(p_33421_, p_33422_)) {
            Entity $$3;
            if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5 && this.random.nextInt(4) == 0) {
                this.teleportSomewhere();
            } else if (p_33421_.is(DamageTypeTags.IS_PROJECTILE) && ($$3 = p_33421_.getDirectEntity()) != null && $$3.getType() == EntityType.SHULKER_BULLET) {
                this.hitByShulkerBullet();
            }
            return true;
        }
        return false;
    }

    private boolean isClosed() {
        return this.getRawPeekAmount() == 0;
    }

    private void hitByShulkerBullet() {
        Vec3 $$0 = this.position();
        AABB $$1 = this.getBoundingBox();
        if (this.isClosed() || !this.teleportSomewhere()) {
            return;
        }
        int $$2 = this.level().getEntities(EntityType.SHULKER, $$1.inflate(8.0), Entity::isAlive).size();
        float $$3 = (float)($$2 - 1) / 5.0f;
        if (this.level().random.nextFloat() < $$3) {
            return;
        }
        Shulker $$4 = EntityType.SHULKER.create(this.level());
        if ($$4 != null) {
            $$4.setVariant((Optional<DyeColor>)this.getVariant());
            $$4.moveTo($$0);
            this.level().addFreshEntity($$4);
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public Direction getAttachFace() {
        return this.entityData.get(DATA_ATTACH_FACE_ID);
    }

    private void setAttachFace(Direction p_149789_) {
        this.entityData.set(DATA_ATTACH_FACE_ID, p_149789_);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_33434_) {
        if (DATA_ATTACH_FACE_ID.equals(p_33434_)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
        super.onSyncedDataUpdated(p_33434_);
    }

    private int getRawPeekAmount() {
        return this.entityData.get(DATA_PEEK_ID).byteValue();
    }

    void setRawPeekAmount(int p_33419_) {
        if (!this.level().isClientSide) {
            this.getAttribute(Attributes.ARMOR).removeModifier(COVERED_ARMOR_MODIFIER.id());
            if (p_33419_ == 0) {
                this.getAttribute(Attributes.ARMOR).addPermanentModifier(COVERED_ARMOR_MODIFIER);
                this.playSound(SoundEvents.SHULKER_CLOSE, 1.0f, 1.0f);
                this.gameEvent(GameEvent.CONTAINER_CLOSE);
            } else {
                this.playSound(SoundEvents.SHULKER_OPEN, 1.0f, 1.0f);
                this.gameEvent(GameEvent.CONTAINER_OPEN);
            }
        }
        this.entityData.set(DATA_PEEK_ID, (byte)p_33419_);
    }

    public float getClientPeekAmount(float p_33481_) {
        return Mth.lerp(p_33481_, this.currentPeekAmountO, this.currentPeekAmount);
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_219067_) {
        super.recreateFromPacket(p_219067_);
        this.yBodyRot = 0.0f;
        this.yBodyRotO = 0.0f;
    }

    @Override
    public int getMaxHeadXRot() {
        return 180;
    }

    @Override
    public int getMaxHeadYRot() {
        return 180;
    }

    @Override
    public void push(Entity p_33474_) {
    }

    public Optional<Vec3> getRenderPosition(float p_149767_) {
        if (this.clientOldAttachPosition == null || this.clientSideTeleportInterpolation <= 0) {
            return Optional.empty();
        }
        double $$1 = (double)((float)this.clientSideTeleportInterpolation - p_149767_) / 6.0;
        $$1 *= $$1;
        BlockPos $$2 = this.blockPosition();
        double $$3 = (double)($$2.getX() - this.clientOldAttachPosition.getX()) * $$1;
        double $$4 = (double)($$2.getY() - this.clientOldAttachPosition.getY()) * $$1;
        double $$5 = (double)($$2.getZ() - this.clientOldAttachPosition.getZ()) * $$1;
        return Optional.of(new Vec3(-$$3, -$$4, -$$5));
    }

    @Override
    protected float sanitizeScale(float p_320641_) {
        return Math.min(p_320641_, 3.0f);
    }

    @Override
    public void setVariant(Optional<DyeColor> p_262609_) {
        this.entityData.set(DATA_COLOR_ID, p_262609_.map(p_262566_ -> (byte)p_262566_.getId()).orElse((byte)16));
    }

    @Override
    public Optional<DyeColor> getVariant() {
        return Optional.ofNullable(this.getColor());
    }

    @Nullable
    public DyeColor getColor() {
        byte $$0 = this.entityData.get(DATA_COLOR_ID);
        if ($$0 == 16 || $$0 > 15) {
            return null;
        }
        return DyeColor.byId($$0);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    class ShulkerLookControl
    extends LookControl {
        public ShulkerLookControl(Mob p_149820_) {
            super(p_149820_);
        }

        @Override
        protected void clampHeadRotationToBody() {
        }

        @Override
        protected Optional<Float> getYRotD() {
            Direction $$0 = Shulker.this.getAttachFace().getOpposite();
            Vector3f $$1 = $$0.getRotation().transform(new Vector3f((Vector3fc)FORWARD));
            Vec3i $$2 = $$0.getNormal();
            Vector3f $$3 = new Vector3f((float)$$2.getX(), (float)$$2.getY(), (float)$$2.getZ());
            $$3.cross((Vector3fc)$$1);
            double $$4 = this.wantedX - this.mob.getX();
            double $$5 = this.wantedY - this.mob.getEyeY();
            double $$6 = this.wantedZ - this.mob.getZ();
            Vector3f $$7 = new Vector3f((float)$$4, (float)$$5, (float)$$6);
            float $$8 = $$3.dot((Vector3fc)$$7);
            float $$9 = $$1.dot((Vector3fc)$$7);
            return Math.abs($$8) > 1.0E-5f || Math.abs($$9) > 1.0E-5f ? Optional.of(Float.valueOf((float)(Mth.atan2(-$$8, $$9) * 57.2957763671875))) : Optional.empty();
        }

        @Override
        protected Optional<Float> getXRotD() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    class ShulkerAttackGoal
    extends Goal {
        private int attackTime;

        public ShulkerAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            LivingEntity $$0 = Shulker.this.getTarget();
            if ($$0 == null || !$$0.isAlive()) {
                return false;
            }
            return Shulker.this.level().getDifficulty() != Difficulty.PEACEFUL;
        }

        @Override
        public void start() {
            this.attackTime = 20;
            Shulker.this.setRawPeekAmount(100);
        }

        @Override
        public void stop() {
            Shulker.this.setRawPeekAmount(0);
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            if (Shulker.this.level().getDifficulty() == Difficulty.PEACEFUL) {
                return;
            }
            --this.attackTime;
            LivingEntity $$0 = Shulker.this.getTarget();
            if ($$0 == null) {
                return;
            }
            Shulker.this.getLookControl().setLookAt($$0, 180.0f, 180.0f);
            double $$1 = Shulker.this.distanceToSqr($$0);
            if ($$1 < 400.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20 + Shulker.this.random.nextInt(10) * 20 / 2;
                    Shulker.this.level().addFreshEntity(new ShulkerBullet(Shulker.this.level(), Shulker.this, $$0, Shulker.this.getAttachFace().getAxis()));
                    Shulker.this.playSound(SoundEvents.SHULKER_SHOOT, 2.0f, (Shulker.this.random.nextFloat() - Shulker.this.random.nextFloat()) * 0.2f + 1.0f);
                }
            } else {
                Shulker.this.setTarget(null);
            }
            super.tick();
        }
    }

    class ShulkerPeekGoal
    extends Goal {
        private int peekTime;

        ShulkerPeekGoal() {
        }

        @Override
        public boolean canUse() {
            return Shulker.this.getTarget() == null && Shulker.this.random.nextInt(ShulkerPeekGoal.reducedTickDelay(40)) == 0 && Shulker.this.canStayAt(Shulker.this.blockPosition(), Shulker.this.getAttachFace());
        }

        @Override
        public boolean canContinueToUse() {
            return Shulker.this.getTarget() == null && this.peekTime > 0;
        }

        @Override
        public void start() {
            this.peekTime = this.adjustedTickDelay(20 * (1 + Shulker.this.random.nextInt(3)));
            Shulker.this.setRawPeekAmount(30);
        }

        @Override
        public void stop() {
            if (Shulker.this.getTarget() == null) {
                Shulker.this.setRawPeekAmount(0);
            }
        }

        @Override
        public void tick() {
            --this.peekTime;
        }
    }

    class ShulkerNearestAttackGoal
    extends NearestAttackableTargetGoal<Player> {
        public ShulkerNearestAttackGoal(Shulker p_33505_) {
            super((Mob)p_33505_, Player.class, true);
        }

        @Override
        public boolean canUse() {
            if (Shulker.this.level().getDifficulty() == Difficulty.PEACEFUL) {
                return false;
            }
            return super.canUse();
        }

        @Override
        protected AABB getTargetSearchArea(double p_33508_) {
            Direction $$1 = ((Shulker)this.mob).getAttachFace();
            if ($$1.getAxis() == Direction.Axis.X) {
                return this.mob.getBoundingBox().inflate(4.0, p_33508_, p_33508_);
            }
            if ($$1.getAxis() == Direction.Axis.Z) {
                return this.mob.getBoundingBox().inflate(p_33508_, p_33508_, 4.0);
            }
            return this.mob.getBoundingBox().inflate(p_33508_, 4.0, p_33508_);
        }
    }

    static class ShulkerDefenseAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public ShulkerDefenseAttackGoal(Shulker p_33496_) {
            super(p_33496_, LivingEntity.class, 10, true, false, p_33501_ -> p_33501_ instanceof Enemy);
        }

        @Override
        public boolean canUse() {
            if (this.mob.getTeam() == null) {
                return false;
            }
            return super.canUse();
        }

        @Override
        protected AABB getTargetSearchArea(double p_33499_) {
            Direction $$1 = ((Shulker)this.mob).getAttachFace();
            if ($$1.getAxis() == Direction.Axis.X) {
                return this.mob.getBoundingBox().inflate(4.0, p_33499_, p_33499_);
            }
            if ($$1.getAxis() == Direction.Axis.Z) {
                return this.mob.getBoundingBox().inflate(p_33499_, p_33499_, 4.0);
            }
            return this.mob.getBoundingBox().inflate(p_33499_, 4.0, p_33499_);
        }
    }

    static class ShulkerBodyRotationControl
    extends BodyRotationControl {
        public ShulkerBodyRotationControl(Mob p_149816_) {
            super(p_149816_);
        }

        @Override
        public void clientTick() {
        }
    }
}

