/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class ZombieVillager
extends Zombie
implements VillagerDataHolder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.defineId(ZombieVillager.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA = SynchedEntityData.defineId(ZombieVillager.class, EntityDataSerializers.VILLAGER_DATA);
    private static final int VILLAGER_CONVERSION_WAIT_MIN = 3600;
    private static final int VILLAGER_CONVERSION_WAIT_MAX = 6000;
    private static final int MAX_SPECIAL_BLOCKS_COUNT = 14;
    private static final int SPECIAL_BLOCK_RADIUS = 4;
    private int villagerConversionTime;
    @Nullable
    private UUID conversionStarter;
    @Nullable
    private Tag gossips;
    @Nullable
    private MerchantOffers tradeOffers;
    private int villagerXp;

    public ZombieVillager(EntityType<? extends ZombieVillager> p_34368_, Level p_34369_) {
        super((EntityType<? extends Zombie>)p_34368_, p_34369_);
        BuiltInRegistries.VILLAGER_PROFESSION.getRandom(this.random).ifPresent(p_255550_ -> this.setVillagerData(this.getVillagerData().setProfession((VillagerProfession)p_255550_.value())));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326075_) {
        super.defineSynchedData(p_326075_);
        p_326075_.define(DATA_CONVERTING_ID, false);
        p_326075_.define(DATA_VILLAGER_DATA, new VillagerData(VillagerType.PLAINS, VillagerProfession.NONE, 1));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_34397_) {
        super.addAdditionalSaveData(p_34397_);
        VillagerData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getVillagerData()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_204072_ -> p_34397_.put("VillagerData", (Tag)p_204072_));
        if (this.tradeOffers != null) {
            p_34397_.put("Offers", (Tag)MerchantOffers.CODEC.encodeStart(this.registryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)this.tradeOffers).getOrThrow());
        }
        if (this.gossips != null) {
            p_34397_.put("Gossips", this.gossips);
        }
        p_34397_.putInt("ConversionTime", this.isConverting() ? this.villagerConversionTime : -1);
        if (this.conversionStarter != null) {
            p_34397_.putUUID("ConversionPlayer", this.conversionStarter);
        }
        p_34397_.putInt("Xp", this.villagerXp);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_34387_) {
        super.readAdditionalSaveData(p_34387_);
        if (p_34387_.contains("VillagerData", 10)) {
            DataResult $$1 = VillagerData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_34387_.get("VillagerData")));
            $$1.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setVillagerData);
        }
        if (p_34387_.contains("Offers")) {
            MerchantOffers.CODEC.parse(this.registryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)p_34387_.get("Offers")).resultOrPartial(Util.prefix("Failed to load offers: ", arg_0 -> ((Logger)LOGGER).warn(arg_0))).ifPresent(p_323336_ -> {
                this.tradeOffers = p_323336_;
            });
        }
        if (p_34387_.contains("Gossips", 9)) {
            this.gossips = p_34387_.getList("Gossips", 10);
        }
        if (p_34387_.contains("ConversionTime", 99) && p_34387_.getInt("ConversionTime") > -1) {
            this.startConverting(p_34387_.hasUUID("ConversionPlayer") ? p_34387_.getUUID("ConversionPlayer") : null, p_34387_.getInt("ConversionTime"));
        }
        if (p_34387_.contains("Xp", 3)) {
            this.villagerXp = p_34387_.getInt("Xp");
        }
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.isAlive() && this.isConverting()) {
            int $$0 = this.getConversionProgress();
            this.villagerConversionTime -= $$0;
            if (this.villagerConversionTime <= 0) {
                this.finishConversion((ServerLevel)this.level());
            }
        }
        super.tick();
    }

    @Override
    public InteractionResult mobInteract(Player p_34394_, InteractionHand p_34395_) {
        ItemStack $$2 = p_34394_.getItemInHand(p_34395_);
        if ($$2.is(Items.GOLDEN_APPLE)) {
            if (this.hasEffect(MobEffects.WEAKNESS)) {
                $$2.consume(1, p_34394_);
                if (!this.level().isClientSide) {
                    this.startConverting(p_34394_.getUUID(), this.random.nextInt(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(p_34394_, p_34395_);
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    @Override
    public boolean removeWhenFarAway(double p_34414_) {
        return !this.isConverting() && this.villagerXp == 0;
    }

    public boolean isConverting() {
        return this.getEntityData().get(DATA_CONVERTING_ID);
    }

    private void startConverting(@Nullable UUID p_34384_, int p_34385_) {
        this.conversionStarter = p_34384_;
        this.villagerConversionTime = p_34385_;
        this.getEntityData().set(DATA_CONVERTING_ID, true);
        this.removeEffect(MobEffects.WEAKNESS);
        this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, p_34385_, Math.min(this.level().getDifficulty().getId() - 1, 0)));
        this.level().broadcastEntityEvent(this, (byte)16);
    }

    @Override
    public void handleEntityEvent(byte p_34372_) {
        if (p_34372_ == 16) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
            return;
        }
        super.handleEntityEvent(p_34372_);
    }

    private void finishConversion(ServerLevel p_34399_) {
        Player $$5;
        Villager $$1 = this.convertTo(EntityType.VILLAGER, false);
        for (EquipmentSlot $$2 : EquipmentSlot.values()) {
            ItemStack $$3 = this.getItemBySlot($$2);
            if ($$3.isEmpty()) continue;
            if (EnchantmentHelper.hasBindingCurse($$3)) {
                $$1.getSlot($$2.getIndex() + 300).set($$3);
                continue;
            }
            double $$4 = this.getEquipmentDropChance($$2);
            if (!($$4 > 1.0)) continue;
            this.spawnAtLocation($$3);
        }
        $$1.setVillagerData(this.getVillagerData());
        if (this.gossips != null) {
            $$1.setGossips(this.gossips);
        }
        if (this.tradeOffers != null) {
            $$1.setOffers(this.tradeOffers.copy());
        }
        $$1.setVillagerXp(this.villagerXp);
        $$1.finalizeSpawn(p_34399_, p_34399_.getCurrentDifficultyAt($$1.blockPosition()), MobSpawnType.CONVERSION, null);
        $$1.refreshBrain(p_34399_);
        if (this.conversionStarter != null && ($$5 = p_34399_.getPlayerByUUID(this.conversionStarter)) instanceof ServerPlayer) {
            CriteriaTriggers.CURED_ZOMBIE_VILLAGER.trigger((ServerPlayer)$$5, this, $$1);
            p_34399_.onReputationEvent(ReputationEventType.ZOMBIE_VILLAGER_CURED, $$5, $$1);
        }
        $$1.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
        if (!this.isSilent()) {
            p_34399_.levelEvent(null, 1027, this.blockPosition(), 0);
        }
    }

    private int getConversionProgress() {
        int $$0 = 1;
        if (this.random.nextFloat() < 0.01f) {
            int $$1 = 0;
            BlockPos.MutableBlockPos $$2 = new BlockPos.MutableBlockPos();
            for (int $$3 = (int)this.getX() - 4; $$3 < (int)this.getX() + 4 && $$1 < 14; ++$$3) {
                for (int $$4 = (int)this.getY() - 4; $$4 < (int)this.getY() + 4 && $$1 < 14; ++$$4) {
                    for (int $$5 = (int)this.getZ() - 4; $$5 < (int)this.getZ() + 4 && $$1 < 14; ++$$5) {
                        BlockState $$6 = this.level().getBlockState($$2.set($$3, $$4, $$5));
                        if (!$$6.is(Blocks.IRON_BARS) && !($$6.getBlock() instanceof BedBlock)) continue;
                        if (this.random.nextFloat() < 0.3f) {
                            ++$$0;
                        }
                        ++$$1;
                    }
                }
            }
        }
        return $$0;
    }

    @Override
    public float getVoicePitch() {
        if (this.isBaby()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 2.0f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_VILLAGER_AMBIENT;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource p_34404_) {
        return SoundEvents.ZOMBIE_VILLAGER_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_VILLAGER_DEATH;
    }

    @Override
    public SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_VILLAGER_STEP;
    }

    @Override
    protected ItemStack getSkull() {
        return ItemStack.EMPTY;
    }

    public void setTradeOffers(MerchantOffers p_324128_) {
        this.tradeOffers = p_324128_;
    }

    public void setGossips(Tag p_34392_) {
        this.gossips = p_34392_;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_34378_, DifficultyInstance p_34379_, MobSpawnType p_34380_, @Nullable SpawnGroupData p_34381_) {
        this.setVillagerData(this.getVillagerData().setType(VillagerType.byBiome(p_34378_.getBiome(this.blockPosition()))));
        return super.finalizeSpawn(p_34378_, p_34379_, p_34380_, p_34381_);
    }

    @Override
    public void setVillagerData(VillagerData p_34376_) {
        VillagerData $$1 = this.getVillagerData();
        if ($$1.getProfession() != p_34376_.getProfession()) {
            this.tradeOffers = null;
        }
        this.entityData.set(DATA_VILLAGER_DATA, p_34376_);
    }

    @Override
    public VillagerData getVillagerData() {
        return this.entityData.get(DATA_VILLAGER_DATA);
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public void setVillagerXp(int p_34374_) {
        this.villagerXp = p_34374_;
    }
}

