/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CopyMemoryWithExpiry;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.behavior.DismountOrSkipMounting;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.Mount;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StartCelebratingIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.TriggerGate;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.RememberIfHoglinWasKilled;
import net.minecraft.world.entity.monster.piglin.StartAdmiringItemIfSeen;
import net.minecraft.world.entity.monster.piglin.StartHuntingHoglin;
import net.minecraft.world.entity.monster.piglin.StopAdmiringIfItemTooFarAway;
import net.minecraft.world.entity.monster.piglin.StopAdmiringIfTiredOfTryingToReachItem;
import net.minecraft.world.entity.monster.piglin.StopHoldingItemIfNoLongerAdmiring;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class PiglinAi {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    public static final Item BARTERING_ITEM = Items.GOLD_INGOT;
    private static final int PLAYER_ANGER_RANGE = 16;
    private static final int ANGER_DURATION = 600;
    private static final int ADMIRE_DURATION = 119;
    private static final int MAX_DISTANCE_TO_WALK_TO_ITEM = 9;
    private static final int MAX_TIME_TO_WALK_TO_ITEM = 200;
    private static final int HOW_LONG_TIME_TO_DISABLE_ADMIRE_WALKING_IF_CANT_REACH_ITEM = 200;
    private static final int CELEBRATION_TIME = 300;
    protected static final UniformInt TIME_BETWEEN_HUNTS = TimeUtil.rangeOfSeconds(30, 120);
    private static final int BABY_FLEE_DURATION_AFTER_GETTING_HIT = 100;
    private static final int HIT_BY_PLAYER_MEMORY_TIMEOUT = 400;
    private static final int MAX_WALK_DISTANCE_TO_START_RIDING = 8;
    private static final UniformInt RIDE_START_INTERVAL = TimeUtil.rangeOfSeconds(10, 40);
    private static final UniformInt RIDE_DURATION = TimeUtil.rangeOfSeconds(10, 30);
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds(5, 20);
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final int EAT_COOLDOWN = 200;
    private static final int DESIRED_DISTANCE_FROM_ENTITY_WHEN_AVOIDING = 12;
    private static final int MAX_LOOK_DIST = 8;
    private static final int MAX_LOOK_DIST_FOR_PLAYER_HOLDING_LOVED_ITEM = 14;
    private static final int INTERACTION_RANGE = 8;
    private static final int MIN_DESIRED_DIST_FROM_TARGET_WHEN_HOLDING_CROSSBOW = 5;
    private static final float SPEED_WHEN_STRAFING_BACK_FROM_TARGET = 0.75f;
    private static final int DESIRED_DISTANCE_FROM_ZOMBIFIED = 6;
    private static final UniformInt AVOID_ZOMBIFIED_DURATION = TimeUtil.rangeOfSeconds(5, 7);
    private static final UniformInt BABY_AVOID_NEMESIS_DURATION = TimeUtil.rangeOfSeconds(5, 7);
    private static final float PROBABILITY_OF_CELEBRATION_DANCE = 0.1f;
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_MOUNTING = 0.8f;
    private static final float SPEED_MULTIPLIER_WHEN_GOING_TO_WANTED_ITEM = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_GOING_TO_CELEBRATE_LOCATION = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_DANCING = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;

    protected static Brain<?> makeBrain(Piglin p_34841_, Brain<Piglin> p_34842_) {
        PiglinAi.initCoreActivity(p_34842_);
        PiglinAi.initIdleActivity(p_34842_);
        PiglinAi.initAdmireItemActivity(p_34842_);
        PiglinAi.initFightActivity(p_34841_, p_34842_);
        PiglinAi.initCelebrateActivity(p_34842_);
        PiglinAi.initRetreatActivity(p_34842_);
        PiglinAi.initRideHoglinActivity(p_34842_);
        p_34842_.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        p_34842_.setDefaultActivity(Activity.IDLE);
        p_34842_.useDefaultActivity();
        return p_34842_;
    }

    protected static void initMemories(Piglin p_219206_, RandomSource p_219207_) {
        int $$2 = TIME_BETWEEN_HUNTS.sample(p_219207_);
        p_219206_.getBrain().setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, true, $$2);
    }

    private static void initCoreActivity(Brain<Piglin> p_34821_) {
        p_34821_.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), InteractWithDoor.create(), PiglinAi.babyAvoidNemesis(), PiglinAi.avoidZombified(), StopHoldingItemIfNoLongerAdmiring.create(), StartAdmiringItemIfSeen.create(119), StartCelebratingIfTargetDead.create(300, PiglinAi::wantsToDance), StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(Brain<Piglin> p_34892_) {
        p_34892_.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, 14.0f), StartAttacking.create(AbstractPiglin::isAdult, PiglinAi::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(Piglin::canHunt, StartHuntingHoglin.create()), PiglinAi.avoidRepellent(), PiglinAi.babySometimesRideBabyHoglin(), PiglinAi.createIdleLookBehaviors(), PiglinAi.createIdleMovementBehaviors(), SetLookAndInteract.create(EntityType.PLAYER, 4)));
    }

    private static void initFightActivity(Piglin p_34904_, Brain<Piglin> p_34905_) {
        p_34905_.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(StopAttackingIfTargetInvalid.create(p_34981_ -> !PiglinAi.isNearestValidAttackTarget(p_34904_, p_34981_)), BehaviorBuilder.triggerIf(PiglinAi::hasCrossbow, BackUpIfTooClose.create(5, 0.75f)), SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(1.0f), MeleeAttack.create(20), new CrossbowAttack(), RememberIfHoglinWasKilled.create(), EraseMemoryIf.create(PiglinAi::isNearZombified, MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCelebrateActivity(Brain<Piglin> p_34921_) {
        p_34921_.addActivityAndRemoveMemoryWhenStopped(Activity.CELEBRATE, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(PiglinAi.avoidRepellent(), SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, 14.0f), StartAttacking.create(AbstractPiglin::isAdult, PiglinAi::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(p_34804_ -> !p_34804_.isDancing(), GoToTargetLocation.create(MemoryModuleType.CELEBRATE_LOCATION, 2, 1.0f)), BehaviorBuilder.triggerIf(Piglin::isDancing, GoToTargetLocation.create(MemoryModuleType.CELEBRATE_LOCATION, 4, 0.6f)), new RunOne(ImmutableList.of((Object)Pair.of(SetEntityLookTarget.create(EntityType.PIGLIN, 8.0f), (Object)1), (Object)Pair.of(RandomStroll.stroll(0.6f, 2, 1), (Object)1), (Object)Pair.of((Object)new DoNothing(10, 20), (Object)1)))), MemoryModuleType.CELEBRATE_LOCATION);
    }

    private static void initAdmireItemActivity(Brain<Piglin> p_34941_) {
        p_34941_.addActivityAndRemoveMemoryWhenStopped(Activity.ADMIRE_ITEM, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(GoToWantedItem.create(PiglinAi::isNotHoldingLovedItemInOffHand, 1.0f, true, 9), StopAdmiringIfItemTooFarAway.create(9), StopAdmiringIfTiredOfTryingToReachItem.create(200, 200)), MemoryModuleType.ADMIRING_ITEM);
    }

    private static void initRetreatActivity(Brain<Piglin> p_34959_) {
        p_34959_.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(SetWalkTargetAwayFrom.entity(MemoryModuleType.AVOID_TARGET, 1.0f, 12, true), PiglinAi.createIdleLookBehaviors(), PiglinAi.createIdleMovementBehaviors(), EraseMemoryIf.create(PiglinAi::wantsToStopFleeing, MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static void initRideHoglinActivity(Brain<Piglin> p_34974_) {
        p_34974_.addActivityAndRemoveMemoryWhenStopped(Activity.RIDE, 10, (ImmutableList<BehaviorControl<Piglin>>)ImmutableList.of(Mount.create(0.8f), SetEntityLookTarget.create(PiglinAi::isPlayerHoldingLovedItem, 8.0f), BehaviorBuilder.sequence(BehaviorBuilder.triggerIf(Entity::isPassenger), TriggerGate.triggerOneShuffled(ImmutableList.builder().addAll(PiglinAi.createLookBehaviors()).add((Object)Pair.of(BehaviorBuilder.triggerIf(p_258950_ -> true), (Object)1)).build())), DismountOrSkipMounting.create(8, PiglinAi::wantsToStopRiding)), MemoryModuleType.RIDE_TARGET);
    }

    private static ImmutableList<Pair<OneShot<LivingEntity>, Integer>> createLookBehaviors() {
        return ImmutableList.of((Object)Pair.of(SetEntityLookTarget.create(EntityType.PLAYER, 8.0f), (Object)1), (Object)Pair.of(SetEntityLookTarget.create(EntityType.PIGLIN, 8.0f), (Object)1), (Object)Pair.of(SetEntityLookTarget.create(8.0f), (Object)1));
    }

    private static RunOne<LivingEntity> createIdleLookBehaviors() {
        return new RunOne<LivingEntity>((List<Pair<BehaviorControl<LivingEntity>, Integer>>)ImmutableList.builder().addAll(PiglinAi.createLookBehaviors()).add((Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)).build());
    }

    private static RunOne<Piglin> createIdleMovementBehaviors() {
        return new RunOne<Piglin>((List<Pair<BehaviorControl<Piglin>, Integer>>)ImmutableList.of((Object)Pair.of(RandomStroll.stroll(0.6f), (Object)2), (Object)Pair.of(InteractWith.of(EntityType.PIGLIN, 8, MemoryModuleType.INTERACTION_TARGET, 0.6f, 2), (Object)2), (Object)Pair.of(BehaviorBuilder.triggerIf(PiglinAi::doesntSeeAnyPlayerHoldingLovedItem, SetWalkTargetFromLookTarget.create(0.6f, 3)), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.pos(MemoryModuleType.NEAREST_REPELLENT, 1.0f, 8, false);
    }

    private static BehaviorControl<Piglin> babyAvoidNemesis() {
        return CopyMemoryWithExpiry.create(Piglin::isBaby, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.AVOID_TARGET, BABY_AVOID_NEMESIS_DURATION);
    }

    private static BehaviorControl<Piglin> avoidZombified() {
        return CopyMemoryWithExpiry.create(PiglinAi::isNearZombified, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.AVOID_TARGET, AVOID_ZOMBIFIED_DURATION);
    }

    protected static void updateActivity(Piglin p_34899_) {
        Brain<Piglin> $$1 = p_34899_.getBrain();
        Activity $$2 = $$1.getActiveNonCoreActivity().orElse(null);
        $$1.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.ADMIRE_ITEM, (Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.CELEBRATE, (Object)Activity.RIDE, (Object)Activity.IDLE));
        Activity $$3 = $$1.getActiveNonCoreActivity().orElse(null);
        if ($$2 != $$3) {
            PiglinAi.getSoundForCurrentActivity(p_34899_).ifPresent(p_34899_::makeSound);
        }
        p_34899_.setAggressive($$1.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        if (!$$1.hasMemoryValue(MemoryModuleType.RIDE_TARGET) && PiglinAi.isBabyRidingBaby(p_34899_)) {
            p_34899_.stopRiding();
        }
        if (!$$1.hasMemoryValue(MemoryModuleType.CELEBRATE_LOCATION)) {
            $$1.eraseMemory(MemoryModuleType.DANCING);
        }
        p_34899_.setDancing($$1.hasMemoryValue(MemoryModuleType.DANCING));
    }

    private static boolean isBabyRidingBaby(Piglin p_34993_) {
        if (!p_34993_.isBaby()) {
            return false;
        }
        Entity $$1 = p_34993_.getVehicle();
        return $$1 instanceof Piglin && ((Piglin)$$1).isBaby() || $$1 instanceof Hoglin && ((Hoglin)$$1).isBaby();
    }

    protected static void pickUpItem(Piglin p_34844_, ItemEntity p_34845_) {
        boolean $$4;
        ItemStack $$3;
        PiglinAi.stopWalking(p_34844_);
        if (p_34845_.getItem().is(Items.GOLD_NUGGET)) {
            p_34844_.take(p_34845_, p_34845_.getItem().getCount());
            ItemStack $$2 = p_34845_.getItem();
            p_34845_.discard();
        } else {
            p_34844_.take(p_34845_, 1);
            $$3 = PiglinAi.removeOneItemFromItemEntity(p_34845_);
        }
        if (PiglinAi.isLovedItem($$3)) {
            p_34844_.getBrain().eraseMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
            PiglinAi.holdInOffhand(p_34844_, $$3);
            PiglinAi.admireGoldItem(p_34844_);
            return;
        }
        if (PiglinAi.isFood($$3) && !PiglinAi.hasEatenRecently(p_34844_)) {
            PiglinAi.eat(p_34844_);
            return;
        }
        boolean bl = $$4 = !p_34844_.equipItemIfPossible($$3).equals(ItemStack.EMPTY);
        if ($$4) {
            return;
        }
        PiglinAi.putInInventory(p_34844_, $$3);
    }

    private static void holdInOffhand(Piglin p_34933_, ItemStack p_34934_) {
        if (PiglinAi.isHoldingItemInOffHand(p_34933_)) {
            p_34933_.spawnAtLocation(p_34933_.getItemInHand(InteractionHand.OFF_HAND));
        }
        p_34933_.holdInOffHand(p_34934_);
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity p_34823_) {
        ItemStack $$1 = p_34823_.getItem();
        ItemStack $$2 = $$1.split(1);
        if ($$1.isEmpty()) {
            p_34823_.discard();
        } else {
            p_34823_.setItem($$1);
        }
        return $$2;
    }

    protected static void stopHoldingOffHandItem(Piglin p_34868_, boolean p_34869_) {
        ItemStack $$2 = p_34868_.getItemInHand(InteractionHand.OFF_HAND);
        p_34868_.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        if (p_34868_.isAdult()) {
            boolean $$3 = PiglinAi.isBarterCurrency($$2);
            if (p_34869_ && $$3) {
                PiglinAi.throwItems(p_34868_, PiglinAi.getBarterResponseItems(p_34868_));
            } else if (!$$3) {
                boolean $$4;
                boolean bl = $$4 = !p_34868_.equipItemIfPossible($$2).isEmpty();
                if (!$$4) {
                    PiglinAi.putInInventory(p_34868_, $$2);
                }
            }
        } else {
            boolean $$5;
            boolean bl = $$5 = !p_34868_.equipItemIfPossible($$2).isEmpty();
            if (!$$5) {
                ItemStack $$6 = p_34868_.getMainHandItem();
                if (PiglinAi.isLovedItem($$6)) {
                    PiglinAi.putInInventory(p_34868_, $$6);
                } else {
                    PiglinAi.throwItems(p_34868_, Collections.singletonList($$6));
                }
                p_34868_.holdInMainHand($$2);
            }
        }
    }

    protected static void cancelAdmiring(Piglin p_34928_) {
        if (PiglinAi.isAdmiringItem(p_34928_) && !p_34928_.getOffhandItem().isEmpty()) {
            p_34928_.spawnAtLocation(p_34928_.getOffhandItem());
            p_34928_.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        }
    }

    private static void putInInventory(Piglin p_34953_, ItemStack p_34954_) {
        ItemStack $$2 = p_34953_.addToInventory(p_34954_);
        PiglinAi.throwItemsTowardRandomPos(p_34953_, Collections.singletonList($$2));
    }

    private static void throwItems(Piglin p_34861_, List<ItemStack> p_34862_) {
        Optional<Player> $$2 = p_34861_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
        if ($$2.isPresent()) {
            PiglinAi.throwItemsTowardPlayer(p_34861_, $$2.get(), p_34862_);
        } else {
            PiglinAi.throwItemsTowardRandomPos(p_34861_, p_34862_);
        }
    }

    private static void throwItemsTowardRandomPos(Piglin p_34913_, List<ItemStack> p_34914_) {
        PiglinAi.throwItemsTowardPos(p_34913_, p_34914_, PiglinAi.getRandomNearbyPos(p_34913_));
    }

    private static void throwItemsTowardPlayer(Piglin p_34851_, Player p_34852_, List<ItemStack> p_34853_) {
        PiglinAi.throwItemsTowardPos(p_34851_, p_34853_, p_34852_.position());
    }

    private static void throwItemsTowardPos(Piglin p_34864_, List<ItemStack> p_34865_, Vec3 p_34866_) {
        if (!p_34865_.isEmpty()) {
            p_34864_.swing(InteractionHand.OFF_HAND);
            for (ItemStack $$3 : p_34865_) {
                BehaviorUtils.throwItem(p_34864_, $$3, p_34866_.add(0.0, 1.0, 0.0));
            }
        }
    }

    private static List<ItemStack> getBarterResponseItems(Piglin p_34997_) {
        LootTable $$1 = p_34997_.level().getServer().reloadableRegistries().getLootTable(BuiltInLootTables.PIGLIN_BARTERING);
        ObjectArrayList<ItemStack> $$2 = $$1.getRandomItems(new LootParams.Builder((ServerLevel)p_34997_.level()).withParameter(LootContextParams.THIS_ENTITY, p_34997_).create(LootContextParamSets.PIGLIN_BARTER));
        return $$2;
    }

    private static boolean wantsToDance(LivingEntity p_34811_, LivingEntity p_34812_) {
        if (p_34812_.getType() != EntityType.HOGLIN) {
            return false;
        }
        return RandomSource.create(p_34811_.level().getGameTime()).nextFloat() < 0.1f;
    }

    protected static boolean wantsToPickup(Piglin p_34858_, ItemStack p_34859_) {
        if (p_34858_.isBaby() && p_34859_.is(ItemTags.IGNORED_BY_PIGLIN_BABIES)) {
            return false;
        }
        if (p_34859_.is(ItemTags.PIGLIN_REPELLENTS)) {
            return false;
        }
        if (PiglinAi.isAdmiringDisabled(p_34858_) && p_34858_.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return false;
        }
        if (PiglinAi.isBarterCurrency(p_34859_)) {
            return PiglinAi.isNotHoldingLovedItemInOffHand(p_34858_);
        }
        boolean $$2 = p_34858_.canAddToInventory(p_34859_);
        if (p_34859_.is(Items.GOLD_NUGGET)) {
            return $$2;
        }
        if (PiglinAi.isFood(p_34859_)) {
            return !PiglinAi.hasEatenRecently(p_34858_) && $$2;
        }
        if (PiglinAi.isLovedItem(p_34859_)) {
            return PiglinAi.isNotHoldingLovedItemInOffHand(p_34858_) && $$2;
        }
        return p_34858_.canReplaceCurrentItem(p_34859_);
    }

    protected static boolean isLovedItem(ItemStack p_149966_) {
        return p_149966_.is(ItemTags.PIGLIN_LOVED);
    }

    private static boolean wantsToStopRiding(Piglin p_34835_, Entity p_34836_) {
        if (p_34836_ instanceof Mob) {
            Mob $$2 = (Mob)p_34836_;
            return !$$2.isBaby() || !$$2.isAlive() || PiglinAi.wasHurtRecently(p_34835_) || PiglinAi.wasHurtRecently($$2) || $$2 instanceof Piglin && $$2.getVehicle() == null;
        }
        return false;
    }

    private static boolean isNearestValidAttackTarget(Piglin p_34901_, LivingEntity p_34902_) {
        return PiglinAi.findNearestValidAttackTarget(p_34901_).filter(p_34887_ -> p_34887_ == p_34902_).isPresent();
    }

    private static boolean isNearZombified(Piglin p_34999_) {
        Brain<Piglin> $$1 = p_34999_.getBrain();
        if ($$1.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED)) {
            LivingEntity $$2 = $$1.getMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED).get();
            return p_34999_.closerThan($$2, 6.0);
        }
        return false;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Piglin p_35001_) {
        Optional<Player> $$3;
        Brain<Piglin> $$1 = p_35001_.getBrain();
        if (PiglinAi.isNearZombified(p_35001_)) {
            return Optional.empty();
        }
        Optional<LivingEntity> $$2 = BehaviorUtils.getLivingEntityFromUUIDMemory(p_35001_, MemoryModuleType.ANGRY_AT);
        if ($$2.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight(p_35001_, $$2.get())) {
            return $$2;
        }
        if ($$1.hasMemoryValue(MemoryModuleType.UNIVERSAL_ANGER) && ($$3 = $$1.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)).isPresent()) {
            return $$3;
        }
        Optional<Mob> $$4 = $$1.getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
        if ($$4.isPresent()) {
            return $$4;
        }
        Optional<Player> $$5 = $$1.getMemory(MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD);
        if ($$5.isPresent() && Sensor.isEntityAttackable(p_35001_, $$5.get())) {
            return $$5;
        }
        return Optional.empty();
    }

    public static void angerNearbyPiglins(Player p_34874_, boolean p_34875_) {
        List<Piglin> $$2 = p_34874_.level().getEntitiesOfClass(Piglin.class, p_34874_.getBoundingBox().inflate(16.0));
        $$2.stream().filter(PiglinAi::isIdle).filter(p_34881_ -> !p_34875_ || BehaviorUtils.canSee(p_34881_, p_34874_)).forEach(p_337859_ -> {
            if (p_337859_.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                PiglinAi.setAngerTargetToNearestTargetablePlayerIfFound(p_337859_, p_34874_);
            } else {
                PiglinAi.setAngerTarget(p_337859_, p_34874_);
            }
        });
    }

    public static InteractionResult mobInteract(Piglin p_34847_, Player p_34848_, InteractionHand p_34849_) {
        ItemStack $$3 = p_34848_.getItemInHand(p_34849_);
        if (PiglinAi.canAdmire(p_34847_, $$3)) {
            ItemStack $$4 = $$3.split(1);
            PiglinAi.holdInOffhand(p_34847_, $$4);
            PiglinAi.admireGoldItem(p_34847_);
            PiglinAi.stopWalking(p_34847_);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected static boolean canAdmire(Piglin p_34910_, ItemStack p_34911_) {
        return !PiglinAi.isAdmiringDisabled(p_34910_) && !PiglinAi.isAdmiringItem(p_34910_) && p_34910_.isAdult() && PiglinAi.isBarterCurrency(p_34911_);
    }

    protected static void wasHurtBy(Piglin p_34838_, LivingEntity p_34839_) {
        if (p_34839_ instanceof Piglin) {
            return;
        }
        if (PiglinAi.isHoldingItemInOffHand(p_34838_)) {
            PiglinAi.stopHoldingOffHandItem(p_34838_, false);
        }
        Brain<Piglin> $$2 = p_34838_.getBrain();
        $$2.eraseMemory(MemoryModuleType.CELEBRATE_LOCATION);
        $$2.eraseMemory(MemoryModuleType.DANCING);
        $$2.eraseMemory(MemoryModuleType.ADMIRING_ITEM);
        if (p_34839_ instanceof Player) {
            $$2.setMemoryWithExpiry(MemoryModuleType.ADMIRING_DISABLED, true, 400L);
        }
        PiglinAi.getAvoidTarget(p_34838_).ifPresent(p_337862_ -> {
            if (p_337862_.getType() != p_34839_.getType()) {
                $$2.eraseMemory(MemoryModuleType.AVOID_TARGET);
            }
        });
        if (p_34838_.isBaby()) {
            $$2.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, p_34839_, 100L);
            if (Sensor.isEntityAttackableIgnoringLineOfSight(p_34838_, p_34839_)) {
                PiglinAi.broadcastAngerTarget(p_34838_, p_34839_);
            }
            return;
        }
        if (p_34839_.getType() == EntityType.HOGLIN && PiglinAi.hoglinsOutnumberPiglins(p_34838_)) {
            PiglinAi.setAvoidTargetAndDontHuntForAWhile(p_34838_, p_34839_);
            PiglinAi.broadcastRetreat(p_34838_, p_34839_);
            return;
        }
        PiglinAi.maybeRetaliate(p_34838_, p_34839_);
    }

    protected static void maybeRetaliate(AbstractPiglin p_34827_, LivingEntity p_34828_) {
        if (p_34827_.getBrain().isActive(Activity.AVOID)) {
            return;
        }
        if (!Sensor.isEntityAttackableIgnoringLineOfSight(p_34827_, p_34828_)) {
            return;
        }
        if (BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(p_34827_, p_34828_, 4.0)) {
            return;
        }
        if (p_34828_.getType() == EntityType.PLAYER && p_34827_.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
            PiglinAi.setAngerTargetToNearestTargetablePlayerIfFound(p_34827_, p_34828_);
            PiglinAi.broadcastUniversalAnger(p_34827_);
        } else {
            PiglinAi.setAngerTarget(p_34827_, p_34828_);
            PiglinAi.broadcastAngerTarget(p_34827_, p_34828_);
        }
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(Piglin p_34948_) {
        return p_34948_.getBrain().getActiveNonCoreActivity().map(p_34908_ -> PiglinAi.getSoundForActivity(p_34948_, p_34908_));
    }

    private static SoundEvent getSoundForActivity(Piglin p_34855_, Activity p_34856_) {
        if (p_34856_ == Activity.FIGHT) {
            return SoundEvents.PIGLIN_ANGRY;
        }
        if (p_34855_.isConverting()) {
            return SoundEvents.PIGLIN_RETREAT;
        }
        if (p_34856_ == Activity.AVOID && PiglinAi.isNearAvoidTarget(p_34855_)) {
            return SoundEvents.PIGLIN_RETREAT;
        }
        if (p_34856_ == Activity.ADMIRE_ITEM) {
            return SoundEvents.PIGLIN_ADMIRING_ITEM;
        }
        if (p_34856_ == Activity.CELEBRATE) {
            return SoundEvents.PIGLIN_CELEBRATE;
        }
        if (PiglinAi.seesPlayerHoldingLovedItem(p_34855_)) {
            return SoundEvents.PIGLIN_JEALOUS;
        }
        if (PiglinAi.isNearRepellent(p_34855_)) {
            return SoundEvents.PIGLIN_RETREAT;
        }
        return SoundEvents.PIGLIN_AMBIENT;
    }

    private static boolean isNearAvoidTarget(Piglin p_35003_) {
        Brain<Piglin> $$1 = p_35003_.getBrain();
        if (!$$1.hasMemoryValue(MemoryModuleType.AVOID_TARGET)) {
            return false;
        }
        return $$1.getMemory(MemoryModuleType.AVOID_TARGET).get().closerThan(p_35003_, 12.0);
    }

    protected static List<AbstractPiglin> getVisibleAdultPiglins(Piglin p_35005_) {
        return p_35005_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS).orElse((List<AbstractPiglin>)ImmutableList.of());
    }

    private static List<AbstractPiglin> getAdultPiglins(AbstractPiglin p_34961_) {
        return p_34961_.getBrain().getMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS).orElse((List<AbstractPiglin>)ImmutableList.of());
    }

    public static boolean isWearingGold(LivingEntity p_34809_) {
        Iterable<ItemStack> $$1 = p_34809_.getArmorAndBodyArmorSlots();
        for (ItemStack $$2 : $$1) {
            Item $$3 = $$2.getItem();
            if (!($$3 instanceof ArmorItem) || !((ArmorItem)$$3).getMaterial().is(ArmorMaterials.GOLD)) continue;
            return true;
        }
        return false;
    }

    private static void stopWalking(Piglin p_35007_) {
        p_35007_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_35007_.getNavigation().stop();
    }

    private static BehaviorControl<LivingEntity> babySometimesRideBabyHoglin() {
        SetEntityLookTargetSometimes.Ticker $$0 = new SetEntityLookTargetSometimes.Ticker(RIDE_START_INTERVAL);
        return CopyMemoryWithExpiry.create(p_337855_ -> p_337855_.isBaby() && $$0.tickDownAndCheck(p_337855_.level().random), MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.RIDE_TARGET, RIDE_DURATION);
    }

    protected static void broadcastAngerTarget(AbstractPiglin p_34896_, LivingEntity p_34897_) {
        PiglinAi.getAdultPiglins(p_34896_).forEach(p_337857_ -> {
            if (!(p_34897_.getType() != EntityType.HOGLIN || p_337857_.canHunt() && ((Hoglin)p_34897_).canBeHunted())) {
                return;
            }
            PiglinAi.setAngerTargetIfCloserThanCurrent(p_337857_, p_34897_);
        });
    }

    protected static void broadcastUniversalAnger(AbstractPiglin p_34825_) {
        PiglinAi.getAdultPiglins(p_34825_).forEach(p_34991_ -> PiglinAi.getNearestVisibleTargetablePlayer(p_34991_).ifPresent(p_149964_ -> PiglinAi.setAngerTarget(p_34991_, p_149964_)));
    }

    protected static void setAngerTarget(AbstractPiglin p_34925_, LivingEntity p_34926_) {
        if (!Sensor.isEntityAttackableIgnoringLineOfSight(p_34925_, p_34926_)) {
            return;
        }
        p_34925_.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        p_34925_.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, p_34926_.getUUID(), 600L);
        if (p_34926_.getType() == EntityType.HOGLIN && p_34925_.canHunt()) {
            PiglinAi.dontKillAnyMoreHoglinsForAWhile(p_34925_);
        }
        if (p_34926_.getType() == EntityType.PLAYER && p_34925_.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
            p_34925_.getBrain().setMemoryWithExpiry(MemoryModuleType.UNIVERSAL_ANGER, true, 600L);
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(AbstractPiglin p_34945_, LivingEntity p_34946_) {
        Optional<Player> $$2 = PiglinAi.getNearestVisibleTargetablePlayer(p_34945_);
        if ($$2.isPresent()) {
            PiglinAi.setAngerTarget(p_34945_, $$2.get());
        } else {
            PiglinAi.setAngerTarget(p_34945_, p_34946_);
        }
    }

    private static void setAngerTargetIfCloserThanCurrent(AbstractPiglin p_34963_, LivingEntity p_34964_) {
        Optional<LivingEntity> $$2 = PiglinAi.getAngerTarget(p_34963_);
        LivingEntity $$3 = BehaviorUtils.getNearestTarget(p_34963_, $$2, p_34964_);
        if ($$2.isPresent() && $$2.get() == $$3) {
            return;
        }
        PiglinAi.setAngerTarget(p_34963_, $$3);
    }

    private static Optional<LivingEntity> getAngerTarget(AbstractPiglin p_34976_) {
        return BehaviorUtils.getLivingEntityFromUUIDMemory(p_34976_, MemoryModuleType.ANGRY_AT);
    }

    public static Optional<LivingEntity> getAvoidTarget(Piglin p_34987_) {
        if (p_34987_.getBrain().hasMemoryValue(MemoryModuleType.AVOID_TARGET)) {
            return p_34987_.getBrain().getMemory(MemoryModuleType.AVOID_TARGET);
        }
        return Optional.empty();
    }

    public static Optional<Player> getNearestVisibleTargetablePlayer(AbstractPiglin p_34894_) {
        if (p_34894_.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)) {
            return p_34894_.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
        }
        return Optional.empty();
    }

    private static void broadcastRetreat(Piglin p_34930_, LivingEntity p_34931_) {
        PiglinAi.getVisibleAdultPiglins(p_34930_).stream().filter(p_34985_ -> p_34985_ instanceof Piglin).forEach(p_34819_ -> PiglinAi.retreatFromNearestTarget((Piglin)p_34819_, p_34931_));
    }

    private static void retreatFromNearestTarget(Piglin p_34950_, LivingEntity p_34951_) {
        Brain<Piglin> $$2 = p_34950_.getBrain();
        LivingEntity $$3 = p_34951_;
        $$3 = BehaviorUtils.getNearestTarget(p_34950_, $$2.getMemory(MemoryModuleType.AVOID_TARGET), $$3);
        $$3 = BehaviorUtils.getNearestTarget(p_34950_, $$2.getMemory(MemoryModuleType.ATTACK_TARGET), $$3);
        PiglinAi.setAvoidTargetAndDontHuntForAWhile(p_34950_, $$3);
    }

    private static boolean wantsToStopFleeing(Piglin p_35009_) {
        Brain<Piglin> $$1 = p_35009_.getBrain();
        if (!$$1.hasMemoryValue(MemoryModuleType.AVOID_TARGET)) {
            return true;
        }
        LivingEntity $$2 = $$1.getMemory(MemoryModuleType.AVOID_TARGET).get();
        EntityType<?> $$3 = $$2.getType();
        if ($$3 == EntityType.HOGLIN) {
            return PiglinAi.piglinsEqualOrOutnumberHoglins(p_35009_);
        }
        if (PiglinAi.isZombified($$3)) {
            return !$$1.isMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, $$2);
        }
        return false;
    }

    private static boolean piglinsEqualOrOutnumberHoglins(Piglin p_35011_) {
        return !PiglinAi.hoglinsOutnumberPiglins(p_35011_);
    }

    private static boolean hoglinsOutnumberPiglins(Piglin p_35013_) {
        int $$1 = p_35013_.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT).orElse(0) + 1;
        int $$2 = p_35013_.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT).orElse(0);
        return $$2 > $$1;
    }

    private static void setAvoidTargetAndDontHuntForAWhile(Piglin p_34968_, LivingEntity p_34969_) {
        p_34968_.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
        p_34968_.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        p_34968_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        p_34968_.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, p_34969_, RETREAT_DURATION.sample(p_34968_.level().random));
        PiglinAi.dontKillAnyMoreHoglinsForAWhile(p_34968_);
    }

    protected static void dontKillAnyMoreHoglinsForAWhile(AbstractPiglin p_34923_) {
        p_34923_.getBrain().setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, true, TIME_BETWEEN_HUNTS.sample(p_34923_.level().random));
    }

    private static void eat(Piglin p_35015_) {
        p_35015_.getBrain().setMemoryWithExpiry(MemoryModuleType.ATE_RECENTLY, true, 200L);
    }

    private static Vec3 getRandomNearbyPos(Piglin p_35017_) {
        Vec3 $$1 = LandRandomPos.getPos(p_35017_, 4, 2);
        return $$1 == null ? p_35017_.position() : $$1;
    }

    private static boolean hasEatenRecently(Piglin p_35019_) {
        return p_35019_.getBrain().hasMemoryValue(MemoryModuleType.ATE_RECENTLY);
    }

    protected static boolean isIdle(AbstractPiglin p_34943_) {
        return p_34943_.getBrain().isActive(Activity.IDLE);
    }

    private static boolean hasCrossbow(LivingEntity p_34919_) {
        return p_34919_.isHolding(Items.CROSSBOW);
    }

    private static void admireGoldItem(LivingEntity p_34939_) {
        p_34939_.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, true, 119L);
    }

    private static boolean isAdmiringItem(Piglin p_35021_) {
        return p_35021_.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_ITEM);
    }

    private static boolean isBarterCurrency(ItemStack p_149968_) {
        return p_149968_.is(BARTERING_ITEM);
    }

    private static boolean isFood(ItemStack p_149970_) {
        return p_149970_.is(ItemTags.PIGLIN_FOOD);
    }

    private static boolean isNearRepellent(Piglin p_35023_) {
        return p_35023_.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    private static boolean seesPlayerHoldingLovedItem(LivingEntity p_34972_) {
        return p_34972_.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM);
    }

    private static boolean doesntSeeAnyPlayerHoldingLovedItem(LivingEntity p_34983_) {
        return !PiglinAi.seesPlayerHoldingLovedItem(p_34983_);
    }

    public static boolean isPlayerHoldingLovedItem(LivingEntity p_34884_) {
        return p_34884_.getType() == EntityType.PLAYER && p_34884_.isHolding(PiglinAi::isLovedItem);
    }

    private static boolean isAdmiringDisabled(Piglin p_35025_) {
        return p_35025_.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_DISABLED);
    }

    private static boolean wasHurtRecently(LivingEntity p_34989_) {
        return p_34989_.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }

    private static boolean isHoldingItemInOffHand(Piglin p_35027_) {
        return !p_35027_.getOffhandItem().isEmpty();
    }

    private static boolean isNotHoldingLovedItemInOffHand(Piglin p_35029_) {
        return p_35029_.getOffhandItem().isEmpty() || !PiglinAi.isLovedItem(p_35029_.getOffhandItem());
    }

    public static boolean isZombified(EntityType<?> p_34807_) {
        return p_34807_ == EntityType.ZOMBIFIED_PIGLIN || p_34807_ == EntityType.ZOGLIN;
    }
}

