/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.VillagerGoalPackages;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class Villager
extends AbstractVillager
implements ReputationEventHandler,
VillagerDataHolder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA = SynchedEntityData.defineId(Villager.class, EntityDataSerializers.VILLAGER_DATA);
    public static final int BREEDING_FOOD_THRESHOLD = 12;
    public static final Map<Item, Integer> FOOD_POINTS = ImmutableMap.of((Object)Items.BREAD, (Object)4, (Object)Items.POTATO, (Object)1, (Object)Items.CARROT, (Object)1, (Object)Items.BEETROOT, (Object)1);
    private static final int TRADES_PER_LEVEL = 2;
    private static final Set<Item> WANTED_ITEMS = ImmutableSet.of((Object)Items.BREAD, (Object)Items.POTATO, (Object)Items.CARROT, (Object)Items.WHEAT, (Object)Items.WHEAT_SEEDS, (Object)Items.BEETROOT, (Object[])new Item[]{Items.BEETROOT_SEEDS, Items.TORCHFLOWER_SEEDS, Items.PITCHER_POD});
    private static final int MAX_GOSSIP_TOPICS = 10;
    private static final int GOSSIP_COOLDOWN = 1200;
    private static final int GOSSIP_DECAY_INTERVAL = 24000;
    private static final int REPUTATION_CHANGE_PER_EVENT = 25;
    private static final int HOW_FAR_AWAY_TO_TALK_TO_OTHER_VILLAGERS_ABOUT_GOLEMS = 10;
    private static final int HOW_MANY_VILLAGERS_NEED_TO_AGREE_TO_SPAWN_A_GOLEM = 5;
    private static final long TIME_SINCE_SLEEPING_FOR_GOLEM_SPAWNING = 24000L;
    @VisibleForTesting
    public static final float SPEED_MODIFIER = 0.5f;
    private int updateMerchantTimer;
    private boolean increaseProfessionLevelOnUpdate;
    @Nullable
    private Player lastTradedPlayer;
    private boolean chasing;
    private int foodLevel;
    private final GossipContainer gossips = new GossipContainer();
    private long lastGossipTime;
    private long lastGossipDecayTime;
    private int villagerXp;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;
    private boolean assignProfessionWhenSpawned;
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.HOME, MemoryModuleType.JOB_SITE, MemoryModuleType.POTENTIAL_JOB_SITE, MemoryModuleType.MEETING_POINT, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.VISIBLE_VILLAGER_BABIES, MemoryModuleType.NEAREST_PLAYERS, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object[])new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.BREED_TARGET, MemoryModuleType.PATH, MemoryModuleType.DOORS_TO_CLOSE, MemoryModuleType.NEAREST_BED, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_HOSTILE, MemoryModuleType.SECONDARY_JOB_SITE, MemoryModuleType.HIDING_PLACE, MemoryModuleType.HEARD_BELL_TIME, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.LAST_SLEPT, MemoryModuleType.LAST_WOKEN, MemoryModuleType.LAST_WORKED_AT_POI, MemoryModuleType.GOLEM_DETECTED_RECENTLY});
    private static final ImmutableList<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ITEMS, SensorType.NEAREST_BED, SensorType.HURT_BY, SensorType.VILLAGER_HOSTILES, SensorType.VILLAGER_BABIES, SensorType.SECONDARY_POIS, SensorType.GOLEM_DETECTED);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<Villager, Holder<PoiType>>> POI_MEMORIES = ImmutableMap.of(MemoryModuleType.HOME, (p_219625_, p_219626_) -> p_219626_.is(PoiTypes.HOME), MemoryModuleType.JOB_SITE, (p_219622_, p_219623_) -> p_219622_.getVillagerData().getProfession().heldJobSite().test((Holder<PoiType>)p_219623_), MemoryModuleType.POTENTIAL_JOB_SITE, (p_219619_, p_219620_) -> VillagerProfession.ALL_ACQUIRABLE_JOBS.test((Holder<PoiType>)p_219620_), MemoryModuleType.MEETING_POINT, (p_219616_, p_219617_) -> p_219617_.is(PoiTypes.MEETING));

    public Villager(EntityType<? extends Villager> p_35381_, Level p_35382_) {
        this(p_35381_, p_35382_, VillagerType.PLAINS);
    }

    public Villager(EntityType<? extends Villager> p_35384_, Level p_35385_, VillagerType p_35386_) {
        super((EntityType<? extends AbstractVillager>)p_35384_, p_35385_);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.getNavigation().setCanFloat(true);
        this.setCanPickUpLoot(true);
        this.setVillagerData(this.getVillagerData().setType(p_35386_).setProfession(VillagerProfession.NONE));
    }

    public Brain<Villager> getBrain() {
        return super.getBrain();
    }

    protected Brain.Provider<Villager> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> p_35445_) {
        Brain<Villager> $$1 = this.brainProvider().makeBrain(p_35445_);
        this.registerBrainGoals($$1);
        return $$1;
    }

    public void refreshBrain(ServerLevel p_35484_) {
        Brain<Villager> $$1 = this.getBrain();
        $$1.stopAll(p_35484_, this);
        this.brain = $$1.copyWithoutBehaviors();
        this.registerBrainGoals(this.getBrain());
    }

    private void registerBrainGoals(Brain<Villager> p_35425_) {
        VillagerProfession $$1 = this.getVillagerData().getProfession();
        if (this.isBaby()) {
            p_35425_.setSchedule(Schedule.VILLAGER_BABY);
            p_35425_.addActivity(Activity.PLAY, VillagerGoalPackages.getPlayPackage(0.5f));
        } else {
            p_35425_.setSchedule(Schedule.VILLAGER_DEFAULT);
            p_35425_.addActivityWithConditions(Activity.WORK, (ImmutableList<Pair<Integer, BehaviorControl<Villager>>>)VillagerGoalPackages.getWorkPackage($$1, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT))));
        }
        p_35425_.addActivity(Activity.CORE, VillagerGoalPackages.getCorePackage($$1, 0.5f));
        p_35425_.addActivityWithConditions(Activity.MEET, (ImmutableList<Pair<Integer, BehaviorControl<Villager>>>)VillagerGoalPackages.getMeetPackage($$1, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.MEETING_POINT, (Object)((Object)MemoryStatus.VALUE_PRESENT))));
        p_35425_.addActivity(Activity.REST, VillagerGoalPackages.getRestPackage($$1, 0.5f));
        p_35425_.addActivity(Activity.IDLE, VillagerGoalPackages.getIdlePackage($$1, 0.5f));
        p_35425_.addActivity(Activity.PANIC, VillagerGoalPackages.getPanicPackage($$1, 0.5f));
        p_35425_.addActivity(Activity.PRE_RAID, VillagerGoalPackages.getPreRaidPackage($$1, 0.5f));
        p_35425_.addActivity(Activity.RAID, VillagerGoalPackages.getRaidPackage($$1, 0.5f));
        p_35425_.addActivity(Activity.HIDE, VillagerGoalPackages.getHidePackage($$1, 0.5f));
        p_35425_.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        p_35425_.setDefaultActivity(Activity.IDLE);
        p_35425_.setActiveActivityIfPossible(Activity.IDLE);
        p_35425_.updateActivityFromSchedule(this.level().getDayTime(), this.level().getGameTime());
    }

    @Override
    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (this.level() instanceof ServerLevel) {
            this.refreshBrain((ServerLevel)this.level());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public boolean assignProfessionWhenSpawned() {
        return this.assignProfessionWhenSpawned;
    }

    @Override
    protected void customServerAiStep() {
        Raid $$0;
        this.level().getProfiler().push("villagerBrain");
        this.getBrain().tick((ServerLevel)this.level(), this);
        this.level().getProfiler().pop();
        if (this.assignProfessionWhenSpawned) {
            this.assignProfessionWhenSpawned = false;
        }
        if (!this.isTrading() && this.updateMerchantTimer > 0) {
            --this.updateMerchantTimer;
            if (this.updateMerchantTimer <= 0) {
                if (this.increaseProfessionLevelOnUpdate) {
                    this.increaseMerchantCareer();
                    this.increaseProfessionLevelOnUpdate = false;
                }
                this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0));
            }
        }
        if (this.lastTradedPlayer != null && this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).onReputationEvent(ReputationEventType.TRADE, this.lastTradedPlayer, this);
            this.level().broadcastEntityEvent(this, (byte)14);
            this.lastTradedPlayer = null;
        }
        if (!this.isNoAi() && this.random.nextInt(100) == 0 && ($$0 = ((ServerLevel)this.level()).getRaidAt(this.blockPosition())) != null && $$0.isActive() && !$$0.isOver()) {
            this.level().broadcastEntityEvent(this, (byte)42);
        }
        if (this.getVillagerData().getProfession() == VillagerProfession.NONE && this.isTrading()) {
            this.stopTrading();
        }
        super.customServerAiStep();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getUnhappyCounter() > 0) {
            this.setUnhappyCounter(this.getUnhappyCounter() - 1);
        }
        this.maybeDecayGossip();
    }

    @Override
    public InteractionResult mobInteract(Player p_35472_, InteractionHand p_35473_) {
        ItemStack $$2 = p_35472_.getItemInHand(p_35473_);
        if (!$$2.is(Items.VILLAGER_SPAWN_EGG) && this.isAlive() && !this.isTrading() && !this.isSleeping()) {
            if (this.isBaby()) {
                this.setUnhappy();
                return InteractionResult.sidedSuccess(this.level().isClientSide);
            }
            boolean $$3 = this.getOffers().isEmpty();
            if (p_35473_ == InteractionHand.MAIN_HAND) {
                if ($$3 && !this.level().isClientSide) {
                    this.setUnhappy();
                }
                p_35472_.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if ($$3) {
                return InteractionResult.sidedSuccess(this.level().isClientSide);
            }
            if (!this.level().isClientSide && !this.offers.isEmpty()) {
                this.startTrading(p_35472_);
            }
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        return super.mobInteract(p_35472_, p_35473_);
    }

    private void setUnhappy() {
        this.setUnhappyCounter(40);
        if (!this.level().isClientSide()) {
            this.makeSound(SoundEvents.VILLAGER_NO);
        }
    }

    private void startTrading(Player p_35537_) {
        this.updateSpecialPrices(p_35537_);
        this.setTradingPlayer(p_35537_);
        this.openTradingScreen(p_35537_, this.getDisplayName(), this.getVillagerData().getLevel());
    }

    @Override
    public void setTradingPlayer(@Nullable Player p_35508_) {
        boolean $$1 = this.getTradingPlayer() != null && p_35508_ == null;
        super.setTradingPlayer(p_35508_);
        if ($$1) {
            this.stopTrading();
        }
    }

    @Override
    protected void stopTrading() {
        super.stopTrading();
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        for (MerchantOffer $$0 : this.getOffers()) {
            $$0.resetSpecialPriceDiff();
        }
    }

    @Override
    public boolean canRestock() {
        return true;
    }

    @Override
    public boolean isClientSide() {
        return this.level().isClientSide;
    }

    public void restock() {
        this.updateDemand();
        for (MerchantOffer $$0 : this.getOffers()) {
            $$0.resetUses();
        }
        this.resendOffersToTradingPlayer();
        this.lastRestockGameTime = this.level().getGameTime();
        ++this.numberOfRestocksToday;
    }

    private void resendOffersToTradingPlayer() {
        MerchantOffers $$0 = this.getOffers();
        Player $$1 = this.getTradingPlayer();
        if ($$1 != null && !$$0.isEmpty()) {
            $$1.sendMerchantOffers($$1.containerMenu.containerId, $$0, this.getVillagerData().getLevel(), this.getVillagerXp(), this.showProgressBar(), this.canRestock());
        }
    }

    private boolean needsToRestock() {
        for (MerchantOffer $$0 : this.getOffers()) {
            if (!$$0.needsRestock()) continue;
            return true;
        }
        return false;
    }

    private boolean allowedToRestock() {
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < 2 && this.level().getGameTime() > this.lastRestockGameTime + 2400L;
    }

    public boolean shouldRestock() {
        long $$0 = this.lastRestockGameTime + 12000L;
        long $$1 = this.level().getGameTime();
        boolean $$2 = $$1 > $$0;
        long $$3 = this.level().getDayTime();
        if (this.lastRestockCheckDayTime > 0L) {
            long $$5 = $$3 / 24000L;
            long $$4 = this.lastRestockCheckDayTime / 24000L;
            $$2 |= $$5 > $$4;
        }
        this.lastRestockCheckDayTime = $$3;
        if ($$2) {
            this.lastRestockGameTime = $$1;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void catchUpDemand() {
        int $$0 = 2 - this.numberOfRestocksToday;
        if ($$0 > 0) {
            for (MerchantOffer $$1 : this.getOffers()) {
                $$1.resetUses();
            }
        }
        for (int $$2 = 0; $$2 < $$0; ++$$2) {
            this.updateDemand();
        }
        this.resendOffersToTradingPlayer();
    }

    private void updateDemand() {
        for (MerchantOffer $$0 : this.getOffers()) {
            $$0.updateDemand();
        }
    }

    private void updateSpecialPrices(Player p_35541_) {
        int $$1 = this.getPlayerReputation(p_35541_);
        if ($$1 != 0) {
            for (MerchantOffer $$2 : this.getOffers()) {
                $$2.addToSpecialPriceDiff(-Mth.floor((float)$$1 * $$2.getPriceMultiplier()));
            }
        }
        if (p_35541_.hasEffect(MobEffects.HERO_OF_THE_VILLAGE)) {
            MobEffectInstance $$3 = p_35541_.getEffect(MobEffects.HERO_OF_THE_VILLAGE);
            int $$4 = $$3.getAmplifier();
            for (MerchantOffer $$5 : this.getOffers()) {
                double $$6 = 0.3 + 0.0625 * (double)$$4;
                int $$7 = (int)Math.floor($$6 * (double)$$5.getBaseCostA().getCount());
                $$5.addToSpecialPriceDiff(-Math.max($$7, 1));
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326013_) {
        super.defineSynchedData(p_326013_);
        p_326013_.define(DATA_VILLAGER_DATA, new VillagerData(VillagerType.PLAINS, VillagerProfession.NONE, 1));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_35481_) {
        super.addAdditionalSaveData(p_35481_);
        VillagerData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getVillagerData()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_35454_ -> p_35481_.put("VillagerData", (Tag)p_35454_));
        p_35481_.putByte("FoodLevel", (byte)this.foodLevel);
        p_35481_.put("Gossips", this.gossips.store(NbtOps.INSTANCE));
        p_35481_.putInt("Xp", this.villagerXp);
        p_35481_.putLong("LastRestock", this.lastRestockGameTime);
        p_35481_.putLong("LastGossipDecay", this.lastGossipDecayTime);
        p_35481_.putInt("RestocksToday", this.numberOfRestocksToday);
        if (this.assignProfessionWhenSpawned) {
            p_35481_.putBoolean("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_35451_) {
        super.readAdditionalSaveData(p_35451_);
        if (p_35451_.contains("VillagerData", 10)) {
            VillagerData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_35451_.get("VillagerData")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_323354_ -> this.entityData.set(DATA_VILLAGER_DATA, p_323354_));
        }
        if (p_35451_.contains("FoodLevel", 1)) {
            this.foodLevel = p_35451_.getByte("FoodLevel");
        }
        ListTag $$1 = p_35451_.getList("Gossips", 10);
        this.gossips.update(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)$$1));
        if (p_35451_.contains("Xp", 3)) {
            this.villagerXp = p_35451_.getInt("Xp");
        }
        this.lastRestockGameTime = p_35451_.getLong("LastRestock");
        this.lastGossipDecayTime = p_35451_.getLong("LastGossipDecay");
        this.setCanPickUpLoot(true);
        if (this.level() instanceof ServerLevel) {
            this.refreshBrain((ServerLevel)this.level());
        }
        this.numberOfRestocksToday = p_35451_.getInt("RestocksToday");
        if (p_35451_.contains("AssignProfessionWhenSpawned")) {
            this.assignProfessionWhenSpawned = p_35451_.getBoolean("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean removeWhenFarAway(double p_35535_) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isSleeping()) {
            return null;
        }
        if (this.isTrading()) {
            return SoundEvents.VILLAGER_TRADE;
        }
        return SoundEvents.VILLAGER_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_35498_) {
        return SoundEvents.VILLAGER_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    public void playWorkSound() {
        this.makeSound(this.getVillagerData().getProfession().workSound());
    }

    @Override
    public void setVillagerData(VillagerData p_35437_) {
        VillagerData $$1 = this.getVillagerData();
        if ($$1.getProfession() != p_35437_.getProfession()) {
            this.offers = null;
        }
        this.entityData.set(DATA_VILLAGER_DATA, p_35437_);
    }

    @Override
    public VillagerData getVillagerData() {
        return this.entityData.get(DATA_VILLAGER_DATA);
    }

    @Override
    protected void rewardTradeXp(MerchantOffer p_35475_) {
        int $$1 = 3 + this.random.nextInt(4);
        this.villagerXp += p_35475_.getXp();
        this.lastTradedPlayer = this.getTradingPlayer();
        if (this.shouldIncreaseLevel()) {
            this.updateMerchantTimer = 40;
            this.increaseProfessionLevelOnUpdate = true;
            $$1 += 5;
        }
        if (p_35475_.shouldRewardExp()) {
            this.level().addFreshEntity(new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), $$1));
        }
    }

    public void setChasing(boolean p_150016_) {
        this.chasing = p_150016_;
    }

    public boolean isChasing() {
        return this.chasing;
    }

    @Override
    public void setLastHurtByMob(@Nullable LivingEntity p_35423_) {
        if (p_35423_ != null && this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).onReputationEvent(ReputationEventType.VILLAGER_HURT, p_35423_, this);
            if (this.isAlive() && p_35423_ instanceof Player) {
                this.level().broadcastEntityEvent(this, (byte)13);
            }
        }
        super.setLastHurtByMob(p_35423_);
    }

    @Override
    public void die(DamageSource p_35419_) {
        LOGGER.info("Villager {} died, message: '{}'", (Object)this, (Object)p_35419_.getLocalizedDeathMessage(this).getString());
        Entity $$1 = p_35419_.getEntity();
        if ($$1 != null) {
            this.tellWitnessesThatIWasMurdered($$1);
        }
        this.releaseAllPois();
        super.die(p_35419_);
    }

    private void releaseAllPois() {
        this.releasePoi(MemoryModuleType.HOME);
        this.releasePoi(MemoryModuleType.JOB_SITE);
        this.releasePoi(MemoryModuleType.POTENTIAL_JOB_SITE);
        this.releasePoi(MemoryModuleType.MEETING_POINT);
    }

    /*
     * WARNING - void declaration
     */
    private void tellWitnessesThatIWasMurdered(Entity p_35421_) {
        void $$2;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$1 = (ServerLevel)level;
        Optional<NearestVisibleLivingEntities> $$3 = this.brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        if ($$3.isEmpty()) {
            return;
        }
        $$3.get().findAll(ReputationEventHandler.class::isInstance).forEach(arg_0 -> Villager.lambda$tellWitnessesThatIWasMurdered$6((ServerLevel)$$2, p_35421_, arg_0));
    }

    public void releasePoi(MemoryModuleType<GlobalPos> p_35429_) {
        if (!(this.level() instanceof ServerLevel)) {
            return;
        }
        MinecraftServer $$1 = ((ServerLevel)this.level()).getServer();
        this.brain.getMemory(p_35429_).ifPresent(p_186306_ -> {
            ServerLevel $$3 = $$1.getLevel(p_186306_.dimension());
            if ($$3 == null) {
                return;
            }
            PoiManager $$4 = $$3.getPoiManager();
            Optional<Holder<PoiType>> $$5 = $$4.getType(p_186306_.pos());
            BiPredicate<Villager, Holder<PoiType>> $$6 = POI_MEMORIES.get(p_35429_);
            if ($$5.isPresent() && $$6.test(this, $$5.get())) {
                $$4.release(p_186306_.pos());
                DebugPackets.sendPoiTicketCountPacket($$3, p_186306_.pos());
            }
        });
    }

    @Override
    public boolean canBreed() {
        return this.foodLevel + this.countFoodPointsInInventory() >= 12 && !this.isSleeping() && this.getAge() == 0;
    }

    private boolean hungry() {
        return this.foodLevel < 12;
    }

    private void eatUntilFull() {
        if (!this.hungry() || this.countFoodPointsInInventory() == 0) {
            return;
        }
        for (int $$0 = 0; $$0 < this.getInventory().getContainerSize(); ++$$0) {
            int $$3;
            Integer $$2;
            ItemStack $$1 = this.getInventory().getItem($$0);
            if ($$1.isEmpty() || ($$2 = FOOD_POINTS.get($$1.getItem())) == null) continue;
            for (int $$4 = $$3 = $$1.getCount(); $$4 > 0; --$$4) {
                this.foodLevel += $$2.intValue();
                this.getInventory().removeItem($$0, 1);
                if (this.hungry()) continue;
                return;
            }
        }
    }

    public int getPlayerReputation(Player p_35533_) {
        return this.gossips.getReputation(p_35533_.getUUID(), p_186302_ -> true);
    }

    private void digestFood(int p_35549_) {
        this.foodLevel -= p_35549_;
    }

    public void eatAndDigestFood() {
        this.eatUntilFull();
        this.digestFood(12);
    }

    public void setOffers(MerchantOffers p_35477_) {
        this.offers = p_35477_;
    }

    private boolean shouldIncreaseLevel() {
        int $$0 = this.getVillagerData().getLevel();
        return VillagerData.canLevelUp($$0) && this.villagerXp >= VillagerData.getMaxXpPerLevel($$0);
    }

    private void increaseMerchantCareer() {
        this.setVillagerData(this.getVillagerData().setLevel(this.getVillagerData().getLevel() + 1));
        this.updateTrades();
    }

    @Override
    protected Component getTypeName() {
        return Component.translatable(this.getType().getDescriptionId() + "." + BuiltInRegistries.VILLAGER_PROFESSION.getKey(this.getVillagerData().getProfession()).getPath());
    }

    @Override
    public void handleEntityEvent(byte p_35391_) {
        if (p_35391_ == 12) {
            this.addParticlesAroundSelf(ParticleTypes.HEART);
        } else if (p_35391_ == 13) {
            this.addParticlesAroundSelf(ParticleTypes.ANGRY_VILLAGER);
        } else if (p_35391_ == 14) {
            this.addParticlesAroundSelf(ParticleTypes.HAPPY_VILLAGER);
        } else if (p_35391_ == 42) {
            this.addParticlesAroundSelf(ParticleTypes.SPLASH);
        } else {
            super.handleEntityEvent(p_35391_);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_35439_, DifficultyInstance p_35440_, MobSpawnType p_35441_, @Nullable SpawnGroupData p_35442_) {
        if (p_35441_ == MobSpawnType.BREEDING) {
            this.setVillagerData(this.getVillagerData().setProfession(VillagerProfession.NONE));
        }
        if (p_35441_ == MobSpawnType.COMMAND || p_35441_ == MobSpawnType.SPAWN_EGG || MobSpawnType.isSpawner(p_35441_) || p_35441_ == MobSpawnType.DISPENSER) {
            this.setVillagerData(this.getVillagerData().setType(VillagerType.byBiome(p_35439_.getBiome(this.blockPosition()))));
        }
        if (p_35441_ == MobSpawnType.STRUCTURE) {
            this.assignProfessionWhenSpawned = true;
        }
        return super.finalizeSpawn(p_35439_, p_35440_, p_35441_, p_35442_);
    }

    @Override
    @Nullable
    public Villager getBreedOffspring(ServerLevel p_150012_, AgeableMob p_150013_) {
        VillagerType $$5;
        double $$2 = this.random.nextDouble();
        if ($$2 < 0.5) {
            VillagerType $$3 = VillagerType.byBiome(p_150012_.getBiome(this.blockPosition()));
        } else if ($$2 < 0.75) {
            VillagerType $$4 = this.getVillagerData().getType();
        } else {
            $$5 = ((Villager)p_150013_).getVillagerData().getType();
        }
        Villager $$6 = new Villager(EntityType.VILLAGER, p_150012_, $$5);
        $$6.finalizeSpawn(p_150012_, p_150012_.getCurrentDifficultyAt($$6.blockPosition()), MobSpawnType.BREEDING, null);
        return $$6;
    }

    @Override
    public void thunderHit(ServerLevel p_35409_, LightningBolt p_35410_) {
        if (p_35409_.getDifficulty() != Difficulty.PEACEFUL) {
            LOGGER.info("Villager {} was struck by lightning {}.", (Object)this, (Object)p_35410_);
            Witch $$2 = EntityType.WITCH.create(p_35409_);
            if ($$2 != null) {
                $$2.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
                $$2.finalizeSpawn(p_35409_, p_35409_.getCurrentDifficultyAt($$2.blockPosition()), MobSpawnType.CONVERSION, null);
                $$2.setNoAi(this.isNoAi());
                if (this.hasCustomName()) {
                    $$2.setCustomName(this.getCustomName());
                    $$2.setCustomNameVisible(this.isCustomNameVisible());
                }
                $$2.setPersistenceRequired();
                p_35409_.addFreshEntityWithPassengers($$2);
                this.releaseAllPois();
                this.discard();
            } else {
                super.thunderHit(p_35409_, p_35410_);
            }
        } else {
            super.thunderHit(p_35409_, p_35410_);
        }
    }

    @Override
    protected void pickUpItem(ItemEntity p_35467_) {
        InventoryCarrier.pickUpItem(this, this, p_35467_);
    }

    @Override
    public boolean wantsToPickUp(ItemStack p_35543_) {
        Item $$1 = p_35543_.getItem();
        return (WANTED_ITEMS.contains($$1) || this.getVillagerData().getProfession().requestedItems().contains((Object)$$1)) && this.getInventory().canAddItem(p_35543_);
    }

    public boolean hasExcessFood() {
        return this.countFoodPointsInInventory() >= 24;
    }

    public boolean wantsMoreFood() {
        return this.countFoodPointsInInventory() < 12;
    }

    private int countFoodPointsInInventory() {
        SimpleContainer $$0 = this.getInventory();
        return FOOD_POINTS.entrySet().stream().mapToInt(p_186300_ -> $$0.countItem((Item)p_186300_.getKey()) * (Integer)p_186300_.getValue()).sum();
    }

    public boolean hasFarmSeeds() {
        return this.getInventory().hasAnyMatching(p_281096_ -> p_281096_.is(ItemTags.VILLAGER_PLANTABLE_SEEDS));
    }

    @Override
    protected void updateTrades() {
        Int2ObjectMap<VillagerTrades.ItemListing[]> $$3;
        VillagerData $$0 = this.getVillagerData();
        if (this.level().enabledFeatures().contains(FeatureFlags.TRADE_REBALANCE)) {
            Int2ObjectMap<VillagerTrades.ItemListing[]> $$1 = VillagerTrades.EXPERIMENTAL_TRADES.get($$0.getProfession());
            Int2ObjectMap<VillagerTrades.ItemListing[]> $$2 = $$1 != null ? $$1 : VillagerTrades.TRADES.get($$0.getProfession());
        } else {
            $$3 = VillagerTrades.TRADES.get($$0.getProfession());
        }
        if ($$3 == null || $$3.isEmpty()) {
            return;
        }
        VillagerTrades.ItemListing[] $$4 = (VillagerTrades.ItemListing[])$$3.get($$0.getLevel());
        if ($$4 == null) {
            return;
        }
        MerchantOffers $$5 = this.getOffers();
        this.addOffersFromItemListings($$5, $$4, 2);
    }

    public void gossip(ServerLevel p_35412_, Villager p_35413_, long p_35414_) {
        if (p_35414_ >= this.lastGossipTime && p_35414_ < this.lastGossipTime + 1200L || p_35414_ >= p_35413_.lastGossipTime && p_35414_ < p_35413_.lastGossipTime + 1200L) {
            return;
        }
        this.gossips.transferFrom(p_35413_.gossips, this.random, 10);
        this.lastGossipTime = p_35414_;
        p_35413_.lastGossipTime = p_35414_;
        this.spawnGolemIfNeeded(p_35412_, p_35414_, 5);
    }

    private void maybeDecayGossip() {
        long $$0 = this.level().getGameTime();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = $$0;
            return;
        }
        if ($$0 < this.lastGossipDecayTime + 24000L) {
            return;
        }
        this.gossips.decay();
        this.lastGossipDecayTime = $$0;
    }

    public void spawnGolemIfNeeded(ServerLevel p_35398_, long p_35399_, int p_35400_) {
        if (!this.wantsToSpawnGolem(p_35399_)) {
            return;
        }
        AABB $$3 = this.getBoundingBox().inflate(10.0, 10.0, 10.0);
        List<Villager> $$4 = p_35398_.getEntitiesOfClass(Villager.class, $$3);
        List $$5 = $$4.stream().filter(p_186293_ -> p_186293_.wantsToSpawnGolem(p_35399_)).limit(5L).collect(Collectors.toList());
        if ($$5.size() < p_35400_) {
            return;
        }
        if (SpawnUtil.trySpawnMob(EntityType.IRON_GOLEM, MobSpawnType.MOB_SUMMONED, p_35398_, this.blockPosition(), 10, 8, 6, SpawnUtil.Strategy.LEGACY_IRON_GOLEM).isEmpty()) {
            return;
        }
        $$4.forEach(GolemSensor::golemDetected);
    }

    public boolean wantsToSpawnGolem(long p_35393_) {
        if (!this.golemSpawnConditionsMet(this.level().getGameTime())) {
            return false;
        }
        return !this.brain.hasMemoryValue(MemoryModuleType.GOLEM_DETECTED_RECENTLY);
    }

    @Override
    public void onReputationEventFrom(ReputationEventType p_35431_, Entity p_35432_) {
        if (p_35431_ == ReputationEventType.ZOMBIE_VILLAGER_CURED) {
            this.gossips.add(p_35432_.getUUID(), GossipType.MAJOR_POSITIVE, 20);
            this.gossips.add(p_35432_.getUUID(), GossipType.MINOR_POSITIVE, 25);
        } else if (p_35431_ == ReputationEventType.TRADE) {
            this.gossips.add(p_35432_.getUUID(), GossipType.TRADING, 2);
        } else if (p_35431_ == ReputationEventType.VILLAGER_HURT) {
            this.gossips.add(p_35432_.getUUID(), GossipType.MINOR_NEGATIVE, 25);
        } else if (p_35431_ == ReputationEventType.VILLAGER_KILLED) {
            this.gossips.add(p_35432_.getUUID(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    @Override
    public int getVillagerXp() {
        return this.villagerXp;
    }

    public void setVillagerXp(int p_35547_) {
        this.villagerXp = p_35547_;
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }

    public GossipContainer getGossips() {
        return this.gossips;
    }

    public void setGossips(Tag p_35456_) {
        this.gossips.update(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_35456_));
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain(this);
    }

    @Override
    public void startSleeping(BlockPos p_35479_) {
        super.startSleeping(p_35479_);
        this.brain.setMemory(MemoryModuleType.LAST_SLEPT, this.level().getGameTime());
        this.brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        this.brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
    }

    @Override
    public void stopSleeping() {
        super.stopSleeping();
        this.brain.setMemory(MemoryModuleType.LAST_WOKEN, this.level().getGameTime());
    }

    private boolean golemSpawnConditionsMet(long p_35462_) {
        Optional<Long> $$1 = this.brain.getMemory(MemoryModuleType.LAST_SLEPT);
        if ($$1.isPresent()) {
            return p_35462_ - $$1.get() < 24000L;
        }
        return false;
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    private static /* synthetic */ void lambda$tellWitnessesThatIWasMurdered$6(ServerLevel p_186295_, Entity p_186296_, LivingEntity p_186297_) {
        p_186295_.onReputationEvent(ReputationEventType.VILLAGER_KILLED, p_186296_, (ReputationEventHandler)((Object)p_186297_));
    }
}

