/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.slf4j.Logger;

public abstract class Player
extends LivingEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final HumanoidArm DEFAULT_MAIN_HAND = HumanoidArm.RIGHT;
    public static final int DEFAULT_MODEL_CUSTOMIZATION = 0;
    public static final int MAX_HEALTH = 20;
    public static final int SLEEP_DURATION = 100;
    public static final int WAKE_UP_DURATION = 10;
    public static final int ENDER_SLOT_OFFSET = 200;
    public static final int HELD_ITEM_SLOT = 499;
    public static final int CRAFTING_SLOT_OFFSET = 500;
    public static final float DEFAULT_BLOCK_INTERACTION_RANGE = 4.5f;
    public static final float DEFAULT_ENTITY_INTERACTION_RANGE = 3.0f;
    public static final float CROUCH_BB_HEIGHT = 1.5f;
    public static final float SWIMMING_BB_WIDTH = 0.6f;
    public static final float SWIMMING_BB_HEIGHT = 0.6f;
    public static final float DEFAULT_EYE_HEIGHT = 1.62f;
    public static final Vec3 DEFAULT_VEHICLE_ATTACHMENT = new Vec3(0.0, 0.6, 0.0);
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.scalable(0.6f, 1.8f).withEyeHeight(1.62f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT));
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)Pose.SLEEPING, (Object)SLEEPING_DIMENSIONS).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.scalable(0.6f, 0.6f).withEyeHeight(0.4f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.scalable(0.6f, 1.5f).withEyeHeight(1.27f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.VEHICLE, DEFAULT_VEHICLE_ATTACHMENT))).put((Object)Pose.DYING, (Object)EntityDimensions.fixed(0.2f, 0.2f).withEyeHeight(1.62f)).build();
    private static final EntityDataAccessor<Float> DATA_PLAYER_ABSORPTION_ID = SynchedEntityData.defineId(Player.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_SCORE_ID = SynchedEntityData.defineId(Player.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION = SynchedEntityData.defineId(Player.class, EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Byte> DATA_PLAYER_MAIN_HAND = SynchedEntityData.defineId(Player.class, EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<CompoundTag> DATA_SHOULDER_LEFT = SynchedEntityData.defineId(Player.class, EntityDataSerializers.COMPOUND_TAG);
    protected static final EntityDataAccessor<CompoundTag> DATA_SHOULDER_RIGHT = SynchedEntityData.defineId(Player.class, EntityDataSerializers.COMPOUND_TAG);
    private long timeEntitySatOnShoulder;
    final Inventory inventory = new Inventory(this);
    protected PlayerEnderChestContainer enderChestInventory = new PlayerEnderChestContainer();
    public final InventoryMenu inventoryMenu;
    public AbstractContainerMenu containerMenu;
    protected FoodData foodData = new FoodData();
    protected int jumpTriggerTime;
    public float oBob;
    public float bob;
    public int takeXpDelay;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    private int sleepCounter;
    protected boolean wasUnderwater;
    private final Abilities abilities = new Abilities();
    public int experienceLevel;
    public int totalExperience;
    public float experienceProgress;
    protected int enchantmentSeed;
    protected final float defaultFlySpeed = 0.02f;
    private int lastLevelUpTime;
    private final GameProfile gameProfile;
    private boolean reducedDebugInfo;
    private ItemStack lastItemInMainHand = ItemStack.EMPTY;
    private final ItemCooldowns cooldowns = this.createItemCooldowns();
    private Optional<GlobalPos> lastDeathLocation = Optional.empty();
    @Nullable
    public FishingHook fishing;
    protected float hurtDir;
    @Nullable
    public Vec3 currentImpulseImpactPos;
    @Nullable
    public Entity currentExplosionCause;
    public boolean ignoreFallDamageFromCurrentImpulse;

    public Player(Level p_250508_, BlockPos p_250289_, float p_251702_, GameProfile p_252153_) {
        super((EntityType<? extends LivingEntity>)EntityType.PLAYER, p_250508_);
        this.setUUID(p_252153_.getId());
        this.gameProfile = p_252153_;
        this.inventoryMenu = new InventoryMenu(this.inventory, !p_250508_.isClientSide, this);
        this.containerMenu = this.inventoryMenu;
        this.moveTo((double)p_250289_.getX() + 0.5, p_250289_.getY() + 1, (double)p_250289_.getZ() + 0.5, p_251702_, 0.0f);
        this.rotOffs = 180.0f;
    }

    public boolean blockActionRestricted(Level p_36188_, BlockPos p_36189_, GameType p_36190_) {
        if (!p_36190_.isBlockPlacingRestricted()) {
            return false;
        }
        if (p_36190_ == GameType.SPECTATOR) {
            return true;
        }
        if (this.mayBuild()) {
            return false;
        }
        ItemStack $$3 = this.getMainHandItem();
        return $$3.isEmpty() || !$$3.canBreakBlockInAdventureMode(new BlockInWorld(p_36188_, p_36189_, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.1f).add(Attributes.ATTACK_SPEED).add(Attributes.LUCK).add(Attributes.BLOCK_INTERACTION_RANGE, 4.5).add(Attributes.ENTITY_INTERACTION_RANGE, 3.0).add(Attributes.BLOCK_BREAK_SPEED);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326117_) {
        super.defineSynchedData(p_326117_);
        p_326117_.define(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(0.0f));
        p_326117_.define(DATA_SCORE_ID, 0);
        p_326117_.define(DATA_PLAYER_MODE_CUSTOMISATION, (byte)0);
        p_326117_.define(DATA_PLAYER_MAIN_HAND, (byte)DEFAULT_MAIN_HAND.getId());
        p_326117_.define(DATA_SHOULDER_LEFT, new CompoundTag());
        p_326117_.define(DATA_SHOULDER_RIGHT, new CompoundTag());
    }

    @Override
    public void tick() {
        this.noPhysics = this.isSpectator();
        if (this.isSpectator()) {
            this.setOnGround(false);
        }
        if (this.takeXpDelay > 0) {
            --this.takeXpDelay;
        }
        if (this.isSleeping()) {
            ++this.sleepCounter;
            if (this.sleepCounter > 100) {
                this.sleepCounter = 100;
            }
            if (!this.level().isClientSide && this.level().isDay()) {
                this.stopSleepInBed(false, true);
            }
        } else if (this.sleepCounter > 0) {
            ++this.sleepCounter;
            if (this.sleepCounter >= 110) {
                this.sleepCounter = 0;
            }
        }
        this.updateIsUnderwater();
        super.tick();
        if (!this.level().isClientSide && this.containerMenu != null && !this.containerMenu.stillValid(this)) {
            this.closeContainer();
            this.containerMenu = this.inventoryMenu;
        }
        this.moveCloak();
        if (!this.level().isClientSide) {
            this.foodData.tick(this);
            this.awardStat(Stats.PLAY_TIME);
            this.awardStat(Stats.TOTAL_WORLD_TIME);
            if (this.isAlive()) {
                this.awardStat(Stats.TIME_SINCE_DEATH);
            }
            if (this.isDiscrete()) {
                this.awardStat(Stats.CROUCH_TIME);
            }
            if (!this.isSleeping()) {
                this.awardStat(Stats.TIME_SINCE_REST);
            }
        }
        int $$0 = 29999999;
        double $$1 = Mth.clamp(this.getX(), -2.9999999E7, 2.9999999E7);
        double $$2 = Mth.clamp(this.getZ(), -2.9999999E7, 2.9999999E7);
        if ($$1 != this.getX() || $$2 != this.getZ()) {
            this.setPos($$1, this.getY(), $$2);
        }
        ++this.attackStrengthTicker;
        ItemStack $$3 = this.getMainHandItem();
        if (!ItemStack.matches(this.lastItemInMainHand, $$3)) {
            if (!ItemStack.isSameItem(this.lastItemInMainHand, $$3)) {
                this.resetAttackStrengthTicker();
            }
            this.lastItemInMainHand = $$3.copy();
        }
        this.turtleHelmetTick();
        this.cooldowns.tick();
        this.updatePlayerPose();
    }

    @Override
    protected float getMaxHeadRotationRelativeToBody() {
        if (this.isBlocking()) {
            return 15.0f;
        }
        return super.getMaxHeadRotationRelativeToBody();
    }

    public boolean isSecondaryUseActive() {
        return this.isShiftKeyDown();
    }

    protected boolean wantsToStopRiding() {
        return this.isShiftKeyDown();
    }

    protected boolean isStayingOnGroundSurface() {
        return this.isShiftKeyDown();
    }

    protected boolean updateIsUnderwater() {
        this.wasUnderwater = this.isEyeInFluid(FluidTags.WATER);
        return this.wasUnderwater;
    }

    private void turtleHelmetTick() {
        ItemStack $$0 = this.getItemBySlot(EquipmentSlot.HEAD);
        if ($$0.is(Items.TURTLE_HELMET) && !this.isEyeInFluid(FluidTags.WATER)) {
            this.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200, 0, false, false, true));
        }
    }

    protected ItemCooldowns createItemCooldowns() {
        return new ItemCooldowns();
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double $$0 = this.getX() - this.xCloak;
        double $$1 = this.getY() - this.yCloak;
        double $$2 = this.getZ() - this.zCloak;
        double $$3 = 10.0;
        if ($$0 > 10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if ($$2 > 10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if ($$1 > 10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        if ($$0 < -10.0) {
            this.xCloakO = this.xCloak = this.getX();
        }
        if ($$2 < -10.0) {
            this.zCloakO = this.zCloak = this.getZ();
        }
        if ($$1 < -10.0) {
            this.yCloakO = this.yCloak = this.getY();
        }
        this.xCloak += $$0 * 0.25;
        this.zCloak += $$2 * 0.25;
        this.yCloak += $$1 * 0.25;
    }

    protected void updatePlayerPose() {
        Pose $$8;
        Pose $$5;
        if (!this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
            return;
        }
        if (this.isFallFlying()) {
            Pose $$0 = Pose.FALL_FLYING;
        } else if (this.isSleeping()) {
            Pose $$1 = Pose.SLEEPING;
        } else if (this.isSwimming()) {
            Pose $$2 = Pose.SWIMMING;
        } else if (this.isAutoSpinAttack()) {
            Pose $$3 = Pose.SPIN_ATTACK;
        } else if (this.isShiftKeyDown() && !this.abilities.flying) {
            Pose $$4 = Pose.CROUCHING;
        } else {
            $$5 = Pose.STANDING;
        }
        if (this.isSpectator() || this.isPassenger() || this.canPlayerFitWithinBlocksAndEntitiesWhen($$5)) {
            void $$6 = $$5;
        } else if (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING)) {
            Pose $$7 = Pose.CROUCHING;
        } else {
            $$8 = Pose.SWIMMING;
        }
        this.setPose($$8);
    }

    protected boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose p_294172_) {
        return this.level().noCollision(this, this.getDimensions(p_294172_).makeBoundingBox(this.position()).deflate(1.0E-7));
    }

    @Override
    public int getPortalWaitTime() {
        return Math.max(1, this.level().getGameRules().getInt(this.abilities.invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
    }

    @Override
    protected SoundEvent getSwimSound() {
        return SoundEvents.PLAYER_SWIM;
    }

    @Override
    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.PLAYER_SPLASH;
    }

    @Override
    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.PLAYER_SPLASH_HIGH_SPEED;
    }

    @Override
    public int getDimensionChangingDelay() {
        return 10;
    }

    @Override
    public void playSound(SoundEvent p_36137_, float p_36138_, float p_36139_) {
        this.level().playSound(this, this.getX(), this.getY(), this.getZ(), p_36137_, this.getSoundSource(), p_36138_, p_36139_);
    }

    public void playNotifySound(SoundEvent p_36140_, SoundSource p_36141_, float p_36142_, float p_36143_) {
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.PLAYERS;
    }

    @Override
    protected int getFireImmuneTicks() {
        return 20;
    }

    @Override
    public void handleEntityEvent(byte p_36120_) {
        if (p_36120_ == 9) {
            this.completeUsingItem();
        } else if (p_36120_ == 23) {
            this.reducedDebugInfo = false;
        } else if (p_36120_ == 22) {
            this.reducedDebugInfo = true;
        } else {
            super.handleEntityEvent(p_36120_);
        }
    }

    protected void closeContainer() {
        this.containerMenu = this.inventoryMenu;
    }

    protected void doCloseContainer() {
    }

    @Override
    public void rideTick() {
        if (!this.level().isClientSide && this.wantsToStopRiding() && this.isPassenger()) {
            this.stopRiding();
            this.setShiftKeyDown(false);
            return;
        }
        super.rideTick();
        this.oBob = this.bob;
        this.bob = 0.0f;
    }

    @Override
    protected void serverAiStep() {
        super.serverAiStep();
        this.updateSwingTime();
        this.yHeadRot = this.getYRot();
    }

    @Override
    public void aiStep() {
        float $$1;
        if (this.jumpTriggerTime > 0) {
            --this.jumpTriggerTime;
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) {
            if (this.getHealth() < this.getMaxHealth() && this.tickCount % 20 == 0) {
                this.heal(1.0f);
            }
            if (this.foodData.needsFood() && this.tickCount % 10 == 0) {
                this.foodData.setFoodLevel(this.foodData.getFoodLevel() + 1);
            }
        }
        this.inventory.tick();
        this.oBob = this.bob;
        super.aiStep();
        this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
        if (!this.onGround() || this.isDeadOrDying() || this.isSwimming()) {
            float $$0 = 0.0f;
        } else {
            $$1 = Math.min(0.1f, (float)this.getDeltaMovement().horizontalDistance());
        }
        this.bob += ($$1 - this.bob) * 0.4f;
        if (this.getHealth() > 0.0f && !this.isSpectator()) {
            AABB $$3;
            if (this.isPassenger() && !this.getVehicle().isRemoved()) {
                AABB $$2 = this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0);
            } else {
                $$3 = this.getBoundingBox().inflate(1.0, 0.5, 1.0);
            }
            List<Entity> $$4 = this.level().getEntities(this, $$3);
            ArrayList $$5 = Lists.newArrayList();
            for (Entity $$6 : $$4) {
                if ($$6.getType() == EntityType.EXPERIENCE_ORB) {
                    $$5.add($$6);
                    continue;
                }
                if ($$6.isRemoved()) continue;
                this.touch($$6);
            }
            if (!$$5.isEmpty()) {
                this.touch((Entity)Util.getRandom($$5, this.random));
            }
        }
        this.playShoulderEntityAmbientSound(this.getShoulderEntityLeft());
        this.playShoulderEntityAmbientSound(this.getShoulderEntityRight());
        if (!this.level().isClientSide && (this.fallDistance > 0.5f || this.isInWater()) || this.abilities.flying || this.isSleeping() || this.isInPowderSnow) {
            this.removeEntitiesOnShoulder();
        }
    }

    private void playShoulderEntityAmbientSound(@Nullable CompoundTag p_36368_) {
        if (!(p_36368_ == null || p_36368_.contains("Silent") && p_36368_.getBoolean("Silent") || this.level().random.nextInt(200) != 0)) {
            String $$1 = p_36368_.getString("id");
            EntityType.byString($$1).filter(p_36280_ -> p_36280_ == EntityType.PARROT).ifPresent(p_337876_ -> {
                if (!Parrot.imitateNearbyMobs(this.level(), this)) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Parrot.getAmbient(this.level(), this.level().random), this.getSoundSource(), 1.0f, Parrot.getPitch(this.level().random));
                }
            });
        }
    }

    private void touch(Entity p_36278_) {
        p_36278_.playerTouch(this);
    }

    public int getScore() {
        return this.entityData.get(DATA_SCORE_ID);
    }

    public void setScore(int p_36398_) {
        this.entityData.set(DATA_SCORE_ID, p_36398_);
    }

    public void increaseScore(int p_36402_) {
        int $$1 = this.getScore();
        this.entityData.set(DATA_SCORE_ID, $$1 + p_36402_);
    }

    public void startAutoSpinAttack(int p_204080_) {
        this.autoSpinAttackTicks = p_204080_;
        if (!this.level().isClientSide) {
            this.removeEntitiesOnShoulder();
            this.setLivingEntityFlag(4, true);
        }
    }

    @Override
    public void die(DamageSource p_36152_) {
        super.die(p_36152_);
        this.reapplyPosition();
        if (!this.isSpectator()) {
            this.dropAllDeathLoot(p_36152_);
        }
        if (p_36152_ != null) {
            this.setDeltaMovement(-Mth.cos((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -Mth.sin((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.setDeltaMovement(0.0, 0.1, 0.0);
        }
        this.awardStat(Stats.DEATHS);
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_DEATH));
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        this.clearFire();
        this.setSharedFlagOnFire(false);
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    @Override
    protected void dropEquipment() {
        super.dropEquipment();
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            this.destroyVanishingCursedItems();
            this.inventory.dropAll();
        }
    }

    protected void destroyVanishingCursedItems() {
        for (int $$0 = 0; $$0 < this.inventory.getContainerSize(); ++$$0) {
            ItemStack $$1 = this.inventory.getItem($$0);
            if ($$1.isEmpty() || !EnchantmentHelper.hasVanishingCurse($$1)) continue;
            this.inventory.removeItemNoUpdate($$0);
        }
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_36310_) {
        return p_36310_.type().effects().sound();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    @Nullable
    public ItemEntity drop(ItemStack p_36177_, boolean p_36178_) {
        return this.drop(p_36177_, false, p_36178_);
    }

    @Nullable
    public ItemEntity drop(ItemStack p_36179_, boolean p_36180_, boolean p_36181_) {
        if (p_36179_.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            this.swing(InteractionHand.MAIN_HAND);
        }
        double $$3 = this.getEyeY() - (double)0.3f;
        ItemEntity $$4 = new ItemEntity(this.level(), this.getX(), $$3, this.getZ(), p_36179_);
        $$4.setPickUpDelay(40);
        if (p_36181_) {
            $$4.setThrower(this);
        }
        if (p_36180_) {
            float $$5 = this.random.nextFloat() * 0.5f;
            float $$6 = this.random.nextFloat() * ((float)Math.PI * 2);
            $$4.setDeltaMovement(-Mth.sin($$6) * $$5, 0.2f, Mth.cos($$6) * $$5);
        } else {
            float $$7 = 0.3f;
            float $$8 = Mth.sin(this.getXRot() * ((float)Math.PI / 180));
            float $$9 = Mth.cos(this.getXRot() * ((float)Math.PI / 180));
            float $$10 = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float $$11 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            float $$12 = this.random.nextFloat() * ((float)Math.PI * 2);
            float $$13 = 0.02f * this.random.nextFloat();
            $$4.setDeltaMovement((double)(-$$10 * $$9 * 0.3f) + Math.cos($$12) * (double)$$13, -$$8 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f, (double)($$11 * $$9 * 0.3f) + Math.sin($$12) * (double)$$13);
        }
        return $$4;
    }

    public float getDestroySpeed(BlockState p_36282_) {
        float $$1 = this.inventory.getDestroySpeed(p_36282_);
        if ($$1 > 1.0f) {
            int $$2 = EnchantmentHelper.getBlockEfficiency(this);
            ItemStack $$3 = this.getMainHandItem();
            if ($$2 > 0 && !$$3.isEmpty()) {
                $$1 += (float)($$2 * $$2 + 1);
            }
        }
        if (MobEffectUtil.hasDigSpeed(this)) {
            $$1 *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification(this) + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            float $$7;
            switch (this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0: {
                    float $$4 = 0.3f;
                    break;
                }
                case 1: {
                    float $$5 = 0.09f;
                    break;
                }
                case 2: {
                    float $$6 = 0.0027f;
                    break;
                }
                default: {
                    $$7 = 8.1E-4f;
                }
            }
            $$1 *= $$7;
        }
        $$1 *= (float)this.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (this.isEyeInFluid(FluidTags.WATER) && !EnchantmentHelper.hasAquaAffinity(this)) {
            $$1 /= 5.0f;
        }
        if (!this.onGround()) {
            $$1 /= 5.0f;
        }
        return $$1;
    }

    public boolean hasCorrectToolForDrops(BlockState p_36299_) {
        return !p_36299_.requiresCorrectToolForDrops() || this.inventory.getSelected().isCorrectToolForDrops(p_36299_);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_36215_) {
        super.readAdditionalSaveData(p_36215_);
        this.setUUID(this.gameProfile.getId());
        ListTag $$1 = p_36215_.getList("Inventory", 10);
        this.inventory.load($$1);
        this.inventory.selected = p_36215_.getInt("SelectedItemSlot");
        this.sleepCounter = p_36215_.getShort("SleepTimer");
        this.experienceProgress = p_36215_.getFloat("XpP");
        this.experienceLevel = p_36215_.getInt("XpLevel");
        this.totalExperience = p_36215_.getInt("XpTotal");
        this.enchantmentSeed = p_36215_.getInt("XpSeed");
        if (this.enchantmentSeed == 0) {
            this.enchantmentSeed = this.random.nextInt();
        }
        this.setScore(p_36215_.getInt("Score"));
        this.foodData.readAdditionalSaveData(p_36215_);
        this.abilities.loadSaveData(p_36215_);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.abilities.getWalkingSpeed());
        if (p_36215_.contains("EnderItems", 9)) {
            this.enderChestInventory.fromTag(p_36215_.getList("EnderItems", 10), this.registryAccess());
        }
        if (p_36215_.contains("ShoulderEntityLeft", 10)) {
            this.setShoulderEntityLeft(p_36215_.getCompound("ShoulderEntityLeft"));
        }
        if (p_36215_.contains("ShoulderEntityRight", 10)) {
            this.setShoulderEntityRight(p_36215_.getCompound("ShoulderEntityRight"));
        }
        if (p_36215_.contains("LastDeathLocation", 10)) {
            this.setLastDeathLocation(GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_36215_.get("LastDeathLocation")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
        }
        if (p_36215_.contains("current_explosion_impact_pos", 9)) {
            Vec3.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_36215_.get("current_explosion_impact_pos")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_335272_ -> {
                this.currentImpulseImpactPos = p_335272_;
            });
        }
        this.ignoreFallDamageFromCurrentImpulse = p_36215_.getBoolean("ignore_fall_damage_from_current_explosion");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_36265_) {
        super.addAdditionalSaveData(p_36265_);
        NbtUtils.addCurrentDataVersion(p_36265_);
        p_36265_.put("Inventory", this.inventory.save(new ListTag()));
        p_36265_.putInt("SelectedItemSlot", this.inventory.selected);
        p_36265_.putShort("SleepTimer", (short)this.sleepCounter);
        p_36265_.putFloat("XpP", this.experienceProgress);
        p_36265_.putInt("XpLevel", this.experienceLevel);
        p_36265_.putInt("XpTotal", this.totalExperience);
        p_36265_.putInt("XpSeed", this.enchantmentSeed);
        p_36265_.putInt("Score", this.getScore());
        this.foodData.addAdditionalSaveData(p_36265_);
        this.abilities.addSaveData(p_36265_);
        p_36265_.put("EnderItems", this.enderChestInventory.createTag(this.registryAccess()));
        if (!this.getShoulderEntityLeft().isEmpty()) {
            p_36265_.put("ShoulderEntityLeft", this.getShoulderEntityLeft());
        }
        if (!this.getShoulderEntityRight().isEmpty()) {
            p_36265_.put("ShoulderEntityRight", this.getShoulderEntityRight());
        }
        this.getLastDeathLocation().flatMap(p_337878_ -> GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, p_337878_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(p_219756_ -> p_36265_.put("LastDeathLocation", (Tag)p_219756_));
        if (this.currentImpulseImpactPos != null) {
            p_36265_.put("current_explosion_impact_pos", (Tag)Vec3.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.currentImpulseImpactPos).getOrThrow());
        }
        p_36265_.putBoolean("ignore_fall_damage_from_current_explosion", this.ignoreFallDamageFromCurrentImpulse);
    }

    @Override
    public boolean isInvulnerableTo(DamageSource p_36249_) {
        if (super.isInvulnerableTo(p_36249_)) {
            return true;
        }
        if (p_36249_.is(DamageTypeTags.IS_DROWNING)) {
            return !this.level().getGameRules().getBoolean(GameRules.RULE_DROWNING_DAMAGE);
        }
        if (p_36249_.is(DamageTypeTags.IS_FALL)) {
            return !this.level().getGameRules().getBoolean(GameRules.RULE_FALL_DAMAGE);
        }
        if (p_36249_.is(DamageTypeTags.IS_FIRE)) {
            return !this.level().getGameRules().getBoolean(GameRules.RULE_FIRE_DAMAGE);
        }
        if (p_36249_.is(DamageTypeTags.IS_FREEZING)) {
            return !this.level().getGameRules().getBoolean(GameRules.RULE_FREEZE_DAMAGE);
        }
        return false;
    }

    @Override
    public boolean hurt(DamageSource p_36154_, float p_36155_) {
        if (this.isInvulnerableTo(p_36154_)) {
            return false;
        }
        if (this.abilities.invulnerable && !p_36154_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        this.noActionTime = 0;
        if (this.isDeadOrDying()) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.removeEntitiesOnShoulder();
        }
        if (p_36154_.scalesWithDifficulty()) {
            if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
                p_36155_ = 0.0f;
            }
            if (this.level().getDifficulty() == Difficulty.EASY) {
                p_36155_ = Math.min(p_36155_ / 2.0f + 1.0f, p_36155_);
            }
            if (this.level().getDifficulty() == Difficulty.HARD) {
                p_36155_ = p_36155_ * 3.0f / 2.0f;
            }
        }
        if (p_36155_ == 0.0f) {
            return false;
        }
        return super.hurt(p_36154_, p_36155_);
    }

    @Override
    protected void blockUsingShield(LivingEntity p_36295_) {
        super.blockUsingShield(p_36295_);
        if (p_36295_.canDisableShield()) {
            this.disableShield();
        }
    }

    @Override
    public boolean canBeSeenAsEnemy() {
        return !this.getAbilities().invulnerable && super.canBeSeenAsEnemy();
    }

    public boolean canHarmPlayer(Player p_36169_) {
        PlayerTeam $$1 = this.getTeam();
        PlayerTeam $$2 = p_36169_.getTeam();
        if ($$1 == null) {
            return true;
        }
        if (!$$1.isAlliedTo($$2)) {
            return true;
        }
        return ((Team)$$1).isAllowFriendlyFire();
    }

    @Override
    protected void hurtArmor(DamageSource p_36251_, float p_36252_) {
        this.doHurtEquipment(p_36251_, p_36252_, EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD);
    }

    @Override
    protected void hurtHelmet(DamageSource p_150103_, float p_150104_) {
        this.doHurtEquipment(p_150103_, p_150104_, EquipmentSlot.HEAD);
    }

    @Override
    protected void hurtCurrentlyUsedShield(float p_36383_) {
        if (!this.useItem.is(Items.SHIELD)) {
            return;
        }
        if (!this.level().isClientSide) {
            this.awardStat(Stats.ITEM_USED.get(this.useItem.getItem()));
        }
        if (p_36383_ >= 3.0f) {
            int $$1 = 1 + Mth.floor(p_36383_);
            InteractionHand $$2 = this.getUsedItemHand();
            this.useItem.hurtAndBreak($$1, this, Player.getSlotForHand($$2));
            if (this.useItem.isEmpty()) {
                if ($$2 == InteractionHand.MAIN_HAND) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                } else {
                    this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                }
                this.useItem = ItemStack.EMPTY;
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
            }
        }
    }

    @Override
    protected void actuallyHurt(DamageSource p_36312_, float p_36313_) {
        if (this.isInvulnerableTo(p_36312_)) {
            return;
        }
        p_36313_ = this.getDamageAfterArmorAbsorb(p_36312_, p_36313_);
        float $$2 = p_36313_ = this.getDamageAfterMagicAbsorb(p_36312_, p_36313_);
        p_36313_ = Math.max(p_36313_ - this.getAbsorptionAmount(), 0.0f);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - ($$2 - p_36313_));
        float $$3 = $$2 - p_36313_;
        if ($$3 > 0.0f && $$3 < 3.4028235E37f) {
            this.awardStat(Stats.DAMAGE_ABSORBED, Math.round($$3 * 10.0f));
        }
        if (p_36313_ == 0.0f) {
            return;
        }
        this.causeFoodExhaustion(p_36312_.getFoodExhaustion());
        this.getCombatTracker().recordDamage(p_36312_, p_36313_);
        this.setHealth(this.getHealth() - p_36313_);
        if (p_36313_ < 3.4028235E37f) {
            this.awardStat(Stats.DAMAGE_TAKEN, Math.round(p_36313_ * 10.0f));
        }
        this.gameEvent(GameEvent.ENTITY_DAMAGE);
    }

    @Override
    protected boolean onSoulSpeedBlock() {
        return !this.abilities.flying && super.onSoulSpeedBlock();
    }

    public boolean isTextFilteringEnabled() {
        return false;
    }

    public void openTextEdit(SignBlockEntity p_36193_, boolean p_277837_) {
    }

    public void openMinecartCommandBlock(BaseCommandBlock p_36182_) {
    }

    public void openCommandBlock(CommandBlockEntity p_36191_) {
    }

    public void openStructureBlock(StructureBlockEntity p_36194_) {
    }

    public void openJigsawBlock(JigsawBlockEntity p_36192_) {
    }

    public void openHorseInventory(AbstractHorse p_36167_, Container p_36168_) {
    }

    public OptionalInt openMenu(@Nullable MenuProvider p_36150_) {
        return OptionalInt.empty();
    }

    public void sendMerchantOffers(int p_36121_, MerchantOffers p_36122_, int p_36123_, int p_36124_, boolean p_36125_, boolean p_36126_) {
    }

    public void openItemGui(ItemStack p_36174_, InteractionHand p_36175_) {
    }

    public InteractionResult interactOn(Entity p_36158_, InteractionHand p_36159_) {
        if (this.isSpectator()) {
            if (p_36158_ instanceof MenuProvider) {
                this.openMenu((MenuProvider)((Object)p_36158_));
            }
            return InteractionResult.PASS;
        }
        ItemStack $$2 = this.getItemInHand(p_36159_);
        ItemStack $$3 = $$2.copy();
        InteractionResult $$4 = p_36158_.interact(this, p_36159_);
        if ($$4.consumesAction()) {
            if (this.abilities.instabuild && $$2 == this.getItemInHand(p_36159_) && $$2.getCount() < $$3.getCount()) {
                $$2.setCount($$3.getCount());
            }
            return $$4;
        }
        if (!$$2.isEmpty() && p_36158_ instanceof LivingEntity) {
            InteractionResult $$5;
            if (this.abilities.instabuild) {
                $$2 = $$3;
            }
            if (($$5 = $$2.interactLivingEntity(this, (LivingEntity)p_36158_, p_36159_)).consumesAction()) {
                this.level().gameEvent(GameEvent.ENTITY_INTERACT, p_36158_.position(), GameEvent.Context.of(this));
                if ($$2.isEmpty() && !this.abilities.instabuild) {
                    this.setItemInHand(p_36159_, ItemStack.EMPTY);
                }
                return $$5;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void removeVehicle() {
        super.removeVehicle();
        this.boardingCooldown = 0;
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.isSleeping();
    }

    @Override
    public boolean isAffectedByFluids() {
        return !this.abilities.flying;
    }

    @Override
    protected Vec3 maybeBackOffFromEdge(Vec3 p_36201_, MoverType p_36202_) {
        double $$3;
        float $$2 = this.maxUpStep();
        if (this.abilities.flying || p_36201_.y > 0.0 || p_36202_ != MoverType.SELF && p_36202_ != MoverType.PLAYER || !this.isStayingOnGroundSurface() || !this.isAboveGround($$2)) {
            return p_36201_;
        }
        double $$4 = p_36201_.z;
        double $$5 = 0.05;
        double $$6 = Math.signum($$3) * 0.05;
        double $$7 = Math.signum($$4) * 0.05;
        for ($$3 = p_36201_.x; $$3 != 0.0 && this.canFallAtLeast($$3, 0.0, $$2); $$3 -= $$6) {
            if (!(Math.abs($$3) <= 0.05)) continue;
            $$3 = 0.0;
            break;
        }
        while ($$4 != 0.0 && this.canFallAtLeast(0.0, $$4, $$2)) {
            if (Math.abs($$4) <= 0.05) {
                $$4 = 0.0;
                break;
            }
            $$4 -= $$7;
        }
        while ($$3 != 0.0 && $$4 != 0.0 && this.canFallAtLeast($$3, $$4, $$2)) {
            $$3 = Math.abs($$3) <= 0.05 ? 0.0 : ($$3 -= $$6);
            if (Math.abs($$4) <= 0.05) {
                $$4 = 0.0;
                continue;
            }
            $$4 -= $$7;
        }
        return new Vec3($$3, p_36201_.y, $$4);
    }

    private boolean isAboveGround(float p_341626_) {
        return this.onGround() || this.fallDistance < p_341626_ && !this.canFallAtLeast(0.0, 0.0, p_341626_ - this.fallDistance);
    }

    private boolean canFallAtLeast(double p_341664_, double p_341597_, float p_341613_) {
        AABB $$3 = this.getBoundingBox();
        return this.level().noCollision(this, new AABB($$3.minX + p_341664_, $$3.minY - (double)p_341613_ - (double)1.0E-5f, $$3.minZ + p_341597_, $$3.maxX + p_341664_, $$3.minY, $$3.maxZ + p_341597_));
    }

    public void attack(Entity p_36347_) {
        if (!p_36347_.isAttackable()) {
            return;
        }
        if (p_36347_.skipAttackInteraction(this)) {
            return;
        }
        float $$1 = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float $$2 = EnchantmentHelper.getDamageBonus(this.getMainHandItem(), p_36347_.getType());
        float $$3 = this.getAttackStrengthScale(0.5f);
        $$1 *= 0.2f + $$3 * $$3 * 0.8f;
        $$2 *= $$3;
        this.resetAttackStrengthTicker();
        if (p_36347_.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && p_36347_ instanceof Projectile) {
            Projectile $$4 = (Projectile)p_36347_;
            $$4.deflect(ProjectileDeflection.AIM_DEFLECT, this, this, true);
            return;
        }
        if ($$1 > 0.0f || $$2 > 0.0f) {
            ItemStack $$11;
            boolean $$8;
            boolean $$5 = $$3 > 0.9f;
            boolean $$6 = false;
            int $$7 = 0;
            $$7 += EnchantmentHelper.getKnockbackBonus(this);
            if (this.isSprinting() && $$5) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, this.getSoundSource(), 1.0f, 1.0f);
                ++$$7;
                $$6 = true;
            }
            $$1 += this.getItemInHand(InteractionHand.MAIN_HAND).getItem().getAttackDamageBonus(this, $$1);
            boolean bl = $$8 = $$5 && this.fallDistance > 0.0f && !this.onGround() && !this.onClimbable() && !this.isInWater() && !this.hasEffect(MobEffects.BLINDNESS) && !this.isPassenger() && p_36347_ instanceof LivingEntity && !this.isSprinting();
            if ($$8) {
                $$1 *= 1.5f;
            }
            $$1 += $$2;
            boolean $$9 = false;
            double $$10 = this.walkDist - this.walkDistO;
            if ($$5 && !$$8 && !$$6 && this.onGround() && $$10 < (double)this.getSpeed() && ($$11 = this.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof SwordItem) {
                $$9 = true;
            }
            float $$12 = 0.0f;
            boolean $$13 = false;
            int $$14 = EnchantmentHelper.getFireAspect(this);
            if (p_36347_ instanceof LivingEntity) {
                $$12 = ((LivingEntity)p_36347_).getHealth();
                if ($$14 > 0 && !p_36347_.isOnFire()) {
                    $$13 = true;
                    p_36347_.igniteForSeconds(1);
                }
            }
            Vec3 $$15 = p_36347_.getDeltaMovement();
            boolean $$16 = p_36347_.hurt(this.damageSources().playerAttack(this), $$1);
            if ($$16) {
                if ($$7 > 0) {
                    if (p_36347_ instanceof LivingEntity) {
                        ((LivingEntity)p_36347_).knockback((float)$$7 * 0.5f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)));
                    } else {
                        p_36347_.push(-Mth.sin(this.getYRot() * ((float)Math.PI / 180)) * (float)$$7 * 0.5f, 0.1, Mth.cos(this.getYRot() * ((float)Math.PI / 180)) * (float)$$7 * 0.5f);
                    }
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                    this.setSprinting(false);
                }
                if ($$9) {
                    float $$17 = 1.0f + EnchantmentHelper.getSweepingDamageRatio(this) * $$1;
                    List<LivingEntity> $$18 = this.level().getEntitiesOfClass(LivingEntity.class, p_36347_.getBoundingBox().inflate(1.0, 0.25, 1.0));
                    for (LivingEntity $$19 : $$18) {
                        if ($$19 == this || $$19 == p_36347_ || this.isAlliedTo($$19) || $$19 instanceof ArmorStand && ((ArmorStand)$$19).isMarker() || !(this.distanceToSqr($$19) < 9.0)) continue;
                        $$19.knockback(0.4f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)));
                        $$19.hurt(this.damageSources().playerAttack(this), $$17);
                    }
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 1.0f, 1.0f);
                    this.sweepAttack();
                }
                if (p_36347_ instanceof ServerPlayer && p_36347_.hurtMarked) {
                    ((ServerPlayer)p_36347_).connection.send(new ClientboundSetEntityMotionPacket(p_36347_));
                    p_36347_.hurtMarked = false;
                    p_36347_.setDeltaMovement($$15);
                }
                if ($$8) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, this.getSoundSource(), 1.0f, 1.0f);
                    this.crit(p_36347_);
                }
                if (!$$8 && !$$9) {
                    if ($$5) {
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, this.getSoundSource(), 1.0f, 1.0f);
                    } else {
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, this.getSoundSource(), 1.0f, 1.0f);
                    }
                }
                if ($$2 > 0.0f) {
                    this.magicCrit(p_36347_);
                }
                this.setLastHurtMob(p_36347_);
                if (p_36347_ instanceof LivingEntity) {
                    EnchantmentHelper.doPostHurtEffects((LivingEntity)p_36347_, this);
                }
                EnchantmentHelper.doPostDamageEffects(this, p_36347_);
                ItemStack $$20 = this.getMainHandItem();
                Entity $$21 = p_36347_;
                if (p_36347_ instanceof EnderDragonPart) {
                    $$21 = ((EnderDragonPart)p_36347_).parentMob;
                }
                if (!this.level().isClientSide && !$$20.isEmpty() && $$21 instanceof LivingEntity) {
                    $$20.hurtEnemy((LivingEntity)$$21, this);
                    if ($$20.isEmpty()) {
                        this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    }
                }
                if (p_36347_ instanceof LivingEntity) {
                    float $$22 = $$12 - ((LivingEntity)p_36347_).getHealth();
                    this.awardStat(Stats.DAMAGE_DEALT, Math.round($$22 * 10.0f));
                    if ($$14 > 0) {
                        p_36347_.igniteForSeconds($$14 * 4);
                    }
                    if (this.level() instanceof ServerLevel && $$22 > 2.0f) {
                        int $$23 = (int)((double)$$22 * 0.5);
                        ((ServerLevel)this.level()).sendParticles(ParticleTypes.DAMAGE_INDICATOR, p_36347_.getX(), p_36347_.getY(0.5), p_36347_.getZ(), $$23, 0.1, 0.0, 0.1, 0.2);
                    }
                }
                this.causeFoodExhaustion(0.1f);
            } else {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.getSoundSource(), 1.0f, 1.0f);
                if ($$13) {
                    p_36347_.clearFire();
                }
            }
        }
    }

    @Override
    protected void doAutoAttackOnTouch(LivingEntity p_36355_) {
        this.attack(p_36355_);
    }

    public void disableShield() {
        this.getCooldowns().addCooldown(Items.SHIELD, 100);
        this.stopUsingItem();
        this.level().broadcastEntityEvent(this, (byte)30);
    }

    public void crit(Entity p_36156_) {
    }

    public void magicCrit(Entity p_36253_) {
    }

    public void sweepAttack() {
        double $$0 = -Mth.sin(this.getYRot() * ((float)Math.PI / 180));
        double $$1 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles(ParticleTypes.SWEEP_ATTACK, this.getX() + $$0, this.getY(0.5), this.getZ() + $$1, 0, $$0, 0.0, $$1, 0.0);
        }
    }

    public void respawn() {
    }

    @Override
    public void remove(Entity.RemovalReason p_150097_) {
        super.remove(p_150097_);
        this.inventoryMenu.removed(this);
        if (this.containerMenu != null && this.hasContainerOpen()) {
            this.doCloseContainer();
        }
    }

    public boolean isLocalPlayer() {
        return false;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.abilities.instabuild;
    }

    public void updateTutorialInventoryAction(ItemStack p_150098_, ItemStack p_150099_, ClickAction p_150100_) {
    }

    public boolean hasContainerOpen() {
        return this.containerMenu != this.inventoryMenu;
    }

    public Either<BedSleepingProblem, Unit> startSleepInBed(BlockPos p_36203_) {
        this.startSleeping(p_36203_);
        this.sleepCounter = 0;
        return Either.right((Object)((Object)Unit.INSTANCE));
    }

    public void stopSleepInBed(boolean p_36226_, boolean p_36227_) {
        super.stopSleeping();
        if (this.level() instanceof ServerLevel && p_36227_) {
            ((ServerLevel)this.level()).updateSleepingPlayerList();
        }
        this.sleepCounter = p_36226_ ? 0 : 100;
    }

    @Override
    public void stopSleeping() {
        this.stopSleepInBed(true, true);
    }

    public static Optional<Vec3> findRespawnPositionAndUseSpawnBlock(ServerLevel p_36131_, BlockPos p_36132_, float p_36133_, boolean p_36134_, boolean p_36135_) {
        BlockState $$5 = p_36131_.getBlockState(p_36132_);
        Block $$6 = $$5.getBlock();
        if ($$6 instanceof RespawnAnchorBlock && (p_36134_ || $$5.getValue(RespawnAnchorBlock.CHARGE) > 0) && RespawnAnchorBlock.canSetSpawn(p_36131_)) {
            Optional<Vec3> $$7 = RespawnAnchorBlock.findStandUpPosition(EntityType.PLAYER, p_36131_, p_36132_);
            if (!p_36134_ && !p_36135_ && $$7.isPresent()) {
                p_36131_.setBlock(p_36132_, (BlockState)$$5.setValue(RespawnAnchorBlock.CHARGE, $$5.getValue(RespawnAnchorBlock.CHARGE) - 1), 3);
            }
            return $$7;
        }
        if ($$6 instanceof BedBlock && BedBlock.canSetSpawn(p_36131_)) {
            return BedBlock.findStandUpPosition(EntityType.PLAYER, p_36131_, p_36132_, $$5.getValue(BedBlock.FACING), p_36133_);
        }
        if (!p_36134_) {
            return Optional.empty();
        }
        boolean $$8 = $$6.isPossibleToRespawnInThis($$5);
        BlockState $$9 = p_36131_.getBlockState(p_36132_.above());
        boolean $$10 = $$9.getBlock().isPossibleToRespawnInThis($$9);
        if ($$8 && $$10) {
            return Optional.of(new Vec3((double)p_36132_.getX() + 0.5, (double)p_36132_.getY() + 0.1, (double)p_36132_.getZ() + 0.5));
        }
        return Optional.empty();
    }

    public boolean isSleepingLongEnough() {
        return this.isSleeping() && this.sleepCounter >= 100;
    }

    public int getSleepTimer() {
        return this.sleepCounter;
    }

    public void displayClientMessage(Component p_36216_, boolean p_36217_) {
    }

    public void awardStat(ResourceLocation p_36221_) {
        this.awardStat(Stats.CUSTOM.get(p_36221_));
    }

    public void awardStat(ResourceLocation p_36223_, int p_36224_) {
        this.awardStat(Stats.CUSTOM.get(p_36223_), p_36224_);
    }

    public void awardStat(Stat<?> p_36247_) {
        this.awardStat(p_36247_, 1);
    }

    public void awardStat(Stat<?> p_36145_, int p_36146_) {
    }

    public void resetStat(Stat<?> p_36144_) {
    }

    public int awardRecipes(Collection<RecipeHolder<?>> p_36213_) {
        return 0;
    }

    public void triggerRecipeCrafted(RecipeHolder<?> p_301080_, List<ItemStack> p_283609_) {
    }

    public void awardRecipesByKey(List<ResourceLocation> p_312922_) {
    }

    public int resetRecipes(Collection<RecipeHolder<?>> p_36263_) {
        return 0;
    }

    @Override
    public void jumpFromGround() {
        super.jumpFromGround();
        this.awardStat(Stats.JUMP);
        if (this.isSprinting()) {
            this.causeFoodExhaustion(0.2f);
        } else {
            this.causeFoodExhaustion(0.05f);
        }
    }

    @Override
    public void travel(Vec3 p_36359_) {
        if (this.isSwimming() && !this.isPassenger()) {
            double $$2;
            double $$1 = this.getLookAngle().y;
            double d = $$2 = $$1 < -0.2 ? 0.085 : 0.06;
            if ($$1 <= 0.0 || this.jumping || !this.level().getBlockState(BlockPos.containing(this.getX(), this.getY() + 1.0 - 0.1, this.getZ())).getFluidState().isEmpty()) {
                Vec3 $$3 = this.getDeltaMovement();
                this.setDeltaMovement($$3.add(0.0, ($$1 - $$3.y) * $$2, 0.0));
            }
        }
        if (this.abilities.flying && !this.isPassenger()) {
            double $$4 = this.getDeltaMovement().y;
            super.travel(p_36359_);
            Vec3 $$5 = this.getDeltaMovement();
            this.setDeltaMovement($$5.x, $$4 * 0.6, $$5.z);
            this.resetFallDistance();
            this.setSharedFlag(7, false);
        } else {
            super.travel(p_36359_);
        }
    }

    @Override
    public void updateSwimming() {
        if (this.abilities.flying) {
            this.setSwimming(false);
        } else {
            super.updateSwimming();
        }
    }

    protected boolean freeAt(BlockPos p_36351_) {
        return !this.level().getBlockState(p_36351_).isSuffocating(this.level(), p_36351_);
    }

    @Override
    public float getSpeed() {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    @Override
    public boolean causeFallDamage(float p_150093_, float p_150094_, DamageSource p_150095_) {
        if (this.abilities.mayfly) {
            return false;
        }
        if (p_150093_ >= 2.0f) {
            this.awardStat(Stats.FALL_ONE_CM, (int)Math.round((double)p_150093_ * 100.0));
        }
        if (this.ignoreFallDamageFromCurrentImpulse && this.currentImpulseImpactPos != null) {
            double $$3 = this.currentImpulseImpactPos.y;
            this.resetCurrentImpulseContext();
            if ($$3 < this.getY()) {
                return false;
            }
            return super.causeFallDamage((float)($$3 - this.getY()), p_150094_, p_150095_);
        }
        return super.causeFallDamage(p_150093_, p_150094_, p_150095_);
    }

    public boolean tryToStartFallFlying() {
        ItemStack $$0;
        if (!this.onGround() && !this.isFallFlying() && !this.isInWater() && !this.hasEffect(MobEffects.LEVITATION) && ($$0 = this.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA) && ElytraItem.isFlyEnabled($$0)) {
            this.startFallFlying();
            return true;
        }
        return false;
    }

    public void startFallFlying() {
        this.setSharedFlag(7, true);
    }

    public void stopFallFlying() {
        this.setSharedFlag(7, true);
        this.setSharedFlag(7, false);
    }

    @Override
    protected void doWaterSplashEffect() {
        if (!this.isSpectator()) {
            super.doWaterSplashEffect();
        }
    }

    @Override
    protected void playStepSound(BlockPos p_282121_, BlockState p_282194_) {
        if (this.isInWater()) {
            this.waterSwimSound();
            this.playMuffledStepSound(p_282194_);
        } else {
            BlockPos $$2 = this.getPrimaryStepSoundBlockPos(p_282121_);
            if (!p_282121_.equals($$2)) {
                BlockState $$3 = this.level().getBlockState($$2);
                if ($$3.is(BlockTags.COMBINATION_STEP_SOUND_BLOCKS)) {
                    this.playCombinationStepSounds($$3, p_282194_);
                } else {
                    super.playStepSound($$2, $$3);
                }
            } else {
                super.playStepSound(p_282121_, p_282194_);
            }
        }
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.PLAYER_SMALL_FALL, SoundEvents.PLAYER_BIG_FALL);
    }

    @Override
    public boolean killedEntity(ServerLevel p_219735_, LivingEntity p_219736_) {
        this.awardStat(Stats.ENTITY_KILLED.get(p_219736_.getType()));
        return true;
    }

    @Override
    public void makeStuckInBlock(BlockState p_36196_, Vec3 p_36197_) {
        if (!this.abilities.flying) {
            super.makeStuckInBlock(p_36196_, p_36197_);
        }
        this.resetCurrentImpulseContext();
    }

    public void giveExperiencePoints(int p_36291_) {
        this.increaseScore(p_36291_);
        this.experienceProgress += (float)p_36291_ / (float)this.getXpNeededForNextLevel();
        this.totalExperience = Mth.clamp(this.totalExperience + p_36291_, 0, Integer.MAX_VALUE);
        while (this.experienceProgress < 0.0f) {
            float $$1 = this.experienceProgress * (float)this.getXpNeededForNextLevel();
            if (this.experienceLevel > 0) {
                this.giveExperienceLevels(-1);
                this.experienceProgress = 1.0f + $$1 / (float)this.getXpNeededForNextLevel();
                continue;
            }
            this.giveExperienceLevels(-1);
            this.experienceProgress = 0.0f;
        }
        while (this.experienceProgress >= 1.0f) {
            this.experienceProgress = (this.experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel();
            this.giveExperienceLevels(1);
            this.experienceProgress /= (float)this.getXpNeededForNextLevel();
        }
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public void onEnchantmentPerformed(ItemStack p_36172_, int p_36173_) {
        this.experienceLevel -= p_36173_;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        this.enchantmentSeed = this.random.nextInt();
    }

    public void giveExperienceLevels(int p_36276_) {
        this.experienceLevel += p_36276_;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        if (p_36276_ > 0 && this.experienceLevel % 5 == 0 && (float)this.lastLevelUpTime < (float)this.tickCount - 100.0f) {
            float $$1 = this.experienceLevel > 30 ? 1.0f : (float)this.experienceLevel / 30.0f;
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_LEVELUP, this.getSoundSource(), $$1 * 0.75f, 1.0f);
            this.lastLevelUpTime = this.tickCount;
        }
    }

    public int getXpNeededForNextLevel() {
        if (this.experienceLevel >= 30) {
            return 112 + (this.experienceLevel - 30) * 9;
        }
        if (this.experienceLevel >= 15) {
            return 37 + (this.experienceLevel - 15) * 5;
        }
        return 7 + this.experienceLevel * 2;
    }

    public void causeFoodExhaustion(float p_36400_) {
        if (this.abilities.invulnerable) {
            return;
        }
        if (!this.level().isClientSide) {
            this.foodData.addExhaustion(p_36400_);
        }
    }

    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.empty();
    }

    public FoodData getFoodData() {
        return this.foodData;
    }

    public boolean canEat(boolean p_36392_) {
        return this.abilities.invulnerable || p_36392_ || this.foodData.needsFood();
    }

    public boolean isHurt() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public boolean mayBuild() {
        return this.abilities.mayBuild;
    }

    public boolean mayUseItemAt(BlockPos p_36205_, Direction p_36206_, ItemStack p_36207_) {
        if (this.abilities.mayBuild) {
            return true;
        }
        BlockPos $$3 = p_36205_.relative(p_36206_.getOpposite());
        BlockInWorld $$4 = new BlockInWorld(this.level(), $$3, false);
        return p_36207_.canPlaceOnBlockInAdventureMode($$4);
    }

    @Override
    public int getExperienceReward() {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || this.isSpectator()) {
            return 0;
        }
        int $$0 = this.experienceLevel * 7;
        if ($$0 > 100) {
            return 100;
        }
        return $$0;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return true;
    }

    @Override
    public boolean shouldShowName() {
        return true;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return !this.abilities.flying && (!this.onGround() || !this.isDiscrete()) ? Entity.MovementEmission.ALL : Entity.MovementEmission.NONE;
    }

    public void onUpdateAbilities() {
    }

    @Override
    public Component getName() {
        return Component.literal(this.gameProfile.getName());
    }

    public PlayerEnderChestContainer getEnderChestInventory() {
        return this.enderChestInventory;
    }

    @Override
    public ItemStack getItemBySlot(EquipmentSlot p_36257_) {
        if (p_36257_ == EquipmentSlot.MAINHAND) {
            return this.inventory.getSelected();
        }
        if (p_36257_ == EquipmentSlot.OFFHAND) {
            return this.inventory.offhand.get(0);
        }
        if (p_36257_.getType() == EquipmentSlot.Type.ARMOR) {
            return this.inventory.armor.get(p_36257_.getIndex());
        }
        return ItemStack.EMPTY;
    }

    @Override
    protected boolean doesEmitEquipEvent(EquipmentSlot p_219741_) {
        return p_219741_.getType() == EquipmentSlot.Type.ARMOR;
    }

    @Override
    public void setItemSlot(EquipmentSlot p_36161_, ItemStack p_36162_) {
        this.verifyEquippedItem(p_36162_);
        if (p_36161_ == EquipmentSlot.MAINHAND) {
            this.onEquipItem(p_36161_, this.inventory.items.set(this.inventory.selected, p_36162_), p_36162_);
        } else if (p_36161_ == EquipmentSlot.OFFHAND) {
            this.onEquipItem(p_36161_, this.inventory.offhand.set(0, p_36162_), p_36162_);
        } else if (p_36161_.getType() == EquipmentSlot.Type.ARMOR) {
            this.onEquipItem(p_36161_, this.inventory.armor.set(p_36161_.getIndex(), p_36162_), p_36162_);
        }
    }

    public boolean addItem(ItemStack p_36357_) {
        return this.inventory.add(p_36357_);
    }

    @Override
    public Iterable<ItemStack> getHandSlots() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getMainHandItem(), this.getOffhandItem()});
    }

    @Override
    public Iterable<ItemStack> getArmorSlots() {
        return this.inventory.armor;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot p_326160_) {
        return p_326160_ != EquipmentSlot.BODY;
    }

    public boolean setEntityOnShoulder(CompoundTag p_36361_) {
        if (this.isPassenger() || !this.onGround() || this.isInWater() || this.isInPowderSnow) {
            return false;
        }
        if (this.getShoulderEntityLeft().isEmpty()) {
            this.setShoulderEntityLeft(p_36361_);
            this.timeEntitySatOnShoulder = this.level().getGameTime();
            return true;
        }
        if (this.getShoulderEntityRight().isEmpty()) {
            this.setShoulderEntityRight(p_36361_);
            this.timeEntitySatOnShoulder = this.level().getGameTime();
            return true;
        }
        return false;
    }

    protected void removeEntitiesOnShoulder() {
        if (this.timeEntitySatOnShoulder + 20L < this.level().getGameTime()) {
            this.respawnEntityOnShoulder(this.getShoulderEntityLeft());
            this.setShoulderEntityLeft(new CompoundTag());
            this.respawnEntityOnShoulder(this.getShoulderEntityRight());
            this.setShoulderEntityRight(new CompoundTag());
        }
    }

    private void respawnEntityOnShoulder(CompoundTag p_36371_) {
        if (!this.level().isClientSide && !p_36371_.isEmpty()) {
            EntityType.create(p_36371_, this.level()).ifPresent(p_337877_ -> {
                if (p_337877_ instanceof TamableAnimal) {
                    ((TamableAnimal)p_337877_).setOwnerUUID(this.uuid);
                }
                p_337877_.setPos(this.getX(), this.getY() + (double)0.7f, this.getZ());
                ((ServerLevel)this.level()).addWithUUID((Entity)p_337877_);
            });
        }
    }

    @Override
    public abstract boolean isSpectator();

    @Override
    public boolean canBeHitByProjectile() {
        return !this.isSpectator() && super.canBeHitByProjectile();
    }

    @Override
    public boolean isSwimming() {
        return !this.abilities.flying && !this.isSpectator() && super.isSwimming();
    }

    public abstract boolean isCreative();

    @Override
    public boolean isPushedByFluid() {
        return !this.abilities.flying;
    }

    public Scoreboard getScoreboard() {
        return this.level().getScoreboard();
    }

    @Override
    public Component getDisplayName() {
        MutableComponent $$0 = PlayerTeam.formatNameForTeam(this.getTeam(), this.getName());
        return this.decorateDisplayNameComponent($$0);
    }

    private MutableComponent decorateDisplayNameComponent(MutableComponent p_36219_) {
        String $$1 = this.getGameProfile().getName();
        return p_36219_.withStyle(p_337880_ -> p_337880_.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tell " + $$1 + " ")).withHoverEvent(this.createHoverEvent()).withInsertion($$1));
    }

    @Override
    public String getScoreboardName() {
        return this.getGameProfile().getName();
    }

    @Override
    protected void internalSetAbsorptionAmount(float p_296426_) {
        this.getEntityData().set(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(p_296426_));
    }

    @Override
    public float getAbsorptionAmount() {
        return this.getEntityData().get(DATA_PLAYER_ABSORPTION_ID).floatValue();
    }

    public boolean isModelPartShown(PlayerModelPart p_36171_) {
        return (this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION) & p_36171_.getMask()) == p_36171_.getMask();
    }

    @Override
    public SlotAccess getSlot(int p_150112_) {
        if (p_150112_ == 499) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return Player.this.containerMenu.getCarried();
                }

                @Override
                public boolean set(ItemStack p_332675_) {
                    Player.this.containerMenu.setCarried(p_332675_);
                    return true;
                }
            };
        }
        final int $$1 = p_150112_ - 500;
        if ($$1 >= 0 && $$1 < 4) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return Player.this.inventoryMenu.getCraftSlots().getItem($$1);
                }

                @Override
                public boolean set(ItemStack p_332810_) {
                    Player.this.inventoryMenu.getCraftSlots().setItem($$1, p_332810_);
                    Player.this.inventoryMenu.slotsChanged(Player.this.inventory);
                    return true;
                }
            };
        }
        if (p_150112_ >= 0 && p_150112_ < this.inventory.items.size()) {
            return SlotAccess.forContainer(this.inventory, p_150112_);
        }
        int $$2 = p_150112_ - 200;
        if ($$2 >= 0 && $$2 < this.enderChestInventory.getContainerSize()) {
            return SlotAccess.forContainer(this.enderChestInventory, $$2);
        }
        return super.getSlot(p_150112_);
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setReducedDebugInfo(boolean p_36394_) {
        this.reducedDebugInfo = p_36394_;
    }

    @Override
    public void setRemainingFireTicks(int p_36353_) {
        super.setRemainingFireTicks(this.abilities.invulnerable ? Math.min(p_36353_, 1) : p_36353_);
    }

    @Override
    public HumanoidArm getMainArm() {
        return this.entityData.get(DATA_PLAYER_MAIN_HAND) == 0 ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public void setMainArm(HumanoidArm p_36164_) {
        this.entityData.set(DATA_PLAYER_MAIN_HAND, (byte)(p_36164_ != HumanoidArm.LEFT ? 1 : 0));
    }

    public CompoundTag getShoulderEntityLeft() {
        return this.entityData.get(DATA_SHOULDER_LEFT);
    }

    protected void setShoulderEntityLeft(CompoundTag p_36363_) {
        this.entityData.set(DATA_SHOULDER_LEFT, p_36363_);
    }

    public CompoundTag getShoulderEntityRight() {
        return this.entityData.get(DATA_SHOULDER_RIGHT);
    }

    protected void setShoulderEntityRight(CompoundTag p_36365_) {
        this.entityData.set(DATA_SHOULDER_RIGHT, p_36365_);
    }

    public float getCurrentItemAttackStrengthDelay() {
        return (float)(1.0 / this.getAttributeValue(Attributes.ATTACK_SPEED) * 20.0);
    }

    public float getAttackStrengthScale(float p_36404_) {
        return Mth.clamp(((float)this.attackStrengthTicker + p_36404_) / this.getCurrentItemAttackStrengthDelay(), 0.0f, 1.0f);
    }

    public void resetAttackStrengthTicker() {
        this.attackStrengthTicker = 0;
    }

    public ItemCooldowns getCooldowns() {
        return this.cooldowns;
    }

    @Override
    protected float getBlockSpeedFactor() {
        return this.abilities.flying || this.isFallFlying() ? 1.0f : super.getBlockSpeedFactor();
    }

    public float getLuck() {
        return (float)this.getAttributeValue(Attributes.LUCK);
    }

    public boolean canUseGameMasterBlocks() {
        return this.abilities.instabuild && this.getPermissionLevel() >= 2;
    }

    @Override
    public boolean canTakeItem(ItemStack p_36315_) {
        EquipmentSlot $$1 = Mob.getEquipmentSlotForItem(p_36315_);
        return this.getItemBySlot($$1).isEmpty();
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose p_36166_) {
        return POSES.getOrDefault((Object)p_36166_, STANDING_DIMENSIONS);
    }

    @Override
    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)Pose.STANDING), (Object)((Object)Pose.CROUCHING), (Object)((Object)Pose.SWIMMING));
    }

    @Override
    public ItemStack getProjectile(ItemStack p_36349_) {
        if (!(p_36349_.getItem() instanceof ProjectileWeaponItem)) {
            return ItemStack.EMPTY;
        }
        Predicate<ItemStack> $$1 = ((ProjectileWeaponItem)p_36349_.getItem()).getSupportedHeldProjectiles();
        ItemStack $$2 = ProjectileWeaponItem.getHeldProjectile(this, $$1);
        if (!$$2.isEmpty()) {
            return $$2;
        }
        $$1 = ((ProjectileWeaponItem)p_36349_.getItem()).getAllSupportedProjectiles();
        for (int $$3 = 0; $$3 < this.inventory.getContainerSize(); ++$$3) {
            ItemStack $$4 = this.inventory.getItem($$3);
            if (!$$1.test($$4)) continue;
            return $$4;
        }
        return this.abilities.instabuild ? new ItemStack(Items.ARROW) : ItemStack.EMPTY;
    }

    @Override
    public ItemStack eat(Level p_36185_, ItemStack p_36186_) {
        this.getFoodData().eat(p_36186_);
        this.awardStat(Stats.ITEM_USED.get(p_36186_.getItem()));
        p_36185_.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, p_36185_.random.nextFloat() * 0.1f + 0.9f);
        if (this instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)this, p_36186_);
        }
        return super.eat(p_36185_, p_36186_);
    }

    @Override
    protected boolean shouldRemoveSoulSpeed(BlockState p_36262_) {
        return this.abilities.flying || super.shouldRemoveSoulSpeed(p_36262_);
    }

    @Override
    public Vec3 getRopeHoldPosition(float p_36374_) {
        double $$1 = 0.22 * (this.getMainArm() == HumanoidArm.RIGHT ? -1.0 : 1.0);
        float $$2 = Mth.lerp(p_36374_ * 0.5f, this.getXRot(), this.xRotO) * ((float)Math.PI / 180);
        float $$3 = Mth.lerp(p_36374_, this.yBodyRotO, this.yBodyRot) * ((float)Math.PI / 180);
        if (this.isFallFlying() || this.isAutoSpinAttack()) {
            float $$11;
            Vec3 $$4 = this.getViewVector(p_36374_);
            Vec3 $$5 = this.getDeltaMovement();
            double $$6 = $$5.horizontalDistanceSqr();
            double $$7 = $$4.horizontalDistanceSqr();
            if ($$6 > 0.0 && $$7 > 0.0) {
                double $$8 = ($$5.x * $$4.x + $$5.z * $$4.z) / Math.sqrt($$6 * $$7);
                double $$9 = $$5.x * $$4.z - $$5.z * $$4.x;
                float $$10 = (float)(Math.signum($$9) * Math.acos($$8));
            } else {
                $$11 = 0.0f;
            }
            return this.getPosition(p_36374_).add(new Vec3($$1, -0.11, 0.85).zRot(-$$11).xRot(-$$2).yRot(-$$3));
        }
        if (this.isVisuallySwimming()) {
            return this.getPosition(p_36374_).add(new Vec3($$1, 0.2, -0.15).xRot(-$$2).yRot(-$$3));
        }
        double $$12 = this.getBoundingBox().getYsize() - 1.0;
        double $$13 = this.isCrouching() ? -0.2 : 0.07;
        return this.getPosition(p_36374_).add(new Vec3($$1, $$12, $$13).yRot(-$$3));
    }

    @Override
    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean isScoping() {
        return this.isUsingItem() && this.getUseItem().is(Items.SPYGLASS);
    }

    @Override
    public boolean shouldBeSaved() {
        return false;
    }

    public Optional<GlobalPos> getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(Optional<GlobalPos> p_219750_) {
        this.lastDeathLocation = p_219750_;
    }

    @Override
    public float getHurtDir() {
        return this.hurtDir;
    }

    @Override
    public void animateHurt(float p_265280_) {
        super.animateHurt(p_265280_);
        this.hurtDir = p_265280_;
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected float getFlyingSpeed() {
        if (this.abilities.flying && !this.isPassenger()) {
            return this.isSprinting() ? this.abilities.getFlyingSpeed() * 2.0f : this.abilities.getFlyingSpeed();
        }
        return this.isSprinting() ? 0.025999999f : 0.02f;
    }

    public double blockInteractionRange() {
        return this.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
    }

    public double entityInteractionRange() {
        return this.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
    }

    public boolean canInteractWithEntity(Entity p_320327_, double p_320632_) {
        if (p_320327_.isRemoved()) {
            return false;
        }
        return this.canInteractWithEntity(p_320327_.getBoundingBox(), p_320632_);
    }

    public boolean canInteractWithEntity(AABB p_320959_, double p_319981_) {
        double $$2 = this.entityInteractionRange() + p_319981_;
        return p_320959_.distanceToSqr(this.getEyePosition()) < $$2 * $$2;
    }

    public boolean canInteractWithBlock(BlockPos p_319804_, double p_320349_) {
        double $$2 = this.blockInteractionRange() + p_320349_;
        return new AABB(p_319804_).distanceToSqr(this.getEyePosition()) < $$2 * $$2;
    }

    public void resetCurrentImpulseContext() {
        this.currentExplosionCause = null;
        this.currentImpulseImpactPos = null;
        this.ignoreFallDamageFromCurrentImpulse = false;
    }

    public static enum BedSleepingProblem {
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW(Component.translatable("block.minecraft.bed.no_sleep")),
        TOO_FAR_AWAY(Component.translatable("block.minecraft.bed.too_far_away")),
        OBSTRUCTED(Component.translatable("block.minecraft.bed.obstructed")),
        OTHER_PROBLEM,
        NOT_SAFE(Component.translatable("block.minecraft.bed.not_safe"));

        @Nullable
        private final Component message;

        private BedSleepingProblem() {
            this.message = null;
        }

        private BedSleepingProblem(Component p_36422_) {
            this.message = p_36422_;
        }

        @Nullable
        public Component getMessage() {
            return this.message;
        }
    }
}

