/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractArrow
extends Projectile {
    private static final double ARROW_BASE_DAMAGE = 2.0;
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.defineId(AbstractArrow.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.defineId(AbstractArrow.class, EntityDataSerializers.BYTE);
    private static final int FLAG_CRIT = 1;
    private static final int FLAG_NOPHYSICS = 2;
    private static final int FLAG_CROSSBOW = 4;
    @Nullable
    private BlockState lastState;
    protected boolean inGround;
    protected int inGroundTime;
    public Pickup pickup = Pickup.DISALLOWED;
    public int shakeTime;
    private int life;
    private double baseDamage = 2.0;
    private int knockback;
    private SoundEvent soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    private ItemStack pickupItemStack = this.getDefaultPickupItem();

    protected AbstractArrow(EntityType<? extends AbstractArrow> p_331098_, Level p_331626_) {
        super((EntityType<? extends Projectile>)p_331098_, p_331626_);
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> p_36711_, Level p_36715_, ItemStack p_308982_) {
        this(p_36711_, p_36715_);
        this.pickupItemStack = p_308982_.copy();
        this.setCustomName(p_308982_.get(DataComponents.CUSTOM_NAME));
        Unit $$3 = p_308982_.remove(DataComponents.INTANGIBLE_PROJECTILE);
        if ($$3 != null) {
            this.pickup = Pickup.CREATIVE_ONLY;
        }
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> p_36721_, double p_309157_, double p_309022_, double p_308962_, Level p_36722_, ItemStack p_309145_) {
        this(p_36721_, p_36722_, p_309145_);
        this.setPos(p_309157_, p_309022_, p_308962_);
    }

    protected AbstractArrow(EntityType<? extends AbstractArrow> p_36717_, LivingEntity p_36718_, Level p_36719_, ItemStack p_309031_) {
        this(p_36717_, p_36718_.getX(), p_36718_.getEyeY() - (double)0.1f, p_36718_.getZ(), p_36719_, p_309031_);
        this.setOwner(p_36718_);
    }

    public void setSoundEvent(SoundEvent p_36741_) {
        this.soundEvent = p_36741_;
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_36726_) {
        double $$1 = this.getBoundingBox().getSize() * 10.0;
        if (Double.isNaN($$1)) {
            $$1 = 1.0;
        }
        return p_36726_ < ($$1 *= 64.0 * AbstractArrow.getViewScale()) * $$1;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325945_) {
        p_325945_.define(ID_FLAGS, (byte)0);
        p_325945_.define(PIERCE_LEVEL, (byte)0);
    }

    @Override
    public void shoot(double p_36775_, double p_36776_, double p_36777_, float p_36778_, float p_36779_) {
        super.shoot(p_36775_, p_36776_, p_36777_, p_36778_, p_36779_);
        this.life = 0;
    }

    @Override
    public void lerpTo(double p_36728_, double p_36729_, double p_36730_, float p_36731_, float p_36732_, int p_36733_) {
        this.setPos(p_36728_, p_36729_, p_36730_);
        this.setRot(p_36731_, p_36732_);
    }

    @Override
    public void lerpMotion(double p_36786_, double p_36787_, double p_36788_) {
        super.lerpMotion(p_36786_, p_36787_, p_36788_);
        this.life = 0;
    }

    @Override
    public void tick() {
        VoxelShape $$5;
        super.tick();
        boolean $$0 = this.isNoPhysics();
        Vec3 $$1 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double $$2 = $$1.horizontalDistance();
            this.setYRot((float)(Mth.atan2($$1.x, $$1.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2($$1.y, $$2) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos $$3 = this.blockPosition();
        BlockState $$4 = this.level().getBlockState($$3);
        if (!($$4.isAir() || $$0 || ($$5 = $$4.getCollisionShape(this.level(), $$3)).isEmpty())) {
            Vec3 $$6 = this.position();
            for (AABB $$7 : $$5.toAabbs()) {
                if (!$$7.move($$3).contains($$6)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain() || $$4.is(Blocks.POWDER_SNOW)) {
            this.clearFire();
        }
        if (this.inGround && !$$0) {
            if (this.lastState != $$4 && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
            return;
        }
        this.inGroundTime = 0;
        Vec3 $$8 = this.position();
        Vec3 $$9 = $$8.add($$1);
        HitResult $$10 = this.level().clip(new ClipContext($$8, $$9, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this));
        if ($$10.getType() != HitResult.Type.MISS) {
            $$9 = $$10.getLocation();
        }
        while (!this.isRemoved()) {
            EntityHitResult $$11 = this.findHitEntity($$8, $$9);
            if ($$11 != null) {
                $$10 = $$11;
            }
            if ($$10 != null && $$10.getType() == HitResult.Type.ENTITY) {
                Entity $$12 = ((EntityHitResult)$$10).getEntity();
                Entity $$13 = this.getOwner();
                if ($$12 instanceof Player && $$13 instanceof Player && !((Player)$$13).canHarmPlayer((Player)$$12)) {
                    $$10 = null;
                    $$11 = null;
                }
            }
            if ($$10 != null && !$$0) {
                ProjectileDeflection $$14 = this.hitTargetOrDeflectSelf($$10);
                this.hasImpulse = true;
                if ($$14 != ProjectileDeflection.NONE) break;
            }
            if ($$11 == null || this.getPierceLevel() <= 0) break;
            $$10 = null;
        }
        $$1 = this.getDeltaMovement();
        double $$15 = $$1.x;
        double $$16 = $$1.y;
        double $$17 = $$1.z;
        if (this.isCritArrow()) {
            for (int $$18 = 0; $$18 < 4; ++$$18) {
                this.level().addParticle(ParticleTypes.CRIT, this.getX() + $$15 * (double)$$18 / 4.0, this.getY() + $$16 * (double)$$18 / 4.0, this.getZ() + $$17 * (double)$$18 / 4.0, -$$15, -$$16 + 0.2, -$$17);
            }
        }
        double $$19 = this.getX() + $$15;
        double $$20 = this.getY() + $$16;
        double $$21 = this.getZ() + $$17;
        double $$22 = $$1.horizontalDistance();
        if ($$0) {
            this.setYRot((float)(Mth.atan2(-$$15, -$$17) * 57.2957763671875));
        } else {
            this.setYRot((float)(Mth.atan2($$15, $$17) * 57.2957763671875));
        }
        this.setXRot((float)(Mth.atan2($$16, $$22) * 57.2957763671875));
        this.setXRot(AbstractArrow.lerpRotation(this.xRotO, this.getXRot()));
        this.setYRot(AbstractArrow.lerpRotation(this.yRotO, this.getYRot()));
        float $$23 = 0.99f;
        if (this.isInWater()) {
            for (int $$24 = 0; $$24 < 4; ++$$24) {
                float $$25 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, $$19 - $$15 * 0.25, $$20 - $$16 * 0.25, $$21 - $$17 * 0.25, $$15, $$16, $$17);
            }
            $$23 = this.getWaterInertia();
        }
        this.setDeltaMovement($$1.scale($$23));
        if (!$$0) {
            this.applyGravity();
        }
        this.setPos($$19, $$20, $$21);
        this.checkInsideBlocks();
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    private boolean shouldFall() {
        return this.inGround && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 $$0 = this.getDeltaMovement();
        this.setDeltaMovement($$0.multiply(this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f, this.random.nextFloat() * 0.2f));
        this.life = 0;
    }

    @Override
    public void move(MoverType p_36749_, Vec3 p_36750_) {
        super.move(p_36749_, p_36750_);
        if (p_36749_ != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.discard();
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult p_36757_) {
        DamageSource $$7;
        Entity $$5;
        super.onHitEntity(p_36757_);
        Entity $$1 = p_36757_.getEntity();
        float $$2 = (float)this.getDeltaMovement().length();
        int $$3 = Mth.ceil(Mth.clamp((double)$$2 * this.baseDamage, 0.0, 2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() < this.getPierceLevel() + 1) {
                this.piercingIgnoreEntityIds.add($$1.getId());
            } else {
                this.discard();
                return;
            }
        }
        if (this.isCritArrow()) {
            long $$4 = this.random.nextInt($$3 / 2 + 2);
            $$3 = (int)Math.min($$4 + (long)$$3, Integer.MAX_VALUE);
        }
        if (($$5 = this.getOwner()) == null) {
            DamageSource $$6 = this.damageSources().arrow(this, this);
        } else {
            $$7 = this.damageSources().arrow(this, $$5);
            if ($$5 instanceof LivingEntity) {
                ((LivingEntity)$$5).setLastHurtMob($$1);
            }
        }
        boolean $$8 = $$1.getType() == EntityType.ENDERMAN;
        int $$9 = $$1.getRemainingFireTicks();
        if (this.isOnFire() && !$$8) {
            $$1.igniteForSeconds(5);
        }
        if ($$1.hurt($$7, $$3)) {
            if ($$8) {
                return;
            }
            if ($$1 instanceof LivingEntity) {
                LivingEntity $$10 = (LivingEntity)$$1;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    $$10.setArrowCount($$10.getArrowCount() + 1);
                }
                if (this.knockback > 0) {
                    double $$11 = Math.max(0.0, 1.0 - $$10.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                    Vec3 $$12 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * $$11);
                    if ($$12.lengthSqr() > 0.0) {
                        $$10.push($$12.x, 0.1, $$12.z);
                    }
                }
                if (!this.level().isClientSide && $$5 instanceof LivingEntity) {
                    EnchantmentHelper.doPostHurtEffects($$10, $$5);
                    EnchantmentHelper.doPostDamageEffects((LivingEntity)$$5, $$10);
                }
                this.doPostHurtEffects($$10);
                if ($$5 != null && $$10 != $$5 && $$10 instanceof Player && $$5 instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)$$5).connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!$$1.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add($$10);
                }
                if (!this.level().isClientSide && $$5 instanceof ServerPlayer) {
                    ServerPlayer $$13 = (ServerPlayer)$$5;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger($$13, this.piercedAndKilledEntities);
                    } else if (!$$1.isAlive() && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger($$13, Arrays.asList($$1));
                    }
                }
            }
            this.playSound(this.soundEvent, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            $$1.setRemainingFireTicks($$9);
            this.deflect(ProjectileDeflection.REVERSE, $$1, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult p_36755_) {
        this.lastState = this.level().getBlockState(p_36755_.getBlockPos());
        super.onHitBlock(p_36755_);
        Vec3 $$1 = p_36755_.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement($$1);
        Vec3 $$2 = $$1.normalize().scale(0.05f);
        this.setPosRaw(this.getX() - $$2.x, this.getY() - $$2.y, this.getZ() - $$2.z);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEvents.ARROW_HIT);
        this.setShotFromCrossbow(false);
        this.resetPiercedEntities();
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.ARROW_HIT;
    }

    protected final SoundEvent getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(LivingEntity p_36744_) {
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_36758_, Vec3 p_36759_) {
        return ProjectileUtil.getEntityHitResult(this.level(), this, p_36758_, p_36759_, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    @Override
    protected boolean canHitEntity(Entity p_36743_) {
        return super.canHitEntity(p_36743_) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(p_36743_.getId()));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_36772_) {
        super.addAdditionalSaveData(p_36772_);
        p_36772_.putShort("life", (short)this.life);
        if (this.lastState != null) {
            p_36772_.put("inBlockState", NbtUtils.writeBlockState(this.lastState));
        }
        p_36772_.putByte("shake", (byte)this.shakeTime);
        p_36772_.putBoolean("inGround", this.inGround);
        p_36772_.putByte("pickup", (byte)this.pickup.ordinal());
        p_36772_.putDouble("damage", this.baseDamage);
        p_36772_.putBoolean("crit", this.isCritArrow());
        p_36772_.putByte("PierceLevel", this.getPierceLevel());
        p_36772_.putString("SoundEvent", BuiltInRegistries.SOUND_EVENT.getKey(this.soundEvent).toString());
        p_36772_.putBoolean("ShotFromCrossbow", this.shotFromCrossbow());
        p_36772_.put("item", this.pickupItemStack.save(this.registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_36761_) {
        super.readAdditionalSaveData(p_36761_);
        this.life = p_36761_.getShort("life");
        if (p_36761_.contains("inBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), p_36761_.getCompound("inBlockState"));
        }
        this.shakeTime = p_36761_.getByte("shake") & 0xFF;
        this.inGround = p_36761_.getBoolean("inGround");
        if (p_36761_.contains("damage", 99)) {
            this.baseDamage = p_36761_.getDouble("damage");
        }
        this.pickup = Pickup.byOrdinal(p_36761_.getByte("pickup"));
        this.setCritArrow(p_36761_.getBoolean("crit"));
        this.setPierceLevel(p_36761_.getByte("PierceLevel"));
        if (p_36761_.contains("SoundEvent", 8)) {
            this.soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(new ResourceLocation(p_36761_.getString("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        this.setShotFromCrossbow(p_36761_.getBoolean("ShotFromCrossbow"));
        if (p_36761_.contains("item", 10)) {
            this.setPickupItemStack(ItemStack.parse(this.registryAccess(), p_36761_.getCompound("item")).orElse(this.getDefaultPickupItem()));
        } else {
            this.setPickupItemStack(this.getDefaultPickupItem());
        }
    }

    @Override
    public void setOwner(@Nullable Entity p_36770_) {
        super.setOwner(p_36770_);
        if (p_36770_ instanceof Player && this.pickup == Pickup.DISALLOWED) {
            this.pickup = Pickup.ALLOWED;
        }
    }

    @Override
    public void playerTouch(Player p_36766_) {
        if (this.level().isClientSide || !this.inGround && !this.isNoPhysics() || this.shakeTime > 0) {
            return;
        }
        if (this.tryPickup(p_36766_)) {
            p_36766_.take(this, 1);
            this.discard();
        }
    }

    protected boolean tryPickup(Player p_150121_) {
        return switch (this.pickup.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> false;
            case 1 -> p_150121_.getInventory().add(this.getPickupItem());
            case 2 -> p_150121_.hasInfiniteMaterials();
        };
    }

    protected ItemStack getPickupItem() {
        return this.pickupItemStack.copy();
    }

    protected abstract ItemStack getDefaultPickupItem();

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public ItemStack getPickupItemStackOrigin() {
        return this.pickupItemStack;
    }

    public void setBaseDamage(double p_36782_) {
        this.baseDamage = p_36782_;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setKnockback(int p_36736_) {
        this.knockback = p_36736_;
    }

    public int getKnockback() {
        return this.knockback;
    }

    @Override
    public boolean isAttackable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    public void setCritArrow(boolean p_36763_) {
        this.setFlag(1, p_36763_);
    }

    public void setPierceLevel(byte p_36768_) {
        this.entityData.set(PIERCE_LEVEL, p_36768_);
    }

    private void setFlag(int p_36738_, boolean p_36739_) {
        byte $$2 = this.entityData.get(ID_FLAGS);
        if (p_36739_) {
            this.entityData.set(ID_FLAGS, (byte)($$2 | p_36738_));
        } else {
            this.entityData.set(ID_FLAGS, (byte)($$2 & ~p_36738_));
        }
    }

    protected void setPickupItemStack(ItemStack p_331486_) {
        this.pickupItemStack = !p_331486_.isEmpty() ? p_331486_ : this.getDefaultPickupItem();
    }

    public boolean isCritArrow() {
        byte $$0 = this.entityData.get(ID_FLAGS);
        return ($$0 & 1) != 0;
    }

    public boolean shotFromCrossbow() {
        byte $$0 = this.entityData.get(ID_FLAGS);
        return ($$0 & 4) != 0;
    }

    public byte getPierceLevel() {
        return this.entityData.get(PIERCE_LEVEL);
    }

    public void setEnchantmentEffectsFromEntity(LivingEntity p_36746_, float p_36747_) {
        int $$2 = EnchantmentHelper.getEnchantmentLevel(Enchantments.POWER, p_36746_);
        int $$3 = EnchantmentHelper.getEnchantmentLevel(Enchantments.PUNCH, p_36746_);
        this.setBaseDamage((double)(p_36747_ * 2.0f) + this.random.triangle((double)this.level().getDifficulty().getId() * 0.11, 0.57425));
        if ($$2 > 0) {
            this.setBaseDamage(this.getBaseDamage() + (double)$$2 * 0.5 + 0.5);
        }
        if ($$3 > 0) {
            this.setKnockback($$3);
        }
        if (EnchantmentHelper.getEnchantmentLevel(Enchantments.FLAME, p_36746_) > 0) {
            this.igniteForSeconds(100);
        }
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean p_36791_) {
        this.noPhysics = p_36791_;
        this.setFlag(2, p_36791_);
    }

    public boolean isNoPhysics() {
        if (!this.level().isClientSide) {
            return this.noPhysics;
        }
        return (this.entityData.get(ID_FLAGS) & 2) != 0;
    }

    public void setShotFromCrossbow(boolean p_36794_) {
        this.setFlag(4, p_36794_);
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.inGround;
    }

    @Override
    public SlotAccess getSlot(int p_341328_) {
        if (p_341328_ == 0) {
            return SlotAccess.of(this::getPickupItemStackOrigin, this::setPickupItemStack);
        }
        return super.getSlot(p_341328_);
    }

    public static enum Pickup {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static Pickup byOrdinal(int p_36809_) {
            if (p_36809_ < 0 || p_36809_ > Pickup.values().length) {
                p_36809_ = 0;
            }
            return Pickup.values()[p_36809_];
        }
    }
}

