/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractHurtingProjectile
extends Projectile {
    public static final double ATTACK_DEFLECTION_SCALE = 0.1;
    public static final double BOUNCE_DEFLECTION_SCALE = 0.05;
    public double xPower;
    public double yPower;
    public double zPower;

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super((EntityType<? extends Projectile>)p_36833_, p_36834_);
    }

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> p_312669_, double p_312561_, double p_312829_, double p_312607_, Level p_312011_) {
        this(p_312669_, p_312011_);
        this.setPos(p_312561_, p_312829_, p_312607_);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> p_36817_, double p_36818_, double p_36819_, double p_36820_, double p_36821_, double p_36822_, double p_36823_, Level p_36824_) {
        this(p_36817_, p_36824_);
        this.moveTo(p_36818_, p_36819_, p_36820_, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignPower(p_36821_, p_36822_, p_36823_);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> p_36826_, LivingEntity p_36827_, double p_36828_, double p_36829_, double p_36830_, Level p_36831_) {
        this(p_36826_, p_36827_.getX(), p_36827_.getY(), p_36827_.getZ(), p_36828_, p_36829_, p_36830_, p_36831_);
        this.setOwner(p_36827_);
        this.setRot(p_36827_.getYRot(), p_36827_.getXRot());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326181_) {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_36837_) {
        double $$1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN($$1)) {
            $$1 = 4.0;
        }
        return p_36837_ < ($$1 *= 64.0) * $$1;
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    @Override
    public void tick() {
        float $$9;
        HitResult $$1;
        Entity $$0 = this.getOwner();
        if (!this.level().isClientSide && ($$0 != null && $$0.isRemoved() || !this.level().hasChunkAt(this.blockPosition()))) {
            this.discard();
            return;
        }
        super.tick();
        if (this.shouldBurn()) {
            this.igniteForSeconds(1);
        }
        if (($$1 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity, this.getClipType())).getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf($$1);
        }
        this.checkInsideBlocks();
        Vec3 $$2 = this.getDeltaMovement();
        double $$3 = this.getX() + $$2.x;
        double $$4 = this.getY() + $$2.y;
        double $$5 = this.getZ() + $$2.z;
        ProjectileUtil.rotateTowardsMovement(this, 0.2f);
        if (this.isInWater()) {
            for (int $$6 = 0; $$6 < 4; ++$$6) {
                float $$7 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, $$3 - $$2.x * 0.25, $$4 - $$2.y * 0.25, $$5 - $$2.z * 0.25, $$2.x, $$2.y, $$2.z);
            }
            float $$8 = this.getLiquidInertia();
        } else {
            $$9 = this.getInertia();
        }
        this.setDeltaMovement($$2.add(this.xPower, this.yPower, this.zPower).scale($$9));
        ParticleOptions $$10 = this.getTrailParticle();
        if ($$10 != null) {
            this.level().addParticle($$10, $$3, $$4 + 0.5, $$5, 0.0, 0.0, 0.0);
        }
        this.setPos($$3, $$4, $$5);
    }

    @Override
    public boolean hurt(DamageSource p_341896_, float p_341906_) {
        return !this.isInvulnerableTo(p_341896_);
    }

    @Override
    protected boolean canHitEntity(Entity p_36842_) {
        return super.canHitEntity(p_36842_) && !p_36842_.noPhysics;
    }

    protected boolean shouldBurn() {
        return true;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SMOKE;
    }

    protected float getInertia() {
        return 0.95f;
    }

    protected float getLiquidInertia() {
        return 0.8f;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_36848_) {
        super.addAdditionalSaveData(p_36848_);
        p_36848_.put("power", this.newDoubleList(this.xPower, this.yPower, this.zPower));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_36844_) {
        ListTag $$1;
        super.readAdditionalSaveData(p_36844_);
        if (p_36844_.contains("power", 9) && ($$1 = p_36844_.getList("power", 6)).size() == 3) {
            this.xPower = $$1.getDouble(0);
            this.yPower = $$1.getDouble(1);
            this.zPower = $$1.getDouble(2);
        }
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        Entity $$0 = this.getOwner();
        int $$1 = $$0 == null ? 0 : $$0.getId();
        return new ClientboundAddEntityPacket(this.getId(), this.getUUID(), this.getX(), this.getY(), this.getZ(), this.getXRot(), this.getYRot(), this.getType(), $$1, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket p_150128_) {
        super.recreateFromPacket(p_150128_);
        double $$1 = p_150128_.getXa();
        double $$2 = p_150128_.getYa();
        double $$3 = p_150128_.getZa();
        this.assignPower($$1, $$2, $$3);
    }

    private void assignPower(double p_333940_, double p_334030_, double p_333897_) {
        double $$3 = Math.sqrt(p_333940_ * p_333940_ + p_334030_ * p_334030_ + p_333897_ * p_333897_);
        if ($$3 != 0.0) {
            this.xPower = p_333940_ / $$3 * 0.1;
            this.yPower = p_334030_ / $$3 * 0.1;
            this.zPower = p_333897_ / $$3 * 0.1;
        }
    }

    @Override
    protected void onDeflection(@Nullable Entity p_341940_, boolean p_341895_) {
        super.onDeflection(p_341940_, p_341895_);
        if (p_341895_) {
            this.xPower = this.getDeltaMovement().x * 0.1;
            this.yPower = this.getDeltaMovement().y * 0.1;
            this.zPower = this.getDeltaMovement().z * 0.1;
        } else {
            this.xPower = this.getDeltaMovement().x * 0.05;
            this.yPower = this.getDeltaMovement().y * 0.05;
            this.zPower = this.getDeltaMovement().z * 0.05;
        }
    }
}

