/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class ProjectileUtil {
    private static final float DEFAULT_ENTITY_HIT_RESULT_MARGIN = 0.3f;

    public static HitResult getHitResultOnMoveVector(Entity p_278228_, Predicate<Entity> p_278315_) {
        Vec3 $$2 = p_278228_.getDeltaMovement();
        Level $$3 = p_278228_.level();
        Vec3 $$4 = p_278228_.position();
        return ProjectileUtil.getHitResult($$4, p_278228_, p_278315_, $$2, $$3, 0.3f, ClipContext.Block.COLLIDER);
    }

    public static HitResult getHitResultOnMoveVector(Entity p_312047_, Predicate<Entity> p_312251_, ClipContext.Block p_311921_) {
        Vec3 $$3 = p_312047_.getDeltaMovement();
        Level $$4 = p_312047_.level();
        Vec3 $$5 = p_312047_.position();
        return ProjectileUtil.getHitResult($$5, p_312047_, p_312251_, $$3, $$4, 0.3f, p_311921_);
    }

    public static HitResult getHitResultOnViewVector(Entity p_278281_, Predicate<Entity> p_278306_, double p_278293_) {
        Vec3 $$3 = p_278281_.getViewVector(0.0f).scale(p_278293_);
        Level $$4 = p_278281_.level();
        Vec3 $$5 = p_278281_.getEyePosition();
        return ProjectileUtil.getHitResult($$5, p_278281_, p_278306_, $$3, $$4, 0.0f, ClipContext.Block.COLLIDER);
    }

    private static HitResult getHitResult(Vec3 p_278237_, Entity p_278320_, Predicate<Entity> p_278257_, Vec3 p_278342_, Level p_278321_, float p_305813_, ClipContext.Block p_312920_) {
        EntityHitResult $$9;
        Vec3 $$7 = p_278237_.add(p_278342_);
        HitResult $$8 = p_278321_.clip(new ClipContext(p_278237_, $$7, p_312920_, ClipContext.Fluid.NONE, p_278320_));
        if (((HitResult)$$8).getType() != HitResult.Type.MISS) {
            $$7 = $$8.getLocation();
        }
        if (($$9 = ProjectileUtil.getEntityHitResult(p_278321_, p_278320_, p_278237_, $$7, p_278320_.getBoundingBox().expandTowards(p_278342_).inflate(1.0), p_278257_, p_305813_)) != null) {
            $$8 = $$9;
        }
        return $$8;
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Entity p_37288_, Vec3 p_37289_, Vec3 p_37290_, AABB p_37291_, Predicate<Entity> p_37292_, double p_37293_) {
        Level $$6 = p_37288_.level();
        double $$7 = p_37293_;
        Entity $$8 = null;
        Vec3 $$9 = null;
        for (Entity $$10 : $$6.getEntities(p_37288_, p_37291_, p_37292_)) {
            Vec3 $$13;
            double $$14;
            AABB $$11 = $$10.getBoundingBox().inflate($$10.getPickRadius());
            Optional<Vec3> $$12 = $$11.clip(p_37289_, p_37290_);
            if ($$11.contains(p_37289_)) {
                if (!($$7 >= 0.0)) continue;
                $$8 = $$10;
                $$9 = $$12.orElse(p_37289_);
                $$7 = 0.0;
                continue;
            }
            if (!$$12.isPresent() || !(($$14 = p_37289_.distanceToSqr($$13 = $$12.get())) < $$7) && $$7 != 0.0) continue;
            if ($$10.getRootVehicle() == p_37288_.getRootVehicle()) {
                if ($$7 != 0.0) continue;
                $$8 = $$10;
                $$9 = $$13;
                continue;
            }
            $$8 = $$10;
            $$9 = $$13;
            $$7 = $$14;
        }
        if ($$8 == null) {
            return null;
        }
        return new EntityHitResult($$8, $$9);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level p_37305_, Entity p_37306_, Vec3 p_37307_, Vec3 p_37308_, AABB p_37309_, Predicate<Entity> p_37310_) {
        return ProjectileUtil.getEntityHitResult(p_37305_, p_37306_, p_37307_, p_37308_, p_37309_, p_37310_, 0.3f);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level p_150176_, Entity p_150177_, Vec3 p_150178_, Vec3 p_150179_, AABB p_150180_, Predicate<Entity> p_150181_, float p_150182_) {
        double $$7 = Double.MAX_VALUE;
        Entity $$8 = null;
        for (Entity $$9 : p_150176_.getEntities(p_150177_, p_150180_, p_150181_)) {
            double $$12;
            AABB $$10 = $$9.getBoundingBox().inflate(p_150182_);
            Optional<Vec3> $$11 = $$10.clip(p_150178_, p_150179_);
            if (!$$11.isPresent() || !(($$12 = p_150178_.distanceToSqr($$11.get())) < $$7)) continue;
            $$8 = $$9;
            $$7 = $$12;
        }
        if ($$8 == null) {
            return null;
        }
        return new EntityHitResult($$8);
    }

    public static void rotateTowardsMovement(Entity p_37285_, float p_37286_) {
        Vec3 $$2 = p_37285_.getDeltaMovement();
        if ($$2.lengthSqr() == 0.0) {
            return;
        }
        double $$3 = $$2.horizontalDistance();
        p_37285_.setYRot((float)(Mth.atan2($$2.z, $$2.x) * 57.2957763671875) + 90.0f);
        p_37285_.setXRot((float)(Mth.atan2($$3, $$2.y) * 57.2957763671875) - 90.0f);
        while (p_37285_.getXRot() - p_37285_.xRotO < -180.0f) {
            p_37285_.xRotO -= 360.0f;
        }
        while (p_37285_.getXRot() - p_37285_.xRotO >= 180.0f) {
            p_37285_.xRotO += 360.0f;
        }
        while (p_37285_.getYRot() - p_37285_.yRotO < -180.0f) {
            p_37285_.yRotO -= 360.0f;
        }
        while (p_37285_.getYRot() - p_37285_.yRotO >= 180.0f) {
            p_37285_.yRotO += 360.0f;
        }
        p_37285_.setXRot(Mth.lerp(p_37286_, p_37285_.xRotO, p_37285_.getXRot()));
        p_37285_.setYRot(Mth.lerp(p_37286_, p_37285_.yRotO, p_37285_.getYRot()));
    }

    public static InteractionHand getWeaponHoldingHand(LivingEntity p_37298_, Item p_37299_) {
        return p_37298_.getMainHandItem().is(p_37299_) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static AbstractArrow getMobArrow(LivingEntity p_37301_, ItemStack p_37302_, float p_37303_) {
        ArrowItem $$3 = (ArrowItem)(p_37302_.getItem() instanceof ArrowItem ? p_37302_.getItem() : Items.ARROW);
        AbstractArrow $$4 = $$3.createArrow(p_37301_.level(), p_37302_, p_37301_);
        $$4.setEnchantmentEffectsFromEntity(p_37301_, p_37303_);
        return $$4;
    }
}

