/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class ThrowableProjectile
extends Projectile {
    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super((EntityType<? extends Projectile>)p_37466_, p_37467_);
    }

    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> p_37456_, double p_37457_, double p_37458_, double p_37459_, Level p_37460_) {
        this(p_37456_, p_37460_);
        this.setPos(p_37457_, p_37458_, p_37459_);
    }

    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> p_37462_, LivingEntity p_37463_, Level p_37464_) {
        this(p_37462_, p_37463_.getX(), p_37463_.getEyeY() - (double)0.1f, p_37463_.getZ(), p_37464_);
        this.setOwner(p_37463_);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_37470_) {
        double $$1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN($$1)) {
            $$1 = 4.0;
        }
        return p_37470_ < ($$1 *= 64.0) * $$1;
    }

    @Override
    public void tick() {
        float $$12;
        super.tick();
        HitResult $$0 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        boolean $$1 = false;
        if ($$0.getType() == HitResult.Type.BLOCK) {
            BlockPos $$2 = ((BlockHitResult)$$0).getBlockPos();
            BlockState $$3 = this.level().getBlockState($$2);
            if ($$3.is(Blocks.NETHER_PORTAL)) {
                this.handleInsidePortal($$2);
                $$1 = true;
            } else if ($$3.is(Blocks.END_GATEWAY)) {
                BlockEntity $$4 = this.level().getBlockEntity($$2);
                if ($$4 instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.canEntityTeleport(this)) {
                    TheEndGatewayBlockEntity.teleportEntity(this.level(), $$2, $$3, this, (TheEndGatewayBlockEntity)$$4);
                }
                $$1 = true;
            }
        }
        if ($$0.getType() != HitResult.Type.MISS && !$$1) {
            this.hitTargetOrDeflectSelf($$0);
        }
        this.checkInsideBlocks();
        Vec3 $$5 = this.getDeltaMovement();
        double $$6 = this.getX() + $$5.x;
        double $$7 = this.getY() + $$5.y;
        double $$8 = this.getZ() + $$5.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int $$9 = 0; $$9 < 4; ++$$9) {
                float $$10 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, $$6 - $$5.x * 0.25, $$7 - $$5.y * 0.25, $$8 - $$5.z * 0.25, $$5.x, $$5.y, $$5.z);
            }
            float $$11 = 0.8f;
        } else {
            $$12 = 0.99f;
        }
        this.setDeltaMovement($$5.scale($$12));
        this.applyGravity();
        this.setPos($$6, $$7, $$8);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }
}

