/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class WitherSkull
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.defineId(WitherSkull.class, EntityDataSerializers.BOOLEAN);

    public WitherSkull(EntityType<? extends WitherSkull> p_37598_, Level p_37599_) {
        super((EntityType<? extends AbstractHurtingProjectile>)p_37598_, p_37599_);
    }

    public WitherSkull(Level p_37609_, LivingEntity p_37610_, double p_37611_, double p_37612_, double p_37613_) {
        super(EntityType.WITHER_SKULL, p_37610_, p_37611_, p_37612_, p_37613_, p_37609_);
    }

    @Override
    protected float getInertia() {
        return this.isDangerous() ? 0.73f : super.getInertia();
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    public float getBlockExplosionResistance(Explosion p_37619_, BlockGetter p_37620_, BlockPos p_37621_, BlockState p_37622_, FluidState p_37623_, float p_37624_) {
        if (this.isDangerous() && WitherBoss.canDestroy(p_37622_)) {
            return Math.min(0.8f, p_37624_);
        }
        return p_37624_;
    }

    @Override
    protected void onHitEntity(EntityHitResult p_37626_) {
        boolean $$5;
        super.onHitEntity(p_37626_);
        if (this.level().isClientSide) {
            return;
        }
        Entity $$1 = p_37626_.getEntity();
        Entity $$2 = this.getOwner();
        if ($$2 instanceof LivingEntity) {
            LivingEntity $$3 = (LivingEntity)$$2;
            boolean $$4 = $$1.hurt(this.damageSources().witherSkull(this, $$3), 8.0f);
            if ($$4) {
                if ($$1.isAlive()) {
                    this.doEnchantDamageEffects($$3, $$1);
                } else {
                    $$3.heal(5.0f);
                }
            }
        } else {
            $$5 = $$1.hurt(this.damageSources().magic(), 5.0f);
        }
        if ($$5 && $$1 instanceof LivingEntity) {
            LivingEntity $$6 = (LivingEntity)$$1;
            int $$7 = 0;
            if (this.level().getDifficulty() == Difficulty.NORMAL) {
                $$7 = 10;
            } else if (this.level().getDifficulty() == Difficulty.HARD) {
                $$7 = 40;
            }
            if ($$7 > 0) {
                $$6.addEffect(new MobEffectInstance(MobEffects.WITHER, 20 * $$7, 1), this.getEffectSource());
            }
        }
    }

    @Override
    protected void onHit(HitResult p_37628_) {
        super.onHit(p_37628_);
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, false, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    @Override
    public boolean hurt(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325939_) {
        p_325939_.define(DATA_DANGEROUS, false);
    }

    public boolean isDangerous() {
        return this.entityData.get(DATA_DANGEROUS);
    }

    public void setDangerous(boolean p_37630_) {
        this.entityData.set(DATA_DANGEROUS, p_37630_);
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_306205_) {
        super.addAdditionalSaveData(p_306205_);
        p_306205_.putBoolean("dangerous", this.isDangerous());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_305818_) {
        super.readAdditionalSaveData(p_305818_);
        this.setDangerous(p_305818_.getBoolean("dangerous"));
    }
}

