/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface ContainerEntity
extends Container,
MenuProvider {
    public Vec3 position();

    public AABB getBoundingBox();

    @Nullable
    public ResourceKey<LootTable> getLootTable();

    public void setLootTable(@Nullable ResourceKey<LootTable> var1);

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public NonNullList<ItemStack> getItemStacks();

    public void clearItemStacks();

    public Level level();

    public boolean isRemoved();

    @Override
    default public boolean isEmpty() {
        return this.isChestVehicleEmpty();
    }

    default public void addChestVehicleSaveData(CompoundTag p_219944_, HolderLookup.Provider p_332101_) {
        if (this.getLootTable() != null) {
            p_219944_.putString("LootTable", this.getLootTable().location().toString());
            if (this.getLootTableSeed() != 0L) {
                p_219944_.putLong("LootTableSeed", this.getLootTableSeed());
            }
        } else {
            ContainerHelper.saveAllItems(p_219944_, this.getItemStacks(), p_332101_);
        }
    }

    default public void readChestVehicleSaveData(CompoundTag p_219935_, HolderLookup.Provider p_331073_) {
        this.clearItemStacks();
        if (p_219935_.contains("LootTable", 8)) {
            this.setLootTable(ResourceKey.create(Registries.LOOT_TABLE, new ResourceLocation(p_219935_.getString("LootTable"))));
            this.setLootTableSeed(p_219935_.getLong("LootTableSeed"));
        } else {
            ContainerHelper.loadAllItems(p_219935_, this.getItemStacks(), p_331073_);
        }
    }

    default public void chestVehicleDestroyed(DamageSource p_219928_, Level p_219929_, Entity p_219930_) {
        Entity $$3;
        if (!p_219929_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        Containers.dropContents(p_219929_, p_219930_, (Container)this);
        if (!p_219929_.isClientSide && ($$3 = p_219928_.getDirectEntity()) != null && $$3.getType() == EntityType.PLAYER) {
            PiglinAi.angerNearbyPiglins((Player)$$3, true);
        }
    }

    default public InteractionResult interactWithContainerVehicle(Player p_270068_) {
        p_270068_.openMenu(this);
        if (!p_270068_.level().isClientSide) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    default public void unpackChestVehicleLootTable(@Nullable Player p_219950_) {
        MinecraftServer $$1 = this.level().getServer();
        if (this.getLootTable() != null && $$1 != null) {
            LootTable $$2 = $$1.reloadableRegistries().getLootTable(this.getLootTable());
            if (p_219950_ != null) {
                CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)p_219950_, this.getLootTable());
            }
            this.setLootTable(null);
            LootParams.Builder $$3 = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, this.position());
            if (p_219950_ != null) {
                $$3.withLuck(p_219950_.getLuck()).withParameter(LootContextParams.THIS_ENTITY, p_219950_);
            }
            $$2.fill(this, $$3.create(LootContextParamSets.CHEST), this.getLootTableSeed());
        }
    }

    default public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().clear();
    }

    default public boolean isChestVehicleEmpty() {
        for (ItemStack $$0 : this.getItemStacks()) {
            if ($$0.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack removeChestVehicleItemNoUpdate(int p_219946_) {
        this.unpackChestVehicleLootTable(null);
        ItemStack $$1 = this.getItemStacks().get(p_219946_);
        if ($$1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.getItemStacks().set(p_219946_, ItemStack.EMPTY);
        return $$1;
    }

    default public ItemStack getChestVehicleItem(int p_219948_) {
        this.unpackChestVehicleLootTable(null);
        return this.getItemStacks().get(p_219948_);
    }

    default public ItemStack removeChestVehicleItem(int p_219937_, int p_219938_) {
        this.unpackChestVehicleLootTable(null);
        return ContainerHelper.removeItem(this.getItemStacks(), p_219937_, p_219938_);
    }

    default public void setChestVehicleItem(int p_219941_, ItemStack p_219942_) {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().set(p_219941_, p_219942_);
        p_219942_.limitSize(this.getMaxStackSize(p_219942_));
    }

    default public SlotAccess getChestVehicleSlot(final int p_219952_) {
        if (p_219952_ >= 0 && p_219952_ < this.getContainerSize()) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return ContainerEntity.this.getChestVehicleItem(p_219952_);
                }

                @Override
                public boolean set(ItemStack p_219964_) {
                    ContainerEntity.this.setChestVehicleItem(p_219952_, p_219964_);
                    return true;
                }
            };
        }
        return SlotAccess.NULL;
    }

    default public boolean isChestVehicleStillValid(Player p_219955_) {
        return !this.isRemoved() && p_219955_.canInteractWithEntity(this.getBoundingBox(), 4.0);
    }
}

