/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HorseInventoryMenu
extends AbstractContainerMenu {
    private final Container horseContainer;
    private final Container armorContainer;
    private final AbstractHorse horse;
    private static final int SLOT_BODY_ARMOR = 1;
    private static final int SLOT_HORSE_INVENTORY_START = 2;

    public HorseInventoryMenu(int p_39656_, Inventory p_39657_, Container p_39658_, final AbstractHorse p_39659_) {
        super(null, p_39656_);
        this.horseContainer = p_39658_;
        this.armorContainer = p_39659_.getBodyArmorAccess();
        this.horse = p_39659_;
        int $$4 = 3;
        p_39658_.startOpen(p_39657_.player);
        int $$5 = -18;
        this.addSlot(new Slot(this, p_39658_, 0, 8, 18){

            @Override
            public boolean mayPlace(ItemStack p_39677_) {
                return p_39677_.is(Items.SADDLE) && !this.hasItem() && p_39659_.isSaddleable();
            }

            @Override
            public boolean isActive() {
                return p_39659_.isSaddleable();
            }
        });
        this.addSlot(new Slot(this, this.armorContainer, 0, 8, 36){

            @Override
            public boolean mayPlace(ItemStack p_39690_) {
                return p_39659_.isBodyArmorItem(p_39690_);
            }

            @Override
            public boolean isActive() {
                return p_39659_.canWearBodyArmor();
            }

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        if (this.hasChest(p_39659_)) {
            for (int $$6 = 0; $$6 < 3; ++$$6) {
                for (int $$7 = 0; $$7 < ((AbstractChestedHorse)p_39659_).getInventoryColumns(); ++$$7) {
                    this.addSlot(new Slot(p_39658_, 1 + $$7 + $$6 * ((AbstractChestedHorse)p_39659_).getInventoryColumns(), 80 + $$7 * 18, 18 + $$6 * 18));
                }
            }
        }
        for (int $$8 = 0; $$8 < 3; ++$$8) {
            for (int $$9 = 0; $$9 < 9; ++$$9) {
                this.addSlot(new Slot(p_39657_, $$9 + $$8 * 9 + 9, 8 + $$9 * 18, 102 + $$8 * 18 + -18));
            }
        }
        for (int $$10 = 0; $$10 < 9; ++$$10) {
            this.addSlot(new Slot(p_39657_, $$10, 8 + $$10 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(Player p_39661_) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(p_39661_) && this.armorContainer.stillValid(p_39661_) && this.horse.isAlive() && p_39661_.canInteractWithEntity(this.horse, 4.0);
    }

    private boolean hasChest(AbstractHorse p_150578_) {
        AbstractChestedHorse $$1;
        return p_150578_ instanceof AbstractChestedHorse && ($$1 = (AbstractChestedHorse)p_150578_).hasChest();
    }

    @Override
    public ItemStack quickMoveStack(Player p_39665_, int p_39666_) {
        ItemStack $$2 = ItemStack.EMPTY;
        Slot $$3 = (Slot)this.slots.get(p_39666_);
        if ($$3 != null && $$3.hasItem()) {
            ItemStack $$4 = $$3.getItem();
            $$2 = $$4.copy();
            int $$5 = this.horseContainer.getContainerSize() + 1;
            if (p_39666_ < $$5) {
                if (!this.moveItemStackTo($$4, $$5, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace($$4) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo($$4, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace($$4)) {
                if (!this.moveItemStackTo($$4, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if ($$5 <= 1 || !this.moveItemStackTo($$4, 2, $$5, false)) {
                int $$7;
                int $$6 = $$5;
                int $$8 = $$7 = $$6 + 27;
                int $$9 = $$8 + 9;
                if (p_39666_ >= $$8 && p_39666_ < $$9 ? !this.moveItemStackTo($$4, $$6, $$7, false) : (p_39666_ >= $$6 && p_39666_ < $$7 ? !this.moveItemStackTo($$4, $$8, $$9, false) : !this.moveItemStackTo($$4, $$8, $$7, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if ($$4.isEmpty()) {
                $$3.setByPlayer(ItemStack.EMPTY);
            } else {
                $$3.setChanged();
            }
        }
        return $$2;
    }

    @Override
    public void removed(Player p_39663_) {
        super.removed(p_39663_);
        this.horseContainer.stopOpen(p_39663_);
    }
}

